/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.report;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedCollection;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedFactory;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.fast.util.ManageMergeOrgUnit;
import com.kingdee.eas.fi.newrpt.AnalysisReportInfo;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportDesignerUI;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportEditUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportListUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptProcessUI;
import com.kingdee.eas.fi.newrpt.client.report.ItemAnalysisFilterUI;
import com.kingdee.eas.fi.newrpt.client.report.ItemAnalysisGuideUI;
import com.kingdee.eas.fi.newrpt.client.report.ItemAnalysisHandle;
import com.kingdee.eas.fi.newrpt.report.AnalysisBasePointParams;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisCellObject;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.YearPeriodCalendar;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ItemAnalysisHepler {
    private static final Logger logger = CoreUIObject.getLogger(ItemAnalysisHepler.class);
    private static ItemAnalysisHepler thisHelper = null;
    private CommonQueryDialog dialog = null;
    private ItemAnalysisGuideUI guideUi = null;
    private ItemAnalysisFilterUI filterUi = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemAnalysisHepler getInstance() {
        Class<ItemAnalysisHepler> clazz = ItemAnalysisHepler.class;
        synchronized (ItemAnalysisHepler.class) {
            if (thisHelper == null) {
                thisHelper = new ItemAnalysisHepler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return thisHelper;
        }
    }

    public void saveBasePointParametersToCell(Range range, AnalysisBasePointParams parameters) {
        ItemFormula tmp;
        ItemFormula f = (ItemFormula)(range = UserObjectHelper.getUnprotectedRange((Range)range)).getUserObject("ITEM");
        f = f == null ? new ItemFormula() : (tmp = (ItemFormula)f.clone());
        f.putExt("DynaParameters", parameters.toString());
        range.setUserObject("ITEM", (Object)f);
    }

    public ArrayList getBasePointList(Sheet sheet) {
        int rowCount = sheet.getRows().getMaxIntMark() + 1;
        int columnCount = sheet.getCols().getMaxIntMark() + 1;
        ArrayList<Point> list = new ArrayList<Point>();
        Point firstPoint = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                if (!this.isBasePointCell(sheet, i, j)) continue;
                firstPoint = new Point(j, i);
                list.add(firstPoint);
                i = ItemAnalysisHepler.getInstance().getParametersFromCell(sheet.getCell(i, j, true)).getRow_endOffSet() + i;
            }
        }
        return list;
    }

    public boolean isBasePointCell(Sheet sheet, int row, int col) {
        ItemFormula f = (ItemFormula)sheet.getRange(row, col).getUserObject("ITEM");
        if (f == null) {
            return false;
        }
        String obj = f.getExt("DynaParameters");
        if (obj != null && obj instanceof String) {
            return AnalysisBasePointParams.getInstance(obj) != null;
        }
        return false;
    }

    public AnalysisBasePointParams getParametersFromCell(Cell cell) {
        ItemFormula f;
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula && (obj = (f = (ItemFormula)obj).getExt("DynaParameters")) != null && obj instanceof String) {
            return AnalysisBasePointParams.getInstance((String)obj);
        }
        return null;
    }

    public OrgStructureCollection getOrgStructureList(String ids, String orgTreeId) throws Exception {
        if (ids.trim().startsWith(",")) {
            ids = ids.trim().replaceFirst(",", "");
            ids = "'" + ids.replaceAll(",", "','") + "'";
            OrgStructureCollection orgStructureColl = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select id,isLeaf,level,unit.name,unit.number,unit.id,tree.number,unit.isunion,parent.unit.id,parent.unit.number,longnumber where tree.id='" + orgTreeId + "' and unit.id in(" + ids + ") order by longnumber asc");
            return orgStructureColl;
        }
        return null;
    }

    public Map<String, List<String>> getChilds(OrgStructureCollection orgStructureColl, Map<String, List<String>> orgChildsMap) {
        HashMap tmpMap = new HashMap();
        for (int i = 0; i < orgStructureColl.size(); ++i) {
            tmpMap.put(orgStructureColl.get(i).getUnit().getNumber(), null);
        }
        List<String> childs = null;
        OrgStructureInfo info = null;
        String parentNumber = null;
        for (int i = 0; i < orgStructureColl.size(); ++i) {
            info = orgStructureColl.get(i);
            if (info.getUnit().isIsUnion()) {
                orgChildsMap.put(info.getUnit().getNumber(), null);
            }
            if (info.getParent() == null || info.getParent().getUnit() == null || info.getParent().getUnit().getNumber() == null || !tmpMap.containsKey(parentNumber = info.getParent().getUnit().getNumber())) continue;
            childs = orgChildsMap.get(parentNumber);
            if (childs == null) {
                childs = new ArrayList<String>();
                orgChildsMap.put(parentNumber, childs);
            }
            childs.add(info.getUnit().getNumber());
        }
        tmpMap.clear();
        return orgChildsMap;
    }

    public void setBorder(Range range) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_H, PenStyle.PS_SOLID);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_H, LineStyle.SINGLE_LINE);
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_V, PenStyle.PS_SOLID);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_V, LineStyle.SINGLE_LINE);
        sa.setFontSize(10);
        range.setStyle(sa, saInnerBorder);
        this.setHorizontalAlign(range, Styles.HorizontalAlignment.LEFT);
    }

    public void setHorizontalAlign(Range range, Styles.HorizontalAlignment hAlign) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHorizontalAlign(hAlign);
        range.setStyle(sa, sa);
    }

    public void setNumberFormat(Range range, String formatStr) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setNumberFormat(formatStr);
        range.setStyle(sa, sa);
    }

    public List<ItemAnalysisCellObject> getDataElementList(String dataElementStr) throws Exception {
        ArrayList<ItemAnalysisCellObject> result = new ArrayList<ItemAnalysisCellObject>();
        ItemAnalysisCellObject object = null;
        if (dataElementStr.trim().startsWith(",")) {
            String[] dataElements;
            String temStr = dataElementStr = dataElementStr.trim().replaceFirst(",", "");
            dataElementStr = "'" + dataElementStr.replaceAll(",", "','") + "'";
            DataElementCollection coll = DataElementFactory.getRemoteInstance().getDataElementCollection("select interSeq,number,name where number in(" + dataElementStr + ") order by number ");
            DataElementInfo info = null;
            HashMap<String, DataElementInfo> catchMap = new HashMap<String, DataElementInfo>();
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                catchMap.put(info.getNumber(), info);
            }
            for (String dataElement : dataElements = temStr.split(",")) {
                if (StringUtils.isEmpty((String)dataElement)) continue;
                info = (DataElementInfo)catchMap.get(dataElement);
                object = new ItemAnalysisCellObject();
                object.setKey(String.valueOf(info.getInterSeq()));
                object.setDisplayName(info.getName());
                result.add(object);
            }
            catchMap.clear();
        }
        return result;
    }

    public List<ItemAnalysisCellObject> getItemList(String itemStr) throws Exception {
        ArrayList<ItemAnalysisCellObject> result = new ArrayList<ItemAnalysisCellObject>();
        ItemAnalysisCellObject object = null;
        if (itemStr.trim().startsWith(",")) {
            String[] items;
            String temStr = itemStr = itemStr.trim().replaceFirst(",", "");
            itemStr = "'" + itemStr.replaceAll(",", "','") + "'";
            RPTItemCollection coll = RPTItemFactory.getRemoteInstance().getRPTItemCollection("select number,name where number in(" + itemStr + ") order by number ");
            RPTItemInfo info = null;
            HashMap<String, RPTItemInfo> catchMap = new HashMap<String, RPTItemInfo>();
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                catchMap.put(info.getNumber(), info);
            }
            for (String item : items = temStr.split(",")) {
                if (StringUtils.isEmpty((String)item)) continue;
                info = (RPTItemInfo)catchMap.get(item);
                object = new ItemAnalysisCellObject();
                object.setKey(info.getNumber());
                object.setDisplayName(info.getName());
                result.add(object);
            }
            catchMap.clear();
        }
        return result;
    }

    public List<ItemAnalysisCellObject> getAdjustTypeList() throws Exception {
        ArrayList<ItemAnalysisCellObject> result = new ArrayList<ItemAnalysisCellObject>();
        ItemAnalysisCellObject object = new ItemAnalysisCellObject();
        object.setKey("2");
        object.setDisplayName(ItemDataTypeEnum.ADJUSTED.getAlias());
        result.add(object);
        object = new ItemAnalysisCellObject();
        object.setKey("1");
        object.setDisplayName(ItemDataTypeEnum.ADJUSTING.getAlias());
        result.add(object);
        object = new ItemAnalysisCellObject();
        object.setKey("0");
        object.setDisplayName(ItemDataTypeEnum.BEFOREADJUST.getAlias());
        result.add(object);
        return result;
    }

    public List<ItemAnalysisCellObject> getOrgUnitList(List<ManageMergeOrgUnit> manageMergeOrgUnits, List selectSourceType, String orgTreeNumber, String solutId, boolean isSupportGroup) {
        ArrayList<ItemAnalysisCellObject> result = new ArrayList<ItemAnalysisCellObject>();
        ItemAnalysisCellObject object = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FastMergeSoluInfo tmpSoluInfo = null;
        String number = null;
        HashMap<String, String> parentId_ParentKey = new HashMap<String, String>();
        for (ManageMergeOrgUnit mmOrgUnit : manageMergeOrgUnits) {
            if (mmOrgUnit.isFastMergeOrgUnit()) {
                orgUnitInfo = mmOrgUnit.getFastMergeOrgUnit().getOrgUnit();
                for (Object obj : selectSourceType) {
                    object = new ItemAnalysisCellObject();
                    object.setKey(orgUnitInfo.getNumber());
                    if (!isSupportGroup) {
                        ReportCalcGroupKey keyInfo = new ReportCalcGroupKey(orgTreeNumber, solutId, isSupportGroup);
                        object.setExKey(keyInfo.toString());
                    }
                    object.setDisplayName(this.getOrgUnitName(orgUnitInfo.getName(), orgUnitInfo.getLevel(), 0));
                    object.setUnion(true);
                    object.setSourceType(Integer.parseInt((String)obj));
                    object.setLongNumber(orgUnitInfo.getLongNumber());
                    number = (String)parentId_ParentKey.get(mmOrgUnit.getParentId());
                    if (!StringUtils.isEmpty((String)mmOrgUnit.getParentId()) && number != null) {
                        if (!StringUtils.isEmpty((String)object.getExKey())) {
                            object.setParentKey(number + ItemAnalysisConstant.splitStr + object.getExKey());
                        } else {
                            object.setParentKey(number);
                        }
                    }
                    result.add(object);
                }
                parentId_ParentKey.put(orgUnitInfo.getId().toString(), orgUnitInfo.getNumber());
                continue;
            }
            object = new ItemAnalysisCellObject();
            orgUnitInfo = mmOrgUnit.getCalOrgUnit().getFullOrgUnitInfo();
            object.setKey(orgUnitInfo.getNumber());
            if (orgUnitInfo.isIsUnion() && !mmOrgUnit.getCalOrgUnit().isFromStatutory() && (mmOrgUnit.getCalOrgUnit().getSourceSoluInfo() == null || mmOrgUnit.getCalOrgUnit().getSourceSoluInfo().getId() == null || StringUtils.isEmpty((String)mmOrgUnit.getCalOrgUnit().getSourceSoluInfo().getId().toString()))) {
                tmpSoluInfo = new FastMergeSoluInfo();
                tmpSoluInfo.put("id", (Object)solutId);
                mmOrgUnit.getCalOrgUnit().setSourceSoluInfo(tmpSoluInfo);
            }
            object.setExKey(new ReportCalcGroupKey(mmOrgUnit.getCalOrgUnit()).toString());
            object.setDisplayName(this.getOrgUnitName(orgUnitInfo.getName(), 8, 0));
            object.setLongNumber(orgUnitInfo.getLongNumber());
            number = (String)parentId_ParentKey.get(mmOrgUnit.getParentId());
            if (!StringUtils.isEmpty((String)mmOrgUnit.getParentId()) && number != null) {
                if (!isSupportGroup) {
                    object.setParentKey(number + ItemAnalysisConstant.splitStr + new ReportCalcGroupKey(orgTreeNumber, solutId, isSupportGroup).toString());
                } else {
                    object.setParentKey(number);
                }
            }
            object.setSourceType(Integer.parseInt(ItemAnalysisConstant.cslType));
            result.add(object);
        }
        parentId_ParentKey.clear();
        return result;
    }

    public List<ItemAnalysisCellObject> getOrgUnitList(OrgStructureCollection orgStructureColl, List selectSourceType) {
        ArrayList<ItemAnalysisCellObject> result = new ArrayList<ItemAnalysisCellObject>();
        ItemAnalysisCellObject object = null;
        OrgStructureInfo info = null;
        int rootLevel = orgStructureColl.get(0).getLevel();
        for (int i = 0; i < orgStructureColl.size(); ++i) {
            info = orgStructureColl.get(i);
            if (info.getUnit().isIsUnion()) {
                for (Object obj : selectSourceType) {
                    object = new ItemAnalysisCellObject();
                    object.setKey(info.getUnit().getNumber());
                    object.setDisplayName(this.getOrgUnitName(info.getUnit().getName(), info.getLevel(), rootLevel));
                    object.setUnion(true);
                    object.setSourceType(Integer.parseInt((String)obj));
                    object.setLongNumber(info.getLongNumber());
                    if (info.getParent() != null && info.getParent().getUnit() != null) {
                        object.setParentKey(info.getParent().getUnit().getNumber());
                    }
                    result.add(object);
                }
                continue;
            }
            object = new ItemAnalysisCellObject();
            object.setKey(info.getUnit().getNumber());
            object.setDisplayName(this.getOrgUnitName(info.getUnit().getName(), info.getLevel(), rootLevel));
            object.setLongNumber(info.getLongNumber());
            object.setParentKey(info.getParent().getUnit().getNumber());
            object.setSourceType(Integer.parseInt(ItemAnalysisConstant.cslType));
            result.add(object);
        }
        return result;
    }

    public String getOrgUnitName(String name, int curLevel, int rootLevel) {
        StringBuffer sb = new StringBuffer();
        for (int i = rootLevel; i < curLevel + 1; ++i) {
            sb.append("  ");
        }
        sb.append(name);
        return sb.toString();
    }

    public List<ItemAnalysisCellObject> getYearPeriodList(int startYear, int endYear, int startPeriod, int endPeriod, boolean isSumByQuarter, boolean isOnlyDisplayQuarter, boolean isSupport13Period) {
        String yearStr = EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"kDLabelContainer4.boundLabelText");
        String periodStr = EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"kDLabelContainer5.boundLabelText");
        String quarterStr = EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"89_quarter");
        ArrayList<ItemAnalysisCellObject> result = new ArrayList<ItemAnalysisCellObject>();
        ItemAnalysisCellObject object = null;
        boolean isSetQuarterCell = false;
        YearPeriodCalendar startCalendar = new YearPeriodCalendar(startYear, startPeriod, isSupport13Period ? 13 : 12);
        YearPeriodCalendar endCalendar = new YearPeriodCalendar(endYear, endPeriod, isSupport13Period ? 13 : 12);
        int quarter = 0;
        int curYear = 0;
        int curPeriod = 0;
        while (startCalendar.compare(endCalendar) <= 0) {
            curYear = startCalendar.getYear();
            curPeriod = startCalendar.getPeriod();
            startCalendar.offSet(0, 1);
            if (!isOnlyDisplayQuarter) {
                object = new ItemAnalysisCellObject();
                object.setKey(curYear + ItemAnalysisConstant.splitStr + String.valueOf(curPeriod));
                object.setDisplayName(curYear + yearStr + curPeriod + periodStr);
                result.add(object);
            }
            if (!isSumByQuarter) continue;
            if (isSupport13Period) {
                if (curPeriod == 12 && startCalendar.compare(endCalendar) <= 0) continue;
                if (curPeriod == 13) {
                    curPeriod = 12;
                }
            }
            if (curPeriod % 3 == 0) {
                quarter = (curPeriod - 1) / 3 + 1;
                object = new ItemAnalysisCellObject();
                object.setKey(curYear + ItemAnalysisConstant.quarterSplitStr + String.valueOf(quarter));
                object.setDisplayName(curYear + yearStr + quarter + quarterStr);
                result.add(object);
                isSetQuarterCell = true;
                continue;
            }
            isSetQuarterCell = false;
        }
        if (!isSetQuarterCell && isSumByQuarter) {
            curPeriod = curPeriod == 13 ? 12 : curPeriod;
            quarter = (endPeriod - 1) / 3 + 1;
            object = new ItemAnalysisCellObject();
            object.setKey(endYear + ItemAnalysisConstant.quarterSplitStr + String.valueOf(quarter));
            object.setDisplayName(endYear + yearStr + quarter + quarterStr);
            result.add(object);
        }
        return result;
    }

    public CustomerParams getAnalysisFilterCustomerParams(SpreadManager spreadManager, ReportBaseInfo reportInfo, boolean isDynamicAnalysis) throws Exception {
        if (!RptPeriodTypeEnum.MONTHLY.equals((Object)reportInfo.getPeriodType())) {
            MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"117_supportMonthRpt"));
            SysUtil.abort();
        }
        CustomerParams params = new CustomerParams();
        params.addCustomerParam("START_YEAR", String.valueOf(reportInfo.getYear()));
        params.addCustomerParam("START_PERIOD", String.valueOf(reportInfo.getPeriod()));
        params.addCustomerParam("END_YEAR", String.valueOf(reportInfo.getYear()));
        params.addCustomerParam("END_PERIOD", String.valueOf(reportInfo.getPeriod()));
        if (reportInfo instanceof CslReportInfo) {
            if (reportInfo.getOrgTree() != null) {
                params.addCustomerParam("ORG_TREE_ID", reportInfo.getOrgTree().getId().toString());
            } else {
                RptReceivedCollection receivedCol = RptReceivedFactory.getRemoteInstance().getRptReceivedCollection("select orgTree where report.id='" + reportInfo.getId().toString() + "'");
                if (receivedCol != null && receivedCol.size() > 0 && receivedCol.get(0).getOrgTree() != null) {
                    params.addCustomerParam("ORG_TREE_ID", receivedCol.get(0).getOrgTree().getId().toString());
                }
            }
            String orgs = null;
            String soluId = ((CslReportInfo)reportInfo).getFastMergeSoluId();
            if (!StringUtils.isEmpty((String)soluId)) {
                params.addCustomerParam("SCHEME_ID", soluId);
                List orgList = FastMergeUtil.getManageMergeOrgUnitList((String)soluId, null, null, (boolean)false, (boolean)false);
                orgs = this.solutOrgs2Str(orgList);
                orgList.clear();
            } else if (reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.SUM) || reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.SUM_FASTMERGE) || reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION_FASTMERGE) || reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE)) {
                ArrayList orgList = CslRptUtil.getUnionDebtAllUnit(null, (IObjectValue)reportInfo.getOrgTree(), (IObjectValue)((CslReportInfo)reportInfo).getOrgUnit());
                if (orgList != null) {
                    orgs = ((CslReportInfo)reportInfo).getOrgUnit().getId().toString() + "," + CslRptUtil.arrToString((Object[])orgList.toArray(), (char)',');
                }
                orgList.clear();
            } else {
                orgs = ((CslReportInfo)reportInfo).getOrgUnit().getId().toString();
            }
            params.addCustomerParam("ORGS", orgs);
        } else if (reportInfo.getCompany() != null) {
            RptReceivedCollection receivedCol;
            if ((reportInfo.getOrgTree() == null || reportInfo.getOrgTree().getId() == null) && reportInfo instanceof ReportInfo && ((ReportInfo)reportInfo).getCslReport() != null && ((ReportInfo)reportInfo).getCslReport().getId() != null && (receivedCol = RptReceivedFactory.getRemoteInstance().getRptReceivedCollection("select orgTree where report.id='" + ((ReportInfo)reportInfo).getCslReport().getId().toString() + "'")) != null && receivedCol.size() > 0 && receivedCol.get(0).getOrgTree() != null) {
                params.addCustomerParam("ORG_TREE_ID", receivedCol.get(0).getOrgTree().getId().toString());
            }
            params.addCustomerParam("ORGS", reportInfo.getCompany().getId().toString());
        }
        params.putBoolean("incluedUnReceivedData", Boolean.TRUE.booleanValue());
        params.addCustomerParam("CURRENCY_ID", reportInfo.getCurrency().getId().toString());
        params.addCustomerParam("ADJUST", String.valueOf(1));
        if (isDynamicAnalysis) {
            this.setDyItemSelectFilter(spreadManager, params);
        } else {
            this.setItemSelectFilter(spreadManager, params);
        }
        return params;
    }

    public void setItemSelectFilter(SpreadManager spreadManager, CustomerParams customerParams) {
        Sheet activeSheet = spreadManager.getSpreadContainer().getBook().getActiveSheet();
        Range ranges = activeSheet.getSelectionRange();
        if (ranges == null) {
            return;
        }
        int valueType = 1;
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<String> fetch_types = new ArrayList<String>();
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getBlock(i);
            Sheet.ICellsIterator iCellsIterator = activeSheet.getCellsIterator(block, false, true);
            while (iCellsIterator.hasNext()) {
                Cell cell = iCellsIterator.next();
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                if (item == null || item.getItemNumber() == null) continue;
                if (!items.contains(item.getItemNumber())) {
                    items.add(item.getItemNumber());
                }
                if (!fetch_types.contains(item.getDataElementNumber())) {
                    fetch_types.add(item.getDataElementNumber());
                }
                valueType = item.getValueType();
            }
        }
        if (!items.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Object e : items) {
                sb.append(",").append(e);
            }
            items.clear();
            customerParams.addCustomerParam("ITEMS", sb.toString());
        }
        if (!fetch_types.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Object e : fetch_types) {
                sb.append(",").append(e);
            }
            fetch_types.clear();
            customerParams.addCustomerParam("FETCH_TYPE", sb.toString());
        }
        customerParams.addCustomerParam("DATA_TYPE", String.valueOf(valueType));
    }

    public void setDyItemSelectFilter(SpreadManager spreadManager, CustomerParams customerParams) {
        Sheet activeSheet = spreadManager.getSpreadContainer().getBook().getActiveSheet();
        Range range = activeSheet.getSelectionRange();
        if (range == null) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<String> fetch_types = new ArrayList<String>();
        ArrayList<DynaItemInfo> dyItems = new ArrayList<DynaItemInfo>();
        int valueType = 1;
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)activeSheet);
        Point basePoint = DynamicTemplateUtility.getBasePoint((Sheet)activeSheet, (Point)new Point(activeSheet.getActiveCol(), activeSheet.getActiveRow()), (ArrayList)basePointList);
        if (basePoint != null) {
            DynaParameters dynaParameters = DynamicTemplateUtility.getDynaParameters((Sheet)activeSheet, (Point)basePoint);
        }
        HashMap<String, List<Point>> basePoints = new HashMap<String, List<Point>>();
        basePoints.put(activeSheet.getSheetName(), basePointList);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            Sheet.ICellsIterator iCellsIterator = activeSheet.getCellsIterator(block, false, true);
            while (iCellsIterator.hasNext()) {
                DynaParameters params;
                String dataElementNumber;
                Cell cell = iCellsIterator.next();
                ItemFormula item = NewRptUtil.getItemFormula(cell, basePoints);
                if (item == null || !item.isDItem()) continue;
                String itemNumber = item.getItemNumber();
                if (!items.contains(itemNumber)) {
                    items.add(itemNumber);
                }
                if (!fetch_types.contains(dataElementNumber = item.getDataElementNumber())) {
                    fetch_types.add(dataElementNumber);
                }
                valueType = item.getValueType();
                String ditemNumber = item.getDItemNumber();
                if (StringUtils.isEmpty((String)ditemNumber)) continue;
                basePoint = DynamicTemplateUtility.getBasePoint((Sheet)activeSheet, (Point)new Point(cell.getCol(), cell.getRow()), (ArrayList)basePointList);
                try {
                    params = DynamicTemplateUtility.getDynaParameters((Sheet)activeSheet, (Point)basePoint);
                }
                catch (NullPointerException e) {
                    continue;
                }
                String ditemName = null;
                ditemName = params.getSpreadStyle() == 0 ? activeSheet.getRange(cell.getRow(), basePoint.x).getValue().toString() : activeSheet.getRange(basePoint.y, cell.getCol()).getValue().toString();
                DynaItemInfo values = new DynaItemInfo(StringUtils.trim((String)ditemName), ditemNumber);
                if (dyItems.contains(values)) continue;
                dyItems.add(values);
            }
        }
        customerParams.addCustomerParam("isHasDyitems", dyItems.isEmpty() ? "0" : "1");
        if (!dyItems.isEmpty()) {
            customerParams.addCustomerParam("DYITEM", this.getDyItemData(dyItems));
            dyItems.clear();
        }
        if (!items.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Object e : items) {
                sb.append(",").append(e);
            }
            items.clear();
            customerParams.addCustomerParam("ITEMS", sb.toString());
        }
        if (!fetch_types.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Object e : fetch_types) {
                sb.append(",").append(e);
            }
            fetch_types.clear();
            customerParams.addCustomerParam("FETCH_TYPE", sb.toString());
        }
        customerParams.addCustomerParam("DATA_TYPE", String.valueOf(valueType));
    }

    public String getDyItemData(List dyItems) {
        StringBuffer sb = new StringBuffer();
        for (Object dyItem : dyItems) {
            if (dyItem instanceof DynaItemInfo) {
                sb.append(((DynaItemInfo)dyItem).getDitemNumber()).append(";;").append(((DynaItemInfo)dyItem).getDitemName());
            } else {
                sb.append(dyItem).append(";;").append(dyItem);
            }
            sb.append(",,");
        }
        sb.delete(sb.lastIndexOf(",,"), sb.length());
        return sb.toString();
    }

    public void analysis(final Book book, final SpreadManager spreadManager, final Component owner, final ReportBaseInfo reportInfo, final boolean isDynamicAnalysis) throws Exception {
        final ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew((CoreUI)owner, true);
        progressDialog.run(true, true, new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(IProgressMonitor monitor) {
                IUIWindow uiWindow = null;
                monitor.beginTask(EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"133_analysisItemData"), -1);
                try {
                    uiWindow = ItemAnalysisHepler.this.analysisThread(book, spreadManager, owner, reportInfo, isDynamicAnalysis, progressDialog);
                }
                catch (Exception e) {
                    logger.error((Object)"analysis error.", (Throwable)e);
                }
                finally {
                    monitor.done();
                    if (uiWindow != null && uiWindow.getUIObject() != null) {
                        try {
                            uiWindow.getUIObject().onShow();
                        }
                        catch (Exception ex) {
                            logger.error((Object)"uiWindow.getUIObject().onShow() error", (Throwable)ex);
                        }
                    }
                }
            }
        }, progressDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUIWindow analysisThread(Book book, SpreadManager spreadManager, Component owner, ReportBaseInfo reportInfo, boolean isDynamicAnalysis, ProgressDialogNew progressDialog) throws Exception {
        CustomerParams filterParams;
        IUIWindow uiWindow = null;
        CustomerParams[] customerParamsArr = this.initCustomerParams(book, spreadManager, owner, reportInfo, isDynamicAnalysis);
        CustomerParams guideParams = customerParamsArr[0];
        CommonQueryDialog dialog = this.initCommonQueryDialog(book, spreadManager, guideParams, filterParams = customerParamsArr[1], owner, isDynamicAnalysis);
        boolean isOk = dialog.show();
        if (isOk) {
            try {
                progressDialog.reSetTime();
                for (int i = 0; i < 2; ++i) {
                    if (dialog.getUserPanel(i) instanceof ItemAnalysisGuideUI) {
                        guideParams = ((ItemAnalysisGuideUI)dialog.getUserPanel(i)).getCustomerParams();
                        continue;
                    }
                    filterParams = ((ItemAnalysisFilterUI)dialog.getUserPanel(i)).getCustomerParams();
                }
                Book curBook = book;
                if (owner instanceof BaseReportDesignerUI && reportInfo != null) {
                    UIContext uiContext = new UIContext();
                    BOSUuid id = BOSUuid.create((BOSObjectType)new ReportBaseInfo().getBOSType());
                    uiContext.put((Object)"ID", (Object)id);
                    uiContext.put((Object)"UIClassParam", (Object)id.toString());
                    uiContext.put((Object)"OwnerWindow", (Object)owner);
                    uiWindow = this.getAnalysisRptWindow(uiContext, OprtState.ADDNEW);
                    curBook = ((AnalysisRptProcessUI)uiWindow.getUIObject()).getBook();
                }
                curBook.setCalculate(false);
                ItemAnalysisHandle handle = new ItemAnalysisHandle();
                handle.init(spreadManager, curBook.getActiveSheet(), guideParams, filterParams, isDynamicAnalysis);
                handle.analysisHandle();
                if (uiWindow != null) {
                    uiWindow.show();
                }
            }
            finally {
                spreadManager.getModifyManager().setModified();
                spreadManager.getSpreadContainer().repaint();
            }
        }
        return uiWindow;
    }

    public CustomerParams[] initCustomerParams(Book book, SpreadManager spreadManager, Component owner, ReportBaseInfo reportInfo, boolean isDynamicAnalysis) throws Exception {
        CustomerParams guideParams = null;
        CustomerParams filterParams = null;
        if (owner instanceof AnalysisRptProcessUI) {
            if (ItemAnalysisHepler.getInstance().isBasePointCell(book.getActiveSheet(), book.getActiveSheet().getActiveRow(), book.getActiveSheet().getActiveCol())) {
                AnalysisBasePointParams params = ItemAnalysisHepler.getInstance().getParametersFromCell(book.getActiveSheet().getActiveCell());
                if (params.isMidTableAnalysis()) {
                    if (isDynamicAnalysis) {
                        MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"86_dyItemCanNotAnalysis"));
                        SysUtil.abort();
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"97_itemCanNotAnalysis"));
                        SysUtil.abort();
                    }
                }
                if (params.isDynamicAnalysis() && !isDynamicAnalysis) {
                    MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"86_dyItemCanNotAnalysis"));
                    SysUtil.abort();
                } else if (!params.isDynamicAnalysis() && isDynamicAnalysis) {
                    MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"97_itemCanNotAnalysis"));
                    SysUtil.abort();
                }
                guideParams = params.getAnalysisGuideParams();
                guideParams.addCustomerParam("startRange", book.getActiveSheet().getSelectionRange().getName());
                filterParams = params.getAnalysisFilterParams();
            } else {
                ArrayList basePointList = this.getBasePointList(book.getActiveSheet());
                if (basePointList != null && !basePointList.isEmpty()) {
                    MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"114_selectBasePoint"));
                    SysUtil.abort();
                }
            }
        } else {
            filterParams = this.getAnalysisFilterCustomerParams(spreadManager, reportInfo, isDynamicAnalysis);
        }
        return new CustomerParams[]{guideParams, filterParams};
    }

    public CommonQueryDialog initCommonQueryDialog(Book book, SpreadManager spreadManager, CustomerParams guideParams, CustomerParams filterParams, Component owner, boolean isDynamicAnalysis) throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
        }
        this.dialog.setOwner(owner);
        for (Object userPanel : this.dialog.getUserPanels()) {
            this.dialog.removeUserPanel((KDPanel)userPanel);
        }
        if (this.guideUi == null) {
            this.guideUi = new ItemAnalysisGuideUI();
        }
        this.guideUi.setSpreadManager(spreadManager);
        this.guideUi.setSheet(book != null ? book.getActiveSheet() : null);
        this.guideUi.setDynamicAnalysis(isDynamicAnalysis);
        if (this.filterUi == null) {
            this.filterUi = new ItemAnalysisFilterUI();
        }
        this.filterUi.setSheet(book != null ? book.getActiveSheet() : null);
        this.filterUi.setDynamicAnalysis(isDynamicAnalysis);
        this.filterUi.setInitCustomerParams(filterParams);
        this.guideUi.setInitCustomerParams(guideParams);
        this.guideUi.setFromReport(owner instanceof BaseReportDesignerUI);
        this.dialog.setUiObject((IUIObject)owner);
        this.dialog.setParentUIClassName(AnalysisRptProcessUI.class.getName());
        this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK(isDynamicAnalysis ? "com.kingdee.eas.fi.newrpt.AnalysisReportQuery" : "com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery"));
        this.dialog.setTitle(!isDynamicAnalysis ? EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"88_itemAnalysisGuide") : EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"97_dyItemAnalysisGuide"));
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        this.dialog.setMaxReturnCountVisible(false);
        this.dialog.setVisibleTableCols(null);
        this.dialog.addUserPanel((KDPanel)this.guideUi);
        this.dialog.addUserPanel((KDPanel)this.filterUi);
        this.dialog.setHeight(420);
        this.dialog.setWidth(600);
        return this.dialog;
    }

    private IUIWindow getAnalysisRptWindow(UIContext uiContext, String OprtState2) throws Exception {
        if (uiContext == null) {
            uiContext = new UIContext();
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AnalysisRptProcessUI.class.getName(), (Map)uiContext, null, OprtState2);
        return uiWindow;
    }

    public AnalysisRptProcessUI openAnalysisRpt(UIContext uiContext, String OprtState2) throws Exception {
        IUIWindow uiWindow = this.getAnalysisRptWindow(uiContext, OprtState2);
        uiWindow.show();
        return (AnalysisRptProcessUI)uiWindow.getUIObject();
    }

    public boolean showAnalysisEditUI(AnalysisReportInfo info, Object owner, String OprtState2, boolean isAnalysisRptOpened) throws Exception {
        String id = info != null && info.getId() != null ? info.getId().toString() : null;
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"Object", (Object)info);
        uiContext.put((Object)"isAnalysisRptOpened", (Object)isAnalysisRptOpened);
        if (owner instanceof AnalysisReportListUI) {
            uiContext.put((Object)"AnalysisReportListUI", owner);
        }
        int winStyle = 95;
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AnalysisReportEditUI.class.getName(), (Map)uiContext, null, OprtState2, winStyle &= 0xFFFFFFF4);
        w.show();
        return ((AnalysisReportEditUI)w.getUIObject()).isOk();
    }

    public String solutOrgs2Str(List orgList) {
        if (orgList != null && !orgList.isEmpty() && orgList.get(0) instanceof ManageMergeOrgUnit) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : orgList) {
                sb.append(((ManageMergeOrgUnit)obj).toStringReal()).append(ItemAnalysisConstant.solutOrgSplit);
            }
            return sb.toString();
        }
        return null;
    }

    public List<ManageMergeOrgUnit> str2SolutOrg(String orgStrs) {
        ManageMergeOrgUnit info;
        String[] arr;
        if (!StringUtils.isEmpty((String)orgStrs) && (arr = orgStrs.split(ItemAnalysisConstant.solutOrgSplit)).length > 0 && (info = ManageMergeOrgUnit.parse((String)arr[0])) != null) {
            ArrayList<ManageMergeOrgUnit> infoLis = new ArrayList<ManageMergeOrgUnit>();
            for (String objStr : arr) {
                info = ManageMergeOrgUnit.parse((String)objStr);
                if (info == null) continue;
                infoLis.add(info);
            }
            return infoLis;
        }
        return null;
    }

    public void setShowOrHide(Sheet sheet, List<Integer> rowOrColList, int offSet, boolean isHide, boolean isRow) throws Exception {
        if (!rowOrColList.isEmpty()) {
            Collections.sort(rowOrColList, (Comparator)new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Integer)o1).compareTo((Integer)o1);
                }
            });
            int start = -1;
            int end = -1;
            Range range = null;
            for (int rowOrCol : rowOrColList) {
                if (start < 0) {
                    start = rowOrCol;
                }
                if (end < 0) {
                    end = rowOrCol;
                    continue;
                }
                if (end + 1 == rowOrCol) {
                    end = rowOrCol;
                    continue;
                }
                range = isRow ? sheet.getRowRange(offSet + start, offSet + end) : sheet.getColRange(offSet + start, offSet + end);
                range.setHidden(isHide, isRow);
                start = rowOrCol;
                end = rowOrCol;
            }
            if (start >= 0 && end >= 0 && start <= end) {
                range = isRow ? sheet.getRowRange(offSet + start, offSet + end) : sheet.getColRange(offSet + start, offSet + end);
                range.setHidden(isHide, isRow);
            }
            rowOrColList.clear();
        }
    }
}

