/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.report;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportDesignerUI;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptProcessUI;
import com.kingdee.eas.fi.newrpt.client.report.ItemAnalysisHandle;
import com.kingdee.eas.fi.newrpt.client.report.MidTableAnalysisFilterUI;
import com.kingdee.eas.fi.newrpt.client.report.MidTableAnalysisGuideUI;
import com.kingdee.eas.fi.newrpt.report.AnalysisBasePointParams;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.Map;

public class MidTableAnalysisHelper {
    private static MidTableAnalysisHelper helper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MidTableAnalysisHelper getInstance() {
        Class<MidTableAnalysisHelper> clazz = MidTableAnalysisHelper.class;
        synchronized (MidTableAnalysisHelper.class) {
            if (helper == null) {
                helper = new MidTableAnalysisHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return helper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analysis(Book book, SpreadManager spreadManager, Component owner, ReportBaseInfo reportInfo, Map<Object, Object> asstParam, boolean isDynamicAnalysis) throws Exception {
        CustomerParams filterParams;
        CustomerParams[] customerParamsArr = this.initCustomerParams(book, spreadManager, owner, reportInfo, isDynamicAnalysis);
        CustomerParams guideParams = customerParamsArr[0];
        CommonQueryDialog dialog = this.initCommonQueryDialog(book, spreadManager, guideParams, filterParams = customerParamsArr[1], owner, isDynamicAnalysis);
        boolean isOk = dialog.show();
        if (isOk) {
            try {
                for (int i = 0; i < 2; ++i) {
                    if (dialog.getUserPanel(i) instanceof MidTableAnalysisGuideUI) {
                        guideParams = ((MidTableAnalysisGuideUI)dialog.getUserPanel(i)).getCustomerParams();
                        continue;
                    }
                    filterParams = ((MidTableAnalysisFilterUI)dialog.getUserPanel(i)).getCustomerParams();
                }
                Book curBook = book;
                if (owner instanceof BaseReportDesignerUI && reportInfo != null) {
                    AnalysisRptProcessUI uiObject = ItemAnalysisHepler.getInstance().openAnalysisRpt(null, OprtState.ADDNEW);
                    curBook = uiObject.getBook();
                }
                curBook.setCalculate(false);
                ItemAnalysisHandle handle = new ItemAnalysisHandle();
                handle.init(spreadManager, curBook.getActiveSheet(), guideParams, filterParams, isDynamicAnalysis);
                handle.analysisHandle();
            }
            finally {
                spreadManager.getModifyManager().setModified();
                spreadManager.getSpreadContainer().repaint();
            }
        }
    }

    public CommonQueryDialog initCommonQueryDialog(Book book, SpreadManager spreadManager, CustomerParams guideParams, CustomerParams filterParams, Component owner, boolean isDynamicAnalysis) throws Exception {
        CommonQueryDialog dialog = new CommonQueryDialog();
        dialog.setOwner(owner);
        MidTableAnalysisGuideUI guideUi = new MidTableAnalysisGuideUI();
        guideUi.setSpreadManager(spreadManager);
        guideUi.setSheet(book != null ? book.getActiveSheet() : null);
        guideUi.setDynamicAnalysis(isDynamicAnalysis);
        guideUi.setInitCustomerParams(guideParams);
        guideUi.setFromReport(owner instanceof BaseReportDesignerUI);
        MidTableAnalysisFilterUI filterUi = new MidTableAnalysisFilterUI();
        filterUi.setSheet(book != null ? book.getActiveSheet() : null);
        filterUi.setDynamicAnalysis(isDynamicAnalysis);
        filterUi.setInitCustomerParams(filterParams);
        filterUi.setRefreshListener(guideUi);
        dialog.setUiObject((IUIObject)owner);
        dialog.setParentUIClassName(AnalysisRptProcessUI.class.getName());
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.newrpt.MidTableAnalysisReportQuery"));
        dialog.setTitle(!isDynamicAnalysis ? EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"88_itemAnalysisGuide") : EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"97_dyItemAnalysisGuide"));
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setMaxReturnCountVisible(false);
        dialog.setVisibleTableCols(null);
        dialog.addUserPanel((KDPanel)filterUi);
        dialog.addUserPanel((KDPanel)guideUi);
        dialog.setHeight(420);
        dialog.setWidth(600);
        return dialog;
    }

    public CustomerParams[] initCustomerParams(Book book, SpreadManager spreadManager, Component owner, ReportBaseInfo reportInfo, boolean isDynamicAnalysis) throws Exception {
        CustomerParams guideParams = null;
        CustomerParams filterParams = null;
        if (owner instanceof AnalysisRptProcessUI) {
            if (ItemAnalysisHepler.getInstance().isBasePointCell(book.getActiveSheet(), book.getActiveSheet().getActiveRow(), book.getActiveSheet().getActiveCol())) {
                AnalysisBasePointParams params = ItemAnalysisHepler.getInstance().getParametersFromCell(book.getActiveSheet().getActiveCell());
                if (!params.isMidTableAnalysis()) {
                    MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"IsNot_MidTableAnalysis_BasePoint"));
                    SysUtil.abort();
                }
                guideParams = params.getAnalysisGuideParams();
                guideParams.addCustomerParam("startRange", book.getActiveSheet().getSelectionRange().getName());
                filterParams = params.getAnalysisFilterParams();
            }
        } else {
            filterParams = this.getAnalysisFilterCustomerParams(spreadManager, reportInfo, isDynamicAnalysis);
        }
        return new CustomerParams[]{guideParams, filterParams};
    }

    public CustomerParams getAnalysisFilterCustomerParams(SpreadManager spreadManager, ReportBaseInfo reportInfo, boolean isDynamicAnalysis) throws Exception {
        CustomerParams params = new CustomerParams();
        params.addCustomerParam("START_YEAR", String.valueOf(reportInfo.getYear()));
        params.addCustomerParam("START_PERIOD", String.valueOf(reportInfo.getPeriod()));
        params.addCustomerParam("startDate", RPTDateUtil.formateDate((Date)reportInfo.getStartDate(), (String)"yyyy-MM-dd"));
        params.addCustomerParam("endDate", RPTDateUtil.formateDate((Date)reportInfo.getEndDate(), (String)"yyyy-MM-dd"));
        if (reportInfo.getCurrency() != null) {
            params.addCustomerParam("currencyNum", reportInfo.getCurrency().getNumber());
        }
        if (!(reportInfo instanceof CslReportInfo)) {
            params.addCustomerParam("companyNum", reportInfo.getCompany().getNumber());
        }
        params.addCustomerParam("orgType", "" + reportInfo.getOrgType().getValue());
        return params;
    }
}

