/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.report;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.ReportFieldInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.SelectNumOrNameEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslCommonQueryDialog;
import com.kingdee.eas.fi.newrpt.EipReportFieldEnum;
import com.kingdee.eas.fi.newrpt.EipRptMidDataParamFactory;
import com.kingdee.eas.fi.newrpt.EipRptMidDataParamInfo;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.report.EipRptDataGenReportFilterUI;
import com.kingdee.eas.fi.newrpt.report.MidTableAnalysisHelper;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MidTableShowHelper {
    private static MidTableShowHelper helper;
    private Book book;
    CommonQueryDialog conditionDialog = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MidTableShowHelper getInstance() {
        Class<MidTableAnalysisHelper> clazz = MidTableAnalysisHelper.class;
        synchronized (MidTableAnalysisHelper.class) {
            if (helper == null) {
                helper = new MidTableShowHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return helper;
        }
    }

    public void processEipData(SpreadManager spreadManager, Book bookParam, Component owner) throws Exception {
        this.book = bookParam;
        if (this.getConditionDialog(owner).show()) {
            Sheet activeSheet = this.book.getActiveSheet();
            EipRptDataGenReportFilterUI eipRptDataGenReportFilterUI = (EipRptDataGenReportFilterUI)this.conditionDialog.getUserPanel(0);
            Map<String, Object> params = this.preFilterUIParams(eipRptDataGenReportFilterUI);
            Map returnMap = EipRptMidDataParamFactory.getRemoteInstance().getMidDataByParams(params);
            if (returnMap.get("errorStr") != null) {
                List errorList = (List)returnMap.get("errorStr");
                StringBuffer strTip = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    strTip.append(errorList.get(i));
                }
                MsgBox.showConfirm2((String)strTip.toString());
                SysUtil.abort();
            }
            List dataList = (List)returnMap.get("dataList");
            Map dataElements = (Map)returnMap.get("dataElement");
            List selectNames = (List)returnMap.get("selectNames");
            List reportFields = (List)params.get("reportFields");
            activeSheet.getRange(0, 0, activeSheet.getRows().getMaxIntMark() + 1, activeSheet.getCols().getMaxIntMark() + 1).clear(true, true, true, true, new String[0]);
            int colIndex = 0;
            for (int i = 0; i < reportFields.size(); ++i) {
                ReportFieldInfo info = (ReportFieldInfo)((EipRptMidDataParamInfo)reportFields.get(i)).get("reportField");
                if (IntegrateSchemeHelper.Fields.fdataelement.name().equals(info.getNumber().toLowerCase()) || IntegrateSchemeHelper.Fields.famount.name().equals(info.getNumber().toLowerCase())) continue;
                this.setLocalNameByNum(info);
                String numStr = info.getName();
                String nameStr = info.getName();
                Object showNameOrNum = ((EipRptMidDataParamInfo)reportFields.get(i)).get("showNameNum");
                if (SelectNumOrNameEnum.NAMEORNUMBER.equals(showNameOrNum)) {
                    nameStr = nameStr + SelectNumOrNameEnum.NAME.getAlias();
                    numStr = numStr + SelectNumOrNameEnum.NUMBER.getAlias();
                }
                activeSheet.getRange(0, colIndex).setValue(new Variant((Object)nameStr));
                this.setMerge(activeSheet, 0, colIndex, 1, colIndex);
                ++colIndex;
                if (!SelectNumOrNameEnum.NAMEORNUMBER.equals(showNameOrNum)) continue;
                activeSheet.getRange(0, colIndex).setValue(new Variant((Object)numStr));
                this.setMerge(activeSheet, 0, colIndex, 1, colIndex);
                ++colIndex;
            }
            Set dataElementNames = dataElements.keySet();
            for (String name : dataElementNames) {
                activeSheet.getRange(0, colIndex).setValue(new Variant((Object)name));
                this.setMerge(activeSheet, 0, colIndex, 0, colIndex + 1);
                activeSheet.getRange(1, colIndex).setValue(new Variant((Object)DebitOrCreditEnum.DEBIT.getAlias()));
                this.setAlignCenter(activeSheet.getRange(1, colIndex));
                activeSheet.getRange(1, ++colIndex).setValue(new Variant((Object)DebitOrCreditEnum.CREDIT.getAlias()));
                this.setAlignCenter(activeSheet.getRange(1, colIndex));
                ++colIndex;
            }
            reportFields = (List)params.get("asstActItemList");
            if (reportFields != null) {
                for (int i = 0; i < reportFields.size(); ++i) {
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((EipRptMidDataParamInfo)reportFields.get(i)).get("asstActType");
                    activeSheet.getRange(0, colIndex).setValue(new Variant((Object)EipReportFieldEnum.ASST_NUMBER.getAlias()));
                    activeSheet.getRange(1, colIndex).setValue(new Variant((Object)asstActTypeInfo.getName()));
                    this.setAlignCenter(activeSheet.getRange(1, colIndex));
                    ++colIndex;
                }
                this.setMerge(activeSheet, 0, colIndex - reportFields.size(), 0, colIndex - 1);
            }
            for (int i = 2; i < dataList.size() + 2; ++i) {
                EipRptMidDataParamInfo dataInfo = (EipRptMidDataParamInfo)dataList.get(i - 2);
                colIndex = 0;
                for (int j = 0; j < selectNames.size(); ++j) {
                    activeSheet.getRange(i, colIndex).setValue(new Variant(dataInfo.get((String)selectNames.get(j))));
                    this.autoSetColWidth(spreadManager, activeSheet, i, colIndex);
                    this.setAlignCenter(activeSheet.getRange(i, colIndex));
                    ++colIndex;
                }
                dataElementNames = dataElements.keySet();
                for (String name : dataElementNames) {
                    if (dataInfo.getInt("dc") == -1) {
                        ++colIndex;
                    }
                    activeSheet.getRange(i, colIndex).setValue(new Variant(dataInfo.get("dataCFFVALUE")));
                    this.autoSetColWidth(spreadManager, activeSheet, i, colIndex);
                    if (dataInfo.getInt("dc") == 1) {
                        ++colIndex;
                    }
                    ++colIndex;
                }
                reportFields = (List)params.get("asstActItemList");
                for (int j = 0; j < reportFields.size(); ++j) {
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((EipRptMidDataParamInfo)reportFields.get(j)).get("asstActType");
                    activeSheet.getRange(i, colIndex).setValue(new Variant(dataInfo.get(asstActTypeInfo.getNumber())));
                    this.autoSetColWidth(spreadManager, activeSheet, i, colIndex);
                    this.setAlignCenter(activeSheet.getRange(i, colIndex));
                    ++colIndex;
                }
            }
        }
    }

    private void setLocalNameByNum(ReportFieldInfo info) {
        if ("fcompanynum".equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.COMPANY.getAlias());
        } else if (IntegrateSchemeHelper.Fields.fcurrencynum.name().equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.CURRENCY.getAlias());
        } else if ("famount".equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.AMOUNT.getAlias());
        } else if ("fbizdate".equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.BIZ_DATE.getAlias());
        } else if ("fdataelement".equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.DATA_ELEMENT.getAlias());
        } else if ("fvaluetype".equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.VALUE_TYPE.getAlias());
        } else if ("ftextvalue".equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.TXT_VALUE.getAlias());
        } else if ("faccountnum".equals(info.getNumber().toLowerCase())) {
            info.setName(EipReportFieldEnum.ACCOUNT.getAlias());
        }
    }

    private Map<String, Object> preFilterUIParams(EipRptDataGenReportFilterUI eipRptDataGenReportFilterUI) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        BillMappingInfo billmMppingInfo = eipRptDataGenReportFilterUI.getF7Value();
        params.put("billMapping", billmMppingInfo);
        if (eipRptDataGenReportFilterUI.getShowAsstActItem()) {
            ArrayList<EipRptMidDataParamInfo> asstActItemList = new ArrayList<EipRptMidDataParamInfo>();
            ArrayList<EipRptMidDataParamInfo> asstActFilterList = new ArrayList<EipRptMidDataParamInfo>();
            KDTable asstActTable = eipRptDataGenReportFilterUI.getAsstActTable();
            for (int i = 0; i < asstActTable.getRowCount(); ++i) {
                if (!((Boolean)asstActTable.getCell(i, "selected").getValue()).booleanValue()) continue;
                EipRptMidDataParamInfo paramsInfo = new EipRptMidDataParamInfo();
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTable.getCell(i, "fieldInfo").getValue();
                paramsInfo.put("asstActType", asstActTypeInfo);
                Object filterTemp = asstActTable.getCell(i, "filterStart").getValue();
                if (filterTemp != null) {
                    paramsInfo.put("filterStart", filterTemp instanceof String ? filterTemp.toString() : ((DataBaseInfo)filterTemp).getNumber());
                    asstActFilterList.add(paramsInfo);
                }
                if ((filterTemp = asstActTable.getCell(i, "filterEnd").getValue()) != null) {
                    paramsInfo.put("filterEnd", filterTemp instanceof String ? filterTemp.toString() : ((DataBaseInfo)filterTemp).getNumber());
                }
                asstActItemList.add(paramsInfo);
            }
            params.put("asstActItemList", asstActItemList);
            params.put("asstActFilterList", asstActFilterList);
        }
        ArrayList<EipRptMidDataParamInfo> reportFields = new ArrayList<EipRptMidDataParamInfo>();
        KDTable table = eipRptDataGenReportFilterUI.getDataFieldTable();
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (!((Boolean)table.getCell(i, "selected").getValue()).booleanValue()) continue;
            EipRptMidDataParamInfo paramsInfo = new EipRptMidDataParamInfo();
            ReportFieldInfo reportField = (ReportFieldInfo)table.getCell(i, "fieldInfo").getValue();
            paramsInfo.put("reportField", reportField);
            Object showNameNum = table.getCell(i, "showNameOrNum").getValue();
            paramsInfo.put("showNameNum", showNameNum);
            reportFields.add(paramsInfo);
        }
        params.put("reportFields", reportFields);
        params.put("company", eipRptDataGenReportFilterUI.getCompanyNumStr());
        params.put("currency", eipRptDataGenReportFilterUI.getCurrencyNumStr());
        params.put("dataElement", eipRptDataGenReportFilterUI.getDataElementNumsStr());
        params.put("accountSrtatr", eipRptDataGenReportFilterUI.getAccountSrtatrNumStr());
        params.put("accountEnd", eipRptDataGenReportFilterUI.getAccountEndNumStr());
        params.put("dateStart", eipRptDataGenReportFilterUI.getDateStart());
        params.put("dateEnd", eipRptDataGenReportFilterUI.getDateEnd());
        return params;
    }

    private void setMerge(Sheet sheet, int top, int left, int bottom, int right) {
        Range rg = sheet.getRange(top, left, bottom, right);
        Book book = sheet.getBook();
        boolean merged = book.getActiveSheet().isMerged(rg.getBlock(0));
        rg.merge();
        if (!merged) {
            this.setAlignCenter(rg);
        }
    }

    private void setAlignCenter(Range rg) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        rg.setStyle(sa, sa);
    }

    public CommonQueryDialog getConditionDialog(Component owner) throws Exception {
        this.conditionDialog = new CslCommonQueryDialog();
        this.conditionDialog.setOwner(owner);
        this.conditionDialog.setShowFilter(false);
        this.conditionDialog.setShowSorter(false);
        this.conditionDialog.setWidth(600);
        this.conditionDialog.setHeight(600);
        this.conditionDialog.setTitle(CslRptUtil.getString((String)"midTableShow"));
        this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.newrpt.client.designer.BaseReportDesignerUI");
        this.conditionDialog.setUiObject((IUIObject)owner);
        this.conditionDialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery"));
        this.conditionDialog.setShowFilter(false);
        this.conditionDialog.setShowSorter(false);
        this.conditionDialog.setMaxReturnCountVisible(false);
        this.conditionDialog.setVisibleTableCols(null);
        this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel(this.conditionDialog));
        return this.conditionDialog;
    }

    public CustomerQueryPanel getConditionPanel(CommonQueryDialog conditionDialog) throws Exception {
        EipRptDataGenReportFilterUI conditionPanel = null;
        if (conditionPanel == null) {
            conditionPanel = new EipRptDataGenReportFilterUI();
            conditionPanel.setPanelName(CslRptUtil.getString((String)"eipRptDataGenReportFilterUITitle"));
        }
        conditionPanel.getUIContext().put("conditionDialog", conditionDialog);
        return conditionPanel;
    }

    private void autoSetColWidth(SpreadManager spreadManager, Sheet sheet, int row, int col) {
        int w;
        if (spreadManager == null) {
            return;
        }
        KDSpread spread = spreadManager.getSpreadContainer().getSpread();
        Graphics2D g2d = (Graphics2D)spread.getGraphics();
        Cell cell = sheet.getCell(row, col, false);
        int width = sheet.getColRange(col, col).getColumnWidth();
        FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
        ICellDisplayProvider cvp = spread.getCellDisplayProvider();
        Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
        if (value instanceof String && ((w = fm.stringWidth((String)value)) > width || width - w < 30)) {
            width = w + 30;
        }
        if (width > 0) {
            sheet.getColRange(col, col).setColumnWidth(width);
        }
    }
}

