/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptInExcel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.newrpt.rptInExcel.IReportInExcelSchm;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelHelper;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelMustInputInfo;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelSchmFactory;
import com.kingdee.eas.fi.newrpt.rptInExcel.client.AbstractRptInExcelImportWizardPage3UI;
import com.kingdee.eas.fi.newrpt.rptInExcel.client.RptInExcelImportWizard;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class RptInExcelImportWizardPage3UI
extends AbstractRptInExcelImportWizardPage3UI {
    private static final Logger logger = CoreUIObject.getLogger(RptInExcelImportWizardPage3UI.class);
    private ArrayList filesList = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Icon getImage() {
        return RptInExcelImportWizard.getWizardImage();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void loadPage() {
        this.tblFileList.getColumn("status").setWidth(80);
        this.tblFileList.getColumn("name").setWidth(200);
        this.tblFileList.getColumn("describe").setWidth(120);
        this.getMyWizard().setComplete(false);
        super.loadPage();
        this.tblFileList.getSelectManager().setSelectMode(10);
        this.lblHint.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_doing_caption"));
        this.filesList = this.getMyWizard().getFilesToImport();
        this.tblFileList.setRefresh(false);
        this.tblFileList.removeRows();
        this.tblFileList.getStyleAttributes().setLocked(true);
        this.tblFileList.addRows(this.filesList.size());
        for (int i = 0; i < this.filesList.size(); ++i) {
            this.tblFileList.getCell(i, "status").setRenderer((IBasicRender)new CompsiteRender());
            this.tblFileList.getCell(i, "status").setValue((Object)0);
            File file = (File)this.filesList.get(i);
            this.tblFileList.getCell(i, "name").setValue((Object)file.getName());
        }
        this.tblFileList.setRefresh(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RptInExcelImportWizardPage3UI.this.importExcel();
                }
                catch (Exception e) {
                    logger.error((Object)("importExcel() : " + e.getMessage()));
                }
                finally {
                    RptInExcelImportWizardPage3UI.this.complete();
                    RptInExcelImportWizardPage3UI.this.lblHint.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_finish_caption"));
                }
            }
        }).start();
    }

    private void complete() {
        this.getMyWizard().setComplete(true);
        this.getMyWizard().getBtnFinish().setEnabled(true);
    }

    private void importExcel() throws EASBizException, BOSException {
        File file;
        if (this.tblFileList.getRowCount() <= 0) {
            return;
        }
        ReportInExcelMustInputInfo mustInputInfo = this.getMyWizard().getMustInputInfo();
        Map<Object, Object> infoMap = mustInputInfo.getInfoMap();
        CtrlUnitInfo cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"));
        infoMap.put("CU", cu);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        infoMap.put("user", user);
        ArrayList list = this.getMyWizard().getFilesToImport();
        Map analysisMap = null;
        FullOrgUnitInfo unit = mustInputInfo.getUnit();
        if (unit != null && unit.getId() != null && unit.isIsUnion()) {
            try {
                OrgStructureInfo orgStructureInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo("select tree where unit = '" + unit.getId().toString() + "'");
                unit.put("treeId", (Object)orgStructureInfo.getTree().getId().toString());
            }
            catch (Exception e) {
                logger.error((Object)("importExcel_getOrgStructureInfo_error:" + e.getMessage()));
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"getTreeId_error"));
            }
        }
        if (mustInputInfo.getSchmInfo().getEntries().size() > 0 && StringUtils.isEmpty((String)mustInputInfo.getErrorMsg())) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                file = (File)list.get(i);
                fileNameList.add(file.getName());
            }
            try {
                analysisMap = this.getBizInterface().analysisExcelName(mustInputInfo, fileNameList);
            }
            catch (Exception e1) {
                logger.error((Object)("importExcel_analysisExcelName_error:" + e1.getMessage()));
            }
        }
        ReportInExcelMustInputInfo generateReportInfo = mustInputInfo;
        ReportInExcelHelper reExcelHelper = new ReportInExcelHelper();
        for (int i = 0; i < list.size(); ++i) {
            file = (File)list.get(i);
            this.tblFileList.getCell(i, "status").setValue((Object)50);
            if (analysisMap != null && !StringUtils.isEmpty((String)(generateReportInfo = (ReportInExcelMustInputInfo)analysisMap.get(file.getName())).getErrorMsg())) {
                this.fill_tblFileList(i, "FAILURE", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_fail"), generateReportInfo.getErrorMsg()));
                continue;
            }
            if (!this.verifyRptInExcelInfo(generateReportInfo) || !StringUtils.isEmpty((String)generateReportInfo.getErrorMsg())) {
                this.fill_tblFileList(i, "FAILURE", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_fail"), generateReportInfo.getErrorMsg()));
                continue;
            }
            ArrayList resultList = null;
            try {
                resultList = reExcelHelper.importExcel(null, generateReportInfo, file);
            }
            catch (Exception e) {
                logger.error((Object)("importExcel_error_" + file.getName() + "::" + e.getMessage()));
                String errorMsg = e instanceof ServerException && ((ServerException)e).getSubCode().equals(ServerException.EXCELNAME_ANALYSIS_ERROR.getCode()) ? ((ServerException)e).getMessage() : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"excelName_import_error");
                this.fill_tblFileList(i, "FAILURE", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_fail"), errorMsg));
                continue;
            }
            if (!resultList.isEmpty()) {
                Object result_status = resultList.get(0);
                if ("SUCCESS".equals(result_status)) {
                    this.fill_tblFileList(i, "SUCCESS", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_success"));
                    continue;
                }
                this.fill_tblFileList(i, "FAILURE", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_fail"), resultList.get(1)));
                continue;
            }
            this.fill_tblFileList(i, "FAILURE", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_fail"), ""));
        }
    }

    private boolean verifyRptInExcelInfo(ReportInExcelMustInputInfo generateReportInfo) {
        return generateReportInfo.getUnit() != null && generateReportInfo.getUnit().getId() != null && generateReportInfo.getTemp() != null && generateReportInfo.getTemp().getId() != null && generateReportInfo.getCurrency() != null && generateReportInfo.getCurrency().getId() != null && generateReportInfo.getPeriodType() != null && generateReportInfo.getYear() != null && generateReportInfo.getPeriod() != null && generateReportInfo.getStatus() != null;
    }

    private void fill_tblFileList(int index, String status, String describe) {
        if ("SUCCESS".equals(status)) {
            this.tblFileList.getCell(index, "status").setValue((Object)"SUCCESS");
        } else {
            this.tblFileList.getCell(index, "status").setValue((Object)"FAILURE");
        }
        this.tblFileList.getCell(index, "describe").setValue((Object)describe);
    }

    private IReportInExcelSchm getBizInterface() throws Exception {
        return ReportInExcelSchmFactory.getRemoteInstance();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private RptInExcelImportWizard getMyWizard() {
        return (RptInExcelImportWizard)super.getWizard();
    }

    private static class ProgressBarRender
    extends KDProgressBar
    implements IBasicRender {
        public ProgressBarRender() {
            this.setStringPainted(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object instanceof Integer) {
                this.setValue((Integer)object);
            }
            Rectangle rect = clip.getBounds();
            rect.x += 2;
            rect.y += 4;
            rect.width -= 6;
            rect.height -= 8;
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }
    }

    private static class IconRender
    extends KDLabel
    implements IBasicRender {
        public IconRender() {
            this.setHorizontalAlignment(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object value, Style cellStyle) {
            if ("SUCCESS".equals(value)) {
                this.setIcon(EASResource.getIcon((String)"imgTable_success"));
            } else if ("FAILURE".equals(value)) {
                this.setIcon(EASResource.getIcon((String)"imgTable_failure"));
            } else {
                this.setIcon(null);
            }
            Rectangle rect = clip.getBounds();
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }

        protected void printComponent(Graphics g) {
            super.printComponent(g);
            g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }

    private static class CompsiteRender
    implements IBasicRender {
        public void draw(Graphics graphics, Shape clip, Object value, Style cellStyle) {
            if (value instanceof Integer) {
                new ProgressBarRender().draw(graphics, clip, value, cellStyle);
            } else if ("SUCCESS".equals(value) || "FAILURE".equals(value)) {
                new IconRender().draw(graphics, clip, value, cellStyle);
            }
        }
    }
}

