/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.qinganalysis.ui.PublishedQingAnalysisExplorer;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Map;

public class AbstractDigitalSignsUI
extends PublishedQingAnalysisExplorer {
    private static final long serialVersionUID = -8493380390760921495L;
    public static final String RES = "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource";
    boolean hasLicence = false;

    public void onLoad() throws Exception {
        this.checkLicenseByHand();
        this.checkMenuPerm();
        super.onLoad();
    }

    private void checkLicenseByHand() throws Exception {
        this.hasLicence = CslRptUIUtil.requestLicense((Map)this.getUIContext(), (CoreUI)this, (String)this.getModule(), (String)this.getClassName());
    }

    private void checkMenuPerm() throws EASBizException, BOSException {
        String perItem = this.getPermItem();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        String id = orgUnitInfo.getId().toString();
        ObjectUuidPK orgPK = new ObjectUuidPK(id);
        IPermission permission = PermissionFactory.getRemoteInstance();
        if (orgPK != null && userPK != null && !permission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, perItem)) {
            String userNumber = this.getUserNumber(userInfo);
            String orgName = this.getOrgName((IObjectPK)orgPK);
            String title = this.getUITitleName();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"103_noPerm", (Object[])new Object[]{userNumber, orgName, title}));
            SysUtil.abort();
        }
    }

    private String getOrgName(IObjectPK orgPK) throws EASBizException, BOSException {
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo(orgPK);
        return orgInfo.getName();
    }

    private String getUserNumber(UserInfo userInfo) throws EASBizException, BOSException {
        String id = userInfo.getId().toString();
        UserInfo user = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(id));
        return user.getNumber();
    }

    public String getUITitleName() {
        return null;
    }

    public String getModule() {
        return "CSLDB";
    }

    public String getPermItem() {
        return null;
    }

    public String getClassName() {
        return null;
    }

    public boolean destroyWindow() {
        this.releaseLicense();
        return super.destroyWindow();
    }

    private void releaseLicense() {
        if (this.hasLicence) {
            CslRptUIUtil.releaseLicense((String)this.getModule(), (String)this.getClassName());
        }
    }

    public IMetaDataPK getMetaDataPK() {
        return null;
    }
}

