/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AbstractAnalyzeIndexListUI;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ReportNotesClientUtil;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.client.GroupTreecomponent;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class AnalyzeIndexListUI
extends AbstractAnalyzeIndexListUI {
    private static final long serialVersionUID = 4991207128823051084L;
    private static final Logger logger = CoreUIObject.getLogger(AnalyzeIndexListUI.class);
    protected GroupTreecomponent treeComponent = null;
    protected String companyId = null;
    protected List<String> deleteIds = new ArrayList<String>();
    private static final String RES = "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource";
    boolean isNeedCheck = true;
    boolean isAbort = false;
    private static final String[] defaultIndexNumbers = new String[]{"CZ0001", "CZ0002", "CZ0003", "CZ0004", "CZ0005", "CZ0006", "CZ0007", "CZ0008", "CZ0009", "YY0001", "YY0002", "YY0003", "YY0004", "YY0005", "YY0006", "YY0007", "YY0008", "YY0009", "YY0010", "YY0011", "YY0012", "YY0013", "YY0014", "YY0015", "YY0016", "YY0017", "YY0018", "YL0001", "YL0002", "YL0003", "YL0004", "YL0005", "YL0006"};

    public AnalyzeIndexListUI() throws Exception {
        this.companyId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        this.treeComponent = new GroupTreecomponent((ListUI)this, this.treeView, DisplayTemplateTypeEnum.ALALYZEINDEX);
        this.treeComponent.setTemplateTypeFieldString("indexType.id");
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                int n = end;
                for (int i = begin; i <= n; ++i) {
                    if (AnalyzeIndexListUI.this.tblMain.getRow(i) == null || AnalyzeIndexListUI.this.isCanEdit(null, i)) continue;
                    AnalyzeIndexListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
                    AnalyzeIndexListUI.this.tblMain.getRow(i).getCell("number").getStyleAttributes().setLocked(true);
                    AnalyzeIndexListUI.this.tblMain.getRow(i).getCell("name").getStyleAttributes().setLocked(true);
                    AnalyzeIndexListUI.this.tblMain.getRow(i).getCell("formula").getStyleAttributes().setLocked(true);
                    AnalyzeIndexListUI.this.tblMain.getRow(i).getCell("description").getStyleAttributes().setLocked(true);
                }
            }
        });
    }

    protected boolean isCanEdit(IRow row, int rowIndex) {
        Object createCompanyId = null;
        createCompanyId = row != null ? row.getCell("company.id").getValue() : this.tblMain.getCell(rowIndex, "company.id").getValue();
        return createCompanyId == null || createCompanyId.equals(this.companyId);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.treeComponent.setRootDisplayName(EASResource.getString((String)RES, (String)"1_AnalyzeType"));
        this.treeComponent.initialize();
        this.menuItemBatchMove.setVisible(true);
        this.menuItemBatchMove.setEnabled(true);
        this.menuItemBatchMove.setCustomAction((Action)this.treeComponent.getActionBatchMove());
        this.actionRefresh_actionPerformed(null);
    }

    private void initTable() {
        String[] keys;
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("formula").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("number").setRequired(true);
        this.tblMain.getColumn("name").setRequired(true);
        this.tblMain.getColumn("formula").setRequired(true);
        for (String key : keys = new String[]{"company", "creator", "lastUpdateUser", "createTime", "lastUpdateTime"}) {
            this.tblMain.getColumn(key).getStyleAttributes().setBackground(Color.lightGray);
            this.tblMain.getColumn(key).getStyleAttributes().setLocked(true);
        }
        KDPromptBox prmtBoxFormula = new KDPromptBox();
        prmtBoxFormula.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 10));
        prmtBoxFormula.setEditable(true);
        prmtBoxFormula.setHistoryRecordEnabled(false);
        KDTDefaultCellEditor formulaEditor = new KDTDefaultCellEditor((IKDEditor)prmtBoxFormula);
        this.tblMain.getColumn("formula").setEditor((ICellEditor)formulaEditor);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() != null && e.getValue().toString().indexOf("=") == 0) {
                    int rowIndex = e.getRowIndex();
                    int colIndex = e.getColIndex();
                    AnalyzeIndexListUI.this.tblMain.getCell(rowIndex, colIndex).setValue(null);
                    if (e.getColIndex() == 0) {
                        MsgBox.showError((String)EASResource.getString((String)AnalyzeIndexListUI.RES, (String)"114_numHasSpecialSymbo"));
                    } else if (e.getColIndex() == 1) {
                        MsgBox.showError((String)EASResource.getString((String)AnalyzeIndexListUI.RES, (String)"115_nameHasSpecialSymbo"));
                    } else if (e.getColIndex() == 2) {
                        MsgBox.showError((String)EASResource.getString((String)AnalyzeIndexListUI.RES, (String)"116_formulaHasSpecialSymbo"));
                    } else if (e.getColIndex() == 3) {
                        MsgBox.showError((String)EASResource.getString((String)AnalyzeIndexListUI.RES, (String)"117_descHasSpecialSymbo"));
                    }
                } else if (e.getOldValue() != null && !e.getOldValue().equals(e.getValue()) || e.getOldValue() == null && e.getValue() != null) {
                    AnalyzeIndexListUI.this.cellChangeHandle(e.getRowIndex());
                }
            }
        });
        this.tblMain.addKeyListener(new KeyListener(){
            Map<Integer, String> tmpMap = new HashMap<Integer, String>();

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 86) {
                    this.tmpMap.clear();
                    int[] selectRows = KDTableUtil.getSelectedRows((KDTable)AnalyzeIndexListUI.this.tblMain);
                    IRow row = null;
                    for (int i : selectRows) {
                        row = AnalyzeIndexListUI.this.tblMain.getRow(i);
                        if (row.getCell("id").getValue() == null) continue;
                        this.tmpMap.put(i, AnalyzeIndexListUI.this.getRowKey(row));
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 86) {
                    int[] selectRows = KDTableUtil.getSelectedRows((KDTable)AnalyzeIndexListUI.this.tblMain);
                    IRow row = null;
                    for (int i : selectRows) {
                        row = AnalyzeIndexListUI.this.tblMain.getRow(i);
                        if (this.tmpMap.get(i) == null || this.tmpMap.get(i).equals(AnalyzeIndexListUI.this.getRowKey(row))) continue;
                        row.setUserObject((Object)handleType.modify);
                    }
                    this.tmpMap.clear();
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AnalyzeIndexListUI.this.changeButtonStatu();
            }
        });
    }

    private void changeButtonStatu() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.isCanEdit(null, selectRow)) {
            this.btnDeleteLine.setEnabled(false);
            this.menuItemDeleteLine.setEnabled(false);
        } else {
            this.btnDeleteLine.setEnabled(true);
            this.menuItemDeleteLine.setEnabled(true);
        }
    }

    protected String getRowKey(IRow row) {
        Object number = row.getCell("number").getValue();
        Object name = row.getCell("name").getValue();
        Object formulas = row.getCell("formula").getValue();
        Object des = row.getCell("description").getValue();
        StringBuffer key = new StringBuffer();
        key.append(number == null ? null : number).append(name == null ? null : name).append(formulas == null ? null : formulas);
        key.append(des == null ? null : des);
        return key.toString();
    }

    public void cellChangeHandle(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        if (row.getCell("id").getValue() != null) {
            if (!this.isCanEdit(row, -1)) {
                return;
            }
            row.setUserObject((Object)handleType.modify);
        } else {
            row.setUserObject((Object)handleType.addnew);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode;
        EntityViewInfo view;
        if (this.isNeedCheck && e != null) {
            this.canUpdate(e);
            if (this.isAbort) {
                SysUtil.abort();
            }
        }
        if ((view = this.getMainQuery()) == null) {
            this.mainQuery = view = new EntityViewInfo();
        }
        view.setFilter(new FilterInfo());
        KDTree kdTree = this.treeView.getTree();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)kdTree.getLastSelectedPathComponent();
        if (treeNode != null && !treeNode.isRoot() && (selectedNode = this.treeComponent.getLastSelectedNode()) != null) {
            TemplateTypeInfo type = (TemplateTypeInfo)selectedNode.getUserObject();
            HashSet<String> set = new HashSet<String>();
            set.add(type.getId().toString());
            this.treeComponent.search(type, set, "111111111111111111111111111=");
            StringBuffer buf = this.treeComponent.createIdBuffer(set);
            view.getFilter().getFilterItems().add(new FilterItemInfo("indexType.id", (Object)buf.toString(), CompareType.INCLUDE));
        }
        String number = this.txtNumber.getText();
        String name = this.txtName.getText();
        String formula = this.txtFormula.getText();
        if (!StringUtils.isEmpty((String)number)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("AnalyzeIndex.number", (Object)("%" + number + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)name)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("AnalyzeIndex.name", (Object)("%" + name + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)formula)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("AnalyzeIndex.formula", (Object)("%" + formula + "%"), CompareType.LIKE));
        }
        this.deleteIds.clear();
        this.refresh(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        Object selectedObj = ReportNotesClientUtil.getSelectedKeyValue(this.tblMain, "number");
        super.refresh(e);
        if (selectedObj != null) {
            ReportNotesClientUtil.setSelectRow(this.tblMain, "number", selectedObj);
        }
        this.deleteIds.clear();
    }

    private void canUpdate(ActionEvent e) {
        try {
            ArrayList<Object[]> addNewList = new ArrayList<Object[]>();
            ArrayList<Object[]> modifyList = new ArrayList<Object[]>();
            this.getEditList(addNewList, modifyList);
            if (!(addNewList.isEmpty() && modifyList.isEmpty() && this.deleteIds.isEmpty())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"11_confirmMsg"));
                this.isAbort = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
            this.handleException(ex);
        }
    }

    public void getEditList(List<Object[]> addNewList, List<Object[]> modifyList) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Object number = row.getCell("number").getValue();
            Object name = row.getCell("name").getValue();
            Object formula = row.getCell("formula").getValue();
            Object selectTreeNodes = row.getCell("typeId").getValue();
            if (number == null && name == null && formula == null) continue;
            if (row.getUserObject() != null) {
                if (handleType.addnew.equals(row.getUserObject())) {
                    addNewList.add(new Object[]{number != null ? number.toString().trim() : null, name != null ? name.toString().trim() : null, formula != null ? formula.toString() : null, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null, selectTreeNodes});
                    continue;
                }
                if (!handleType.modify.equals(row.getUserObject())) continue;
                modifyList.add(new Object[]{row.getCell("id").getValue().toString(), number != null ? number.toString().trim() : null, name != null ? name.toString().trim() : null, formula != null ? formula.toString() : null, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null});
                continue;
            }
            if (row.getCell("id").getValue() != null) continue;
            addNewList.add(new Object[]{number != null ? number.toString().trim() : null, name != null ? name.toString().trim() : null, formula != null ? formula.toString() : null, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null, selectTreeNodes});
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        ArrayList<Object[]> addNewList = new ArrayList<Object[]>();
        ArrayList<Object[]> modifyList = new ArrayList<Object[]>();
        this.getEditList(addNewList, modifyList);
        boolean isSucess = false;
        StringBuffer msg = new StringBuffer();
        if (!(addNewList.isEmpty() && modifyList.isEmpty() && this.deleteIds.isEmpty())) {
            if (this.deleteIds != null && !this.deleteIds.isEmpty()) {
                ArrayList<String> defaultIndexList = new ArrayList<String>();
                String dMsg = this.checkDelDefaultIndex(this.deleteIds, defaultIndexList);
                if (!defaultIndexList.isEmpty()) {
                    this.deleteIds.removeAll(defaultIndexList);
                    msg.append(dMsg);
                }
                ArrayList<String> indexRelaList = new ArrayList<String>();
                String delMsg = this.checkDelRel(true, this.deleteIds, "42_delRelTitle", indexRelaList);
                if (!indexRelaList.isEmpty()) {
                    this.deleteIds.removeAll(indexRelaList);
                    msg.append(delMsg);
                }
            }
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("addNewList", addNewList);
            params.put("modifyList", modifyList);
            params.put("deleteIds", this.deleteIds);
            AnalyzeIndexFactory.getRemoteInstance().batchExecute(params);
            this.deleteIds.clear();
            addNewList.clear();
            modifyList.clear();
            isSucess = true;
        }
        if (msg.length() > 0) {
            String title = EASResource.getString((String)RES, (String)"41_delTitle");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)msg.toString(), (int)2);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        }
        if (isSucess) {
            this.isAbort = false;
            this.isNeedCheck = false;
            this.actionRefresh_actionPerformed(e);
            this.isNeedCheck = true;
        }
    }

    private String checkDelDefaultIndex(List<String> deleteIds, List<String> defaultIndexList) throws BOSException {
        StringBuffer msg = new StringBuffer();
        HashSet<String> delIds = new HashSet<String>(deleteIds);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", delIds, CompareType.INCLUDE));
        view.setFilter(filter);
        AnalyzeIndexCollection coll = AnalyzeIndexFactory.getRemoteInstance().getAnalyzeIndexCollection(view);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            List<String> dList = Arrays.asList(defaultIndexNumbers);
            while (it.hasNext()) {
                AnalyzeIndexInfo analyzeIndex = (AnalyzeIndexInfo)it.next();
                String id = analyzeIndex.getId().toString();
                String number = analyzeIndex.getNumber();
                if (!dList.contains(number)) continue;
                defaultIndexList.add(id);
                msg.append(EASResource.getString((String)RES, (String)"120_chkDelDef", (Object[])new Object[]{number})).append(" \n");
            }
        }
        return msg.toString();
    }

    private void removeUpdateData(List<Object[]> modifyList, List<String> indexRelaList) {
        ArrayList<Object[]> removes = new ArrayList<Object[]>();
        for (Object[] updateData : modifyList) {
            String id = (String)updateData[0];
            if (!indexRelaList.contains(id)) continue;
            removes.add(updateData);
        }
        if (!removes.isEmpty()) {
            modifyList.removeAll(removes);
        }
    }

    private List<String> getUpdateIds(List<Object[]> modifyList) {
        ArrayList<String> updateIds = new ArrayList<String>();
        for (Object[] updateData : modifyList) {
            String id = (String)updateData[0];
            updateIds.add(id);
        }
        return updateIds;
    }

    private String checkDelRel(boolean isDel, List<String> deleteIds, String titleKey, List<String> indexRelaList) throws BOSException {
        Iterator it;
        StringBuffer msg = new StringBuffer();
        HashSet<String> delIds = new HashSet<String>(deleteIds);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("analyzeIndex.number"));
        view.getSelector().add(new SelectorItemInfo("analyze.number"));
        view.getSorter().add(new SorterItemInfo("analyzeIndex.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("analyzeIndex.id", delIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IndexEntryCollection indexEntrys = IndexEntryFactory.getRemoteInstance().getIndexEntryCollection(view);
        HashMap groups = new HashMap();
        if (indexEntrys != null && !indexEntrys.isEmpty()) {
            it = indexEntrys.iterator();
            ArrayList<String> analyzeNumbers = null;
            while (it.hasNext()) {
                IndexEntryInfo indexEntry = (IndexEntryInfo)it.next();
                String indexId = indexEntry.getAnalyzeIndex().getId().toString();
                String indexNumber = indexEntry.getAnalyzeIndex().getNumber();
                String analyzeNumber = indexEntry.getAnalyze().getNumber();
                if (!indexRelaList.contains(indexId)) {
                    indexRelaList.add(indexId);
                }
                if (groups.containsKey(indexNumber)) {
                    ((List)groups.get(indexNumber)).add(analyzeNumber);
                    continue;
                }
                analyzeNumbers = new ArrayList<String>();
                analyzeNumbers.add(analyzeNumber);
                groups.put(indexNumber, analyzeNumbers);
            }
        }
        if (!groups.isEmpty()) {
            it = groups.keySet().iterator();
            StringBuffer analyzeMsg = null;
            while (it.hasNext()) {
                String indexNumber = (String)it.next();
                List analyzeNumbers = (List)groups.get(indexNumber);
                String title = EASResource.getString((String)RES, (String)titleKey, (Object[])new Object[]{indexNumber});
                analyzeMsg = new StringBuffer();
                int size = analyzeNumbers.size();
                for (int i = 0; i < size; ++i) {
                    String analyzeNumber = (String)analyzeNumbers.get(i);
                    analyzeMsg.append(analyzeNumber).append("\u3001");
                }
                String msgString = analyzeMsg.toString();
                msgString = msgString.substring(0, msgString.length() - 1);
                String detail = EASResource.getString((String)RES, (String)"43_delRelDetail") + msgString;
                msg.append(title).append("\n").append(detail).append("\n");
            }
        }
        return msg.toString();
    }

    private void verifyInput() throws EASBizException, BOSException {
        HashMap<String, Integer> numberMap = new HashMap<String, Integer>();
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Object number = row.getCell("number").getValue();
            Object name = row.getCell("name").getValue();
            Object formula = row.getCell("formula").getValue();
            Object description = row.getCell("description").getValue();
            Object id = row.getCell("id").getValue();
            if (!(number == null || StringUtils.isEmpty((String)number.toString()) || name == null || StringUtils.isEmpty((String)name.toString()) || formula == null || StringUtils.isEmpty((String)formula.toString()))) {
                if (number.toString().length() > 80) {
                    msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"6_numberIsTooLong"), i + 1)).append("\n");
                }
                if (name.toString().length() > 255) {
                    msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"7_nameIsTooLong"), i + 1)).append("\n");
                }
                if (formula.toString().length() > 3000) {
                    msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"8_formulaIsTooLong"), i + 1)).append("\n");
                }
                if (description != null && !StringUtils.isEmpty((String)description.toString()) && description.toString().length() > 2000) {
                    msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"9_descriptionIsTooLong"), i + 1)).append("\n");
                }
                boolean isExist = false;
                if (msg.length() == 0) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", number, CompareType.EQUALS));
                    if (id != null) {
                        filter.getFilterItems().add(new FilterItemInfo("id", id, CompareType.NOTEQUALS));
                    }
                    isExist = id == null ? AnalyzeIndexFactory.getRemoteInstance().exists(filter) : AnalyzeIndexFactory.getRemoteInstance().exists(filter);
                }
                if (numberMap.containsKey(number.toString()) || isExist) {
                    msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"2_numberDup"), i + 1)).append("\n");
                    continue;
                }
                numberMap.put(number.toString(), i + 1);
                continue;
            }
            if (number == null || StringUtils.isEmpty((String)number.toString())) {
                msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"3_numberIsNull"), i + 1)).append("\n");
            }
            if (name == null || StringUtils.isEmpty((String)name.toString())) {
                msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"4_nameIsNull"), i + 1)).append("\n");
            }
            if (formula != null && !StringUtils.isEmpty((String)formula.toString())) continue;
            msg.append(MessageFormat.format(EASResource.getString((String)RES, (String)"5_formulaIsNull"), i + 1)).append("\n");
        }
        if (msg.length() > 0) {
            this.isAbort = true;
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"10_saveError"), (String)msg.toString(), (int)1);
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        String selectTreeNodes = this.treeComponent.getSelectedNodeKeyValue();
        if ("111111111111111111111111111=".equals(selectTreeNodes)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"13_isRoot"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.addRow();
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        row.getCell("typeId").setValue((Object)selectTreeNodes);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String selectTreeNodes = this.treeComponent.getSelectedNodeKeyValue();
        if ("111111111111111111111111111=".equals(selectTreeNodes)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"14_isRootInsert"));
            SysUtil.abort();
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.addRow(rowIndex + 1);
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        row.getCell("typeId").setValue((Object)selectTreeNodes);
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        int mode = 0;
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                Object obj = this.tblMain.getCell(i, "id").getValue();
                if (!this.isCanEdit(null, i)) continue;
                if (obj != null) {
                    this.deleteIds.add(obj.toString());
                }
                this.tblMain.removeRow(i);
            }
        } else {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            for (int i = selectRows.length - 1; i >= 0; --i) {
                Object obj = this.tblMain.getCell(selectRows[i], "id").getValue();
                if (!this.isCanEdit(null, selectRows[i])) continue;
                if (obj != null) {
                    this.deleteIds.add(obj.toString());
                }
                this.tblMain.removeRow(selectRows[i]);
            }
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows;
        this.checkSelected();
        String selectTreeNodes = this.treeComponent.getSelectedNodeKeyValue();
        if ("111111111111111111111111111=".equals(selectTreeNodes)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"19_isRootCopy"));
            SysUtil.abort();
        }
        if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)) != null) {
            int rowIndex = selectRows[0];
            IRow copyRow = this.tblMain.addRow(rowIndex + 1);
            this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
            copyRow.setUserObject((Object)handleType.addnew);
            IRow row = this.tblMain.getRow(rowIndex);
            copyRow.getCell("name").setValue(row.getCell("name").getValue());
            copyRow.getCell("formula").setValue(row.getCell("formula").getValue());
            copyRow.getCell("description").setValue(row.getCell("description").getValue());
            copyRow.getCell("typeId").setValue((Object)selectTreeNodes);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AnalyzeIndexFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
            if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                this.deleteIds.clear();
            }
        }
    }

    public Object getClientValue(Object key) {
        Object obj;
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1 && (obj = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), "formula").getValue()) != null) {
            return obj.toString();
        }
        return null;
    }

    public boolean destroyWindow() {
        try {
            ArrayList<Object[]> addNewList = new ArrayList<Object[]>();
            ArrayList<Object[]> modifyList = new ArrayList<Object[]>();
            this.getEditList(addNewList, modifyList);
            if (!(addNewList.isEmpty() && modifyList.isEmpty() && this.deleteIds.isEmpty() || MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"12_confirmExit")) == 0)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            this.handleException(e);
        }
        return super.destroyWindow();
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"formula"};
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
    }

    @Override
    public void actionDescription_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"128_indexDes1")).append("<br>");
        sb.append(EASResource.getString((String)RES, (String)"129_indexDes2")).append("<br><br>");
        sb.append(EASResource.getString((String)RES, (String)"130_indexDes3")).append("<br>");
        sb.append(EASResource.getString((String)RES, (String)"131_indexDes4")).append("<br>");
        uiCtx.put((Object)"String", (Object)sb.toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        String uiTitle = EASResource.getString((String)RES, (String)"138_useDes");
        ((ShowEditorPanelUI)uiWindow.getUIObject()).setUITitle(uiTitle);
        ((ShowEditorPanelUI)uiWindow.getUIObject()).getPrintButton().setVisible(false);
        ((ShowEditorPanelUI)uiWindow.getUIObject()).getOKButton().setVisible(false);
        uiWindow.show();
        super.repaint();
    }

    protected static enum handleType {
        addnew,
        modify;

    }
}

