/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeTypeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AbstractBatchCalculateAnalyzeUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BatchCalculateAnalyzeUI
extends AbstractBatchCalculateAnalyzeUI {
    private static final long serialVersionUID = 1523677375917456817L;
    private static final Logger logger = CoreUIObject.getLogger(BatchCalculateAnalyzeUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource";
    private static final String ID = "id";
    private static final String SELECT = "select";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ANALYZETYPE = "analyzeType";
    private static final String SPLIT = "@@";
    private boolean isCtrlPress = false;
    private Set<String> analyzeIds;
    private Set<String> loadAnalyzeIds;

    public BatchCalculateAnalyzeUI(Set<String> analyzeIds) throws Exception {
        this.analyzeIds = analyzeIds;
        this.loadAnalyzeIds = new HashSet<String>();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAnalyzeType();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(SELECT).getStyleAttributes().setLocked(false);
        this.refresh(this.analyzeIds, null, null, 0, false);
        this.initTableEvent();
        this.initTxtLocation();
    }

    private void initAnalyzeType() {
        String all = EASResource.getString((String)RES, (String)"90_all");
        this.combFilter.addItem((Object)all);
        this.combFilter.addItems(AnalyzeTypeEnum.getEnumList().toArray());
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtFilter.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtFilter);
        this.txtFilter.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initTableEvent() {
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    BatchCalculateAnalyzeUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (BatchCalculateAnalyzeUI.this.isCtrlPress) {
                    BatchCalculateAnalyzeUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1 && BatchCalculateAnalyzeUI.this.isCtrlPress) {
                    IRow row = BatchCalculateAnalyzeUI.this.tblMain.getRow(e.getRowIndex());
                    boolean isSelect = (Boolean)row.getCell(BatchCalculateAnalyzeUI.SELECT).getValue();
                    row.getCell(BatchCalculateAnalyzeUI.SELECT).setValue((Object)(!isSelect ? 1 : 0));
                    BatchCalculateAnalyzeUI.this.tblMain.checkParsed();
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock = e.getSelectBlock();
                if (selectBlock != null) {
                    ICell cell;
                    int selectIndex = BatchCalculateAnalyzeUI.this.tblMain.getColumnIndex(BatchCalculateAnalyzeUI.SELECT);
                    Object cellObj = null;
                    if (selectBlock.getBottom() - selectBlock.getTop() > 0) {
                        for (int i = selectBlock.getTop(); i <= selectBlock.getBottom(); ++i) {
                            if (BatchCalculateAnalyzeUI.this.tblMain.getRow(i).getStyleAttributes().isHided() || !((cellObj = BatchCalculateAnalyzeUI.this.tblMain.getCell(i, selectIndex).getValue()) instanceof Boolean)) continue;
                            BatchCalculateAnalyzeUI.this.tblMain.getCell(i, selectIndex).setValue((Object)((Boolean)cellObj == false ? 1 : 0));
                        }
                    } else if (selectBlock.getBottom() - selectBlock.getTop() == 0 && selectBlock.getBeginCol() == selectBlock.getEndCol() && selectBlock.getBeginCol() == selectIndex && !BatchCalculateAnalyzeUI.this.tblMain.getRow(selectBlock.getBottom()).getStyleAttributes().isHided() && (cell = BatchCalculateAnalyzeUI.this.tblMain.getCell(selectBlock.getBottom(), selectBlock.getBeginCol())).getValue() instanceof Boolean) {
                        cell.setValue((Object)(cell.getValue() != null ? false : (Boolean)cell.getValue() == false));
                    }
                }
            }
        });
    }

    private void init(RptQingAnalyzeCollection analyzeThemes, boolean isSelect) throws BOSException {
        if (analyzeThemes != null && !analyzeThemes.isEmpty()) {
            Iterator it = analyzeThemes.iterator();
            while (it.hasNext()) {
                RptQingAnalyzeInfo analyzeTheme = (RptQingAnalyzeInfo)it.next();
                this.initTable(analyzeTheme, isSelect);
            }
        }
    }

    private void initTable(RptQingAnalyzeInfo analyzeTheme, boolean isSelect) {
        String id = analyzeTheme.getId().toString();
        String number = analyzeTheme.getNumber();
        String name = analyzeTheme.getName();
        AnalyzeTypeEnum analyzeTypeEnum = analyzeTheme.getAnalyzeType();
        IRow row = this.tblMain.addRow();
        row.getCell(SELECT).setValue((Object)(isSelect || this.loadAnalyzeIds.contains(id) ? 1 : 0));
        row.getCell(ID).setValue((Object)id);
        row.getCell(NUMBER).setValue((Object)number);
        row.getCell(NAME).setValue((Object)name);
        row.getCell(ANALYZETYPE).setValue((Object)analyzeTypeEnum);
    }

    private RptQingAnalyzeCollection getAnalyzeThemes(Set<String> themeIds, FilterInfo filter, StringBuffer mask, int index) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(ID, themeIds, CompareType.INCLUDE));
        if (mask != null) {
            mask.append(" and #").append(index++);
            filter.setMaskString(mask.toString());
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo(ID));
        selector.add(new SelectorItemInfo(NUMBER));
        selector.add(new SelectorItemInfo(NAME));
        selector.add(new SelectorItemInfo(ANALYZETYPE));
        view.setSelector(selector);
        view.getSorter().add(new SorterItemInfo(ANALYZETYPE));
        view.getSorter().add(new SorterItemInfo(NUMBER));
        RptQingAnalyzeCollection analyzeThemes = RptQingAnalyzeFactory.getRemoteInstance().getRptQingAnalyzeCollection(view);
        return analyzeThemes;
    }

    public FilterInfo getFilterInfo() {
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"80_selIsNull"));
            SysUtil.abort();
        }
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer filter = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isSelect = (Boolean)row.getCell(SELECT).getValue();
            if (!isSelect) continue;
            if (filter.length() > 0) {
                filter.append(SPLIT);
            }
            String id = (String)row.getCell(ID).getValue();
            filter.append(id);
        }
        if (filter.length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"80_selIsNull"));
            SysUtil.abort();
        }
        FilterItemInfo itemInfo = new FilterItemInfo("analyzeIds", (Object)filter.toString());
        filterInfo.getFilterItems().add(itemInfo);
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.tblMain.removeRows();
        this.combFilter.setSelectedIndex(0);
        this.txtFilter.setText(null);
        FilterItemCollection filterItems = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo item = filterItems.get(i);
            if (!item.getPropertyName().equalsIgnoreCase("analyzeIds")) continue;
            String analyzeIdsString = item.getCompareValue().toString();
            String[] ids = analyzeIdsString.split(SPLIT);
            List<String> list = Arrays.asList(ids);
            this.loadAnalyzeIds = new HashSet<String>(list);
            try {
                this.refresh(this.loadAnalyzeIds, null, null, 0, true);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"loadData : ", (Throwable)e);
            }
        }
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        int index = this.combFilter.getSelectedIndex();
        FilterInfo filter = new FilterInfo();
        String filterString = this.txtFilter.getText();
        StringBuffer strMask = new StringBuffer();
        int iIndex = 0;
        if (defaultStr.equals(filterString)) {
            if (index == 0) {
                this.refresh(this.analyzeIds, null, null, 0, false);
            } else {
                switch (index) {
                    case 1: {
                        filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)0, CompareType.EQUALS));
                        strMask.append("#").append(iIndex++);
                        break;
                    }
                    case 2: {
                        filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)1, CompareType.EQUALS));
                        strMask.append("#").append(iIndex++);
                        break;
                    }
                    case 3: {
                        filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)2, CompareType.EQUALS));
                        strMask.append("#").append(iIndex++);
                    }
                }
                this.refresh(this.analyzeIds, filter, strMask, iIndex, false);
            }
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo(NUMBER, (Object)("%" + filterString + "%"), CompareType.LIKE));
        strMask.append(" (#").append(iIndex++);
        filter.getFilterItems().add(new FilterItemInfo(NAME, (Object)("%" + filterString + "%"), CompareType.LIKE));
        strMask.append(" or #").append(iIndex++).append(")");
        switch (index) {
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)0, CompareType.EQUALS));
                strMask.append("And #").append(iIndex++);
                break;
            }
            case 2: {
                filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)1, CompareType.EQUALS));
                strMask.append("And #").append(iIndex++);
                break;
            }
            case 3: {
                filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)2, CompareType.EQUALS));
                strMask.append("And #").append(iIndex++);
            }
        }
        this.refresh(this.analyzeIds, filter, strMask, iIndex, false);
    }

    private void refresh(Set<String> themeIds, FilterInfo filter, StringBuffer mask, int index, boolean isSelect) throws BOSException {
        this.tblMain.removeRows();
        RptQingAnalyzeCollection analyzeThemes = this.getAnalyzeThemes(themeIds, filter, mask, index);
        this.init(analyzeThemes, isSelect);
    }

    @Override
    public void actionAllSelect_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrClear(this.tblMain, true);
    }

    @Override
    public void actionAllClear_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrClear(this.tblMain, false);
    }

    private void selectOrClear(KDTable tbl, boolean isSelect) {
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            ICell cell = tbl.getRow(i).getCell(SELECT);
            if (cell.getValue() == null) continue;
            cell.setValue((Object)isSelect);
        }
    }

    public Set<String> getReturnIds() {
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"80_selIsNull"));
            SysUtil.abort();
        }
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isSelect = (Boolean)row.getCell(SELECT).getValue();
            if (!isSelect) continue;
            String id = (String)row.getCell(ID).getValue();
            ids.add(id);
        }
        if (ids.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"80_selIsNull"));
            SysUtil.abort();
        }
        return ids;
    }

    public void clear() {
        super.clear();
        try {
            this.loadAnalyzeIds = new HashSet<String>();
            this.combFilter.setSelectedIndex(0);
            this.txtFilter.setText(null);
            this.refresh(this.analyzeIds, null, null, 0, false);
        }
        catch (BOSException e) {
            logger.error((Object)"clear : ", (Throwable)e);
        }
    }
}

