/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AbstractCalculateDetailProcessUI;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.CalculateProcessDetailMenuManage;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.report.ReportProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CalculateDetailProcessUI
extends AbstractCalculateDetailProcessUI {
    private static final long serialVersionUID = 2851940414689825461L;
    private static final Logger logger = CoreUIObject.getLogger(CalculateDetailProcessUI.class);

    public CalculateDetailProcessUI() throws Exception {
        this.setVariableProvider(new IReportVariableProvider(){

            @Override
            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initSheetReservedVariables(sheetName, RptPeriodTypeEnum.MONTHLY);
                variables.addAll(init, false);
            }

            @Override
            public void initReportDefaultVariable(ReportVariables variables) {
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        ReportInfo report = this.getReportInfo();
        Book book = (Book)this.getUIContext().get("INIT_BOOK");
        report.setBook(book);
        this.setMenuStrategy(new CalculateProcessDetailMenuManage());
        ReportProvider reportProvider = new ReportProvider();
        reportProvider.setEditValue((IObjectValue)report);
        this.setBookProvider((IBookProvider)reportProvider);
        this.setPropertyAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        super.onLoad();
        book = this.getBook();
        this.getVariables().add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
        book.getSheet(0).getColRange(0, 0).setColumnHidden(true);
        book.getSheet(0).getColRange(1, 1).setColumnWidth(200);
        book.getSheet(0).getColRange(2, 2).setColumnWidth(120);
        book.getSheet(0).getColRange(3, 3).setColumnWidth(120);
        book.getSheet(0).getColRange(4, 4).setColumnWidth(120);
        book.getSheet(0).getColRange(5, 5).setColumnWidth(200);
        book.getSheet(0).getColRange(6, 6).setColumnWidth(120);
        book.getSheet(0).getColRange(8, 8).setColumnWidth(120);
        this.getUIMenuBar().setVisible(false);
        this.actionSave.setVisible(false);
        this.actionSheetManager.setVisible(false);
        this.actionReportCheck.setVisible(false);
        this.actionReportRound.setVisible(false);
    }

    private ReportInfo getReportInfo() throws EASBizException, BOSException {
        CalculateProcessInfo calProc = (CalculateProcessInfo)this.getUIContext().get("calProc");
        String analyzeId = calProc.getAnalyze().getId().toString();
        RptQingAnalyzeInfo info = RptQingAnalyzeFactory.getRemoteInstance().getRptQingAnalyzeInfo("select periodType where id = '" + analyzeId + "'");
        RptPeriodTypeEnum periodType = info.getPeriodType();
        ReportInfo report = new ReportInfo();
        report.setPeriodType(periodType);
        return report;
    }

    private CslReportInfo getCslReportInfo() throws IOException, EASBizException, BOSException {
        CslReportInfo cslrpt = new CslReportInfo();
        CalculateProcessInfo calProc = (CalculateProcessInfo)this.getUIContext().get("calProc");
        String analyzeId = calProc.getAnalyze().getId().toString();
        RptQingAnalyzeInfo info = RptQingAnalyzeFactory.getRemoteInstance().getRptQingAnalyzeInfo("select periodType where id = '" + analyzeId + "'");
        RptPeriodTypeEnum periodType = info.getPeriodType();
        int year = calProc.getYear();
        int period = calProc.getPeriod();
        String currencyId = calProc.getCurrencyId();
        String currencyNumber = calProc.getCurrencyNumber();
        String currencyName = calProc.getCurrencyName();
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        currency.setNumber(currencyNumber);
        currency.setName(currencyName);
        String orgId = calProc.getOrgUnitId();
        String orgNum = calProc.getOrgUnitNumber();
        String orgName = calProc.getOrgUnitName();
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        fullOrgUnit.setId(BOSUuid.read((String)orgId));
        fullOrgUnit.setNumber(orgNum);
        fullOrgUnit.setName(orgName);
        Book book = (Book)this.getUIContext().get("INIT_BOOK");
        cslrpt.setYear(year);
        cslrpt.setPeriod((short)period);
        cslrpt.setOrgTree(calProc.getAnalyze().getOrgTree());
        cslrpt.setOrgUnit(fullOrgUnit);
        cslrpt.setCompany(fullOrgUnit);
        cslrpt.setCurrency(currency);
        cslrpt.setPeriodType(periodType);
        cslrpt.setBook(book);
        FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        boolean isUnion = orgUnit.isIsUnion();
        if (isUnion) {
            cslrpt.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
        } else {
            cslrpt.setSourceType(RptSrcTypeEnum.COMMITREPORT);
        }
        return cslrpt;
    }

    @Override
    public String getUITitle() {
        String title = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"276_title");
        return title;
    }
}

