/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AbstractCalculateProcessListUI;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.CalculateDetailProcessUI;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalculateProcessListUI
extends AbstractCalculateProcessListUI {
    private static final long serialVersionUID = 818009514864507656L;
    private static final Logger logger = CoreUIObject.getLogger(CalculateProcessListUI.class);
    private static final String ID = "id";
    private static final String ANALYZENAME = "analyzeName";
    private static final String ORGNUM = "orgNum";
    private static final String ORGNAME = "orgName";
    private static final String YEARPERIOD = "yearPeriod";
    private static final String CURRENCYNAME = "currencyName";
    private static final String ANALYZEINDEX = "analyzeIndex";
    private static final String CALPROCESS = "calProcess";
    private static final String CALCULATOR = "calculator";
    private static final String CALTIME = "calTime";
    private static final int ANALYZEINDEXINDEX = 6;
    private String tempTable = null;

    public CalculateProcessListUI() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        int pageCount = 1500;
        this.tblMain.getDataRequestManager().setPageRowCount(pageCount);
        Field pageCountField = this.tblMain.getDataRequestManager().getClass().getDeclaredField("pageRowCount");
        NewRptUtil.makeAccessible(pageCountField);
        pageCountField.set(this.tblMain.getDataRequestManager(), pageCount);
        pageCountField = this.tblMain.getDataRequestManager().getClass().getDeclaredField("queryPageRowCount");
        NewRptUtil.makeAccessible(pageCountField);
        pageCountField.set(this.tblMain.getDataRequestManager(), pageCount);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(ANALYZEINDEX).getStyleAttributes().setFontColor(Color.blue);
        this.tblMain.getColumn(ANALYZEINDEX).getStyleAttributes().setUnderline(true);
        this.actionAddNew.setVisible(false);
        this.actionQuery.setVisible(false);
        this.actionView.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionLocate.setVisible(false);
        this.menuEdit.setVisible(false);
        this.actionRefresh_actionPerformed(null);
    }

    private Set<String> getPermOrgUnitId() throws BOSException {
        HashSet<String> orgIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)userId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)10, CompareType.EQUALS));
        view.getSelector().add(new SelectorItemInfo("org"));
        OrgRangeCollection orgRanges = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(view);
        if (orgRanges != null && !orgRanges.isEmpty()) {
            for (OrgRangeInfo orgRange : orgRanges) {
                String orgId = orgRange.getOrg().getId().toString();
                orgIds.add(orgId);
            }
        }
        return orgIds;
    }

    private void initTable(IRowSet rs, String detail) throws SQLException {
        IRow row = this.tblMain.addRow();
        String id = rs.getString("FId");
        row.getCell(ID).setValue((Object)id);
        String analyzeName = rs.getString("FAnalyzeName");
        row.getCell(ANALYZENAME).setValue((Object)analyzeName);
        String orgNum = rs.getString("FOrgUnitNumber");
        String orgName = rs.getString("FOrgUnitName");
        row.getCell(ORGNUM).setValue((Object)orgNum);
        row.getCell(ORGNAME).setValue((Object)orgName);
        String yearPeriod = rs.getString("FYearPeriod");
        row.getCell(YEARPERIOD).setValue((Object)yearPeriod);
        String currencyName = rs.getString("FCurrencyNumber");
        row.getCell(CURRENCYNAME).setValue((Object)currencyName);
        if (rs.getObject("FData") != null) {
            row.getCell(ANALYZEINDEX).setValue((Object)detail);
        }
        CalculateProcessEnum proc = CalculateProcessEnum.getEnum(rs.getInt("FCalculateProcess"));
        row.getCell(CALPROCESS).setValue((Object)proc.getAlias());
        String userId = rs.getString("FCalculatorId");
        try {
            UserInfo user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            row.getCell(CALCULATOR).setValue((Object)user.getName());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Timestamp calTime = rs.getTimestamp("FCalculateTime");
        row.getCell(CALTIME).setValue((Object)calTime);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            int colIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
            if (colIndex == 6 && this.tblMain.getCell(rowIndex, colIndex).getValue() != null) {
                String id = (String)this.tblMain.getRow(rowIndex).getCell(ID).getValue();
                CalculateProcessInfo info = CalculateProcessFactory.getRemoteInstance().getCalculateProcessInfo((IObjectPK)new ObjectUuidPK(id));
                Book book = IOHelper.unpackBook((byte[])info.getData());
                book.setCalculate(false);
                UIContext context = new UIContext();
                context.put((Object)"INIT_BOOK", (Object)book);
                context.put((Object)"calProc", (Object)info);
                context.put((Object)"Owner", (Object)this);
                IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CalculateDetailProcessUI.class.getName(), (Map)context, null, OprtState.VIEW);
                window.show();
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if ("menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuItemCopy".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    public int getSelectedRowCount(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        return selectRows.length;
    }

    protected String getKeyFieldName() {
        return ID;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        this.tblMain_doRequestRowSetForHasQueryPK(e);
    }

    protected void tblMain_doRequestRowSetForHasQueryPK(RequestRowSetEvent e) {
        try {
            Map result;
            int from = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - from + 1;
            Set<String> idSet = new HashSet();
            if (this.getUIContext().containsKey("theme")) {
                RptQingAnalyzeInfo themeInfo = (RptQingAnalyzeInfo)this.getUIContext().get("theme");
                int analyzeType = themeInfo.getAnalyzeType().getValue();
                if (analyzeType != 2) {
                    this.tblMain.getColumn(ORGNUM).getStyleAttributes().setHided(true);
                    this.tblMain.getColumn(ORGNAME).getStyleAttributes().setHided(true);
                    this.tblMain.getColumn(YEARPERIOD).getStyleAttributes().setHided(true);
                    this.tblMain.getColumn(CURRENCYNAME).getStyleAttributes().setHided(true);
                    this.tblMain.getColumn(ANALYZEINDEX).getStyleAttributes().setHided(true);
                }
                idSet.add(themeInfo.getId().toString());
            }
            if (this.getUIContext().containsKey("themeIds")) {
                idSet = (Set)this.getUIContext().get("themeIds");
            }
            Set<String> orgIds = this.getPermOrgUnitId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("from", from);
            params.put("length", length);
            params.put("themeIds", idSet);
            params.put("permOrgIds", orgIds);
            if (this.tempTable != null) {
                params.put("tempTable", this.tempTable);
            }
            if ((result = CalculateProcessFactory.getRemoteInstance().getCalProcessRecords(params)) != null && !result.isEmpty()) {
                this.tempTable = (String)result.get("tempTable");
                IRowSet rs = (IRowSet)result.get("rowSet");
                if (rs != null) {
                    String detail = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"275_detail");
                    while (rs.next()) {
                        this.initTable(rs, detail);
                    }
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)"getCalProcessRecords: ", (Throwable)e1);
        }
    }
}

