/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFacade;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AbstractModifyThemeCreatorUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ModifyThemeCreatorUI
extends AbstractModifyThemeCreatorUI {
    private static final long serialVersionUID = 6492886191056644042L;
    private static final Logger logger = CoreUIObject.getLogger(ModifyThemeCreatorUI.class);
    protected boolean isCtrlPress = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        List themes = (List)this.getUIContext().get("themes");
        this.init(themes);
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock;
                if (!ModifyThemeCreatorUI.this.isCtrlPress && (selectBlock = e.getSelectBlock()) != null) {
                    if (selectBlock.getBottom() - selectBlock.getTop() > 0) {
                        for (int i = selectBlock.getTop(); i <= selectBlock.getBottom(); ++i) {
                            ModifyThemeCreatorUI.this.tblMain.getCell(i, 1).setValue((Object)((Boolean)ModifyThemeCreatorUI.this.tblMain.getCell(i, 1).getValue() == false ? 1 : 0));
                        }
                    } else if (selectBlock.getBottom() - selectBlock.getTop() == 0 && selectBlock.getBeginCol() == selectBlock.getEndCol() && selectBlock.getBeginCol() == 0) {
                        ICell cell;
                        cell.setValue((Object)((cell = ModifyThemeCreatorUI.this.tblMain.getCell(selectBlock.getBottom(), selectBlock.getBeginCol())).getValue() != null ? false : (Boolean)cell.getValue() == false));
                    }
                }
            }
        });
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    ModifyThemeCreatorUI.this.isCtrlPress = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (ModifyThemeCreatorUI.this.isCtrlPress) {
                    ModifyThemeCreatorUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblMain.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent paramMouseEvent) {
                if (ModifyThemeCreatorUI.this.isCtrlPress) {
                    ModifyThemeCreatorUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
    }

    private void init(List<RptQingAnalyzeInfo> themes) {
        if (themes != null && !themes.isEmpty()) {
            for (RptQingAnalyzeInfo info : themes) {
                this.initTable(info);
            }
        }
    }

    private void initTable(RptQingAnalyzeInfo info) {
        IRow row = this.tblMain.addRow();
        row.getCell("id").setValue((Object)info.getId().toString());
        row.getCell("select").setValue((Object)false);
        row.getCell("number").setValue((Object)info.getNumber());
        row.getCell("name").setValue((Object)info.getName());
        row.getCell("analyzeType").setValue((Object)info.getAnalyzeType());
        row.getCell("creator").setValue((Object)info.getCreator().getName());
    }

    @Override
    public void actionModifyCreator_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkSelected()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"119_selFirst"));
        } else {
            Object[] users;
            UserInfo user;
            RptQingAnalyzeCollection updateThemes;
            KDCommonPromptDialog f7 = new KDCommonPromptDialog();
            QueryAgent queryAgent = new QueryAgent();
            queryAgent.setQueryInfoPK(new MetaDataPK("com.kingdee.eas.fi.newrpt.rptIndexAnalyze.F7UserQuery"));
            queryAgent.setEnabledMultiSelection(false);
            f7.setQueryInfo(queryAgent.getQueryInfo());
            f7.setReturnValueType(queryAgent.getReturnValueType());
            f7.show();
            if (!f7.isCanceled() && (updateThemes = this.getSelectedThemes(user = (UserInfo)(users = (Object[])f7.getData())[0])) != null && !updateThemes.isEmpty()) {
                StringBuffer logName = new StringBuffer();
                logName.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"84_logTitle"));
                logName.append("-").append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"122_modifyCreator"));
                String logItem = "csl_analyze_modifyCreator";
                IObjectPK logPk = LogUtil.beginLog(null, (String)"actionModifyCreator", (BOSObjectType)new RptQingAnalyzeFacade().getType(), null, (String)logName.toString(), (String)logItem);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("creator"));
                RptQingAnalyzeFactory.getRemoteInstance().updatePartialBatchData((IObjectCollection)updateThemes, selectors);
                LogUtil.afterLog(null, (IObjectPK)logPk);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"121_modifySucess"));
                this.actionRefresh_actionPerformed(e);
            }
        }
    }

    private boolean checkSelected() {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean iSelect = (Boolean)row.getCell("select").getValue();
            if (!iSelect) continue;
            return true;
        }
        return false;
    }

    private RptQingAnalyzeCollection getSelectedThemes(UserInfo user) {
        int count = this.tblMain.getRowCount();
        RptQingAnalyzeCollection coll = new RptQingAnalyzeCollection();
        RptQingAnalyzeInfo info = null;
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean iSelect = (Boolean)row.getCell("select").getValue();
            if (!iSelect) continue;
            String themeId = (String)row.getCell("id").getValue();
            info = new RptQingAnalyzeInfo();
            info.setId(BOSUuid.read((String)themeId));
            info.setCreator(user);
            coll.add(info);
        }
        return coll;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)true);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)false);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        ArrayList<RptQingAnalyzeInfo> themes = (ArrayList<RptQingAnalyzeInfo>)this.getUIContext().get("themes");
        Set<String> ids = this.getThemeIdSet((List<RptQingAnalyzeInfo>)themes);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("analyzeType"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("creator.name"));
        view.getSorter().add(new SorterItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        RptQingAnalyzeCollection coll = RptQingAnalyzeFactory.getRemoteInstance().getRptQingAnalyzeCollection(view);
        if (coll != null && !coll.isEmpty()) {
            themes = new ArrayList<RptQingAnalyzeInfo>();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                themes.add((RptQingAnalyzeInfo)it.next());
            }
            this.init(themes);
        }
    }

    private Set<String> getThemeIdSet(List<RptQingAnalyzeInfo> themes) {
        HashSet<String> themeIds = new HashSet<String>();
        for (RptQingAnalyzeInfo theme : themes) {
            String id = theme.getId().toString();
            themeIds.add(id);
        }
        return themeIds;
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        Object owner = this.getUIContext().get("Owner");
        if (b && owner instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return b;
    }
}

