/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.bi.client.EnumChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemContentProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.bi.util.AnalysisAdjustEnum;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeTypeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.BaseDateEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CurrencyEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CurrencyEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DateRangeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DateShiftEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DynaItemEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DynaItemEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DynaItemSourceEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ItemEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ItemEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.OrgUnitEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.OrgUnitEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AbstractRptQingAnalyzeEditUI;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AnalyzeIndexContentProvider;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AnalyzeIndexLabelProvider;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AnalyzeIndexSorterUI;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.DynaItemContentProvider;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.DynaItemLabelProvider;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.DynaItemSortableChooseUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class RptQingAnalyzeEditUI
extends AbstractRptQingAnalyzeEditUI {
    private static final long serialVersionUID = 7816782731091780695L;
    private static final Logger logger = CoreUIObject.getLogger(RptQingAnalyzeEditUI.class);
    private static String title = null;
    private OrgTreeCollection otc = this.getAllOrgTrees();
    private OrgTreeCollection selectedOrgTrees = null;
    private OrgTreeCollection orgTrees = null;
    private static final String RES = "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource";
    private boolean isFired = true;
    private Object owner = null;
    private RptQingAnalyzeInfo rptQingAnalyze = null;
    private CurrencyInfo cui = null;
    private String displayAnalyzeTypeId = null;
    private boolean beforeOnLoad = false;
    private boolean isEcho = true;
    private boolean isError = false;
    private String oldOrgBoundNumber = null;

    public void onLoad() throws Exception {
        this.hidebutton();
        this.initCompanent();
        this.beforeOnLoad = true;
        super.onLoad();
        this.beforeOnLoad = false;
        title = this.getUITitle();
        this.setTitle();
        this.owner = this.getUIContext().get("Owner");
        this.displayAnalyzeTypeId = (String)this.getUIContext().get("displayAnalyzeTypeId");
        if ("ADDNEW".equals(this.getOprtState())) {
            this.cmbPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            this.combDateRange.setSelectedItem((Object)DateRangeEnum.CurrentYear);
            this.chkAudit.setSelected(true);
            this.editData.setIsAudit(true);
            this.rdbSingle.setSelected(true);
            this.rdbCombo.setSelected(true);
            this.chkOnlyCompany.setSelected(true);
            this.editData.setIsOnlyCompany(true);
            this.initDefaultValue();
        } else {
            this.initData();
        }
        int periodType = ((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()).getValue();
        this.getUIContext().put("periodType", periodType);
    }

    private void setTitle() {
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
    }

    private void hidebutton() {
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionSave.setEnabled(false);
    }

    private void initData() throws EASBizException, BOSException {
        String analyzeId = this.editData.getId().toString();
        this.rptQingAnalyze = (RptQingAnalyzeInfo)RptQingAnalyzeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(analyzeId), this.getQingSelector());
        this.initOrgTreeData(this.rptQingAnalyze);
        this.initOrgUnitData(this.rptQingAnalyze);
        this.initRptItemData(this.rptQingAnalyze);
        this.initAnalyzeIndexData(this.rptQingAnalyze);
        this.initDataElementData(this.rptQingAnalyze);
        this.initCurrencyData(this.rptQingAnalyze);
        this.initDataTypeData(this.rptQingAnalyze);
        this.initAdjustStatusData(this.rptQingAnalyze);
        this.initDynaItemData(this.rptQingAnalyze);
        this.displayAnalyzeTypeId = this.rptQingAnalyze.getDisplayAnalyzeType().getId().toString();
        if (this.rptQingAnalyze.getDateRange().getValue() == 0 || this.rptQingAnalyze.getDateRange().getValue() == 1) {
            this.combDateShift.setSelectedItem(null);
            this.combBaseDate.setSelectedItem(null);
        } else {
            this.spanToBefore.setValue((Object)this.rptQingAnalyze.getToBefore());
            this.spanToAfter.setValue((Object)this.rptQingAnalyze.getToAfter());
        }
    }

    private SelectorItemCollection getQingSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.isUnion"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.id"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.number"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.name"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.id"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.number"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.name"));
        sic.add(new SelectorItemInfo("dataElement.id"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.id"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.number"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.name"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.interseq"));
        sic.add(new SelectorItemInfo("currency.currency.id"));
        sic.add(new SelectorItemInfo("currency.currency.number"));
        sic.add(new SelectorItemInfo("currency.currency.name"));
        sic.add(new SelectorItemInfo("dynaItem.dynaNumber"));
        sic.add(new SelectorItemInfo("dynaItem.dynaName"));
        return sic;
    }

    private void initDynaItemData(RptQingAnalyzeInfo rptQingAnalyze) throws BOSException {
        DynaItemEntryCollection dynaitemEntrys = rptQingAnalyze.getDynaItem();
        if (dynaitemEntrys != null) {
            ArrayList<DynaItemInfo> contents = new ArrayList<DynaItemInfo>(dynaitemEntrys.size());
            Iterator it = dynaitemEntrys.iterator();
            while (it.hasNext()) {
                DynaItemEntryInfo dynaItemEntry = (DynaItemEntryInfo)it.next();
                String dynaItemNumber = dynaItemEntry.getDynaNumber();
                String dynaItemName = dynaItemEntry.getDynaName();
                DynaItemInfo dynaItemInfo = new DynaItemInfo(dynaItemName, dynaItemNumber);
                contents.add(dynaItemInfo);
            }
            if (!contents.isEmpty()) {
                this.promtDynaItem.setData(contents);
            }
        }
    }

    private void initAdjustStatusData(RptQingAnalyzeInfo rptQingAnalyze) {
        String adjustStatusString = rptQingAnalyze.getAdjustStatus();
        if (adjustStatusString != null) {
            ArrayList<AnalysisAdjustEnum> contents = null;
            if (adjustStatusString.indexOf(",") > 0) {
                String[] adjustStatusStrings = adjustStatusString.split(",");
                contents = new ArrayList(adjustStatusStrings.length);
                int size = adjustStatusStrings.length;
                for (int i = 0; i < size; ++i) {
                    AnalysisAdjustEnum adjustStatus = AnalysisAdjustEnum.getEnum((int)Integer.valueOf(adjustStatusStrings[i]));
                    contents.add(adjustStatus);
                }
            } else {
                contents = new ArrayList<AnalysisAdjustEnum>(1);
                AnalysisAdjustEnum adjustStatus = AnalysisAdjustEnum.getEnum((int)Integer.valueOf(adjustStatusString));
                contents.add(adjustStatus);
            }
            this.promtAdjustStatus.setData(contents);
        }
    }

    private void initDataTypeData(RptQingAnalyzeInfo rptQingAnalyze) {
        String dataType = rptQingAnalyze.getDataType();
        if (dataType != null) {
            ArrayList<ValueTypeEnum> contents = null;
            if (dataType.indexOf(",") > 0) {
                String[] dataTypes = dataType.split(",");
                contents = new ArrayList(dataTypes.length);
                int size = dataTypes.length;
                for (int i = 0; i < size; ++i) {
                    ValueTypeEnum valueTypeEnum = ValueTypeEnum.getEnum((int)Integer.valueOf(dataTypes[i]));
                    contents.add(valueTypeEnum);
                }
            } else {
                contents = new ArrayList<ValueTypeEnum>(1);
                ValueTypeEnum valueTypeEnum = ValueTypeEnum.getEnum((int)Integer.valueOf(dataType));
                contents.add(valueTypeEnum);
            }
            this.promtDataType.setData(contents);
        }
    }

    private void initCurrencyData(RptQingAnalyzeInfo rptQingAnalyze) throws BOSException {
        CurrencyEntryCollection currencyEntrys = rptQingAnalyze.getCurrency();
        if (currencyEntrys != null && !currencyEntrys.isEmpty()) {
            ArrayList<CurrencyInfo> contents = new ArrayList<CurrencyInfo>(currencyEntrys.size());
            Iterator it = currencyEntrys.iterator();
            while (it.hasNext()) {
                CurrencyEntryInfo currencyEntry = (CurrencyEntryInfo)it.next();
                contents.add(currencyEntry.getCurrency());
            }
            this.promtCurrency.setData(contents);
        }
    }

    private void initDataElementData(RptQingAnalyzeInfo rptQingAnalyze) throws BOSException, EASBizException {
        DataElementEntryCollection dataElementEntrys = rptQingAnalyze.getDataElement();
        if (dataElementEntrys != null && !dataElementEntrys.isEmpty()) {
            ArrayList<DataElementInfo> contents = new ArrayList<DataElementInfo>(dataElementEntrys.size());
            Iterator it = dataElementEntrys.iterator();
            while (it.hasNext()) {
                DataElementEntryInfo dataElementEntry = (DataElementEntryInfo)it.next();
                if (dataElementEntry.getDataElement() != null && dataElementEntry.getDataElement().getNumber() == null) {
                    if (!"6QH5/Jz6iRbgUxU3EazNlbnmwM4=".equals(dataElementEntry.getDataElement().getId().toString())) continue;
                    FilterInfo filter = new FilterInfo();
                    FilterItemInfo filterItem = new FilterItemInfo("number", (Object)"TSPLY");
                    filter.getFilterItems().add(filterItem);
                    boolean isExist = DataElementFactory.getRemoteInstance().exists(filter);
                    if (!isExist) {
                        String resource = "com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource";
                        IDataElement iDataElement = DataElementFactory.getRemoteInstance();
                        DataElementInfo dataElementInfo = new DataElementInfo();
                        dataElementInfo.setNumber("TSPLY");
                        dataElementInfo.setName(EASCommonResource.getString((String)resource, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                        dataElementInfo.setName(EASCommonResource.getString((String)resource, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                        dataElementInfo.setName(EASCommonResource.getString((String)resource, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                        dataElementInfo.setIsUsedElim(true);
                        dataElementInfo.setIsSys(true);
                        dataElementInfo.setInterSeq(6);
                        dataElementInfo.setSeq(6);
                        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where id='00000000-0000-0000-0000-000000000000CCE7AED4'");
                        dataElementInfo.setTrackRecordCreator(info);
                        iDataElement.addnew((CoreBaseInfo)dataElementInfo);
                    }
                    DataElementInfo deInfo = DataElementFactory.getRemoteInstance().getDataElementInfo("select id,number,name,interseq where number = 'TSPLY'");
                    dataElementEntry.setDataElement(deInfo);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("dataElement"));
                    DataElementEntryFactory.getRemoteInstance().updatePartial(dataElementEntry, selector);
                    contents.add(deInfo);
                    continue;
                }
                contents.add(dataElementEntry.getDataElement());
            }
            this.promtDataElement.setData(contents);
        }
    }

    private void initAnalyzeIndexData(RptQingAnalyzeInfo rptQingAnalyze) throws BOSException {
        IndexEntryCollection indexEntrys = rptQingAnalyze.getAnalyzeIndex();
        if (indexEntrys != null && !indexEntrys.isEmpty()) {
            ArrayList<AnalyzeIndexInfo> contents = new ArrayList<AnalyzeIndexInfo>(indexEntrys.size());
            Iterator it = indexEntrys.iterator();
            while (it.hasNext()) {
                IndexEntryInfo indexEntry = (IndexEntryInfo)it.next();
                contents.add(indexEntry.getAnalyzeIndex());
            }
            this.promtAnalyzeIndex.setData(contents);
        }
    }

    private void initRptItemData(RptQingAnalyzeInfo rptQingAnalyze) throws BOSException {
        ItemEntryCollection itemEntrys = rptQingAnalyze.getRptItem();
        if (itemEntrys != null && !itemEntrys.isEmpty()) {
            ArrayList<RPTItemInfo> contents = new ArrayList<RPTItemInfo>(itemEntrys.size());
            Iterator it = itemEntrys.iterator();
            while (it.hasNext()) {
                ItemEntryInfo itemEntry = (ItemEntryInfo)it.next();
                if (itemEntry.getRptItem() == null || itemEntry.getRptItem().getNumber() == null) continue;
                contents.add(itemEntry.getRptItem());
            }
            if (!contents.isEmpty()) {
                this.promtRptItem.setData(contents);
            }
        }
    }

    private void initOrgUnitData(RptQingAnalyzeInfo rptQingAnalyze) throws BOSException {
        OrgUnitEntryCollection orgUnitEntrys = rptQingAnalyze.getOrgUnit();
        if (orgUnitEntrys != null && !orgUnitEntrys.isEmpty()) {
            ArrayList<FullOrgUnitInfo> contents = new ArrayList<FullOrgUnitInfo>(orgUnitEntrys.size());
            Iterator it = orgUnitEntrys.iterator();
            while (it.hasNext()) {
                OrgUnitEntryInfo orgUnitEntry = (OrgUnitEntryInfo)it.next();
                contents.add(orgUnitEntry.getOrgUnit());
            }
            this.promtOrgUnit.setData(contents);
        }
    }

    private void initOrgTreeData(RptQingAnalyzeInfo rptQingAnalyze) {
        OrgTreeInfo orgTree = rptQingAnalyze.getOrgTree();
        if (orgTree != null) {
            String orgTreeNumber = orgTree.getNumber().toString();
            int size = this.cmbOrgTree.getItemCount();
            for (int i = 0; i < size; ++i) {
                String treeNumber;
                OrgTreeInfo info = (OrgTreeInfo)this.cmbOrgTree.getItemAt(i);
                if (info.getNumber() == null || !orgTreeNumber.equals(treeNumber = info.getNumber().toString())) continue;
                this.cmbOrgTree.setSelectedIndex(i);
                return;
            }
        }
    }

    private void initCompanent() throws Exception {
        this.addOrgUnitSelectorListener();
        this.initItemPromt();
        this.initAnalyzeIndexPromt();
        this.initDataElementPromt();
        this.initCurrencyPromt();
        this.initDataTypePromt();
        this.initAdjustPrompt();
        this.initAsstActTypePromt();
        this.initAsstPromt();
    }

    private void addOrgUnitSelectorListener() {
        this.promtOrgUnit.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                List orgs;
                if (RptQingAnalyzeEditUI.this.otc == null || RptQingAnalyzeEditUI.this.otc != null && RptQingAnalyzeEditUI.this.otc.isEmpty()) {
                    MsgBox.showError((String)EASResource.getString((String)RptQingAnalyzeEditUI.RES, (String)"91_orgTreeIsNull"));
                    SysUtil.abort();
                }
                if ((orgs = (List)RptQingAnalyzeEditUI.this.promtOrgUnit.getData()) != null && orgs.size() > 0) {
                    HashSet<String> orgSet = new HashSet<String>();
                    int size = orgs.size();
                    for (int i = 0; i < size; ++i) {
                        Object org = orgs.get(i);
                        if (org instanceof CompanyOrgUnitInfo) {
                            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)org;
                            orgSet.add(company.getId().toString());
                            continue;
                        }
                        if (!(org instanceof FullOrgUnitInfo)) continue;
                        FullOrgUnitInfo fullOrgUnit = (FullOrgUnitInfo)org;
                        orgSet.add(fullOrgUnit.getId().toString());
                    }
                    ((UnionF7Helper.UnionF7)RptQingAnalyzeEditUI.this.promtOrgUnit.getSelector()).refresh();
                    ((UnionF7Helper.UnionF7)RptQingAnalyzeEditUI.this.promtOrgUnit.getSelector()).setSelectedOrgIds(orgSet);
                }
            }
        });
    }

    private void initDefaultValue() {
        this.promtDataType.setData(Arrays.asList(ValueTypeEnum.MONEY));
        this.promtAdjustStatus.setData(Arrays.asList(AnalysisAdjustEnum.ADJUSTED));
        try {
            this.cui = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId()));
            this.promtCurrency.setData(Arrays.asList(this.cui));
        }
        catch (Exception e) {
            logger.error((Object)"initDefaultValue: ", (Throwable)e);
        }
    }

    private void initAsstPromt() {
        this.promtDynaItem.setEditable(false);
        this.promtDynaItem.setSelectAllOnFocus(false);
        this.promtDynaItem.setSelector((KDPromptSelector)new DynaItemSortableChooseUI(new DynaItemContentProvider(){

            @Override
            public List getSelected() {
                return (List)RptQingAnalyzeEditUI.this.promtDynaItem.getData();
            }
        }, new DynaItemLabelProvider(), (IUIObject)this));
    }

    private void initAnalyzeIndexPromt() {
        this.promtAnalyzeIndex.setEditable(false);
        this.promtAnalyzeIndex.setSelectAllOnFocus(false);
        this.promtAnalyzeIndex.setSelector((KDPromptSelector)new AnalyzeIndexSorterUI(new AnalyzeIndexContentProvider(){

            @Override
            public List getSelected() {
                return (List)RptQingAnalyzeEditUI.this.promtAnalyzeIndex.getData();
            }
        }, new AnalyzeIndexLabelProvider(), (IUIObject)this));
    }

    private Set<String> getSelectedOrgTreeIds(OrgTreeCollection orgTreeColl) {
        HashSet<String> orgTreeIds = new HashSet<String>();
        if (orgTreeColl != null) {
            for (OrgTreeInfo orgTree : orgTreeColl) {
                String treeId = orgTree.getId().toString();
                orgTreeIds.add(treeId);
            }
        }
        return orgTreeIds;
    }

    private void initAsstActTypePromt() {
        this.promtAsstActType.setQueryInfo("com.kingdee.eas.fi.newrpt.rptIndexAnalyze.F7AsstActTypeQuery");
        this.promtAsstActType.setFilterInfoProducer((IFilterInfoProducer)new NullFilterInfoProducer());
        this.promtAsstActType.setEditable(false);
    }

    private void initItemPromt() {
        this.promtRptItem.setEditable(false);
        this.promtRptItem.setSelectAllOnFocus(false);
        this.getUIContext().put("isNeedMultiDynRpt", "false");
        this.promtRptItem.setSelector((KDPromptSelector)new SortableChooser((IChooserContentProvider)new ItemContentProvider(){

            public List getSelected() {
                return (List)RptQingAnalyzeEditUI.this.promtRptItem.getData();
            }
        }, (IChooserLabelProvider)new ItemLabelProvider(), (IUIObject)this));
    }

    private void initDataElementPromt() {
        this.promtDataElement.setEditable(false);
        this.promtDataElement.setSelectAllOnFocus(false);
        this.promtDataElement.setSelector((KDPromptSelector)new SortableChooser((IChooserContentProvider)new FetchTypeProvider(){

            public List getSelected() {
                return (List)RptQingAnalyzeEditUI.this.promtDataElement.getData();
            }
        }, (IChooserLabelProvider)new FetchTypeLabelProvider(), (IUIObject)this));
    }

    private void initCurrencyPromt() throws Exception {
        this.promtCurrency.setEditable(false);
        this.promtCurrency.setSelectAllOnFocus(false);
        CurrencyProvider contentP = new CurrencyProvider();
        this.promtCurrency.setSelector((KDPromptSelector)new SortableChooser((IChooserContentProvider)contentP, (IChooserLabelProvider)new CurrencyLabelProvider(), (IUIObject)this));
        this.promtCurrency.setData((Object)contentP.getContents());
    }

    private void initDataTypePromt() {
        this.promtDataType.setEditable(false);
        this.promtDataType.setSelectAllOnFocus(false);
        this.promtDataType.setSelector((KDPromptSelector)new SortableChooser(new IChooserContentProvider(){
            List contents = null;

            public int compare(Object obj1, Object obj2) {
                return obj1 == obj2 ? 0 : 1;
            }

            public boolean enableFilter() {
                return false;
            }

            public List getContents() throws Exception {
                if (this.contents == null) {
                    this.contents = new ArrayList();
                    this.contents.add(ValueTypeEnum.MONEY);
                    this.contents.add(ValueTypeEnum.QUANTITY);
                }
                return this.contents;
            }

            public List getSelected() {
                return (List)RptQingAnalyzeEditUI.this.promtDataType.getData();
            }

            public boolean matchFilter(Object item, int column, String filterString) {
                return false;
            }

            public void setContents(ArrayList contents) {
                this.contents = contents;
            }

            public boolean enableTemplateFilter() {
                return false;
            }
        }, (IChooserLabelProvider)new EnumChooserLabelProvider(), (IUIObject)this));
    }

    private void initAdjustPrompt() {
        this.promtAdjustStatus.setEditable(false);
        this.promtAdjustStatus.setSelectAllOnFocus(false);
        this.promtAdjustStatus.setSelector((KDPromptSelector)new SortableChooser(new IChooserContentProvider(){
            List contents = null;

            public int compare(Object obj1, Object obj2) {
                return obj1 == obj2 ? 0 : 1;
            }

            public boolean enableFilter() {
                return false;
            }

            public List getContents() throws Exception {
                if (this.contents == null) {
                    this.contents = new ArrayList();
                    this.contents.add(AnalysisAdjustEnum.ADJUSTED);
                    this.contents.add(AnalysisAdjustEnum.BEFOREADJUST);
                    this.contents.add(AnalysisAdjustEnum.ADJUSTVALUE);
                }
                return this.contents;
            }

            public List getSelected() {
                return (List)RptQingAnalyzeEditUI.this.promtAdjustStatus.getData();
            }

            public boolean matchFilter(Object item, int column, String filterString) {
                return false;
            }

            public void setContents(ArrayList contents) {
                this.contents = contents;
            }

            public boolean enableTemplateFilter() {
                return false;
            }
        }, (IChooserLabelProvider)new EnumChooserLabelProvider(), (IUIObject)this));
    }

    private void initOrgBound() throws EASBizException, BOSException {
        if (this.otc == null) {
            return;
        }
        this.cmbOrgTree.removeAllItems();
        ArrayList<OrgTreeInfo> orgTreeList = new ArrayList<OrgTreeInfo>();
        ArrayList<String> orgTreeNumberList = new ArrayList<String>();
        OrgTreeInfo treeInfo2 = null;
        OrgTreeInfo newOrgTreeInfo = null;
        if (this.otc != null && !this.otc.isEmpty()) {
            Date startDate = this.getStartDate();
            Date endDate = this.getEndDate();
            for (OrgTreeInfo treeInfo2 : this.otc) {
                if (treeInfo2 == null || treeInfo2.isIsHide() || treeInfo2.getStatus().getValue() == 0) continue;
                Timestamp treeStratDate = treeInfo2.getStartDate();
                Timestamp treeEndDate = treeInfo2.getEndDate();
                if ((treeStratDate == null || startDate.compareTo(treeStratDate) > 0 || treeEndDate != null && endDate.compareTo(treeEndDate) < 0) && (treeStratDate == null || startDate.compareTo(treeStratDate) < 0 || treeEndDate != null && endDate.compareTo(treeEndDate) > 0)) continue;
                newOrgTreeInfo = new OrgTreeInfo();
                newOrgTreeInfo.setId(treeInfo2.getId());
                newOrgTreeInfo.setName(treeInfo2.getName());
                newOrgTreeInfo.setNumber(treeInfo2.getNumber());
                if (orgTreeNumberList.contains(treeInfo2.getNumber())) continue;
                orgTreeNumberList.add(treeInfo2.getNumber());
                orgTreeList.add(newOrgTreeInfo);
            }
        }
        this.isFired = false;
        if (!orgTreeList.isEmpty()) {
            this.cmbOrgTree.addItem((Object)new OrgTreeInfo());
            this.cmbOrgTree.addItems(orgTreeList.toArray());
            if (this.oldOrgBoundNumber != null) {
                int size = this.cmbOrgTree.getItemCount();
                for (int i = 0; i < size; ++i) {
                    String treeNumber;
                    OrgTreeInfo info = (OrgTreeInfo)this.cmbOrgTree.getItemAt(i);
                    if (info.getNumber() == null || !this.oldOrgBoundNumber.equals(treeNumber = info.getNumber().toString())) continue;
                    this.cmbOrgTree.setSelectedIndex(i);
                    return;
                }
            }
        }
        this.isFired = true;
    }

    private Date getStartDate() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        int year = this.spnStartYear.getIntegerVlaue();
        int period = this.spnStartPeriod.getIntegerVlaue();
        Date startDate = RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)periodType);
        Timestamp time = new Timestamp(startDate.getTime());
        return time;
    }

    private Date getEndDate() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        int year = this.spnEndYear.getIntegerVlaue();
        int period = this.spnEndPeriod.getIntegerVlaue();
        Date endDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType);
        Timestamp time = new Timestamp(endDate.getTime());
        return time;
    }

    private OrgTreeCollection getAllOrgTrees() throws EASBizException, BOSException {
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection();
        if (otc == null) {
            return null;
        }
        if ((otc = CslRptUtil.getOrgTreeCollectionOrderByNumberNew(null, (OrgTreeCollection)otc)) == null) {
            return null;
        }
        return otc;
    }

    private OrgTreeCollection getSelectedOrgTreesByDate() throws BOSException {
        if (this.cmbOrgTree.getSelectedItem() != null) {
            OrgTreeInfo tree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            String treeNumber = tree.getNumber();
            OrgTreeCollection trees = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("select id,name,number,IsHide,IsForBudget,status,layerType,type,isVersioned,startDate,endDate where number = '" + treeNumber + "' and status != " + 0 + " and type = 8 order by startDate desc");
            OrgTreeCollection orgtrees = new OrgTreeCollection();
            if (trees != null && !trees.isEmpty()) {
                Date startDate = this.getStartDate();
                Date endDate = this.getEndDate();
                for (OrgTreeInfo treeInfo : trees) {
                    Timestamp treeStratDate = treeInfo.getStartDate();
                    Timestamp treeEndDate = treeInfo.getEndDate();
                    if ((treeStratDate == null || ((Date)treeStratDate).compareTo(startDate) < 0 || treeEndDate != null && ((Date)treeEndDate).compareTo(endDate) > 0) && (treeStratDate == null || ((Date)treeStratDate).compareTo(startDate) > 0 || treeEndDate != null && (treeEndDate == null || ((Date)treeEndDate).compareTo(endDate) < 0))) continue;
                    orgtrees.add(treeInfo);
                }
            }
            return orgtrees;
        }
        return null;
    }

    private OrgTreeCollection getOrgTreesByDate() {
        if (this.otc != null && !this.otc.isEmpty()) {
            Date startDate = this.getStartDate();
            Date endDate = this.getEndDate();
            Iterator it = this.otc.iterator();
            OrgTreeCollection orgtrees = new OrgTreeCollection();
            while (it.hasNext()) {
                OrgTreeInfo treeInfo = (OrgTreeInfo)it.next();
                Timestamp treeStratDate = treeInfo.getStartDate();
                Timestamp treeEndDate = treeInfo.getEndDate();
                if ((treeStratDate == null || startDate.compareTo(treeStratDate) > 0 || treeEndDate != null && endDate.compareTo(treeEndDate) < 0) && (treeStratDate == null || startDate.compareTo(treeStratDate) < 0 || treeEndDate != null && endDate.compareTo(treeEndDate) > 0)) continue;
                orgtrees.add(treeInfo);
            }
            return orgtrees;
        }
        return null;
    }

    private void refreshUnitF7() throws BOSException {
        if (this.otc != null && !this.otc.isEmpty()) {
            this.promtOrgUnit.setValue(null);
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            OrgTreeInfo orgTree = (OrgTreeInfo)this.cmbOrgTree.getSelectedItem();
            if (orgTree != null && orgTree.getId() != null) {
                try {
                    this.selectedOrgTrees = this.getSelectedOrgTreesByDate();
                    this.oldOrgBoundNumber = orgTree.getNumber();
                }
                catch (BOSException e1) {
                    logger.error((Object)"getSelectedOrgTreesByDate: ", (Throwable)e1);
                }
                f7.setOrgTrees(this.selectedOrgTrees);
            } else {
                this.orgTrees = this.getOrgTreesByDate();
                f7.setOrgTrees(this.orgTrees);
            }
            f7.setNeedAddOrgRange(false);
            f7.setMultiSelect(true);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            f7.setQingAnalyze(true);
            this.promtOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
            this.promtOrgUnit.setSelector((KDPromptSelector)f7);
            this.promtOrgUnit.setEditable(false);
        }
    }

    @Override
    protected void promtOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        this.initAsstItem();
    }

    private void initAsstItem() throws BOSException {
        if (this.promtOrgUnit.getData() == null) {
            this.getUIContext().clear();
            return;
        }
        Set<String> orgTreeIds = null;
        if (this.selectedOrgTrees != null) {
            orgTreeIds = this.getSelectedOrgTreeIds(this.selectedOrgTrees);
        }
        HashSet<String> companyIds = new HashSet<String>();
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> orgNumbers = new HashSet<String>();
        HashSet<String> relOrgUnitIds = new HashSet<String>();
        this.getSelectedOrgUnit(companyIds, orgIds, orgNumbers);
        if (this.selectedOrgTrees == null) {
            orgTreeIds = new HashSet<String>();
            this.getSelOrgTreeIds(orgTreeIds, orgIds);
        }
        Map context = this.getUIContext();
        int startYear = this.spnStartYear.getIntegerVlaue();
        int startPeriod = this.spnStartPeriod.getIntegerVlaue();
        int endYear = this.spnEndYear.getIntegerVlaue();
        int endPeriod = this.spnEndPeriod.getIntegerVlaue();
        context.put("startYear", startYear);
        context.put("startPeriod", startPeriod);
        context.put("endYear", endYear);
        context.put("endPeriod", endPeriod);
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        context.put("periodType", periodType.getValue());
        context.put("orgTreeIds", orgTreeIds);
        if (!companyIds.isEmpty()) {
            context.put("companyIds", companyIds);
        }
        if (!orgNumbers.isEmpty()) {
            this.getOrgUnitIds(relOrgUnitIds, orgTreeIds, orgNumbers);
            context.put("orgIds", relOrgUnitIds);
        }
        if (this.promtAsstActType.getData() != null) {
            String asstActNumber = ((AsstActTypeInfo)this.promtAsstActType.getData()).getNumber();
            context.put("asstActNumber", asstActNumber);
        }
        context.put("isFromQingAnalyze", true);
    }

    @Override
    protected void cmbPeriodType_actionPerformed(ActionEvent e) throws Exception {
        if (this.beforeOnLoad) {
            return;
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (periodType == null) {
            this.cmbPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        }
        this.setYearAndPeriod();
        this.setUserDefineYearAndPeriod();
        this.initOrgBound();
        this.refreshUnitF7();
    }

    @Override
    protected void combDateRange_actionPerformed(ActionEvent e) throws Exception {
        if ("ADDNEW".equals(this.getOprtState()) && this.beforeOnLoad) {
            return;
        }
        DateRangeEnum dateRange = (DateRangeEnum)((Object)this.combDateRange.getSelectedItem());
        if (dateRange.getValue() == 2) {
            this.combDateShift.setEnabled(true);
            this.combBaseDate.setEnabled(true);
            this.spanToBefore.setEnabled(true);
            this.spanToAfter.setEnabled(true);
            this.dpkSpecifyDate.setEnabled(true);
            this.combDateShift.setSelectedItem((Object)DateShiftEnum.YearlyShift);
            this.combBaseDate.setSelectedItem((Object)BaseDateEnum.CurrentDate);
            this.spanToBefore.setValue((Object)0);
            this.spanToAfter.setValue((Object)0);
            this.setUserDefineYearAndPeriod();
            this.initOrgBound();
            this.refreshUnitF7();
        } else {
            this.combDateShift.setEnabled(false);
            this.combBaseDate.setEnabled(false);
            this.spanToBefore.setEnabled(false);
            this.spanToAfter.setEnabled(false);
            this.dpkSpecifyDate.setEnabled(false);
            this.dpkSpecifyDate.setValue(null);
            this.combDateShift.setSelectedItem(null);
            this.combBaseDate.setSelectedItem(null);
            this.spanToBefore.setValue((Object)0, false);
            this.spanToAfter.setValue((Object)0, false);
            this.setYearAndPeriod();
            this.initOrgBound();
            this.refreshUnitF7();
        }
    }

    private void setUserDefineYearAndPeriod() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        DateRangeEnum dateRange = (DateRangeEnum)((Object)this.combDateRange.getSelectedItem());
        if (dateRange.getValue() == 2) {
            this.setUserDefineStartYearAndPeriod(periodType);
            this.setUserDefineEndYearAndPeriod(periodType);
        }
    }

    private void setUserDefineStartYearAndPeriod(RptPeriodTypeEnum periodType) {
        BaseDateEnum baseDate = (BaseDateEnum)((Object)this.combBaseDate.getSelectedItem());
        Date date = null;
        date = baseDate.getValue() == 0 ? new Date() : this.dpkSpecifyDate.getSqlDate();
        DateShiftEnum dateShift = (DateShiftEnum)((Object)this.combDateShift.getSelectedItem());
        int beforeShiftValue = this.spanToBefore.getIntegerVlaue();
        beforeShiftValue = -1 * beforeShiftValue;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        int year = 0;
        if (dateShift.getValue() == 0) {
            calendar.add(1, beforeShiftValue);
            year = calendar.get(1);
            this.setStartYearAndPeriod(periodType, year);
        } else if (dateShift.getValue() == 1) {
            calendar.add(2, beforeShiftValue *= 3);
            date = this.getFirstMonthForQuarter(calendar);
            List startTimes = RPTDateUtil.getRptPeriod((Date)date, (RptPeriodTypeEnum)periodType);
            int startYear = new Integer(startTimes.get(0).toString());
            int startPeriod = new Integer(startTimes.get(1).toString());
            this.spnStartYear.setValue((Object)startYear);
            this.spnStartPeriod.setValue((Object)startPeriod);
        } else if (dateShift.getValue() == 2) {
            calendar.add(2, beforeShiftValue);
            date = calendar.getTime();
            List startTimes = RPTDateUtil.getRptPeriod((Date)date, (RptPeriodTypeEnum)periodType);
            int startYear = new Integer(startTimes.get(0).toString());
            int startPeriod = new Integer(startTimes.get(1).toString());
            this.spnStartYear.setValue((Object)startYear);
            this.spnStartPeriod.setValue((Object)startPeriod);
        } else {
            calendar.add(5, beforeShiftValue);
            date = calendar.getTime();
            List startTimes = RPTDateUtil.getRptPeriod((Date)date, (RptPeriodTypeEnum)periodType);
            int startYear = new Integer(startTimes.get(0).toString());
            int startPeriod = new Integer(startTimes.get(1).toString());
            this.spnStartYear.setValue((Object)startYear);
            this.spnStartPeriod.setValue((Object)startPeriod);
        }
    }

    private Date getFirstMonthForQuarter(Calendar calendar) {
        int month = calendar.get(2) + 1;
        if (month < 4) {
            month = 0;
        } else if (month < 7) {
            month = 3;
        } else if (month < 10) {
            month = 6;
        } else if (month <= 12) {
            month = 9;
        }
        calendar.set(2, month);
        return calendar.getTime();
    }

    private void setUserDefineEndYearAndPeriod(RptPeriodTypeEnum periodType) {
        BaseDateEnum baseDate = (BaseDateEnum)((Object)this.combBaseDate.getSelectedItem());
        Date date = null;
        date = baseDate.getValue() == 0 ? new Date() : this.dpkSpecifyDate.getSqlDate();
        DateShiftEnum dateShift = (DateShiftEnum)((Object)this.combDateShift.getSelectedItem());
        int afterShiftValue = this.spanToAfter.getIntegerVlaue();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        int year = 0;
        if (dateShift.getValue() == 0) {
            calendar.add(1, afterShiftValue);
            year = calendar.get(1);
            this.setEndYearAndPeriod(periodType, year);
        } else if (dateShift.getValue() == 1) {
            calendar.add(2, afterShiftValue *= 3);
            date = this.getLastMonthForQuarter(calendar);
            List endTimes = RPTDateUtil.getRptPeriod((Date)date, (RptPeriodTypeEnum)periodType);
            int endYear = new Integer(endTimes.get(0).toString());
            int endPeriod = new Integer(endTimes.get(1).toString());
            this.spnEndYear.setValue((Object)endYear);
            this.spnEndPeriod.setValue((Object)endPeriod);
        } else if (dateShift.getValue() == 2) {
            calendar.add(2, afterShiftValue);
            date = calendar.getTime();
            List endTimes = RPTDateUtil.getRptPeriod((Date)date, (RptPeriodTypeEnum)periodType);
            int endYear = new Integer(endTimes.get(0).toString());
            int endPeriod = new Integer(endTimes.get(1).toString());
            this.spnEndYear.setValue((Object)endYear);
            this.spnEndPeriod.setValue((Object)endPeriod);
        } else {
            calendar.add(5, afterShiftValue);
            date = calendar.getTime();
            List endTimes = RPTDateUtil.getRptPeriod((Date)date, (RptPeriodTypeEnum)periodType);
            int endYear = new Integer(endTimes.get(0).toString());
            int endPeriod = new Integer(endTimes.get(1).toString());
            this.spnEndYear.setValue((Object)endYear);
            this.spnEndPeriod.setValue((Object)endPeriod);
        }
    }

    private Date getLastMonthForQuarter(Calendar calendar) {
        int month = calendar.get(2) + 1;
        if (month < 4) {
            month = 2;
        } else if (month < 7) {
            month = 5;
        } else if (month < 10) {
            month = 8;
        } else if (month <= 12) {
            month = 11;
        }
        calendar.set(2, month);
        return calendar.getTime();
    }

    private void setYearAndPeriod() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        DateRangeEnum dateRange = (DateRangeEnum)((Object)this.combDateRange.getSelectedItem());
        if (dateRange.getValue() == 0) {
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            this.setStartYearAndPeriod(periodType, year);
            this.setEndYearAndPeriod(periodType, year);
        } else if (dateRange.getValue() == 1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -1);
            int year = calendar.get(1);
            this.setStartYearAndPeriod(periodType, year);
            this.setEndYearAndPeriod(periodType, year);
        }
    }

    private void setEndYearAndPeriod(RptPeriodTypeEnum periodType, int year) {
        Date endDate = this.getLastDateOfYear(year);
        List endTimes = RPTDateUtil.getRptPeriod((Date)endDate, (RptPeriodTypeEnum)periodType);
        int endYear = new Integer(endTimes.get(0).toString());
        int endPeriod = new Integer(endTimes.get(1).toString());
        this.spnEndYear.setValue((Object)endYear);
        this.spnEndPeriod.setValue((Object)endPeriod);
    }

    private void setStartYearAndPeriod(RptPeriodTypeEnum periodType, int year) {
        Date startDate = this.getFirstDateOfYear(year);
        List startTimes = RPTDateUtil.getRptPeriod((Date)startDate, (RptPeriodTypeEnum)periodType);
        int startYear = new Integer(startTimes.get(0).toString());
        int startPeriod = new Integer(startTimes.get(1).toString());
        this.spnStartYear.setValue((Object)startYear);
        this.spnStartPeriod.setValue((Object)startPeriod);
    }

    private Date getFirstDateOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    private Date getLastDateOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    @Override
    protected void combDateShift_actionPerformed(ActionEvent e) throws Exception {
        if (this.combDateShift.isEnabled()) {
            DateShiftEnum dateShift = (DateShiftEnum)((Object)this.combDateShift.getSelectedItem());
            if (dateShift.getValue() == 0) {
                String yearString = EASResource.getString((String)RES, (String)"92_yearlyShift");
                this.lblToBefore.setText(yearString);
                this.lblToAfter.setText(yearString);
                this.isEcho = false;
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToBefore, (int)0, (int)5);
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToAfter, (int)0, (int)5);
                this.isEcho = true;
            } else if (dateShift.getValue() == 1) {
                String quarterString = EASResource.getString((String)RES, (String)"93_quarterlyShift");
                this.lblToBefore.setText(quarterString);
                this.lblToAfter.setText(quarterString);
                this.isEcho = false;
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToBefore, (int)0, (int)12);
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToAfter, (int)0, (int)12);
                this.isEcho = true;
            } else if (dateShift.getValue() == 2) {
                String monthString = EASResource.getString((String)RES, (String)"94_monthlyShift");
                this.lblToBefore.setText(monthString);
                this.lblToAfter.setText(monthString);
                this.isEcho = false;
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToBefore, (int)0, (int)36);
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToAfter, (int)0, (int)36);
                this.isEcho = true;
            } else if (dateShift.getValue() == 3) {
                String dayString = EASResource.getString((String)RES, (String)"113_dayTitle");
                this.lblToBefore.setText(dayString);
                this.lblToAfter.setText(dayString);
                this.isEcho = false;
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToBefore, (int)0, (int)35);
                CslRptUIUtil.setSpineRange((KDSpinner)this.spanToAfter, (int)0, (int)35);
                this.isEcho = true;
            }
            this.spanToBefore.setValue((Object)0);
            this.spanToAfter.setValue((Object)0);
            DateRangeEnum dateRange = (DateRangeEnum)((Object)this.combDateRange.getSelectedItem());
            if (dateRange.getValue() == 2) {
                BaseDateEnum baseData = (BaseDateEnum)((Object)this.combBaseDate.getSelectedItem());
                if (baseData == null) {
                    this.combBaseDate.setSelectedItem((Object)BaseDateEnum.CurrentDate);
                }
                RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
                this.setUserDefineStartYearAndPeriod(periodType);
                this.setUserDefineEndYearAndPeriod(periodType);
            }
        }
    }

    @Override
    protected void combBaseDate_actionPerformed(ActionEvent e) throws Exception {
        if (this.combBaseDate.isEnabled()) {
            BaseDateEnum baseDate = (BaseDateEnum)((Object)this.combBaseDate.getSelectedItem());
            if (baseDate.getValue() == 1) {
                this.dpkSpecifyDate.setEnabled(true);
                this.dpkSpecifyDate.setValue((Object)new Date());
            } else {
                this.dpkSpecifyDate.setEnabled(false);
                this.dpkSpecifyDate.setValue(null, false);
            }
            DateRangeEnum dateRange = (DateRangeEnum)((Object)this.combDateRange.getSelectedItem());
            if (dateRange.getValue() == 2) {
                RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
                this.setUserDefineStartYearAndPeriod(periodType);
                this.setUserDefineEndYearAndPeriod(periodType);
            }
        }
    }

    @Override
    protected void spanToBefore_stateChanged(ChangeEvent e) throws Exception {
        if (this.spanToBefore.isEnabled() && this.isEcho) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
            this.setUserDefineStartYearAndPeriod(periodType);
            this.initOrgBound();
            this.refreshUnitF7();
        }
    }

    @Override
    protected void spanToAfter_stateChanged(ChangeEvent e) throws Exception {
        if (this.spanToBefore.isEnabled() && this.isEcho) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
            this.setUserDefineEndYearAndPeriod(periodType);
            this.initOrgBound();
            this.refreshUnitF7();
        }
    }

    @Override
    protected void dpkSpecifyDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.dpkSpecifyDate.isEnabled()) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
            this.setUserDefineStartYearAndPeriod(periodType);
            this.setUserDefineEndYearAndPeriod(periodType);
            this.initOrgBound();
            this.refreshUnitF7();
        }
    }

    @Override
    protected void cmbOrgTree_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFired) {
            this.refreshUnitF7();
        }
    }

    @Override
    protected void cmbAnalyzeType_actionPerformed(ActionEvent e) throws Exception {
        AnalyzeTypeEnum anlyzeType;
        if (!this.beforeOnLoad) {
            this.reInit();
        }
        if ((anlyzeType = (AnalyzeTypeEnum)((Object)this.cmbAnalyzeType.getSelectedItem())).getValue() == 0) {
            this.kDLabelContainer11.setVisible(true);
            this.kDLabelContainer15.setVisible(true);
            this.kDLabelContainer16.setVisible(false);
            this.kDLabelContainer17.setVisible(false);
            this.kDLabelContainer18.setVisible(false);
            this.kDLabelContainer19.setVisible(false);
            this.kDPanel1.setBounds(new Rectangle(10, 172, 620, 193));
            this.kDPanel2.setBounds(new Rectangle(10, 368, 620, 40));
            this.kDPanel3.setBounds(new Rectangle(10, 409, 620, 40));
            this.kDLabel7.setBounds(new Rectangle(10, 454, 100, 19));
            this.txtDescription.setBounds(new Rectangle(10, 474, 620, 120));
            this.chkOnlyCompany.setVisible(true);
            this.promtDataType.setRequired(true);
            this.promtDataElement.setRequired(true);
        } else if (anlyzeType.getValue() == 1) {
            this.kDLabelContainer11.setVisible(true);
            this.kDLabelContainer16.setVisible(false);
            this.kDLabelContainer15.setVisible(true);
            this.kDLabelContainer17.setVisible(true);
            this.kDLabelContainer18.setVisible(true);
            this.kDLabelContainer19.setVisible(true);
            this.kDPanel1.setBounds(new Rectangle(10, 172, 620, 265));
            this.kDPanel2.setBounds(new Rectangle(10, 440, 620, 40));
            this.kDPanel3.setBounds(new Rectangle(10, 483, 620, 40));
            this.kDLabel7.setBounds(new Rectangle(10, 526, 100, 19));
            this.txtDescription.setBounds(new Rectangle(10, 543, 620, 50));
            this.chkOnlyCompany.setVisible(true);
            this.promtDataType.setRequired(true);
            this.promtDataElement.setRequired(true);
        } else {
            this.kDLabelContainer15.setVisible(false);
            this.kDLabelContainer16.setVisible(true);
            this.kDLabelContainer11.setVisible(false);
            this.kDLabelContainer17.setVisible(false);
            this.kDLabelContainer18.setVisible(false);
            this.kDLabelContainer19.setVisible(false);
            this.kDPanel1.setBounds(new Rectangle(10, 172, 620, 169));
            this.kDPanel2.setBounds(new Rectangle(10, 339, 620, 40));
            this.kDPanel3.setBounds(new Rectangle(10, 382, 620, 40));
            this.kDLabel7.setBounds(new Rectangle(10, 425, 100, 19));
            this.txtDescription.setBounds(new Rectangle(10, 445, 620, 167));
            this.chkOnlyCompany.setVisible(false);
            this.promtDataType.setRequired(false);
            this.promtDataType.setEditable(true);
            this.promtDataElement.setRequired(false);
            this.promtDataElement.setEditable(true);
        }
        this.updateUI();
        this.promtDataType.setEditable(false);
        this.promtDataElement.setEditable(false);
    }

    private void reInit() {
        this.promtOrgUnit.setData(null);
        this.promtRptItem.setData(null);
        this.promtAnalyzeIndex.setData(null);
        this.promtDataElement.setData(null);
        this.cmbDynaItemSource.setSelectedIndex(0);
        this.promtAsstActType.setData(null);
        this.promtDynaItem.setData(null);
        this.chkWeave.setSelected(false);
        this.chkAudit.setSelected(true);
        this.chkCommit.setSelected(false);
        this.chkComfirm.setSelected(false);
        this.rdbSingle.setSelected(true);
        this.rdbCombo.setSelected(true);
        this.rdbSum.setSelected(false);
        this.chkOnlyCompany.setSelected(true);
        this.initDefaultValue();
    }

    @Override
    protected void cmbDynaItemSource_actionPerformed(ActionEvent e) throws Exception {
        AnalyzeTypeEnum analyzeType = (AnalyzeTypeEnum)((Object)this.cmbAnalyzeType.getSelectedItem());
        if (analyzeType.getValue() == 1) {
            DynaItemSourceEnum dItemSource = (DynaItemSourceEnum)((Object)this.cmbDynaItemSource.getSelectedItem());
            if (dItemSource.getValue() == 0) {
                this.promtAsstActType.setEnabled(true);
            } else {
                this.promtAsstActType.setEnabled(false);
                this.promtAsstActType.setData(null);
            }
            this.promtDynaItem.setData(null);
        }
    }

    @Override
    protected void promtAsstActType_stateChanged(ChangeEvent e) throws Exception {
        if (this.promtAsstActType.getData() != null) {
            String asstActNumber = ((AsstActTypeInfo)this.promtAsstActType.getData()).getNumber();
            this.getUIContext().put("asstActNumber", asstActNumber);
        }
        this.promtDynaItem.setData(null);
    }

    private void getOrgUnitIds(Set<String> relOrgUnitIds, Set<String> orgTreeIds, Set<String> orgNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", orgTreeIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("unit.number", orgNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        OrgStructureCollection orgStructure = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view);
        if (orgStructure != null && !orgStructure.isEmpty()) {
            for (OrgStructureInfo info : orgStructure) {
                String unitId = info.getUnit().getId().toString();
                relOrgUnitIds.add(unitId);
            }
        }
    }

    private void getSelOrgTreeIds(Set<String> orgTreeIds, Set<String> orgIds) throws BOSException {
        if (orgIds.isEmpty()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("tree.number"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSorter().add(new SorterItemInfo("tree.number"));
        filter.getFilterItems().add(new FilterItemInfo("unit", orgIds, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgStructureCollection orgStructures = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view);
        if (orgStructures != null && orgStructures.isEmpty()) {
            for (OrgStructureInfo orgStructure : orgStructures) {
                String treeNumber = orgStructure.getTree().getNumber();
                this.getOrgTreeIdByOrgUnit(orgTreeIds, treeNumber);
            }
        }
    }

    private void getOrgTreeIdByOrgUnit(Set<String> orgTreeIds, String treeNumber) {
        if (this.orgTrees != null && !this.orgTrees.isEmpty()) {
            for (OrgTreeInfo orgTree : this.orgTrees) {
                String number = orgTree.getNumber();
                String id = orgTree.getId().toString();
                if (!number.equals(treeNumber)) continue;
                orgTreeIds.add(id);
            }
        }
    }

    private void getSelectedOrgUnit(Set<String> companyIds, Set<String> orgIds, Set<String> orgNumbers) {
        Object[] orgUnits = null;
        if (this.promtOrgUnit.getData() instanceof ArrayList) {
            ArrayList list = (ArrayList)this.promtOrgUnit.getData();
            orgUnits = list.toArray();
        } else {
            orgUnits = (Object[])this.promtOrgUnit.getData();
        }
        int size = orgUnits.length;
        for (int i = 0; i < size; ++i) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)orgUnits[i];
            boolean isUnion = orgUnit.isIsUnion();
            String orgId = orgUnit.getId().toString();
            String orgNumber = orgUnit.getNumber();
            if (isUnion) {
                orgIds.add(orgId);
                orgNumbers.add(orgNumber);
                continue;
            }
            companyIds.add(orgId);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeEntrys();
    }

    private void storeEntrys() {
        this.editData.setSyncOldValue(true);
        AnalyzeTypeEnum analyzeType = (AnalyzeTypeEnum)((Object)this.cmbAnalyzeType.getSelectedItem());
        this.storeOrgUnitEntrys();
        this.storeDataElementData();
        this.storeCurrencyData();
        this.storeDataTypeData();
        if (analyzeType.getValue() == 0) {
            this.storeRptItemEntrys();
            this.storeAdjustStatusData();
        } else if (analyzeType.getValue() == 1) {
            this.storeRptItemEntrys();
            this.storeAdjustStatusData();
            this.storeDynaItemData();
        } else {
            this.storeAnalyzeIndexData();
        }
        if (this.editData.getId() == null) {
            TemplateTypeInfo templateType = new TemplateTypeInfo();
            templateType.setId(BOSUuid.read((String)this.displayAnalyzeTypeId));
            this.editData.setDisplayAnalyzeType(templateType);
        }
        this.editData.setSyncOldValue(false);
    }

    private void storeDynaItemData() {
        this.editData.getDynaItem().clear();
        if (this.promtDynaItem.getData() != null) {
            DynaItemEntryInfo dynaItemEntry = null;
            ArrayList dynaItems = (ArrayList)this.promtDynaItem.getData();
            for (DynaItemInfo dynaItem : dynaItems) {
                dynaItemEntry = new DynaItemEntryInfo();
                dynaItemEntry.setDynaName(dynaItem.getDitemName());
                dynaItemEntry.setDynaNumber(dynaItem.getDitemNumber());
                this.editData.getDynaItem().add(dynaItemEntry);
            }
        }
    }

    private void storeAdjustStatusData() {
        if (this.promtAdjustStatus.getData() != null) {
            List adjusts = (List)this.promtAdjustStatus.getData();
            StringBuffer sb = new StringBuffer();
            for (AnalysisAdjustEnum adjust : adjusts) {
                sb.append(adjust.getValue()).append(",");
            }
            String adjustString = sb.toString();
            adjustString = adjustString.substring(0, adjustString.length() - 1);
            this.editData.setAdjustStatus(adjustString);
        } else {
            this.editData.setAdjustStatus(null);
        }
    }

    private void storeDataTypeData() {
        if (this.promtDataType.getData() != null) {
            List valueTypes = (List)this.promtDataType.getData();
            if (!valueTypes.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (ValueTypeEnum valueType : valueTypes) {
                    sb.append(valueType.getValue()).append(",");
                }
                String valueTypeString = sb.toString();
                valueTypeString = valueTypeString.substring(0, valueTypeString.length() - 1);
                this.editData.setDataType(valueTypeString);
            }
        } else {
            this.editData.setDataType(null);
        }
    }

    private void storeCurrencyData() {
        this.editData.getCurrency().clear();
        if (this.promtCurrency.getData() != null) {
            CurrencyEntryInfo currencyEntry = null;
            List currencyInfos = (List)this.promtCurrency.getData();
            for (CurrencyInfo currency : currencyInfos) {
                currencyEntry = new CurrencyEntryInfo();
                currencyEntry.setCurrency(currency);
                this.editData.getCurrency().add(currencyEntry);
            }
        }
    }

    private void storeDataElementData() {
        this.editData.getDataElement().clear();
        if (this.promtDataElement.getData() != null) {
            DataElementEntryInfo dataElementEntry = null;
            ArrayList dataElements = (ArrayList)this.promtDataElement.getData();
            for (DataElementInfo dataElement : dataElements) {
                dataElementEntry = new DataElementEntryInfo();
                dataElementEntry.setDataElement(dataElement);
                this.editData.getDataElement().add(dataElementEntry);
            }
        }
    }

    private void storeAnalyzeIndexData() {
        this.editData.getAnalyzeIndex().clear();
        if (this.promtAnalyzeIndex.getData() != null) {
            IndexEntryInfo IndexEntry2 = null;
            ArrayList indexes = (ArrayList)this.promtAnalyzeIndex.getData();
            for (AnalyzeIndexInfo index : indexes) {
                IndexEntry2 = new IndexEntryInfo();
                IndexEntry2.setAnalyzeIndex(index);
                this.editData.getAnalyzeIndex().add(IndexEntry2);
            }
        }
    }

    private void storeRptItemEntrys() {
        this.editData.getRptItem().clear();
        if (this.promtRptItem.getData() != null) {
            ItemEntryInfo itemEntryInfo = null;
            ArrayList items = (ArrayList)this.promtRptItem.getData();
            for (RPTItemInfo rptItem : items) {
                itemEntryInfo = new ItemEntryInfo();
                itemEntryInfo.setRptItem(rptItem);
                this.editData.getRptItem().add(itemEntryInfo);
            }
        }
    }

    private void storeOrgUnitEntrys() {
        this.editData.getOrgUnit().clear();
        if (this.promtOrgUnit.getData() != null) {
            OrgUnitEntryInfo orgUnitEntry = null;
            List orgs = (List)this.promtOrgUnit.getData();
            FullOrgUnitInfo orgUnitInfo = null;
            this.editData.getOrgUnit().clear();
            for (int i = 0; i < orgs.size(); ++i) {
                Object org = orgs.get(i);
                orgUnitInfo = new FullOrgUnitInfo();
                if (org instanceof CompanyOrgUnitInfo) {
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)org;
                    orgUnitInfo.setId(company.getId());
                } else if (org instanceof FullOrgUnitInfo) {
                    FullOrgUnitInfo fullOrgUnit = (FullOrgUnitInfo)org;
                    orgUnitInfo.setId(fullOrgUnit.getId());
                }
                orgUnitEntry = new OrgUnitEntryInfo();
                orgUnitEntry.setOrgUnit(orgUnitInfo);
                this.editData.getOrgUnit().add(orgUnitEntry);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception ex) {
            if (ex instanceof SQLAccessException) {
                if (ex.getMessage().indexOf("FNUMBER") > 0) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"89_numberIsTooLong"));
                    SysUtil.abort();
                } else {
                    this.handleException(ex);
                }
            }
            this.handleException(ex);
        }
        if (!this.isError) {
            this.reInit();
            this.setOprtState(OprtState.ADDNEW);
            this.txtNumber.setText(null);
            this.txtName.setSelectedItem(null);
            this.txtDescription.setSelectedItem(null);
            this.cmbPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            this.combDateRange.setSelectedIndex(0);
            if (this.cmbOrgTree.getItemCount() > 0) {
                this.cmbOrgTree.setSelectedIndex(0);
            }
            this.editData.setIsWeave(this.chkWeave.isSelected());
            this.editData.setIsAudit(this.chkAudit.isSelected());
            this.editData.setIsCommit(this.chkCommit.isSelected());
            this.editData.setIsReceive(this.chkComfirm.isSelected());
            this.editData.setIsSingle(this.rdbSingle.isSelected());
            this.editData.setIsCombine(this.rdbCombo.isSelected());
            this.editData.setIsSum(this.rdbSum.isSelected());
            this.editData.setIsOnlyCompany(this.chkOnlyCompany.isSelected());
            this.cmbAnalyzeType.setSelectedIndex(0);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        AnalyzeTypeEnum analyzeType;
        boolean isExist;
        String number;
        this.isError = false;
        if (this.otc == null || this.otc != null && this.otc.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"91_orgTreeIsNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(number = this.txtNumber.getText()))) {
            this.isError = true;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"20_numberIsNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtName.getSelectedItem().toString())) {
            this.isError = true;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"21_nameIsNull"));
            SysUtil.abort();
        }
        if (number.length() > 80) {
            this.isError = true;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"89_numberIsTooLong"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        if (isExist = RptQingAnalyzeFactory.getRemoteInstance().exists(filter)) {
            this.isError = true;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"22_numberDup"));
            SysUtil.abort();
        }
        if (this.promtCurrency.getData() == null) {
            this.isError = true;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"36_currencyIsNull"));
            SysUtil.abort();
        }
        if ((analyzeType = (AnalyzeTypeEnum)((Object)this.cmbAnalyzeType.getSelectedItem())).getValue() == 2) {
            if (this.promtAnalyzeIndex.getData() == null) {
                this.isError = true;
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"37_analyzeIndexIsNull"));
                SysUtil.abort();
            }
        } else {
            if (this.promtDataElement.getData() == null) {
                this.isError = true;
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"35_dataElementIsNull"));
                SysUtil.abort();
            }
            if (this.promtAdjustStatus.getData() == null) {
                this.isError = true;
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"38_adjustStatusIsNull"));
                SysUtil.abort();
            }
            if (this.promtDataType.getData() == null) {
                this.isError = true;
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"39_dataTypeIsNull"));
                SysUtil.abort();
            }
        }
        if (!(this.chkWeave.isSelected() || this.chkAudit.isSelected() || this.chkCommit.isSelected() || this.chkComfirm.isSelected())) {
            this.isError = true;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"40_rptStatusIsNull"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        return new RptQingAnalyzeInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptQingAnalyzeFactory.getRemoteInstance();
    }

    public boolean isModify() {
        return this.checkModify();
    }

    private boolean checkModify() {
        this.storeFields();
        if ("ADDNEW".equals(this.getOprtState())) {
            return this.checkAddNewModify();
        }
        if ("VIEW".equals(this.getOprtState())) {
            return false;
        }
        return this.checkEditModify();
    }

    private boolean checkEditModify() {
        DataElementEntryCollection oldDataElementEntry;
        String id;
        CoreBaseInfo newEntry;
        Iterator newIt;
        CoreBaseInfo oldEntry;
        Iterator oldIt;
        String number = this.editData.getNumber();
        String name = this.editData.getName();
        String description = this.editData.getDescription();
        OrgTreeInfo tree = this.editData.getOrgTree();
        RptPeriodTypeEnum periodType = this.editData.getPeriodType();
        DateRangeEnum dateRange = this.editData.getDateRange();
        DateShiftEnum dateShift = this.editData.getDateShift();
        BaseDateEnum basedata = this.editData.getBaseDate();
        Timestamp specifyDate = this.editData.getSpecifyDate();
        int toBefore = this.editData.getToBefore();
        int toAfter = this.editData.getToAfter();
        AnalyzeTypeEnum analyzeType = this.editData.getAnalyzeType();
        OrgUnitEntryCollection orgUnitEntry = this.editData.getOrgUnit();
        ItemEntryCollection itemEntry = this.editData.getRptItem();
        DataElementEntryCollection dataElementEntry = this.editData.getDataElement();
        CurrencyEntryCollection currencyEntry = this.editData.getCurrency();
        IndexEntryCollection indexEntry = this.editData.getAnalyzeIndex();
        DynaItemSourceEnum dItemSource = this.editData.getDItemSource();
        AsstActTypeInfo asstActType = this.editData.getAsstActType();
        DynaItemEntryCollection dynaItemEntry = this.editData.getDynaItem();
        String dataType = this.editData.getDataType();
        String adjustStatus = this.editData.getAdjustStatus();
        boolean isWeave = this.editData.isIsWeave();
        boolean isAudit = this.editData.isIsAudit();
        boolean isCommit = this.editData.isIsCommit();
        boolean isReceive = this.editData.isIsReceive();
        boolean isSingle = this.editData.isIsSingle();
        boolean isCombine = this.editData.isIsCombine();
        boolean isSum = this.editData.isIsSum();
        boolean isOnlyCompany = this.editData.isIsOnlyCompany();
        if (number == null && this.rptQingAnalyze.getNumber() != null || number != null && this.rptQingAnalyze.getNumber() == null || number != null && this.rptQingAnalyze.getNumber() != null && !number.equals(this.rptQingAnalyze.getNumber())) {
            return true;
        }
        if (name == null && this.rptQingAnalyze.getName() != null || name != null && this.rptQingAnalyze.getName() == null || name != null && this.rptQingAnalyze.getName() != null && !name.equals(this.rptQingAnalyze.getName())) {
            return true;
        }
        if (description == null && this.rptQingAnalyze.getDescription() != null || description != null && this.rptQingAnalyze.getDescription() == null || description != null && this.rptQingAnalyze.getDescription() != null && !description.equals(this.rptQingAnalyze.getDescription())) {
            return true;
        }
        if (tree == null && this.rptQingAnalyze.getOrgTree() != null) {
            return true;
        }
        if (tree != null && tree.getId() == null && this.rptQingAnalyze.getOrgTree() != null) {
            return true;
        }
        if (tree != null && tree.getId() != null && this.rptQingAnalyze.getOrgTree() == null) {
            return true;
        }
        if (tree != null && tree.getId() != null && !tree.getId().equals((Object)this.rptQingAnalyze.getOrgTree().getId())) {
            return true;
        }
        if (periodType.getValue() != this.rptQingAnalyze.getPeriodType().getValue()) {
            return true;
        }
        if (dateRange.getValue() != this.rptQingAnalyze.getDateRange().getValue()) {
            return true;
        }
        if (dateShift.getValue() != this.rptQingAnalyze.getDateShift().getValue()) {
            return true;
        }
        if (basedata.getValue() != this.rptQingAnalyze.getBaseDate().getValue()) {
            return true;
        }
        if (this.rptQingAnalyze.getSpecifyDate() == null && this.editData.getSpecifyDate() != null || this.rptQingAnalyze.getSpecifyDate() != null && specifyDate.getTime() != this.rptQingAnalyze.getSpecifyDate().getTime()) {
            return true;
        }
        if (analyzeType.getValue() != this.rptQingAnalyze.getAnalyzeType().getValue()) {
            return true;
        }
        if (toBefore != this.rptQingAnalyze.getToBefore()) {
            return true;
        }
        if (toAfter != this.rptQingAnalyze.getToAfter()) {
            return true;
        }
        OrgUnitEntryCollection oldOrgUnitEntry = this.rptQingAnalyze.getOrgUnit();
        if (orgUnitEntry.size() != orgUnitEntry.size()) {
            return true;
        }
        ArrayList<String> oldOrgUnitIds = new ArrayList<String>();
        Iterator oldIt2 = oldOrgUnitEntry.iterator();
        while (oldIt2.hasNext()) {
            OrgUnitEntryInfo oldEntry2 = (OrgUnitEntryInfo)oldIt2.next();
            oldOrgUnitIds.add(oldEntry2.getOrgUnit().getId().toString());
        }
        Iterator newIt2 = orgUnitEntry.iterator();
        while (newIt2.hasNext()) {
            OrgUnitEntryInfo newEntry2 = (OrgUnitEntryInfo)newIt2.next();
            String orgId = newEntry2.getOrgUnit().getId().toString();
            if (oldOrgUnitIds.contains(orgId)) continue;
            return true;
        }
        ItemEntryCollection oldItemEntry = this.rptQingAnalyze.getRptItem();
        if (oldItemEntry.size() != itemEntry.size()) {
            return true;
        }
        ArrayList<String> oldRptItemIds = new ArrayList<String>();
        Iterator oldIt3 = oldItemEntry.iterator();
        while (oldIt3.hasNext()) {
            ItemEntryInfo oldEntry3 = (ItemEntryInfo)oldIt3.next();
            oldRptItemIds.add(oldEntry3.getRptItem().getId().toString());
        }
        Iterator newIt3 = itemEntry.iterator();
        while (newIt3.hasNext()) {
            ItemEntryInfo newEntry3 = (ItemEntryInfo)newIt3.next();
            String id2 = newEntry3.getRptItem().getId().toString();
            if (oldRptItemIds.contains(id2)) continue;
            return true;
        }
        if (analyzeType.getValue() == 2) {
            IndexEntryCollection oldIndexEntry = this.rptQingAnalyze.getAnalyzeIndex();
            if (oldIndexEntry.size() != indexEntry.size()) {
                return true;
            }
            ArrayList<String> oldIndexIds = new ArrayList<String>();
            oldIt = oldIndexEntry.iterator();
            while (oldIt.hasNext()) {
                oldEntry = (IndexEntryInfo)oldIt.next();
                oldIndexIds.add(oldEntry.getAnalyzeIndex().getId().toString());
            }
            newIt = indexEntry.iterator();
            while (newIt.hasNext()) {
                newEntry = (IndexEntryInfo)newIt.next();
                id = newEntry.getAnalyzeIndex().getId().toString();
                if (oldIndexIds.contains(id)) continue;
                return true;
            }
        }
        if ((oldDataElementEntry = this.rptQingAnalyze.getDataElement()).size() != dataElementEntry.size()) {
            return true;
        }
        ArrayList<String> oldDataElementIds = new ArrayList<String>();
        oldIt = oldDataElementEntry.iterator();
        while (oldIt.hasNext()) {
            oldEntry = (DataElementEntryInfo)oldIt.next();
            oldDataElementIds.add(oldEntry.getDataElement().getId().toString());
        }
        newIt = dataElementEntry.iterator();
        while (newIt.hasNext()) {
            newEntry = (DataElementEntryInfo)newIt.next();
            id = newEntry.getDataElement().getId().toString();
            if (oldDataElementIds.contains(id)) continue;
            return true;
        }
        CurrencyEntryCollection oldCurrencyEntry = this.rptQingAnalyze.getCurrency();
        if (oldCurrencyEntry.size() != currencyEntry.size()) {
            return true;
        }
        ArrayList<String> oldCurrencyIds = new ArrayList<String>();
        Iterator oldIt4 = oldCurrencyEntry.iterator();
        while (oldIt4.hasNext()) {
            CurrencyEntryInfo oldEntry4 = (CurrencyEntryInfo)oldIt4.next();
            oldCurrencyIds.add(oldEntry4.getCurrency().getId().toString());
        }
        Iterator newIt4 = currencyEntry.iterator();
        while (newIt4.hasNext()) {
            CurrencyEntryInfo newEntry4 = (CurrencyEntryInfo)newIt4.next();
            String id3 = newEntry4.getCurrency().getId().toString();
            if (oldCurrencyIds.contains(id3)) continue;
            return true;
        }
        if (dataType == null && this.rptQingAnalyze.getDataType() != null || dataType != null && this.rptQingAnalyze.getDataType() == null) {
            return true;
        }
        if (dataType != null && this.rptQingAnalyze.getDataType() != null && !dataType.equals(this.rptQingAnalyze.getDataType())) {
            return true;
        }
        if (analyzeType.getValue() == 1 || analyzeType.getValue() == 0) {
            if (adjustStatus == null && this.rptQingAnalyze.getAdjustStatus() != null || adjustStatus != null && this.rptQingAnalyze.getAdjustStatus() == null) {
                return true;
            }
            if (adjustStatus != null && this.rptQingAnalyze.getAdjustStatus() != null && !adjustStatus.equals(this.rptQingAnalyze.getAdjustStatus())) {
                return true;
            }
        }
        if (isWeave != this.rptQingAnalyze.isIsWeave() || isAudit != this.rptQingAnalyze.isIsAudit() || isCommit != this.rptQingAnalyze.isIsCommit() || isReceive != this.rptQingAnalyze.isIsReceive()) {
            return true;
        }
        if (isSingle != this.rptQingAnalyze.isIsSingle() || isCombine != this.rptQingAnalyze.isIsCombine() || isSum != this.rptQingAnalyze.isIsSum()) {
            return true;
        }
        if (isOnlyCompany != this.rptQingAnalyze.isIsOnlyCompany()) {
            return true;
        }
        if (analyzeType.getValue() == 1) {
            if (dItemSource.getValue() != this.rptQingAnalyze.getDItemSource().getValue()) {
                return true;
            }
            if (asstActType == null && this.rptQingAnalyze.getAsstActType() != null || asstActType != null && this.rptQingAnalyze.getAsstActType() == null) {
                return true;
            }
            if (asstActType != null && this.rptQingAnalyze.getAsstActType() != null && !asstActType.getId().equals((Object)this.rptQingAnalyze.getAsstActType().getId())) {
                return true;
            }
            DynaItemEntryCollection oldDynaItemEntry = this.rptQingAnalyze.getDynaItem();
            if (oldDynaItemEntry.size() != dynaItemEntry.size()) {
                return true;
            }
            ArrayList<String> oldDynaItemNums = new ArrayList<String>();
            Iterator oldIt5 = oldDynaItemEntry.iterator();
            while (oldIt5.hasNext()) {
                DynaItemEntryInfo oldEntry5 = (DynaItemEntryInfo)oldIt5.next();
                oldDynaItemNums.add(oldEntry5.getDynaNumber());
            }
            Iterator newIt5 = dynaItemEntry.iterator();
            while (newIt5.hasNext()) {
                DynaItemEntryInfo newEntry5 = (DynaItemEntryInfo)newIt5.next();
                String dynaNumber = newEntry5.getDynaNumber();
                if (oldDynaItemNums.contains(dynaNumber)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAddNewModify() {
        String number = this.editData.getNumber();
        String name = this.editData.getName();
        String description = this.editData.getDescription();
        if (number == null && (name != null || description != null)) {
            String des;
            String newName = (String)this.txtName.getSelectedItemData();
            if (newName == null) {
                name = null;
            }
            if ((des = (String)this.txtDescription.getSelectedItemData()) == null) {
                description = null;
            }
        }
        OrgTreeInfo tree = this.editData.getOrgTree();
        RptPeriodTypeEnum periodType = this.editData.getPeriodType();
        DateRangeEnum dateRange = this.editData.getDateRange();
        DateShiftEnum dateShift = this.editData.getDateShift();
        BaseDateEnum basedata = this.editData.getBaseDate();
        Timestamp specifyDate = this.editData.getSpecifyDate();
        int toBefore = this.editData.getToBefore();
        int toAfter = this.editData.getToAfter();
        AnalyzeTypeEnum analyzeType = this.editData.getAnalyzeType();
        OrgUnitEntryCollection orgUnitEntry = this.editData.getOrgUnit();
        ItemEntryCollection itemEntry = this.editData.getRptItem();
        DataElementEntryCollection dataElementEntry = this.editData.getDataElement();
        CurrencyEntryCollection currencyEntry = this.editData.getCurrency();
        String dataType = this.editData.getDataType();
        String adjustStatus = this.editData.getAdjustStatus();
        boolean isWeave = this.editData.isIsWeave();
        boolean isAudit = this.editData.isIsAudit();
        boolean isCommit = this.editData.isIsCommit();
        boolean isReceive = this.editData.isIsReceive();
        boolean isSingle = this.editData.isIsSingle();
        boolean isCombine = this.editData.isIsCombine();
        boolean isSum = this.editData.isIsSum();
        boolean isonlyCompany = this.editData.isIsOnlyCompany();
        if (!StringUtils.isEmpty((String)number) || !StringUtils.isEmpty((String)name) || !StringUtils.isEmpty((String)description) || tree != null && tree.getId() != null) {
            return true;
        }
        if (periodType.getValue() != 3) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int period = calendar.get(2) + 1;
        if (dateRange.getValue() != 0) {
            return true;
        }
        if (analyzeType.getValue() != 0) {
            return true;
        }
        if (!(orgUnitEntry.isEmpty() && itemEntry.isEmpty() && dataElementEntry.isEmpty())) {
            return true;
        }
        if (currencyEntry.size() > 1) {
            return true;
        }
        String currencyId = currencyEntry.get(0).getCurrency().getId().toString();
        String defCurrencyId = this.cui.getId().toString();
        if (!defCurrencyId.equals(currencyId)) {
            return true;
        }
        if (dataType.indexOf(",") > 0) {
            return true;
        }
        if (!dataType.equals(String.valueOf(1))) {
            return true;
        }
        if (adjustStatus.indexOf(",") > 0) {
            return true;
        }
        if (!adjustStatus.equals(String.valueOf(1))) {
            return true;
        }
        return isWeave || !isAudit || isCommit || isReceive || !isSingle || !isCombine || isSum || !isonlyCompany;
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (b && this.owner instanceof ListUI && !(this.owner instanceof TreeListUI)) {
            try {
                ((ListUI)this.owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkBeforeWindowClosing() {
        if (!this.isModify()) return true;
        String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
        if (result == 0) {
            if (this.isModifySave()) return true;
            this.actionSubmit.setDaemonRun(false);
            ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
            UtilRequest.setPrepare((boolean)false);
            this.btnSubmit.getAction().actionPerformed(event);
            if (this.actionSubmit.isInvokeFailed()) return false;
            if (this.isError) return false;
            return true;
        }
        if (result != 1) return false;
        return true;
    }

    @Override
    public void actionExplain_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"95_tips1")).append("<br> <br>");
        sb.append(EASResource.getString((String)RES, (String)"96_tips2")).append("<br> <br>");
        sb.append(EASResource.getString((String)RES, (String)"97_tips3")).append("<br> <br>");
        sb.append(EASResource.getString((String)RES, (String)"98_tips4")).append("<br> <br>");
        sb.append(EASResource.getString((String)RES, (String)"99_tips5")).append("<br> <br>");
        sb.append(EASResource.getString((String)RES, (String)"100_tips6")).append("<br> <br>");
        uiCtx.put((Object)"String", (Object)sb.toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        String uiTitle = EASResource.getString((String)RES, (String)"101_desTitle");
        ((ShowEditorPanelUI)uiWindow.getUIObject()).setUITitle(uiTitle);
        ((ShowEditorPanelUI)uiWindow.getUIObject()).getPrintButton().setVisible(false);
        ((ShowEditorPanelUI)uiWindow.getUIObject()).getOKButton().setVisible(false);
        uiWindow.show();
        super.repaint();
    }

    private class NullFilterInfoProducer
    implements IFilterInfoProducer {
        private NullFilterInfoProducer() {
        }

        public FilterInfo getFilterInfo() {
            return DynamicTemplateUtility.getDefaultFilterForAsstActType(null);
        }

        public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
        }

        public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
        }
    }

    private class CurrencyLabelProvider
    implements IChooserLabelProvider {
        private String[] header = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"47_FetchTypeLabelProvider"), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"40_EnumChooserLabelProvider")};

        private CurrencyLabelProvider() {
        }

        public String getColumnText(Object obj, int i) {
            CurrencyInfo info = (CurrencyInfo)obj;
            switch (i) {
                case 0: {
                    return info.getNumber();
                }
                case 1: {
                    return info.getName();
                }
            }
            return null;
        }

        public String[] getHeaderText() {
            return this.header;
        }
    }

    private class CurrencyProvider
    implements IChooserContentProvider {
        private List content = null;

        private CurrencyProvider() {
        }

        public int compare(Object obj1, Object obj2) {
            CurrencyInfo info1 = (CurrencyInfo)obj1;
            CurrencyInfo info2 = (CurrencyInfo)obj2;
            return info1.getId().equals((Object)info2.getId()) ? 0 : 1;
        }

        public boolean enableFilter() {
            return false;
        }

        public List getContents() throws Exception {
            CurrencyCollection col = CurrencyFactory.getRemoteInstance().getCurrencyCollection("where number != 'GLC' and number !='GRC')");
            if (this.content == null) {
                this.content = Arrays.asList(col.toArray());
            }
            return this.content;
        }

        public List getSelected() {
            return (List)RptQingAnalyzeEditUI.this.promtCurrency.getData();
        }

        public boolean matchFilter(Object item, int column, String filterString) {
            return false;
        }

        public void setContents(ArrayList content) {
            this.content = content;
        }

        public boolean enableTemplateFilter() {
            return false;
        }
    }
}

