/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeTypeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class RptQingAnalyzeFunctionLabel
extends KDLabel {
    private static final long serialVersionUID = 2757120822594414198L;
    private static final String RES = "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource";
    private RptQingAnalyzeInfo theme;
    private boolean isMousePressed;
    private Color inColor;
    private Color borderColor;
    private float borderWidth;

    public RptQingAnalyzeFunctionLabel(RptQingAnalyzeInfo theme) {
        this.theme = theme;
        this.initLabel();
    }

    public boolean isMousePressed() {
        return this.isMousePressed;
    }

    public void setMousePressed(boolean isMousePressed) {
        this.isMousePressed = isMousePressed;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Color getInColor() {
        return this.inColor;
    }

    public void setInColor(Color inColor) {
        this.inColor = inColor;
    }

    public RptQingAnalyzeInfo getTheme() {
        return this.theme;
    }

    public void setAutoToolTipText(boolean auto) {
        super.setAutoToolTipText(auto);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setLightWeightPopupEnabled(false);
        if (auto) {
            toolTipManager.registerComponent((JComponent)((Object)this));
        } else {
            toolTipManager.unregisterComponent((JComponent)((Object)this));
        }
    }

    private void initLabel() {
        this.setOpaque(false);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setText();
        this.setToolTips();
        this.setIcon();
    }

    private void setIcon() {
        AnalyzeTypeEnum analyzeType = this.theme.getAnalyzeType();
        if (analyzeType.getValue() == 0) {
            this.setIcon(EASResource.getIcon((String)"imgFunction_statements"));
        } else if (analyzeType.getValue() == 1) {
            this.setIcon(EASResource.getIcon((String)"imgFunction_bdQuery"));
        } else {
            this.setIcon(EASResource.getIcon((String)"imgFunction_calculate"));
        }
    }

    private void setToolTips() {
        String timeDesc;
        StringBuffer toolTips = new StringBuffer();
        String number = this.theme.getNumber();
        String name = this.theme.getName();
        toolTips.append("<html>").append("<body style = font-size:9px;>");
        toolTips.append(EASResource.getString((String)RES, (String)"24_number")).append(number).append("<br/>");
        toolTips.append(EASResource.getString((String)RES, (String)"25_name")).append(name);
        String description = this.theme.getDescription();
        if (description != null) {
            toolTips.append(" <br/> ").append(EASResource.getString((String)RES, (String)"26_description")).append(description);
        }
        String creator = this.theme.getCreator().getName();
        toolTips.append(" <br/> ").append(EASResource.getString((String)RES, (String)"85_creator")).append(creator);
        Timestamp calTime = this.theme.getLastCalculateTime();
        if (calTime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String calTimeString = dateFormat.format(new Date(calTime.getTime()));
            toolTips.append(" <br/> ").append(EASResource.getString((String)RES, (String)"27_calTime")).append(calTimeString);
        }
        if ((timeDesc = this.theme.getTimeDescription()) != null) {
            toolTips.append(" <br/> ").append(EASResource.getString((String)RES, (String)"145_dispatch")).append(timeDesc);
        }
        toolTips.append(" </body>").append(" </html>");
        this.setToolTipText(toolTips.toString());
    }

    private void setText() {
        StringBuffer title = new StringBuffer();
        String number = this.theme.getNumber();
        String name = this.theme.getName();
        title.append(number).append("(").append(name).append(")");
        this.setText(title.toString());
    }

    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.inColor != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.inColor);
            g2d.fillRoundRect(0, 0, w - 1, h - 1, 15, 15);
            g2d.setColor(this.borderColor);
            g2d.setStroke(new BasicStroke(this.borderWidth));
            g2d.drawRoundRect(0, 0, w - 1, h - 1, 15, 15);
        }
        super.paintComponent(g);
    }
}

