/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeRelaFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.RptQingAnalyzeCommonExplorer;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.RptQingAnalyzeFunctionLabel;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptQingAnalyzeFunctionPanel
extends KDPanel {
    private static final long serialVersionUID = -1845152630111681297L;
    private static final Logger logger = CoreUIObject.getLogger(RptQingAnalyzeFunctionPanel.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource";
    private static final int BUTTON_WIDHT = 110;
    private static final int BUTTON_HEIGHT = 110;
    private boolean isMousePressed;
    private ListUI ui;
    private RptQingAnalyzeFunctionLabel currentLabel;
    private List<RptQingAnalyzeInfo> themeList;

    public RptQingAnalyzeFunctionPanel() {
        this.setLayout(new FlowLayout(0));
        this.themeList = new ArrayList<RptQingAnalyzeInfo>();
    }

    public void load() {
        this.currentLabel = null;
        this.addFunctionLabel();
    }

    public void addFunctionLabel() {
        if (this.themeList != null && !this.themeList.isEmpty()) {
            for (RptQingAnalyzeInfo theme : this.themeList) {
                RptQingAnalyzeFunctionLabel label = new RptQingAnalyzeFunctionLabel(theme);
                label.setPreferredSize(new Dimension(110, 110));
                this.addListenerForFunctionLabel(label);
                this.add((Component)((Object)label));
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void addListenerForFunctionLabel(RptQingAnalyzeFunctionLabel label) {
        label.addMouseListener(new functionLabelMouseListener());
    }

    public ListUI getUi() {
        return this.ui;
    }

    public void setUi(ListUI ui) {
        this.ui = ui;
    }

    public RptQingAnalyzeFunctionLabel getCurrentLabel() {
        return this.currentLabel;
    }

    public void setCurrentLabel(RptQingAnalyzeFunctionLabel currentLabel) {
        this.currentLabel = currentLabel;
    }

    public List<RptQingAnalyzeInfo> getThemeList() {
        return this.themeList;
    }

    public void setThemeList(List<RptQingAnalyzeInfo> themeList) {
        this.themeList = themeList;
    }

    private void analyze(RptQingAnalyzeInfo themeInfo) throws Exception {
        UIContext uiContext = new UIContext((Object)new RptQingAnalyzeCommonExplorer());
        uiContext.put((Object)"rptQingAnalyzeInfo", (Object)themeInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptQingAnalyzeCommonExplorer.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    private void singleClicked(MouseEvent e) {
        RptQingAnalyzeFunctionLabel thisLabel = (RptQingAnalyzeFunctionLabel)((Object)e.getSource());
        thisLabel.requestFocus();
    }

    public void exited(MouseEvent e) {
        RptQingAnalyzeFunctionLabel label = (RptQingAnalyzeFunctionLabel)((Object)e.getSource());
        if (!label.isMousePressed()) {
            label.setInColor(null);
            label.repaint();
        }
    }

    private void pressed(MouseEvent e) {
        RptQingAnalyzeFunctionLabel label = (RptQingAnalyzeFunctionLabel)((Object)e.getSource());
        this.setCurrentLabelCustomerStatus();
        this.isMousePressed = true;
        this.currentLabel = label;
        this.setStatusByMouseSelected(label);
        label.repaint();
    }

    public void entered(MouseEvent e) {
        RptQingAnalyzeFunctionLabel label = (RptQingAnalyzeFunctionLabel)((Object)e.getSource());
        this.setStatusByMouseEntered(label);
        label.repaint();
    }

    private void setStatusByMouseEntered(RptQingAnalyzeFunctionLabel label) {
        label.setInColor(Color.decode("#F7F7F7"));
        label.setBorderColor(Color.decode("#C8C8C8"));
        label.setBorderWidth(1.0f);
    }

    private void setCurrentLabelCustomerStatus() {
        if (this.currentLabel != null) {
            this.setCustomStatus(this.currentLabel);
            this.currentLabel.repaint();
            this.isMousePressed = false;
            this.currentLabel = null;
        }
    }

    private void setCustomStatus(RptQingAnalyzeFunctionLabel label) {
        label.setInColor(null);
        label.setBorderColor(null);
        label.setMousePressed(false);
    }

    private void setStatusByMouseSelected(RptQingAnalyzeFunctionLabel label) {
        label.setMousePressed(true);
        label.setInColor(Color.decode("#FFFDEF"));
        label.setBorderColor(Color.decode("#C8C8C8"));
    }

    class functionLabelMouseListener
    extends MouseAdapter {
        functionLabelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 1) {
                    RptQingAnalyzeFunctionPanel.this.singleClicked(e);
                }
                if (e.getClickCount() == 2) {
                    RptQingAnalyzeInfo themeInfo = RptQingAnalyzeFunctionPanel.this.currentLabel.getTheme();
                    String analyzeId = themeInfo.getId().toString();
                    try {
                        boolean isNeedCal;
                        boolean isCal = RptQingAnalyzeRelaFactory.getRemoteInstance().exists("where analyzeId = '" + analyzeId + "' and IsLock = 1");
                        if (isCal) {
                            MsgBox.showError((String)EASResource.getString((String)RptQingAnalyzeFunctionPanel.RES, (String)"60_IsCal"));
                            SysUtil.abort();
                        }
                        if (isNeedCal = RptQingAnalyzeFactory.getRemoteInstance().exists("where id = '" + analyzeId + "' and lastCalculateTime is null")) {
                            MsgBox.showError((String)EASResource.getString((String)RptQingAnalyzeFunctionPanel.RES, (String)"61_calFirst"));
                            SysUtil.abort();
                        }
                        boolean dataIsNull1 = RptQingAnalyzeRelaFactory.getRemoteInstance().exists("where analyzeId = '" + analyzeId + "'");
                        boolean dataIsNull2 = RptQingAnalyzeFactory.getRemoteInstance().exists("where id = '" + analyzeId + "' and lastCalculateTime is not null");
                        if (!dataIsNull1 && dataIsNull2) {
                            MsgBox.showError((String)EASResource.getString((String)RptQingAnalyzeFunctionPanel.RES, (String)"62_dataIsNull"));
                            SysUtil.abort();
                        }
                        RptQingAnalyzeFunctionPanel.this.analyze(themeInfo);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"analyze: ", (Throwable)e1);
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RptQingAnalyzeFunctionPanel.this.exited(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RptQingAnalyzeFunctionPanel.this.entered(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            RptQingAnalyzeFunctionPanel.this.pressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            RptQingAnalyzeFunctionPanel.this.isMousePressed = false;
        }
    }
}

