/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.databind.JobProcessDefDataBindImp;
import com.kingdee.eas.fi.gr.weaverpt.client.listener.DispatchPeriodSettingActionListener;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeTypeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.client.AbstractThemeDispatchSettingUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ThemeDispatchSettingUI
extends AbstractThemeDispatchSettingUI {
    private static final long serialVersionUID = -8635573108996961357L;
    private static final Logger logger = CoreUIObject.getLogger(ThemeDispatchSettingUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource";
    private static final String ID = "id";
    private static final String SELECT = "select";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ANALYZETYPE = "analyzeType";
    private static final String DISPATCHTIME = "dispatchTime";
    private static final String SCHEDULINGSCHEME_BOSTYPE = "32F62716";
    private boolean isCtrlPress = false;
    private Set<String> analyzeIds;

    public void onLoad() throws Exception {
        super.onLoad();
        this.analyzeIds = (Set)this.getUIContext().get("analyzeIds");
        this.initAnalyzeType();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(SELECT).getStyleAttributes().setLocked(false);
        this.refresh(this.analyzeIds, null, null, 0, false);
        this.initTableEvent();
        this.initTxtLocation();
        this.initButtonEvent();
    }

    private void initButtonEvent() {
        this.btnSetTimeDispatch.addActionListener((ActionListener)new DispatchPeriodSettingActionListener((Object)this, this.txtTimeDesc, logger));
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtFilter.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtFilter);
        this.txtFilter.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initTableEvent() {
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    ThemeDispatchSettingUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (ThemeDispatchSettingUI.this.isCtrlPress) {
                    ThemeDispatchSettingUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1 && ThemeDispatchSettingUI.this.isCtrlPress) {
                    IRow row = ThemeDispatchSettingUI.this.tblMain.getRow(e.getRowIndex());
                    boolean isSelect = (Boolean)row.getCell(ThemeDispatchSettingUI.SELECT).getValue();
                    row.getCell(ThemeDispatchSettingUI.SELECT).setValue((Object)(!isSelect ? 1 : 0));
                    ThemeDispatchSettingUI.this.tblMain.checkParsed();
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock = e.getSelectBlock();
                if (selectBlock != null) {
                    ICell cell;
                    int selectIndex = ThemeDispatchSettingUI.this.tblMain.getColumnIndex(ThemeDispatchSettingUI.SELECT);
                    Object cellObj = null;
                    if (selectBlock.getBottom() - selectBlock.getTop() > 0) {
                        for (int i = selectBlock.getTop(); i <= selectBlock.getBottom(); ++i) {
                            if (ThemeDispatchSettingUI.this.tblMain.getRow(i).getStyleAttributes().isHided() || !((cellObj = ThemeDispatchSettingUI.this.tblMain.getCell(i, selectIndex).getValue()) instanceof Boolean)) continue;
                            ThemeDispatchSettingUI.this.tblMain.getCell(i, selectIndex).setValue((Object)((Boolean)cellObj == false ? 1 : 0));
                        }
                    } else if (selectBlock.getBottom() - selectBlock.getTop() == 0 && selectBlock.getBeginCol() == selectBlock.getEndCol() && selectBlock.getBeginCol() == selectIndex && !ThemeDispatchSettingUI.this.tblMain.getRow(selectBlock.getBottom()).getStyleAttributes().isHided() && (cell = ThemeDispatchSettingUI.this.tblMain.getCell(selectBlock.getBottom(), selectBlock.getBeginCol())).getValue() instanceof Boolean) {
                        cell.setValue((Object)(cell.getValue() != null ? false : (Boolean)cell.getValue() == false));
                    }
                }
            }
        });
    }

    private void refresh(Set<String> themeIds, FilterInfo filter, StringBuffer mask, int index, boolean isSelect) throws BOSException {
        this.tblMain.removeRows();
        RptQingAnalyzeCollection analyzeThemes = this.getAnalyzeThemes(themeIds, filter, mask, index);
        this.init(analyzeThemes, isSelect);
    }

    private RptQingAnalyzeCollection getAnalyzeThemes(Set<String> themeIds, FilterInfo filter, StringBuffer mask, int index) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(ID, themeIds, CompareType.INCLUDE));
        if (mask != null) {
            mask.append(" and #").append(index++);
            filter.setMaskString(mask.toString());
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo(ID));
        selector.add(new SelectorItemInfo(NUMBER));
        selector.add(new SelectorItemInfo(NAME));
        selector.add(new SelectorItemInfo(ANALYZETYPE));
        selector.add(new SelectorItemInfo("timeDescription"));
        view.setSelector(selector);
        view.getSorter().add(new SorterItemInfo(ANALYZETYPE));
        view.getSorter().add(new SorterItemInfo(NUMBER));
        view.getSorter().add(new SorterItemInfo("timeDescription"));
        RptQingAnalyzeCollection analyzeThemes = RptQingAnalyzeFactory.getRemoteInstance().getRptQingAnalyzeCollection(view);
        return analyzeThemes;
    }

    private void init(RptQingAnalyzeCollection analyzeThemes, boolean isSelect) throws BOSException {
        if (analyzeThemes != null && !analyzeThemes.isEmpty()) {
            Iterator it = analyzeThemes.iterator();
            while (it.hasNext()) {
                RptQingAnalyzeInfo analyzeTheme = (RptQingAnalyzeInfo)it.next();
                this.initTable(analyzeTheme, isSelect);
            }
        }
    }

    private void initTable(RptQingAnalyzeInfo analyzeTheme, boolean isSelect) {
        String id = analyzeTheme.getId().toString();
        String number = analyzeTheme.getNumber();
        String name = analyzeTheme.getName();
        AnalyzeTypeEnum analyzeTypeEnum = analyzeTheme.getAnalyzeType();
        String timeDesc = analyzeTheme.getTimeDescription();
        IRow row = this.tblMain.addRow();
        row.getCell(SELECT).setValue((Object)isSelect);
        row.getCell(ID).setValue((Object)id);
        row.getCell(NUMBER).setValue((Object)number);
        row.getCell(NAME).setValue((Object)name);
        row.getCell(ANALYZETYPE).setValue((Object)analyzeTypeEnum);
        row.getCell(DISPATCHTIME).setValue((Object)timeDesc);
    }

    private void initAnalyzeType() {
        String all = EASResource.getString((String)RES, (String)"90_all");
        this.combFilter.addItem((Object)all);
        this.combFilter.addItems(AnalyzeTypeEnum.getEnumList().toArray());
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        int index = this.combFilter.getSelectedIndex();
        FilterInfo filter = new FilterInfo();
        String filterString = this.txtFilter.getText();
        StringBuffer strMask = new StringBuffer();
        int iIndex = 0;
        if (defaultStr.equals(filterString)) {
            if (index == 0) {
                this.refresh(this.analyzeIds, null, null, 0, false);
            } else {
                switch (index) {
                    case 1: {
                        filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)0, CompareType.EQUALS));
                        strMask.append("#").append(iIndex++);
                        break;
                    }
                    case 2: {
                        filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)1, CompareType.EQUALS));
                        strMask.append("#").append(iIndex++);
                        break;
                    }
                    case 3: {
                        filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)2, CompareType.EQUALS));
                        strMask.append("#").append(iIndex++);
                    }
                }
                this.refresh(this.analyzeIds, filter, strMask, iIndex, false);
            }
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo(NUMBER, (Object)("%" + filterString + "%"), CompareType.LIKE));
        strMask.append(" (#").append(iIndex++);
        filter.getFilterItems().add(new FilterItemInfo(NAME, (Object)("%" + filterString + "%"), CompareType.LIKE));
        strMask.append(" or #").append(iIndex++).append(")");
        switch (index) {
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)0, CompareType.EQUALS));
                strMask.append("And #").append(iIndex++);
                break;
            }
            case 2: {
                filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)1, CompareType.EQUALS));
                strMask.append("And #").append(iIndex++);
                break;
            }
            case 3: {
                filter.getFilterItems().add(new FilterItemInfo(ANALYZETYPE, (Object)2, CompareType.EQUALS));
                strMask.append("And #").append(iIndex++);
            }
        }
        this.refresh(this.analyzeIds, filter, strMask, iIndex, false);
    }

    @Override
    public void actionAllSelect_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrClear(this.tblMain, true);
    }

    @Override
    public void actionAllClear_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrClear(this.tblMain, false);
    }

    private void selectOrClear(KDTable tbl, boolean isSelect) {
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            ICell cell = tbl.getRow(i).getCell(SELECT);
            if (cell.getValue() == null) continue;
            cell.setValue((Object)isSelect);
        }
    }

    @Override
    public void actionRemoveDispatch_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        String msg = this.getSelectedThemeIdsForRemoveSceduling(ids);
        if (ids != null && !ids.isEmpty()) {
            Set<String> schmIds = this.getSchedulingSchemeIds(ids);
            this.delSchemeEntry(ids);
            this.delSchedulingSchemeWhichEntriesIsNull(schmIds);
            this.updateTimeDescription(ids, null);
            if (msg != null && msg.length() > 0) {
                String title = EASResource.getString((String)RES, (String)"142_removeSchemeTitle");
                StringBuffer detail = new StringBuffer();
                String detailTitle = EASResource.getString((String)RES, (String)"143_removeSchemeDetail");
                detail.append(detailTitle).append(" \n ").append(msg);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)detail.toString(), (int)0);
            } else {
                String success = EASResource.getString((String)RES, (String)"144_removeSchemeSucess");
                MsgBox.showInfo((Component)((Object)this), (String)success);
            }
            this.refresh(this.analyzeIds, null, null, 0, false);
        } else {
            msg = msg != null && msg.length() > 0 ? EASResource.getString((String)RES, (String)"146_removeDispatchFail") : EASResource.getString((String)RES, (String)"140_selectThemeFirst");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ScheduleDef schedule = (ScheduleDef)this.txtTimeDesc.getUserObject();
        if (schedule != null) {
            ArrayList<String> ids = new ArrayList<String>();
            this.getSelectedThemeIds(ids);
            if (ids != null && !ids.isEmpty()) {
                this.insertToSchedulingScheme(ids);
                this.destroyWindow();
            } else {
                String msg = EASResource.getString((String)RES, (String)"140_selectThemeFirst");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
            }
        } else {
            String msg = EASResource.getString((String)RES, (String)"139_setDispatchFirst");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
        }
    }

    private void insertToSchedulingScheme(List<String> ids) throws EASBizException, BOSException {
        String timeDesc = this.txtTimeDesc.getText();
        if (SchedulingSchemeFactory.getRemoteInstance().exists("select id where timeDescription = '" + timeDesc + "'")) {
            SchedulingSchemeInfo schedulingSchemeInfo = SchedulingSchemeFactory.getRemoteInstance().getSchedulingSchemeInfo("select id,entries.analyzeId where timeDescription = '" + timeDesc + "'");
            SchedulingSchemeEntryCollection entries = schedulingSchemeInfo.getEntries();
            ArrayList<String> idList = new ArrayList<String>();
            if (entries != null && !entries.isEmpty()) {
                Iterator it = entries.iterator();
                while (it.hasNext()) {
                    SchedulingSchemeEntryInfo entry = (SchedulingSchemeEntryInfo)it.next();
                    String analyzeId = entry.getAnalyzeId();
                    idList.add(analyzeId);
                }
                for (String analyzeId : idList) {
                    if (!ids.contains(analyzeId)) continue;
                    ids.remove(analyzeId);
                }
                if (ids != null && !ids.isEmpty()) {
                    Set<String> schmIds = this.getSchedulingSchemeIds(ids);
                    this.delSchedulingSchemeWhichEntriesIsNull(schmIds);
                    this.delSchemeEntry(ids);
                    this.addSchedulingSchemeEntries(ids, schedulingSchemeInfo);
                    this.updateTimeDescription(ids, timeDesc);
                }
            }
        } else {
            Set<String> schmIds = this.getSchedulingSchemeIds(ids);
            this.delSchedulingSchemeWhichEntriesIsNull(schmIds);
            this.delSchemeEntry(ids);
            this.addSchedulingScheme(ids);
            this.updateTimeDescription(ids, timeDesc);
        }
    }

    private void addSchedulingScheme(List<String> ids) throws EASBizException, BOSException {
        String schemeId = BOSUuid.create((String)SCHEDULINGSCHEME_BOSTYPE).toString();
        SchedulingSchemeInfo schm = new SchedulingSchemeInfo();
        schm.setNumber(this.getSchedulingSchemeNumber());
        schm.setId(BOSUuid.read((String)schemeId));
        this.setDataObject((IObjectValue)schm);
        JobProcessDefDataBindImp jobProcessDefDataBindImp = new JobProcessDefDataBindImp(this.txtTimeDesc, (IUIObject)this, "RptQingAnalyze", 0);
        String jobProcessDefID = jobProcessDefDataBindImp.getJobProcessDef();
        schm.setJobProcessDef(jobProcessDefID);
        schm.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date date = new Date();
        Timestamp time = new Timestamp(date.getTime());
        schm.setCreateTime(time);
        String timeDesc = this.txtTimeDesc.getText();
        schm.setTimeDescription(timeDesc);
        SchedulingSchemeFactory.getRemoteInstance().addnew(schm);
        CoreBaseCollection entries = new CoreBaseCollection();
        SchedulingSchemeEntryInfo entry = null;
        for (String id : ids) {
            entry = new SchedulingSchemeEntryInfo();
            entry.setAnalyzeId(id);
            entry.setSchedulingSchemeId(schm);
            entries.add((CoreBaseInfo)entry);
        }
        SchedulingSchemeEntryFactory.getRemoteInstance().addnew(entries);
    }

    private String getSchedulingSchemeNumber() {
        StringBuffer sb = new StringBuffer();
        Date date = new Date();
        sb.append("RptQingAnalyzeDispatch").append(date.getTime());
        return sb.toString();
    }

    private void delSchedulingSchemeWhichEntriesIsNull(Set<String> schmIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("schedulingSchemeId", schmIds, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("schedulingSchemeId"));
        SchedulingSchemeEntryCollection entries = SchedulingSchemeEntryFactory.getRemoteInstance().getSchedulingSchemeEntryCollection(view);
        if (entries != null && !entries.isEmpty()) {
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                SchedulingSchemeEntryInfo schm = (SchedulingSchemeEntryInfo)it.next();
                String schmId = schm.getSchedulingSchemeId().getId().toString();
                if (!schmIds.contains(schmId)) continue;
                schmIds.remove(schmId);
            }
            if (!schmIds.isEmpty()) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo(ID, schmIds, CompareType.INCLUDE));
                view.getSelector().add(new SelectorItemInfo("jobProcessDef"));
                SchedulingSchemeCollection schms = SchedulingSchemeFactory.getRemoteInstance().getSchedulingSchemeCollection(view);
                if (schms != null && !schms.isEmpty()) {
                    Iterator schmIt = schms.iterator();
                    while (schmIt.hasNext()) {
                        SchedulingSchemeInfo schm = (SchedulingSchemeInfo)schmIt.next();
                        String jobProcessDef = schm.getJobProcessDef();
                        if (StringUtils.isEmpty((String)jobProcessDef)) continue;
                        EnactmentServiceFactory.createRemoteEnactService().removeJobProcessDef(jobProcessDef);
                    }
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo(ID, schmIds, CompareType.INCLUDE));
                    SchedulingSchemeFactory.getRemoteInstance().delete(filter);
                }
            }
        } else if (schmIds != null && !schmIds.isEmpty()) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(ID, schmIds, CompareType.INCLUDE));
            SchedulingSchemeFactory.getRemoteInstance().delete(filter);
        }
    }

    private Set<String> getSchedulingSchemeIds(List<String> ids) throws BOSException {
        HashSet<String> schms = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("analyzeId", idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("schedulingSchemeId"));
        SchedulingSchemeEntryCollection entries = SchedulingSchemeEntryFactory.getRemoteInstance().getSchedulingSchemeEntryCollection(view);
        if (entries != null && !entries.isEmpty()) {
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                SchedulingSchemeEntryInfo entry = (SchedulingSchemeEntryInfo)it.next();
                String schemeId = entry.getSchedulingSchemeId().getId().toString();
                schms.add(schemeId);
            }
        }
        return schms;
    }

    private void addSchedulingSchemeEntries(List<String> ids, SchedulingSchemeInfo schedulingSchemeInfo) throws EASBizException, BOSException {
        CoreBaseCollection entries = new CoreBaseCollection();
        SchedulingSchemeEntryInfo entry = null;
        for (String id : ids) {
            entry = new SchedulingSchemeEntryInfo();
            entry.setAnalyzeId(id);
            entry.setSchedulingSchemeId(schedulingSchemeInfo);
            entries.add((CoreBaseInfo)entry);
        }
        SchedulingSchemeEntryFactory.getRemoteInstance().addnew(entries);
    }

    private void updateTimeDescription(List<String> ids, String timeDesc) throws EASBizException, BOSException {
        RptQingAnalyzeCollection colls = new RptQingAnalyzeCollection();
        RptQingAnalyzeInfo rptQingAnalyzeInfo = null;
        for (String id : ids) {
            rptQingAnalyzeInfo = new RptQingAnalyzeInfo();
            rptQingAnalyzeInfo.setId(BOSUuid.read((String)id));
            rptQingAnalyzeInfo.setTimeDescription(timeDesc);
            colls.add(rptQingAnalyzeInfo);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("timeDescription"));
        RptQingAnalyzeFactory.getRemoteInstance().updatePartialBatchData((IObjectCollection)colls, selector);
    }

    private void delSchemeEntry(List<String> ids) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("analyzeId", idSet, CompareType.INCLUDE));
        SchedulingSchemeEntryFactory.getRemoteInstance().delete(filter);
    }

    private String getSelectedThemeIdsForRemoveSceduling(List<String> ids) {
        StringBuffer msg = new StringBuffer();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isSel = (Boolean)row.getCell(SELECT).getValue();
            if (!isSel) continue;
            String id = (String)row.getCell(ID).getValue();
            String dispatchTime = (String)row.getCell(DISPATCHTIME).getValue();
            if (dispatchTime == null) {
                String number = (String)row.getCell(NUMBER).getValue();
                msg.append(number).append("\u3001");
                continue;
            }
            ids.add(id);
        }
        if (msg.length() > 0) {
            msg.deleteCharAt(msg.length() - 1);
        }
        return msg.toString();
    }

    private void getSelectedThemeIds(List<String> ids) {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isSel = (Boolean)row.getCell(SELECT).getValue();
            if (!isSel) continue;
            String id = (String)row.getCell(ID).getValue();
            ids.add(id);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        Object owner = this.getUIContext().get("Owner");
        if (b && owner instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return b;
    }
}

