/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.preparedata.handler.budget.IQingBudgetDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.ParentChildDimension;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingFieldType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFacadeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeRelaFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeRelaInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RptQingAnalyzeForCommonRpt
implements IQingBudgetDataProvider {
    private Context ctx = null;

    public RptQingAnalyzeForCommonRpt(Context ctx) {
        this.ctx = ctx;
    }

    public RptQingAnalyzeForCommonRpt() {
    }

    public QingMeta getMeta(String tag) throws EASBizException, BOSException {
        QingMeta qingMeta = new QingMeta();
        RptQingAnalyzeInfo theme = RptQingAnalyzeFactory.getRemoteInstance().getRptQingAnalyzeInfo((IObjectPK)new ObjectUuidPK(tag));
        List<Integer> adjusts = this.getAdjustStatus(theme);
        int analyzeType = theme.getAnalyzeType().getValue();
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field num = null;
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field pnum = null;
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field alias = null;
        qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FBizDate", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"102_bizDate"), QingFieldType.Date.toNumber(), null, null, false, null));
        qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FYear", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"77_year"), QingFieldType.String.toNumber(), null, null, false, null));
        qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FPeriod", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"78_period"), QingFieldType.String.toNumber(), null, null, false, null));
        qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FOrgUnitId", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"88_orgId"), QingFieldType.String.toNumber(), null, null, true, null));
        num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FOrgUnitNumber", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"46_orgNum"), QingFieldType.String.toNumber(), null, null, false, null);
        pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FOrgUnitParent", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"46_orgNum"), QingFieldType.String.toNumber(), null, null, true, null);
        alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FOrgUnitName", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"47_orgName"), QingFieldType.String.toNumber(), null, null, false, null);
        this.addColumn(qingMeta, num, pnum, alias, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"47_orgName"));
        num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FRptItemNumber", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"51_rptItemNum"), QingFieldType.String.toNumber(), null, null, false, null);
        pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FRptItemParent", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"51_rptItemNum"), QingFieldType.String.toNumber(), null, null, true, null);
        alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FRptItemName", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"52_rptItemName"), QingFieldType.String.toNumber(), null, null, false, null);
        this.addColumn(qingMeta, num, pnum, alias, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"52_rptItemName"));
        if (analyzeType == 1) {
            num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FDynaItemNumber", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"67_dynaItemNum"), QingFieldType.String.toNumber(), null, null, false, null);
            pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FDynaItemParent", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"68_dynaItemPNum"), QingFieldType.String.toNumber(), null, null, true, null);
            alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FDynaItemName", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"69_dynaItemName"), QingFieldType.String.toNumber(), null, null, false, null);
            this.addColumn(qingMeta, num, pnum, alias, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"69_dynaItemName"));
        }
        num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FDataElementNumber", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"53_deNumber"), QingFieldType.String.toNumber(), null, null, false, null);
        pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FDataElementParent", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"53_deNumber"), QingFieldType.String.toNumber(), null, null, true, null);
        alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FDataElementName", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"54_deName"), QingFieldType.String.toNumber(), null, null, false, null);
        this.addColumn(qingMeta, num, pnum, alias, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"54_deName"));
        num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FCurrencyNumber", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"48_curNum"), QingFieldType.String.toNumber(), null, null, false, null);
        pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FCurrencyParent", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"48_curNum"), QingFieldType.String.toNumber(), null, null, true, null);
        alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FCurrencyName", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"49_curName"), QingFieldType.String.toNumber(), null, null, false, null);
        this.addColumn(qingMeta, num, pnum, alias, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"49_curName"));
        qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FdataType", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"55_dataType"), QingFieldType.String.toNumber(), null, null, false, null));
        if (adjusts.contains(0)) {
            qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FBeforeAdjustValue", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"56_beforeAdjust"), QingFieldType.Number.toNumber(), null, null, false, null));
        }
        if (adjusts.contains(2)) {
            qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FAdjustValue", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"57_adjust"), QingFieldType.Number.toNumber(), null, null, false, null));
        }
        if (adjusts.contains(1)) {
            qingMeta.addColumn((Field)new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field("FAfterAdjustValue", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"58_afterAdjust"), QingFieldType.Number.toNumber(), null, null, false, null));
        }
        return qingMeta;
    }

    private void addColumn(QingMeta qingMeta, com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field num, com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field pnum, com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field alias, String name) {
        qingMeta.addColumn((Field)num);
        qingMeta.addColumn((Field)pnum);
        qingMeta.addColumn((Field)alias);
        ParentChildDimension pcDimension = new ParentChildDimension(num.getName(), name, (Field)num, (Field)pnum);
        pcDimension.setDefaultDisplayName((Field)alias);
        pcDimension.setSortAccording((Field)num);
        qingMeta.addParentChildDimension((com.kingdee.bos.qing.preparedata.handler.controller.model.ParentChildDimension)pcDimension);
    }

    public List<Integer> getAdjustStatus(RptQingAnalyzeInfo theme) {
        ArrayList<Integer> adjustStatuss = new ArrayList<Integer>();
        if (theme != null && theme.getAdjustStatus() != null) {
            String adjustStatusStr = theme.getAdjustStatus();
            String[] adjustStatusStrs = adjustStatusStr.split(",");
            int size = adjustStatusStrs.length;
            for (int i = 0; i < size; ++i) {
                int adjustStatus = Integer.valueOf(adjustStatusStrs[i]);
                adjustStatuss.add(adjustStatus);
            }
        }
        return adjustStatuss;
    }

    public List<String> getFiles(String tag) throws EASBizException, BOSException {
        if (this.isNeedCalBeforeAnalyze(tag)) {
            RptQingAnalyzeFacadeFactory.getLocalInstance(this.ctx).calculate(tag);
        }
        RptQingAnalyzeRelaInfo relaInfo = RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).getRptQingAnalyzeRelaInfo("select qingFileId where analyzeId = '" + tag + "'");
        String qingFileId = relaInfo.getQingFileId();
        ArrayList<String> qsFiles = new ArrayList<String>();
        qsFiles.add(qingFileId);
        return qsFiles;
    }

    private boolean isNeedCalBeforeAnalyze(String tag) throws EASBizException, BOSException {
        RptQingAnalyzeInfo analyzeInfo = RptQingAnalyzeFactory.getLocalInstance(this.ctx).getRptQingAnalyzeInfo("select lastCalculateTime where id= '" + tag + "'");
        Timestamp time = analyzeInfo.getLastCalculateTime();
        if (time == null) {
            return true;
        }
        Calendar calandar = Calendar.getInstance();
        calandar.setTimeInMillis(time.getTime());
        int calYear = calandar.get(1);
        int calPeriod = calandar.get(2) + 1;
        calandar = Calendar.getInstance();
        int year = calandar.get(1);
        int period = calandar.get(2) + 1;
        return calYear != year || calPeriod != period;
    }

    public Map<String, List<String>> getFilter(String tag) throws EASBizException, BOSException {
        return this.getOrgIds(tag);
    }

    private Map<String, List<String>> getOrgIds(String tag) throws BOSException {
        HashMap<String, List<String>> permOegIds = new HashMap<String, List<String>>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String userId = this.ctx.getCaller().toString();
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)userId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)10, CompareType.EQUALS));
        view.getSelector().add(new SelectorItemInfo("org"));
        OrgRangeCollection orgRanges = OrgRangeFactory.getLocalInstance((Context)this.ctx).getOrgRangeCollection(view);
        if (orgRanges != null && !orgRanges.isEmpty()) {
            Iterator it = orgRanges.iterator();
            ArrayList<String> orgIdList = new ArrayList<String>();
            while (it.hasNext()) {
                OrgRangeInfo orgRange = (OrgRangeInfo)it.next();
                String orgId = orgRange.getOrg().getId().toString();
                orgIdList.add(orgId);
            }
            permOegIds.put("FOrgUnitId", orgIdList);
        }
        return permOegIds;
    }
}

