/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes;

import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.AttachmentEncryptUtil;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataEntryInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.app.openApi.CslRptOpenApiFacadeFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.Command;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesIndexFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesIndexInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesTemplateFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesTemplateInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeCollection;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeItemCollection;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeItemInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesIndexValueTypeEnum;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesUnionDataTypeEnum;
import com.kingdee.eas.fi.newrpt.rptnotes.sortEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;

public class ReportNotesUtil {
    private static final Logger logger = CoreUIObject.getLogger(ReportNotesUtil.class);
    private static FileGetter fg = null;
    private static String totalStr = null;
    static String startStr = "{%";
    static String endStr = "%}";
    static String dyStartStr = "{#";
    static String dyEndStr = "#}";

    public static String readFileContent(File file) throws Exception {
        BufferedReader reader = null;
        StringBuffer sbf = new StringBuffer();
        try {
            String tempStr;
            reader = new BufferedReader(new FileReader(file));
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr);
            }
            reader.close();
            String content = sbf.toString().trim();
            if (!StringUtils.isEmpty((String)content)) {
                String string = content;
                return string;
            }
            String string = Command.none.toString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)"readFileContent error.", (Throwable)e);
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"readFileContent error.", (Throwable)ex);
                    throw ex;
                }
            }
        }
    }

    public static void removeFile(final String filePath) throws Exception {
        if (!StringUtils.isEmpty((String)filePath)) {
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        File file = new File(filePath);
                        while (file.exists()) {
                            if (ReportNotesUtil.isFileClose(filePath)) {
                                System.gc();
                                if (!file.delete()) {
                                    file.delete();
                                }
                            }
                            Thread.sleep(200L);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"removeFile error.", (Throwable)e);
                    }
                }
            };
            th.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileClose(String filePath) throws Exception {
        try (RandomAccessFile rdAccess = null;){
            rdAccess = new RandomAccessFile(filePath, "rw");
            FileChannel channel = rdAccess.getChannel();
            FileLock lock = channel.tryLock();
            if (lock != null) {
                lock.release();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static void wirteContentToFile(File file, String content) throws Exception {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file, false);
            fw.write(content);
            fw.close();
        }
        catch (Exception e) {
            logger.error((Object)"wirteContentToFile error.", (Throwable)e);
            throw e;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"wirteContentToFile error.", (Throwable)ex);
                    throw ex;
                }
            }
        }
    }

    public static void notifyVBA(File file, Command command) throws Exception {
        ReportNotesUtil.wirteContentToFile(file, command.toString());
    }

    public static Command getVBANotify(File file) throws Exception {
        String content;
        if (file.exists() && (content = ReportNotesUtil.readFileContent(file)) != null) {
            return Command.valueOf(content.trim());
        }
        return Command.none;
    }

    public static byte[] generateRptNotesWord(Context ctx, String tempWordPath, String rptNotesWordPath, ReportNotesInfo rptNotesInfo, byte[] wordContent) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            FullOrgUnitCollection coll;
            if (wordContent != null && wordContent.length > 0) {
                inputStream = new ByteArrayInputStream(wordContent);
                outputStream = new ByteArrayOutputStream();
            } else {
                inputStream = new FileInputStream(tempWordPath);
                outputStream = new FileOutputStream(rptNotesWordPath);
            }
            if (rptNotesInfo.getCompany().get("isUnion") == null && (coll = (ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx)).getFullOrgUnitCollection("select isUnion where id='" + rptNotesInfo.getCompany().getId().toString() + "'")) != null && coll.size() > 0) {
                rptNotesInfo.getCompany().setIsUnion(coll.get(0).isIsUnion());
            }
            XWPFDocument xwpfDocument = new XWPFDocument(inputStream);
            Set<String> formulasKeys = ReportNotesUtil.getTempWordFormulas(xwpfDocument);
            boolean isHasFormula = false;
            if (!formulasKeys.isEmpty()) {
                isHasFormula = true;
                HashMap<String, List<ReportNotesIndexInfo>> formulas = new HashMap<String, List<ReportNotesIndexInfo>>();
                ReportNotesUtil.initRptNotesIndexs(ctx, formulasKeys, formulas, false);
                if (!formulas.isEmpty()) {
                    Map<String, String> formulValues = ReportNotesUtil.calcFormuls(ctx, rptNotesInfo, formulas.keySet(), formulas);
                    ReportNotesUtil.setFormulaValuesToWord(xwpfDocument, formulValues);
                } else {
                    throw new Exception(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"48_indexNotExist"), formulasKeys.toString()));
                }
            }
            if (ReportNotesUtil.handleDySchemeForTable(ctx, xwpfDocument, rptNotesInfo)) {
                isHasFormula = true;
            }
            if (!isHasFormula) {
                throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"49_tmpNotIndex"));
            }
            if (wordContent != null && wordContent.length > 0) {
                xwpfDocument.write(outputStream);
                byte[] byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                return byArray;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"generateRptNotesWord error.", (Throwable)ex);
            throw ex;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    logger.error((Object)"outputStream error.", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    logger.error((Object)"outputStream error.", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void initRptNotesIndexs(Context ctx, Set<String> formulasKeys, Map<String, List<ReportNotesIndexInfo>> formulas, boolean isCheck) throws Exception {
        indexs = null;
        indexNames = null;
        if (!isCheck) {
            indexNames = new HashSet<String>();
            indexNames.addAll(formulasKeys);
        }
        if (ctx == null || formulasKeys.size() < 50) {
            if (DebugLogger.isDebug) {
                ReportNotesUtil.logger.error((Object)("formulasKeys:" + formulasKeys.toString()));
            }
            selectStr = isCheck != false ? "name" : "formulas,name,valueType";
            coll = (ctx == null ? ReportNotesIndexFactory.getRemoteInstance() : ReportNotesIndexFactory.getLocalInstance(ctx)).getReportNotesIndexCollection("select " + selectStr + " where name in(" + CslRptUtil.collection2String(formulasKeys, (String)",", (boolean)true) + ") ");
            for (i = 0; i < coll.size(); ++i) {
                if (isCheck) {
                    formulasKeys.remove(coll.get(i).getName());
                    continue;
                }
                indexNames.remove(coll.get(i).getName());
                indexs = formulas.get(coll.get(i).getFormulas());
                if (indexs == null) {
                    indexs = new ArrayList<ReportNotesIndexInfo>();
                    formulas.put(coll.get(i).getFormulas(), indexs);
                }
                indexs.add(coll.get(i));
            }
        } else {
            service = null;
            try {
                table = new TableInfo("T_CSL_formulas");
                table.addColumn(new ColumnInfo("FName", "NVARCHAR(256)"));
                service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, formulasKeys, null);
                sql = new StringBuffer();
                sql.append("select notesindex.FName FName ");
                if (!isCheck) {
                    sql.append(",notesindex.FFormulas FFormulas,notesindex.FValueType FValueType ");
                }
                sql.append(" from T_CSL_ReportNotesIndex notesindex ");
                sql.append(" inner join ").append(service.getTmpTableName()).append(" tmp on tmp.FName=notesindex.fname ");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet == null) ** GOTO lbl72
                info = null;
                while (rowSet.next()) {
                    if (isCheck) {
                        formulasKeys.remove(rowSet.getString("FName"));
                        continue;
                    }
                    info = new ReportNotesIndexInfo();
                    info.setName(rowSet.getString("FName"));
                    info.setValueType(RptNotesIndexValueTypeEnum.getEnum(rowSet.getInt("FValueType")));
                    indexNames.remove(info.getName());
                    indexs = formulas.get(rowSet.getString("FFormulas"));
                    if (indexs == null) {
                        indexs = new ArrayList<ReportNotesIndexInfo>();
                        formulas.put(rowSet.getString("FFormulas"), indexs);
                    }
                    indexs.add(info);
                }
            }
            catch (Exception ex) {
                ReportNotesUtil.logger.error((Object)"", (Throwable)ex);
                throw ex;
            }
            finally {
                if (!DebugLogger.isDebug && service != null) {
                    service.release();
                }
            }
        }
lbl72:
        // 3 sources

        if (indexNames != null && !indexNames.isEmpty()) {
            throw new Exception(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"48_indexNotExist"), new Object[]{indexNames.toString()}));
        }
    }

    public static boolean checkWordIndex(Context ctx, byte[] templateContent, StringBuffer msg) throws Exception {
        try (ByteArrayInputStream inputStream = null;){
            inputStream = new ByteArrayInputStream(templateContent);
            XWPFDocument xwpfDocument = new XWPFDocument((InputStream)inputStream);
            Set<String> formulas = ReportNotesUtil.getTempWordFormulas(xwpfDocument);
            boolean isHasFormulas = false;
            if (!formulas.isEmpty()) {
                isHasFormulas = true;
                ReportNotesUtil.initRptNotesIndexs(ctx, formulas, null, true);
                if (!formulas.isEmpty()) {
                    String checkIndex = null;
                    for (String formula : formulas) {
                        if (checkIndex == null) {
                            checkIndex = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"48_indexNotExist");
                        }
                        msg.append(MessageFormat.format(checkIndex, formula)).append("\n");
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            formulas.clear();
            ReportNotesUtil.getTableFormula(xwpfDocument, formulas, true);
            if (!formulas.isEmpty()) {
                isHasFormulas = true;
                RptNotesDynaDataSchemeCollection coll = RptNotesDynaDataSchemeFactory.getLocalInstance(ctx).getRptNotesDynaDataSchemeCollection("select name where name in(" + CslRptUtil.collection2String(formulas, (String)",", (boolean)true) + ")");
                for (int i = 0; i < coll.size(); ++i) {
                    formulas.remove(coll.get(i).getName());
                }
                if (!formulas.isEmpty()) {
                    String checkIndex = null;
                    for (String formula : formulas) {
                        if (checkIndex == null) {
                            checkIndex = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"83_dySchemeNotExists");
                        }
                        msg.append(MessageFormat.format(checkIndex, formula)).append("\n");
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            if (!isHasFormulas) {
                msg.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"49_tmpNotIndex"));
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadWordFile(Context ctx, String filePath, String boID, byte[] notesContent) throws Exception {
        if (!StringUtils.isEmpty((String)filePath)) {
            AttachmentServerManager attachmentManager = AttachmentManagerFactory.getServerManager((Context)ctx);
            File file = new File(filePath);
            String fullname = file.getName();
            String mainname = StringUtil4File.getMainFileName((String)fullname);
            String extname = StringUtil4File.getExtendedFileName((String)fullname);
            extname = extname.toLowerCase();
            String fileUrl = null;
            byte[] content = null;
            if (notesContent != null && notesContent.length > 0) {
                content = notesContent;
            } else {
                FileInputStream fis = null;
                AbstractInterruptibleChannel fc = null;
                try {
                    if (file == null) {
                        throw new AttachmentException(AttachmentException.FILENOTFOUND);
                    }
                    if (!file.canRead()) {
                        throw new AttachmentException(AttachmentException.FILECANNOTREAD);
                    }
                    fis = new FileInputStream(file);
                    fc = fis.getChannel();
                    long size = ((FileChannel)fc).size();
                    content = new byte[new Long(size).intValue()];
                    MappedByteBuffer mbb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    mbb.get(content);
                    mbb.clear();
                }
                finally {
                    if (fc != null) {
                        fc.close();
                    }
                    if (fc != null) {
                        fis.close();
                    }
                }
            }
            SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
            sai.setMainName(mainname);
            sai.setExtName(extname);
            sai.setContent(content);
            sai.setFileUrl(fileUrl);
            if (notesContent == null || notesContent.length <= 0) {
                sai.setLength(file.length());
            }
            sai.setCode("");
            sai.setIsShared(false);
            sai.setShareRange(null);
            sai.setBeizhu("");
            attachmentManager.setContext(ctx);
            return attachmentManager.addNewAttachment(ctx, boID, sai);
        }
        return null;
    }

    public static Set<String> getTempWordFormulas(XWPFDocument xwpfDocument) throws Exception {
        List paras = xwpfDocument.getParagraphs();
        HashSet<String> formuls = new HashSet<String>();
        for (XWPFParagraph para : paras) {
            String text = para.getParagraphText();
            ReportNotesUtil.handleTextFormuls(text, formuls, false);
        }
        ReportNotesUtil.getTableFormula(xwpfDocument, formuls, false);
        return formuls;
    }

    public static void getTableFormula(XWPFDocument xwpfDocument, Set<String> formuls, boolean isDyTable) throws Exception {
        List tableList = xwpfDocument.getTables();
        if (tableList != null) {
            for (XWPFTable table : tableList) {
                List rows = table.getRows();
                for (XWPFTableRow row : rows) {
                    List cells = row.getTableCells();
                    for (XWPFTableCell cell : cells) {
                        ReportNotesUtil.handleTextFormuls(cell.getText(), formuls, isDyTable);
                    }
                }
            }
        }
    }

    public static void handleTextFormuls(String text, Set<String> formuls, boolean isDyTable) throws Exception {
        if (!StringUtils.isEmpty((String)text)) {
            int endIndex = 0;
            int startIndex = 0;
            while (startIndex >= 0 && endIndex >= 0) {
                startIndex = text.indexOf(isDyTable ? dyStartStr : startStr, endIndex);
                if (startIndex < 0 || (endIndex = text.indexOf(isDyTable ? dyEndStr : endStr, startIndex)) <= 0) continue;
                formuls.add(text.substring(startIndex + (isDyTable ? dyStartStr : startStr).length(), endIndex).trim());
            }
        }
    }

    public static boolean handleDySchemeForTable(Context ctx, XWPFDocument xwpfDocument, ReportNotesInfo rptNotesInfo) throws Exception {
        List tableList = xwpfDocument.getTables();
        boolean isNoFormula = true;
        if (tableList != null) {
            Object paras = null;
            boolean isTableEnd = false;
            block0: for (XWPFTable table : tableList) {
                List rows = table.getRows();
                String schemeNumber = null;
                isTableEnd = false;
                for (int i = 0; i < rows.size(); ++i) {
                    XWPFTableRow row = (XWPFTableRow)rows.get(i);
                    List cells = row.getTableCells();
                    for (int j = 0; j < cells.size(); ++j) {
                        int endIndex;
                        String text;
                        int startIndex;
                        XWPFTableCell cell = (XWPFTableCell)cells.get(j);
                        if (cell == null || StringUtils.isEmpty((String)cell.getText()) || (startIndex = (text = cell.getText()).indexOf(dyStartStr)) < 0 || (endIndex = text.indexOf(dyEndStr, startIndex)) <= 0) continue;
                        schemeNumber = text.substring(startIndex + dyStartStr.length(), endIndex);
                        List<Object[]> datas = ReportNotesUtil.getDySchemeFillDatas(ctx, rptNotesInfo, schemeNumber);
                        if (datas != null && !datas.isEmpty()) {
                            ReportNotesUtil.fillDySchemeDatas(datas, table, i, j);
                        }
                        isNoFormula = false;
                        isTableEnd = true;
                        break;
                    }
                    if (isTableEnd) continue block0;
                }
            }
        }
        return !isNoFormula;
    }

    public static void fillDySchemeDatas(List<Object[]> datas, XWPFTable table, int rowIndex, int colIndex) throws Exception {
        for (int i = 0; i < datas.size(); ++i) {
            XWPFTableRow curRow = null;
            curRow = i == 0 ? table.getRow(rowIndex) : ReportNotesUtil.insertTableNewRow(table, rowIndex + i - 1, rowIndex);
            Object[] data = datas.get(i);
            List cells = curRow.getTableCells();
            int dataIndex = 0;
            for (int j = colIndex; j < cells.size(); ++j) {
                if (dataIndex >= data.length - 1) continue;
                Object cruCellData = data[dataIndex++];
                ReportNotesUtil.setCellValue((XWPFTableCell)cells.get(j), cruCellData != null ? cruCellData.toString() : null);
            }
        }
    }

    public static List<Object[]> getDySchemeFillDatas(Context ctx, ReportNotesInfo rptNotesInfo, String schemeNumber) throws Exception {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        if (!StringUtils.isEmpty((String)schemeNumber)) {
            RptNotesDynaDataSchemeCollection coll = RptNotesDynaDataSchemeFactory.getLocalInstance(ctx).getRptNotesDynaDataSchemeCollection("where name='" + schemeNumber + "' order by items.seq asc ");
            if (coll != null && coll.size() > 0) {
                RptNotesDynaDataSchemeInfo dataSchemeinfo = coll.get(0);
                SQLBuilder sql = ReportNotesUtil.getDySql(rptNotesInfo, dataSchemeinfo);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                if (rowSet != null) {
                    HashMap rows = new HashMap();
                    StringBuffer key = new StringBuffer();
                    while (rowSet.next()) {
                        DynaItemDataEntryInfo dyInfo;
                        DynaItemDataEntryInfo info = new DynaItemDataEntryInfo();
                        info.setKeyName(rowSet.getString("fkeyname"));
                        info.setValueType(ValueTypeEnum.getEnum((int)rowSet.getInt("fvaluetype")));
                        info.setTextValue(rowSet.getString("ftextvalue"));
                        info.setValue(rowSet.getBigDecimal("fvalue"));
                        key.setLength(0);
                        key.append(rowSet.getString("fitem")).append(rowSet.getString("fdataelement")).append(info.getValueType().getValue());
                        String keyNumber = rowSet.getString("fkeynumber");
                        HashMap<String, DynaItemDataEntryInfo> row = (HashMap<String, DynaItemDataEntryInfo>)rows.get(keyNumber);
                        if (row == null) {
                            row = new HashMap<String, DynaItemDataEntryInfo>();
                            rows.put(keyNumber, row);
                        }
                        if ((dyInfo = (DynaItemDataEntryInfo)row.get(key.toString())) == null) {
                            row.put(key.toString(), info);
                            continue;
                        }
                        if (ValueTypeEnum.TXT.equals((Object)dyInfo.getValueType())) {
                            if (dyInfo.getTextValue().indexOf(info.getTextValue()) >= 0) continue;
                            dyInfo.setTextValue(dyInfo.getTextValue() + ";" + info.getTextValue());
                            continue;
                        }
                        dyInfo.setValue(dyInfo.getValue().add(info.getValue()));
                    }
                    int arraySize = dataSchemeinfo.getItems().size() + 2;
                    int sortIndex = arraySize - 1;
                    sortEnum sortType = sortEnum.Asc;
                    for (String keyNumber : rows.keySet()) {
                        Object[] rowObj = new Object[arraySize];
                        int index = 1;
                        rowObj[arraySize - 1] = keyNumber;
                        String keyName = null;
                        Map row = (Map)rows.get(keyNumber);
                        for (int i = 0; i < dataSchemeinfo.getItems().size(); ++i) {
                            DynaItemDataEntryInfo info = (DynaItemDataEntryInfo)row.get(dataSchemeinfo.getItems().get(i).getKey());
                            if (sortIndex == arraySize - 1 && dataSchemeinfo.getItems().get(i).getSortType() != null && !dataSchemeinfo.getItems().get(i).getSortType().equals((Object)sortEnum.NoSort)) {
                                sortIndex = index;
                                sortType = dataSchemeinfo.getItems().get(i).getSortType();
                            }
                            if (info != null) {
                                Object value = null;
                                value = info.getValueType().getValue() == 3 ? info.getTextValue() : info.getValue();
                                rowObj[index++] = value;
                                keyName = info.getKeyName();
                                continue;
                            }
                            rowObj[index++] = null;
                        }
                        rowObj[0] = keyName;
                        datas.add(rowObj);
                    }
                    rows.clear();
                    ReportNotesUtil reportNotesUtil = new ReportNotesUtil();
                    reportNotesUtil.getClass();
                    MyComparator myComparator = reportNotesUtil.new MyComparator(sortIndex, sortType);
                    Collections.sort(datas, myComparator);
                    int showCount = dataSchemeinfo.getShowRowCount();
                    if (showCount > 0) {
                        for (int i = datas.size() - 1; i >= showCount; --i) {
                            datas.remove(i);
                        }
                    }
                    if (dataSchemeinfo.isIsShowSum()) {
                        Object[] rowObj = new Object[arraySize];
                        if (totalStr == null) {
                            totalStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"316_AfterElimReportUI");
                        }
                        rowObj[0] = totalStr;
                        for (Object[] row : datas) {
                            for (int i = 1; i < row.length - 1; ++i) {
                                if (rowObj[i] != null) {
                                    if (!(rowObj[i] instanceof BigDecimal)) continue;
                                    rowObj[i] = ((BigDecimal)rowObj[i]).add(row[i] != null ? (BigDecimal)row[i] : BigDecimal.ZERO);
                                    continue;
                                }
                                if (!(row[i] instanceof BigDecimal)) continue;
                                rowObj[i] = row[i];
                            }
                        }
                        if (dataSchemeinfo.isIsSumTop()) {
                            datas.add(0, rowObj);
                        } else {
                            datas.add(rowObj);
                        }
                    }
                    DecimalFormat df = new DecimalFormat("###,##0.00");
                    for (Object[] rowData : datas) {
                        for (int i = 0; i < rowData.length; ++i) {
                            if (!(rowData[i] instanceof BigDecimal)) continue;
                            try {
                                rowData[i] = df.format((BigDecimal)rowData[i]);
                                continue;
                            }
                            catch (Throwable e) {
                                logger.error((Object)"calcFormuls error.", e);
                            }
                        }
                    }
                }
            } else {
                throw new Exception(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"83_dySchemeNotExists"), schemeNumber));
            }
        }
        return datas;
    }

    public static SQLBuilder getDySql(ReportNotesInfo rptNotesInfo, RptNotesDynaDataSchemeInfo dataSchemeinfo) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select sum(itementry.fvalue) fvalue,itementry.ftextvalue,itementry.fitemid fitem,");
        sql.append("itementry.fdataelement,itementry.fvaluetype,itementry.fkeynumber,itementry.fkeyname");
        sql.append(" from t_csl_dynaitemdataentry itementry ");
        sql.append(" inner join t_csl_dynaitemdata item on item.fid=itementry.fitemdataid ");
        sql.append(" inner join t_csl_rptreceived rec on rec.freportid=item.freportid ");
        sql.append(" inner join t_org_tree tree on tree.fid=rec.forgtreeid ");
        if (rptNotesInfo.getCompany().isIsUnion()) {
            sql.append(" inner join t_org_baseunit unit on unit.fid=item.forgunitid ");
        }
        sql.append(" where itementry.fyear=? ", (Object)rptNotesInfo.getYear());
        sql.append(" and itementry.fperiod=? ", (Object)rptNotesInfo.getPeriod());
        sql.append(" and item.fperiodtype=? ", (Object)rptNotesInfo.getPeriodType().getValue());
        sql.append(" and item.fcurrencyid=? ", (Object)rptNotesInfo.getCurrency().getId().toString());
        sql.append(" and tree.fnumber=? ", (Object)rptNotesInfo.getOrgTreeNumber());
        if (rptNotesInfo.getCompany().isIsUnion()) {
            sql.append(" and item.fdynatype=?", (Object)(dataSchemeinfo.isIsByName() ? 1 : 6));
            sql.append(" and unit.fnumber=? ", (Object)rptNotesInfo.getOrgUnitNumber());
            boolean isSum = false;
            if (RptNotesUnionDataTypeEnum.SUM_DATA.equals((Object)dataSchemeinfo.getUnionDataType())) {
                isSum = true;
            }
            sql.append(" and item.fdatasource=").append(isSum ? "11" : "12");
        } else {
            sql.append(" and item.fdynatype=?", (Object)1);
            sql.append(" and item.forgunitid=? ", (Object)rptNotesInfo.getCompany().getId().toString());
            sql.append(" and item.fdatasource=10 ");
        }
        sql.append(" and item.fdataType in(0) ");
        sql.append(" and (");
        RptNotesDynaDataSchemeItemCollection itemColl = dataSchemeinfo.getItems();
        RptNotesDynaDataSchemeItemInfo itemInfo = null;
        for (int i = 0; i < itemColl.size(); ++i) {
            itemInfo = itemColl.get(i);
            if (i > 0) {
                sql.append(" or ");
            }
            sql.append("itementry.fitemid=? ", (Object)itemInfo.getItemNumber());
            sql.append("and itementry.fdataelement=? ", (Object)itemInfo.getDataElement());
            sql.append("and itementry.fvaluetype=? ", (Object)itemInfo.getValueType());
        }
        sql.append(") group by itementry.ftextvalue,itementry.fitemid,itementry.fdataelement,itementry.fvaluetype,itementry.fkeynumber,itementry.fkeyname ");
        return sql;
    }

    public static XWPFTableRow insertTableNewRow(XWPFTable table, int rowIndex, int soureRowIndex) throws Exception {
        XWPFTableRow sourceRow = table.getRow(soureRowIndex);
        XWPFTableRow newRow = table.insertNewTableRow(rowIndex + 1);
        newRow.getCtRow().setTrPr(sourceRow.getCtRow().getTrPr());
        List tableCells = sourceRow.getTableCells();
        if (tableCells == null || tableCells.isEmpty()) {
            return null;
        }
        for (XWPFTableCell sourceCell : tableCells) {
            XWPFRun run;
            XWPFParagraph p;
            XWPFTableCell newCell = newRow.addNewTableCell();
            newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
            List sourceParagraphs = sourceCell.getParagraphs();
            if (sourceParagraphs == null || sourceParagraphs.isEmpty()) continue;
            XWPFParagraph sourceParagraph = (XWPFParagraph)sourceParagraphs.get(0);
            List targetParagraphs = newCell.getParagraphs();
            if (targetParagraphs == null || targetParagraphs.isEmpty()) {
                p = newCell.addParagraph();
                p.getCTP().setPPr(sourceParagraph.getCTP().getPPr());
                run = p.getRuns().isEmpty() ? p.createRun() : (XWPFRun)p.getRuns().get(0);
                ReportNotesUtil.copyCellStyle(run, (XWPFRun)sourceParagraph.getRuns().get(0));
                continue;
            }
            p = (XWPFParagraph)targetParagraphs.get(0);
            p.getCTP().setPPr(sourceParagraph.getCTP().getPPr());
            XWPFRun xWPFRun = run = p.getRuns().isEmpty() ? p.createRun() : (XWPFRun)p.getRuns().get(0);
            if (sourceParagraph.getRuns() == null || sourceParagraph.getRuns().size() <= 0) continue;
            ReportNotesUtil.copyCellStyle(run, (XWPFRun)sourceParagraph.getRuns().get(0));
        }
        return newRow;
    }

    public static void copyCellStyle(XWPFRun targRun, XWPFRun sourceRun) throws Exception {
        CTRPr sourceRPr;
        if (sourceRun.getFontFamily() != null) {
            targRun.setFontFamily(sourceRun.getFontFamily());
        }
        if (sourceRun.getFontSize() != -1) {
            targRun.setFontSize(sourceRun.getFontSize());
        }
        targRun.setColor(sourceRun.getColor());
        if (!targRun.isBold()) {
            targRun.setBold(sourceRun.isBold());
        }
        targRun.setItalic(sourceRun.isItalic());
        targRun.setUnderline(sourceRun.getUnderline());
        targRun.setColor(sourceRun.getColor());
        targRun.setTextPosition(sourceRun.getTextPosition());
        if (sourceRun.getFontSize() != -1) {
            targRun.setFontSize(sourceRun.getFontSize());
        }
        if (sourceRun.getFontFamily() != null) {
            targRun.setFontFamily(sourceRun.getFontFamily());
        }
        if (sourceRun.getCTR() != null && sourceRun.getCTR().isSetRPr() && (sourceRPr = sourceRun.getCTR().getRPr()).isSetRFonts()) {
            CTFonts sourceFonts = sourceRPr.getRFonts();
            CTRPr targRPr = targRun.getCTR().isSetRPr() ? targRun.getCTR().getRPr() : targRun.getCTR().addNewRPr();
            CTFonts targFonts = targRPr.isSetRFonts() ? targRPr.getRFonts() : targRPr.addNewRFonts();
            targFonts.setAscii(sourceFonts.getAscii());
            targFonts.setAsciiTheme(sourceFonts.getAsciiTheme());
            targFonts.setCs(sourceFonts.getCs());
            targFonts.setCstheme(sourceFonts.getCstheme());
            targFonts.setEastAsia(sourceFonts.getEastAsia());
            targFonts.setEastAsiaTheme(sourceFonts.getEastAsiaTheme());
            targFonts.setHAnsi(sourceFonts.getHAnsi());
            targFonts.setHAnsiTheme(sourceFonts.getHAnsiTheme());
        }
    }

    public static boolean setFormulaValuesToWordForTable(XWPFDocument xwpfDocument, Map<String, String> formulValues) throws Exception {
        List tableList = xwpfDocument.getTables();
        if (tableList != null) {
            List paras = null;
            StringBuffer curText = new StringBuffer();
            for (XWPFTable table : tableList) {
                List rows = table.getRows();
                for (XWPFTableRow row : rows) {
                    List cells = row.getTableCells();
                    block2: for (XWPFTableCell cell : cells) {
                        String text = cell.getText();
                        int endIndex = 0;
                        int startIndex = 0;
                        while (startIndex >= 0 && endIndex >= 0) {
                            startIndex = text.indexOf(startStr, endIndex);
                            if (startIndex < 0 || (endIndex = text.indexOf(endStr, startIndex)) <= 0) continue;
                            paras = cell.getParagraphs();
                            ReportNotesUtil.setFormulaValuesToWordForText(paras, formulValues);
                            continue block2;
                        }
                    }
                }
            }
        }
        return true;
    }

    public static void setCellValue(XWPFTableCell cell, String value) throws Exception {
        List paras = cell.getParagraphs();
        boolean isSetedCell = false;
        for (XWPFParagraph para : paras) {
            List list = para.getRuns();
            if ((list == null || list.isEmpty()) && !isSetedCell) {
                XWPFRun run = para.createRun();
                run.setText(value, 0);
                isSetedCell = true;
                continue;
            }
            for (int i = 0; i < list.size(); ++i) {
                XWPFRun run = (XWPFRun)list.get(i);
                if (i == 0) {
                    run.setText(value, 0);
                } else {
                    run.setText("", 0);
                }
                isSetedCell = true;
            }
        }
        if (!isSetedCell) {
            cell.setText(value);
        }
    }

    public static void setFormulaValuesToWordForText(List<XWPFParagraph> paras, Map<String, String> formulValues) throws Exception {
        StringBuffer paraText = new StringBuffer();
        block0: for (XWPFParagraph para : paras) {
            paraText.setLength(0);
            List list = para.getRuns();
            for (int i = 0; i < list.size(); ++i) {
                XWPFRun run = (XWPFRun)list.get(i);
                paraText.append(run.getText(run.getTextPosition()));
            }
            ArrayList<Object[]> formulaIndexs = new ArrayList<Object[]>();
            String text = paraText.toString();
            if (!StringUtils.isEmpty((String)text)) {
                int startIndex = 0;
                int endIndex = 0;
                while (startIndex >= 0 && endIndex >= 0) {
                    startIndex = text.indexOf(startStr, endIndex);
                    if (startIndex < 0 || (endIndex = text.indexOf(endStr, startIndex)) <= 0) continue;
                    formulaIndexs.add(new Object[]{startIndex, endIndex, text.substring(startIndex + startStr.length(), endIndex).trim()});
                }
            }
            if (formulaIndexs.isEmpty()) continue;
            int formulaIndex = 0;
            int allRunTextLen = 0;
            Object[] indexInfo = null;
            int startIndex = -1;
            int endIndex = -1;
            boolean isFormulIndexEnd = true;
            boolean isRunEnd = false;
            StringBuffer tmpText = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                int lastFormulaEndPosition = 0;
                XWPFRun run = (XWPFRun)list.get(i);
                String runText = run.getText(run.getTextPosition());
                if (runText == null) {
                    allRunTextLen += 4;
                    continue;
                }
                if (formulaIndex >= formulaIndexs.size()) continue block0;
                tmpText.setLength(0);
                isRunEnd = false;
                boolean isSetRunText = false;
                while (!isRunEnd && formulaIndex < formulaIndexs.size()) {
                    indexInfo = (Object[])formulaIndexs.get(formulaIndex);
                    startIndex = (Integer)indexInfo[0];
                    endIndex = (Integer)indexInfo[1];
                    int curRunEndLen = allRunTextLen + runText.length();
                    if (!isFormulIndexEnd) {
                        if (curRunEndLen >= endIndex + endStr.length()) {
                            lastFormulaEndPosition = endIndex - allRunTextLen + endStr.length();
                            ++formulaIndex;
                            isFormulIndexEnd = true;
                            continue;
                        }
                        run.setText("", 0);
                        isSetRunText = true;
                        isRunEnd = true;
                        continue;
                    }
                    if (curRunEndLen >= startIndex) {
                        tmpText.append(runText.substring(lastFormulaEndPosition, startIndex - allRunTextLen));
                        tmpText.append(formulValues.get((String)indexInfo[2]));
                        if (curRunEndLen >= endIndex + endStr.length()) {
                            lastFormulaEndPosition = endIndex - allRunTextLen + endStr.length();
                            ++formulaIndex;
                            isFormulIndexEnd = true;
                            continue;
                        }
                        run.setText(tmpText.toString(), 0);
                        isSetRunText = true;
                        isFormulIndexEnd = false;
                        isRunEnd = true;
                        continue;
                    }
                    isRunEnd = true;
                }
                if (!isSetRunText && lastFormulaEndPosition > 0) {
                    tmpText.append(runText.substring(lastFormulaEndPosition));
                    run.setText(tmpText.toString(), 0);
                }
                allRunTextLen += runText.length();
            }
        }
    }

    public static boolean setFormulaValuesToWord(XWPFDocument xwpfDocument, Map<String, String> formulValues) throws Exception {
        List paras = xwpfDocument.getParagraphs();
        ReportNotesUtil.setFormulaValuesToWordForText(paras, formulValues);
        ReportNotesUtil.setFormulaValuesToWordForTable(xwpfDocument, formulValues);
        return true;
    }

    public static Map<String, String> calcFormuls(Context ctx, ReportNotesInfo rptNotesInfo, Set<String> formulas, Map<String, List<ReportNotesIndexInfo>> formulas_index) throws Exception {
        ArrayList<String> formulaList = new ArrayList<String>(formulas);
        HashMap<String, Object> commParams = new HashMap<String, Object>();
        boolean isUnion = false;
        if (rptNotesInfo.getCompany().get("isUnion") == null) {
            FullOrgUnitCollection coll = (ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx)).getFullOrgUnitCollection("select isUnion where id='" + rptNotesInfo.getCompany().getId().toString() + "'");
            if (coll != null && coll.size() > 0) {
                isUnion = coll.get(0).isIsUnion();
            }
        } else {
            isUnion = rptNotesInfo.getCompany().isIsUnion();
        }
        commParams.put("Report.SourceType", isUnion ? 3 : 7);
        commParams.put("Company.Number", rptNotesInfo.getOrgUnitNumber());
        commParams.put("Company.Name", rptNotesInfo.getCompany().getName());
        commParams.put("Company.ID", rptNotesInfo.getCompany().getId().toString());
        commParams.put("OrgUnit.Name", rptNotesInfo.getCompany().getName());
        commParams.put("OrgUnit.Number", rptNotesInfo.getOrgUnitNumber());
        commParams.put("OrgUnit.Id", rptNotesInfo.getCompany().getId().toString());
        commParams.put("CSLReport_OrgTree_Number", rptNotesInfo.getOrgTreeNumber());
        commParams.put("PeriodType", rptNotesInfo.getPeriodType().getValue());
        commParams.put("Report.Year", rptNotesInfo.getYear());
        commParams.put("Report.Period", rptNotesInfo.getPeriod());
        commParams.put("Currency.Number", rptNotesInfo.getCurrency().getNumber());
        commParams.put("Report.Name", rptNotesInfo.getName());
        commParams.put("Report.ID", rptNotesInfo.getId().toString());
        commParams.put("Report.Number", rptNotesInfo.getNumber());
        commParams.put("LastUpdater.Name", rptNotesInfo.getLastUpdateUser().getName());
        commParams.put("Creater.Name", rptNotesInfo.getCreator().getName());
        commParams.put("Report_StartDate", RPTDateUtil.getPeriodFirstDate((int)rptNotesInfo.getYear(), (int)rptNotesInfo.getPeriod(), (RptPeriodTypeEnum)rptNotesInfo.getPeriodType()));
        commParams.put("Report_EndDate", RPTDate13Util.getPeriodLastDate((int)rptNotesInfo.getYear(), (int)rptNotesInfo.getPeriod(), (RptPeriodTypeEnum)rptNotesInfo.getPeriodType()));
        ReportNotesTemplateInfo info = ReportNotesTemplateFactory.getLocalInstance(ctx).getReportNotesTemplateInfo("select errorReplaceTxt where id='" + rptNotesInfo.getTemplate().getId().toString() + "'");
        String errorReplateTxt = ReportNotesUtil.getErrorReplaceTxt(info.getErrorReplaceTxt());
        if (errorReplateTxt != null) {
            commParams.put("errorReplaceTxt", errorReplateTxt);
        }
        HashMap<String, Boolean> sheetVariables = new HashMap<String, Boolean>();
        sheetVariables.put("IncludePosted", true);
        List values = CslRptOpenApiFacadeFactory.getLocalInstance((Context)ctx).getBatchFormulaValues(commParams, sheetVariables, formulaList);
        HashMap<String, String> formulValues = new HashMap<String, String>();
        DecimalFormat df = new DecimalFormat("###,##0.00");
        String value = null;
        List<ReportNotesIndexInfo> indexInfos = null;
        for (int i = 0; i < formulaList.size(); ++i) {
            value = (String)values.get(i);
            indexInfos = formulas_index.get((String)formulaList.get(i));
            for (ReportNotesIndexInfo indexInfo : indexInfos) {
                String tmpValue = value;
                if (RptNotesIndexValueTypeEnum.Amount.equals((Object)indexInfo.getValueType())) {
                    try {
                        tmpValue = df.format(new BigDecimal(value));
                    }
                    catch (Throwable e) {
                        logger.error((Object)"calcFormuls error.", e);
                    }
                }
                formulValues.put(indexInfo.getName(), tmpValue);
            }
        }
        return formulValues;
    }

    public static FileGetter getFileGetter() throws Exception {
        try {
            if (fg == null) {
                fg = new FileGetter(AttachmentFactory.getRemoteInstance(), AttachmentFtpFacadeFactory.getRemoteInstance());
            }
        }
        catch (Exception e) {
            logger.error((Object)"getFileGetter error.", (Throwable)e);
            throw e;
        }
        return fg;
    }

    public static String downLoadWordForServer(Context ctx, String wordAttachId, String fileName) throws Exception {
        try (FileOutputStream out = null;){
            String dir = System.getProperty("EAS_INSTANCE_HOME");
            File file = File.createTempFile(fileName, ".docx", new File(dir));
            out = new FileOutputStream(file);
            IAttachmentFtpFacade iAttachmentFacade = AttachmentFtpFacadeFactory.getLocalInstance((Context)ctx);
            while (true) {
                byte[] content;
                if ((content = iAttachmentFacade.downloadFile(wordAttachId, 0L)) == null || content.length == 0) break;
                out.write(content);
                out.flush();
            }
            logger.error((Object)"*****AttachmentDownloadClient*****content is null**************");
            String string = file.getPath();
            return string;
        }
    }

    public static byte[] getWordContent(Context ctx, String wordAttachId) throws Exception {
        try {
            AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo("select name,isEncrypt where id = '" + wordAttachId + "'");
            byte[] contents = null;
            ArrayList<byte[]> contentList = new ArrayList<byte[]>();
            int length = 0;
            IAttachmentFtpFacade iAttachmentFacade = AttachmentFtpFacadeFactory.getLocalInstance((Context)ctx);
            while (true) {
                byte[] content = iAttachmentFacade.downloadFile(wordAttachId, 0L);
                if (attachmentInfo != null && attachmentInfo.getIsEncrypt() == 1 && content != null && content.length > 0) {
                    try {
                        content = AttachmentEncryptUtil.decrypt((byte[])content);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"getWordContent error.", (Throwable)ex);
                        throw ex;
                    }
                }
                if (content == null || content.length == 0) break;
                length += content.length;
                contentList.add(content);
            }
            logger.error((Object)"*****AttachmentDownloadClient*****content is null**************");
            if (length > 0) {
                if (contentList.size() == 1) {
                    return (byte[])contentList.get(0);
                }
                contents = new byte[length];
                int startIndex = 0;
                for (byte[] con : contentList) {
                    System.arraycopy(con, 0, contents, startIndex, con.length);
                    startIndex += con.length;
                }
            }
            return contents;
        }
        catch (Exception e) {
            logger.error((Object)"downLoadTemplate error.", (Throwable)e);
            throw e;
        }
    }

    public static void setFileOnlyRead(String filePath) throws Exception {
        try {
            Process p = Runtime.getRuntime().exec("cmd /c attrib " + filePath + " +R");
            p.waitFor();
            p.exitValue();
        }
        catch (Exception e) {
            logger.error((Object)"set onlyread error.", (Throwable)e);
            throw e;
        }
    }

    public static String buildErrorReplaceBDTxt(String replaceTxt) {
        StringBuffer txt = new StringBuffer();
        txt.append("isErrorReplace").append("=true;");
        txt.append("errorReplaceTxt").append("=").append(replaceTxt);
        return txt.toString();
    }

    public static String getErrorReplaceTxt(String dbTxt) {
        if (!StringUtils.isEmpty((String)dbTxt)) {
            String[] txt = dbTxt.split(";");
            String[] error = txt[1].split("=");
            if (error.length <= 1) {
                return "";
            }
            return txt[1].split("=")[1];
        }
        return null;
    }

    public static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public class MyComparator
    implements Comparator {
        private int sortIndex = 0;
        private boolean isAsc = false;

        public MyComparator(int sortIndex, sortEnum sortType) {
            this.sortIndex = sortIndex;
            if (sortEnum.Asc.equals((Object)sortType)) {
                this.isAsc = true;
            }
        }

        public int compare(Object o1, Object o2) {
            if (o1 != null || o2 != null) {
                Object obj1 = ((Object[])o1)[this.sortIndex];
                Object obj2 = ((Object[])o2)[this.sortIndex];
                if (obj1 != null && obj2 != null) {
                    if (obj1 instanceof BigDecimal) {
                        return this.isAsc ? ((BigDecimal)obj1).compareTo((BigDecimal)obj2) : ((BigDecimal)obj2).compareTo((BigDecimal)obj1);
                    }
                    return this.isAsc ? obj1.toString().compareTo(obj2.toString()) : obj2.toString().compareTo(obj1.toString());
                }
                if (obj1 != null || obj2 != null) {
                    if (obj1 != null) {
                        return this.isAsc ? 1 : -1;
                    }
                    return this.isAsc ? -1 : 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

