/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentDownloadClient;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpClientController;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.permission.client.longtime.AbstractLongTimeTaskExt;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.KDLongTimeDialogBuilder;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialogExt;
import com.kingdee.eas.base.permission.client.longtime.dialogimpl.KDLongTimeDialogBuilderDefaultImpl;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesConstant;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesTemplateFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FileHandle {
    private static final Logger logger = CoreUIObject.getLogger(FileHandle.class);
    private static final String INVALID_CHARS_REGEX = "[<>\\?\\|\\\\/:\\*\\\"\\~\\&\\%\\$\\!\\^]";
    private boolean isSuccess = true;
    FileOutputStream out = null;

    public boolean uploadFile(final File attachFile, final String boID, final AttachmentUIContextInfo info, final Component owner, final IRow row, final boolean isRpt) throws Exception {
        Window win = SwingUtilities.getWindowAncestor(owner);
        KDDialog dialog = win != null && win instanceof KDDialog ? (KDDialog)win : new KDDialog();
        LongTimeDialogExt ltd = new LongTimeDialogExt((Dialog)dialog);
        ltd.setLongTimeTask(new AbstractLongTimeTaskExt(){

            public Object exec() throws Exception {
                try {
                    Thread.sleep(50L);
                    AttachmentInfo attachInfo = FileHandle.this.makeAttachmentInfo(attachFile, boID, info);
                    AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
                    String attchID = attachmentClientManager.submitAttachment(attachInfo);
                    if (isRpt) {
                        ReportNotesFactory.getRemoteInstance().updateWordId(boID, attchID);
                        row.getCell("wordAttachId").setValue((Object)attchID);
                        row.getCell("updateTime").setValue((Object)ReportNotesUtil.getTime());
                        row.getCell("updateUser").setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getName());
                    } else {
                        ReportNotesTemplateFactory.getRemoteInstance().updateWordId(boID, attchID);
                        row.getCell("wordId").setValue((Object)attchID);
                        row.getCell("updateTime").setValue((Object)ReportNotesUtil.getTime());
                        row.getCell("updateuser").setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getName());
                    }
                    FileHandle.this.isSuccess = true;
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    FileHandle.this.isSuccess = false;
                    logger.info((Object)"", (Throwable)e);
                    throw e;
                }
            }

            public void afterExec(Object arg0) throws Exception {
            }

            public void stopTask() throws Exception {
                logger.info((Object)"stop upload file begin!");
                AttachmentFtpClientController.setStopUploadFile();
            }
        });
        ltd.setDialogBuilder((KDLongTimeDialogBuilder)new KDLongTimeDialogBuilderDefaultImpl());
        ltd.buildDialog();
        ltd.show();
        if (this.isSuccess) {
            new Thread(){

                @Override
                public void run() {
                    MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"23_saveSuccess"));
                }
            }.start();
        }
        return this.isSuccess;
    }

    public AttachmentInfo makeAttachmentInfo(File attachFile, String boID, AttachmentUIContextInfo info) throws Exception {
        IAttachment ia = AttachmentFactory.getRemoteInstance();
        AttachmentInfo ai = new AttachmentInfo();
        String fullname = attachFile.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        Locale locale = SysContext.getSysContext().getLocale();
        extname = extname.toLowerCase(locale);
        String fileUrl = null;
        byte[] content = null;
        if (attachFile.length() > 0x3200000L) {
            fileUrl = attachFile.getAbsolutePath();
        } else {
            content = FileGetter.getBytesFromFile((File)attachFile);
        }
        if (extname.equals("url")) {
            StringUtil4File.checkURL((IAttachment)ia, (String)boID, (String)mainname);
        } else {
            if (mainname == null || mainname.equals("")) {
                throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
            }
            StringUtil4File.checkInvalidCharsInFileName((String)mainname);
            SimpleAttachmentInfo sa = new SimpleAttachmentInfo();
            double attSize = AttachmentSizeFactory.getRemoteInstance().getFileSize();
            sa.setContent(content);
            sa.checkFileSize(attSize);
        }
        MutilLangeToolForParam.muti2Obj((String)mainname, (IObjectValue)ai, (String)"name");
        MutilLangeToolForParam.muti2Obj(null, (IObjectValue)ai, (String)"description");
        String tempValue = ai.isIsShared() ? EASResource.getString((String)"yes") : EASResource.getString((String)"no");
        MutilLangeToolForParam.muti2Obj((String)tempValue, (IObjectValue)ai, (String)"sharedDesc");
        ai.setNumber(info.getCode());
        ai.setFile(content);
        ai.setIsShared(!extname.equals("url"));
        ai.setSimpleName(extname);
        ai.setType(extname.equals("url") ? "URL" : StringUtil4File.getFileTypeDescription((String)extname));
        ai.setSize(StringUtil4File.getFileSizeRepresentation((long)(content == null ? attachFile.length() : (long)content.length)));
        ai.setSizeInByte((int)(content == null ? attachFile.length() : (long)content.length));
        ai.setShareRange(info.getShareRange());
        ai.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + (int)(new SecureRandom().nextDouble() * 9000.0 + 1000.0));
        BoAttchAssoInfo baai = new BoAttchAssoInfo();
        baai.setBoID(boID);
        baai.setAssoType(Resrcs.getString((String)"NewAttachment"));
        baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
        ai.getBoAttchAsso().add(baai);
        ai.setBeizhu(info.getBeizhu());
        ai.setRemotePath(fileUrl);
        return ai;
    }

    public String download(String attchID, String dir, boolean isEditOpen, Component owner) throws Exception {
        return this.download(attchID, dir, null, isEditOpen, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(String attchID, String dir, String fileName, boolean isEditOpen, Component owner) throws Exception {
        String type = "";
        String fullname = "";
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("simpleName"));
            sic.add(new SelectorItemInfo("sizeInByte"));
            IAttachment ia = AttachmentFactory.getRemoteInstance();
            AttachmentInfo ai = (AttachmentInfo)ia.getValue((IObjectPK)new ObjectUuidPK(attchID), sic);
            final String waitAttachmentId = ai.getId().toString();
            String name = ai.getName();
            int oprtIndex = name.lastIndexOf("--");
            if (oprtIndex > 0) {
                name = name.substring(0, oprtIndex);
            }
            if (!StringUtils.isEmpty((String)fileName) && !name.startsWith(fileName)) {
                name = fileName + name.substring(name.lastIndexOf(")") + 1);
            }
            name = name.replaceAll(INVALID_CHARS_REGEX, "");
            name = name + "--" + (isEditOpen ? ReportNotesConstant.edit : ReportNotesConstant.view);
            type = ai.getSimpleName();
            fullname = dir + File.separator + name + "." + type;
            File file = new File(fullname = FilenameUtils.normalize((String)fullname));
            if (file.exists() && !dir.equals("") && !file.delete()) {
                System.gc();
                if (!file.delete()) {
                    fullname = dir + File.separator + name + "N." + type;
                    fullname = FilenameUtils.normalize((String)fullname);
                    file = new File(fullname);
                }
            }
            this.out = new FileOutputStream(file);
            KDDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor(owner);
            dialog = win != null && win instanceof KDDialog ? (KDDialog)win : new KDDialog();
            LongTimeDialog ltd = new LongTimeDialog((Dialog)dialog);
            ltd.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    try {
                        AttachmentDownloadClient downloadClient = new AttachmentDownloadClient(AttachmentFtpFacadeFactory.getRemoteInstance());
                        downloadClient.setOutputStream((OutputStream)FileHandle.this.out);
                        downloadClient.downLoad(waitAttachmentId);
                        FileHandle.this.isSuccess = true;
                    }
                    catch (Exception e) {
                        FileHandle.this.isSuccess = false;
                        logger.error((Object)e);
                        throw e;
                    }
                    return true;
                }

                public void afterExec(Object arg0) throws Exception {
                }
            });
            ltd.show();
            if (!this.isSuccess) {
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            MsgBox.showInfo((String)Resrcs.getString((String)"PathNotExisted"));
            fullname = "";
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
        }
        return fullname;
    }
}

