/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesIndexFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.client.FileHandle;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ReportNotesListUI;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ReportNotesTemplateListUI;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateTypeCollection;
import com.kingdee.eas.fi.rpt.TemplateTypeFactory;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericException;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ReportNotesClientUtil {
    private static final Logger logger = CoreUIObject.getLogger(ReportNotesClientUtil.class);

    public static void saveThread(final String filePath, final String boID, final IRow row, final boolean isCanEdit, final String cantEditmsg, final Component owner, final boolean isRpt) throws Exception {
        Thread.sleep(2000L);
        Thread saveThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long time;
                    long timeout = 5000L;
                    for (time = 0L; time < timeout && ReportNotesUtil.isFileClose(filePath); time += 200L) {
                        Thread.sleep(200L);
                    }
                    if (time >= timeout) {
                        ReportNotesClientUtil.closeOpenedFile(row, owner, isRpt);
                        return;
                    }
                    File file = new File(filePath);
                    if (!file.exists()) {
                        ReportNotesClientUtil.closeOpenedFile(row, owner, isRpt);
                        return;
                    }
                    long lastModified = file.lastModified();
                    long length = file.length();
                    int outTime = 0;
                    while (true) {
                        if (outTime > 1000) {
                            try {
                                if (ReportNotesUtil.isFileClose(filePath)) {
                                    System.gc();
                                    ReportNotesClientUtil.deleteFile(filePath, null);
                                    ReportNotesClientUtil.closeOpenedFile(row, owner, isRpt);
                                    return;
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)"file is not closed.", (Throwable)ex);
                            }
                            outTime = 0;
                        }
                        if (file.lastModified() != lastModified || file.length() != length) {
                            if (!isCanEdit) {
                                owner.setVisible(true);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        if (!StringUtils.isEmpty((String)cantEditmsg)) {
                                            MsgBox.showError((Component)owner, (String)cantEditmsg);
                                        } else {
                                            MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)(isRpt ? "20_notesCantSave" : "75_templateAudited")));
                                        }
                                    }
                                }.start();
                                lastModified = file.lastModified();
                                length = file.length();
                                continue;
                            }
                            try {
                                if (!ReportNotesClientUtil.saveFileToEas(filePath, boID, row, owner, isRpt)) {
                                    new Thread(){

                                        @Override
                                        public void run() {
                                            MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"22_saveError"));
                                        }
                                    }.start();
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)"save error.", (Throwable)ex);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"22_saveError"), (String)ex.getMessage());
                                    }
                                }.start();
                            }
                            finally {
                                System.gc();
                            }
                            lastModified = file.lastModified();
                            length = file.length();
                        }
                        1.sleep(600L);
                        outTime += 600;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"saveThread error.", (Throwable)e);
                    ((CoreUI)owner).handUIException((Throwable)e);
                    return;
                }
            }
        };
        saveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openFile(String filePath) throws Exception {
        File tempbat = File.createTempFile("tempbat", ".bat");
        try (FileWriter fw = null;){
            fw = new FileWriter(tempbat);
            int lp = filePath.lastIndexOf(File.separator);
            filePath = lp == -1 ? "\"" + filePath + "\"" : filePath.substring(0, lp + 1) + "\"" + filePath.substring(lp + 1) + "\"";
            fw.write("start /I " + filePath);
            fw.close();
            String tempbatFullname = tempbat.getPath();
            logger.error((Object)("***tempbatFullname***" + tempbatFullname));
            Process process = Runtime.getRuntime().exec(tempbatFullname);
            while (ReportNotesClientUtil.isProcessAlive(process)) {
                Thread.sleep(200L);
            }
            ReportNotesClientUtil.deleteFile(tempbat.getPath(), null);
            logger.error((Object)"***open File***");
        }
    }

    private static boolean isProcessAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected static void deleteFile(String filePath, String catchPath) throws Exception {
        File catchFile2;
        File file;
        if (!StringUtils.isEmpty((String)filePath) && !(file = new File(filePath)).delete()) {
            System.gc();
            file.delete();
        }
        if (!StringUtils.isEmpty((String)catchPath) && !(catchFile2 = new File(catchPath)).delete()) {
            System.gc();
            catchFile2.delete();
        }
    }

    public static boolean saveFileToEas(String filePath, String boID, IRow row, Component owner, boolean isRpt) throws Exception {
        try {
            if (!StringUtils.isEmpty((String)filePath)) {
                AttachmentUIContextInfo info = new AttachmentUIContextInfo();
                info.setBoID(boID);
                info.setCode("");
                info.setEdit(true);
                info.setBeizhu(" ");
                File attachFile = new File(filePath);
                FileHandle uploadFile = new FileHandle();
                return uploadFile.uploadFile(attachFile, boID, info, owner, row, isRpt);
            }
        }
        catch (Exception e) {
            logger.error((Object)"saveFileToEas error.", (Throwable)e);
            throw new Exception(e);
        }
        return false;
    }

    public static void closeOpenedFile(IRow row, Component owner, boolean isRpt) throws Exception {
        String id = row.getCell("id").getValue().toString();
        if (isRpt) {
            ((ReportNotesListUI)((Object)owner)).closeFile(id);
        } else {
            ((ReportNotesTemplateListUI)((Object)owner)).closeFile(id);
        }
    }

    public static void handleMutexLock(IVOChangeListener listener, String id, Component owner, boolean requestLock) throws Exception {
        ReportNotesClientUtil.handleMutexLock(listener, id, owner, requestLock, true);
    }

    public static void handleMutexLock(IVOChangeListener listener, String id, Component owner, boolean requestLock, boolean isAbort) throws Exception {
        try {
            if (listener != null && id != null) {
                VOChangeEvent e = new VOChangeEvent((Object)owner);
                e.setState(requestLock ? OprtState.EDIT : "RELEASEALL");
                if (!StringUtils.isEmpty((String)id)) {
                    if (requestLock) {
                        e.setNewObjectId(id);
                    } else {
                        e.setCurrentObjectId(id);
                    }
                }
                listener.change(e);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"handleMutexLock error.", e);
            if (isAbort) {
                ((ListUI)owner).handUIException(e);
                ((ListUI)owner).setCursorOfDefault();
                SysUtil.abort();
            }
            if (e instanceof NumericException) {
                throw new Exception(e.getMessage());
            }
            throw new Exception(e);
        }
    }

    public static IRow setSelectRow(KDTable tblMain, String keyField, Object keyValue) throws Exception {
        if (!StringUtils.isEmpty((String)keyField) && keyValue != null) {
            int rowCount = tblMain.getRowCount();
            Object curKey = null;
            IRow row = null;
            ICell cell = null;
            for (int i = 0; i < rowCount; ++i) {
                row = tblMain.getRow(i);
                if (row == null || (cell = row.getCell(keyField)) == null || (curKey = cell.getValue()) == null || !curKey.equals(keyValue)) continue;
                tblMain.getSelectManager().select(i, 0);
                tblMain.getLayoutManager().scrollRowToShow(i);
                return row;
            }
        }
        return null;
    }

    public static Object getSelectedKeyValue(KDTable tblMain, String keyField) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        if (selectRows != null && selectRows.length > 0) {
            Object key = tblMain.getRow(selectRows[0]).getCell(keyField).getValue();
            return key;
        }
        return null;
    }

    public static void addGenerteIndexMenue(final CoreUI owner, KDMenu menuTool, final TemplateInfo info, final Book book) {
        try {
            String sourceType = ReportNotesClientUtil.getSourceType(info);
            if (!StringUtils.isEmpty((String)sourceType)) {
                final KDMenuItem menueGenerteIndex = new KDMenuItem();
                menueGenerteIndex.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"74_generteRptNoteIndex"));
                menuTool.add((JMenuItem)menueGenerteIndex);
                menueGenerteIndex.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            ReportNotesClientUtil.generteIndex(owner, info, book);
                        }
                        catch (Exception ex) {
                            logger.error((Object)"generteNotesIndex error.", (Throwable)ex);
                            owner.handUIException((Throwable)ex);
                        }
                    }
                });
                book.addBookChangeListener(new BookChangeListener(){

                    public void changed(BookChangeEvent e) {
                        if (e.isSheetActive()) {
                            try {
                                Sheet sheet = e.getSheet();
                                int rptClass = CslRptUtil.getReportClass((Book)book, (Sheet)sheet);
                                menueGenerteIndex.setVisible(1 == rptClass);
                            }
                            catch (Exception ex) {
                                logger.error((Object)"addBookChangeListener error.", (Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Object)"addGenerteIndexMenue error.", (Throwable)e);
        }
    }

    public static String getSourceType(TemplateInfo info) {
        String sourceType = null;
        if (info.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONREPORT) || info.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPREPORT) || info.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
            sourceType = "COMMITREPORT";
        } else if (info.getTemplateType().equals((Object)RptTmpTypeEnum.CSLREPORT)) {
            sourceType = "CONSOLIDATION";
        } else if (info.getTemplateType().equals((Object)RptTmpTypeEnum.SUMREPORT)) {
            sourceType = "SUM";
        }
        return sourceType;
    }

    public static void generteIndex(CoreUI owner, TemplateInfo info, Book book) throws Exception {
        String sourceType = ReportNotesClientUtil.getSourceType(info);
        if (sourceType != null) {
            String tmplateNumber = info.getNumber();
            String typeId = null;
            TemplateTypeCollection coll = TemplateTypeFactory.getRemoteInstance().getTemplateTypeCollection("select id,number where number='" + tmplateNumber + "' and reportType=" + 91);
            if (coll != null && coll.size() > 0) {
                typeId = coll.get(0).getId().toString();
            } else {
                TemplateTypeInfo typeInfo = new TemplateTypeInfo();
                typeInfo.setNumber(tmplateNumber);
                typeInfo.setName(tmplateNumber);
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                typeInfo.setCU(cu);
                typeInfo.setReportType(DisplayTemplateTypeEnum.RPTNOTESINDEX);
                typeInfo.setIsLeaf(true);
                typeInfo.setLevel(1);
                typeId = TemplateTypeFactory.getRemoteInstance().addnew(typeInfo).toString();
            }
            Sheet sheet = book.getActiveSheet();
            int row = sheet.getMaxRowIndex();
            int col = sheet.getMaxColIndex();
            Object cell = null;
            ArrayList<Object[]> addNewList = new ArrayList<Object[]>();
            for (int r = 0; r <= row; ++r) {
                for (int c = 0; c <= col; ++c) {
                    ItemFormula f;
                    Range range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(r, c));
                    if (range == null || (f = (ItemFormula)range.getUserObject("ITEM")) == null || f.getFormula() == null) continue;
                    String name = tmplateNumber + "-" + f.getItemNumber() + "-" + f.getDataElementNumber();
                    StringBuffer sbFormula = new StringBuffer();
                    sbFormula.append("AcctItem(\"\",\"\",\"\",\"\",");
                    sbFormula.append("\"" + f.getItemNumber() + "\",");
                    sbFormula.append("\"" + f.getItemNumber() + "\",");
                    sbFormula.append("\"" + info.getPeriodType().getName() + "\",");
                    sbFormula.append("0,0,0,");
                    sbFormula.append("\"" + sourceType + "\",");
                    sbFormula.append("\"" + f.getDataElementNumber() + "\",");
                    sbFormula.append("\"" + ValueTypeEnum.getEnum((int)f.getValueType()).getName() + "\",");
                    sbFormula.append("true,true,");
                    sbFormula.append("\"\",");
                    sbFormula.append("false,\"\")");
                    addNewList.add(new Object[]{name, sbFormula.toString(), 1, null, typeId});
                    range.setFormula(null);
                    range.setValue(new Variant((Object)("{%" + name + "%}")));
                }
            }
            if (!addNewList.isEmpty()) {
                HashMap params = new HashMap();
                params.put("addNewList", addNewList);
                params.put("modifyList", new ArrayList());
                params.put("deleteIds", new ArrayList());
                Map result = ReportNotesIndexFactory.getRemoteInstance().batchUpdate(params);
                if (result != null && result.containsKey("msg")) {
                    MsgBox.showDetailAndOK((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"1_dataError"), (String)result.get("msg").toString(), (int)1);
                    return;
                }
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"73_indexGenerSuccess"));
            }
        }
    }
}

