/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesIndexFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesIndexValueTypeEnum;
import com.kingdee.eas.fi.newrpt.rptnotes.client.AbstractReportNotesIndexListUI;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ReportNotesClientUtil;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.client.GroupTreecomponent;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ReportNotesIndexListUI
extends AbstractReportNotesIndexListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportNotesIndexListUI.class);
    protected String name = null;
    protected String formulasTxt = null;
    protected List<String> deleteIds = new ArrayList<String>();
    protected GroupTreecomponent treeComponent = null;
    protected String companyId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();

    public ReportNotesIndexListUI() throws Exception {
        this.treeComponent = new GroupTreecomponent((ListUI)this, this.treeView, DisplayTemplateTypeEnum.RPTNOTESINDEX);
        this.treeComponent.setTemplateTypeFieldString("displayIndexType.id");
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                int n = end;
                for (int i = begin; i <= n; ++i) {
                    if (ReportNotesIndexListUI.this.tblMain.getRow(i) == null || ReportNotesIndexListUI.this.isCanEdit(null, i)) continue;
                    ReportNotesIndexListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
                    ReportNotesIndexListUI.this.tblMain.getRow(i).getCell("name").getStyleAttributes().setLocked(true);
                    ReportNotesIndexListUI.this.tblMain.getRow(i).getCell("formulas").getStyleAttributes().setLocked(true);
                    ReportNotesIndexListUI.this.tblMain.getRow(i).getCell("description").getStyleAttributes().setLocked(true);
                    ReportNotesIndexListUI.this.tblMain.getRow(i).getCell("valueType").getStyleAttributes().setLocked(true);
                }
            }
        });
        this.tblMain.getScriptManager().setScriptDisabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTblMain();
        this.treeComponent.setRootDisplayName(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"54_notesIndex"));
        this.treeComponent.initialize();
        this.menuItemBatchMove.setVisible(true);
        this.menuItemBatchMove.setEnabled(true);
        this.menuItemBatchMove.setCustomAction((Action)this.treeComponent.getActionBatchMove());
    }

    protected void initTblMain() throws Exception {
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("formulas").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("valueType").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("name").setRequired(true);
        this.tblMain.getColumn("formulas").setRequired(true);
        this.tblMain.getColumn("valueType").setRequired(true);
        for (String key : new String[]{"companyName", "creator", "lastUpdateUser", "createTime", "lastUpdateTime"}) {
            this.tblMain.getColumn(key).getStyleAttributes().setBackground(Color.lightGray);
            this.tblMain.getColumn(key).getStyleAttributes().setLocked(true);
        }
        KDPromptBox prmtBoxC = new KDPromptBox();
        prmtBoxC.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 10));
        prmtBoxC.setEditable(true);
        prmtBoxC.setHistoryRecordEnabled(false);
        KDTDefaultCellEditor formulaEditorC = new KDTDefaultCellEditor((IKDEditor)prmtBoxC);
        this.tblMain.getColumn("formulas").setEditor((ICellEditor)formulaEditorC);
        KDComboBox cmbValueType = new KDComboBox();
        cmbValueType.addItems(RptNotesIndexValueTypeEnum.getEnumList().toArray());
        this.tblMain.getColumn("valueType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbValueType));
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getOldValue() != null && !e.getOldValue().equals(e.getValue()) || e.getOldValue() == null && e.getValue() != null) {
                    ReportNotesIndexListUI.this.cellChangeHandle(e.getRowIndex());
                }
            }
        });
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int valueType = -1;
                for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                    ICell cell = ReportNotesIndexListUI.this.tblMain.getCell(i, "valueType");
                    Object valueTypeObj = cell.getValue();
                    if (valueTypeObj instanceof BizEnumValueDTO) {
                        valueType = Integer.valueOf(((BizEnumValueDTO)valueTypeObj).getValue().toString());
                    } else if (valueTypeObj instanceof RptNotesIndexValueTypeEnum) {
                        valueType = ((RptNotesIndexValueTypeEnum)((Object)valueTypeObj)).getValue();
                    }
                    if (valueType == -1) continue;
                    cell.setValue((Object)RptNotesIndexValueTypeEnum.getEnum(valueType));
                }
            }
        });
        this.tblMain.addKeyListener(new KeyListener(){
            Map<Integer, String> tmpMap = new HashMap<Integer, String>();

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 86) {
                    this.tmpMap.clear();
                    int[] selectRows = KDTableUtil.getSelectedRows((KDTable)ReportNotesIndexListUI.this.tblMain);
                    IRow row = null;
                    for (int i : selectRows) {
                        row = ReportNotesIndexListUI.this.tblMain.getRow(i);
                        if (row.getCell("id").getValue() == null) continue;
                        this.tmpMap.put(i, ReportNotesIndexListUI.this.getRowKey(row));
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 86) {
                    int[] selectRows = KDTableUtil.getSelectedRows((KDTable)ReportNotesIndexListUI.this.tblMain);
                    IRow row = null;
                    for (int i : selectRows) {
                        row = ReportNotesIndexListUI.this.tblMain.getRow(i);
                        if (this.tmpMap.get(i) == null || this.tmpMap.get(i).equals(ReportNotesIndexListUI.this.getRowKey(row))) continue;
                        row.setUserObject((Object)handleType.modify);
                    }
                    this.tmpMap.clear();
                }
            }
        });
        this.actionQuery_actionPerformed(null);
        if (this.tblMain.getRowCount() <= 0) {
            for (int i = 0; i <= 5; ++i) {
                this.actionAddLine_actionPerformed(null);
            }
        }
    }

    protected String getRowKey(IRow row) {
        Object name = row.getCell("name").getValue();
        Object formulas = row.getCell("formulas").getValue();
        Object des = row.getCell("description").getValue();
        StringBuffer key = new StringBuffer();
        key.append(name == null ? null : name).append(formulas == null ? null : formulas);
        key.append(des == null ? null : des);
        return key.toString();
    }

    protected boolean isCanEdit(IRow row, int rowIndex) {
        Object createCompanyId = null;
        createCompanyId = row != null ? row.getCell("companyId").getValue() : this.tblMain.getCell(rowIndex, "companyId").getValue();
        return createCompanyId == null || createCompanyId.equals(this.companyId);
    }

    public void cellChangeHandle(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        if (row.getCell("id").getValue() != null) {
            if (!this.isCanEdit(row, -1)) {
                return;
            }
            row.setUserObject((Object)handleType.modify);
        } else {
            row.setUserObject((Object)handleType.addnew);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.treeComponent != null) {
            this.treeComponent.refreshTree();
            this.actionQuery_actionPerformed(e);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode;
        if (e != null) {
            try {
                ArrayList<Object[]> addNewList = new ArrayList<Object[]>();
                ArrayList<Object[]> modifyList = new ArrayList<Object[]>();
                this.getEditList(addNewList, modifyList);
                if (!(addNewList.isEmpty() && modifyList.isEmpty() && this.deleteIds.isEmpty() || MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"50_updateLost")) == 0)) {
                    return;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"error", (Throwable)ex);
                this.handleException(ex);
            }
        }
        this.name = this.kDIndexName.getText();
        this.formulasTxt = this.kDIndexFormula.getText();
        EntityViewInfo view = this.getMainQuery();
        if (view == null) {
            this.mainQuery = view = new EntityViewInfo();
        }
        view.setFilter(new FilterInfo());
        KDTree kdTree = this.treeView.getTree();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)kdTree.getLastSelectedPathComponent();
        if (treeNode != null && !treeNode.isRoot() && (selectedNode = this.treeComponent.getLastSelectedNode()) != null) {
            TemplateTypeInfo type = (TemplateTypeInfo)selectedNode.getUserObject();
            String typeId = type.getId().toString();
            HashSet<String> set = new HashSet<String>();
            set.add(type.getId().toString());
            this.treeComponent.search(type, set, "111111111111111111111111111=");
            StringBuffer buf = this.treeComponent.createIdBuffer(set);
            view.getFilter().getFilterItems().add(new FilterItemInfo("displayIndexType.id", (Object)buf.toString(), CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((String)this.name)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("REPORTNOTESINDEX.name", (Object)("%" + this.name + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)this.formulasTxt)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("REPORTNOTESINDEX.formulas", (Object)("%" + this.formulasTxt + "%"), CompareType.LIKE));
        }
        CslGradeManageUtil.filteData(view.getFilter(), "company.id", ((Object)((Object)this)).getClass().getName(), null);
        this.deleteIds.clear();
        this.refresh(e);
    }

    public void getEditList(List<Object[]> addNewList, List<Object[]> modifyList) throws Exception {
        String selectTreeNodes = this.treeComponent.getSelectedNodeKeyValue();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Object name = row.getCell("name").getValue();
            Object formulas = row.getCell("formulas").getValue();
            if (name == null || formulas == null) continue;
            Object valueTypeObj = row.getCell("valueType").getValue();
            int valueType = 1;
            if (valueTypeObj instanceof BizEnumValueDTO) {
                valueType = Integer.valueOf(((BizEnumValueDTO)valueTypeObj).getValue().toString());
            } else if (valueTypeObj instanceof RptNotesIndexValueTypeEnum) {
                valueType = ((RptNotesIndexValueTypeEnum)((Object)valueTypeObj)).getValue();
            }
            if (row.getUserObject() != null) {
                if (handleType.addnew.equals(row.getUserObject())) {
                    addNewList.add(new Object[]{name.toString().trim(), formulas.toString(), valueType, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null, selectTreeNodes});
                    continue;
                }
                if (!handleType.modify.equals(row.getUserObject())) continue;
                modifyList.add(new Object[]{row.getCell("id").getValue().toString(), name.toString().trim(), formulas.toString(), valueType, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null});
                continue;
            }
            if (row.getCell("id").getValue() != null) continue;
            addNewList.add(new Object[]{name.toString().trim(), formulas.toString(), valueType, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null, selectTreeNodes});
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkDup();
        ArrayList<Object[]> addNewList = new ArrayList<Object[]>();
        ArrayList<Object[]> modifyList = new ArrayList<Object[]>();
        this.getEditList(addNewList, modifyList);
        if (!(addNewList.isEmpty() && modifyList.isEmpty() && this.deleteIds.isEmpty())) {
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("addNewList", addNewList);
            params.put("modifyList", modifyList);
            params.put("deleteIds", this.deleteIds);
            Map result = ReportNotesIndexFactory.getRemoteInstance().batchUpdate(params);
            this.deleteIds.clear();
            if (result != null && result.containsKey("msg")) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"1_dataError"), (String)result.get("msg").toString(), (int)1);
                return;
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            this.actionQuery_actionPerformed(null);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"2_dataNotModify"));
        }
    }

    protected void checkDup() throws Exception {
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Object name = row.getCell("name").getValue();
            Object formulas = row.getCell("formulas").getValue();
            if (name != null && formulas != null) {
                if (name.toString().length() > 256) {
                    String checkNameLength = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"3_checkNameLength");
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(checkNameLength, i + 1));
                    SysUtil.abort();
                }
                if (formulas.toString().length() > 2000) {
                    String checkIndexLength = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"4_checkIndexLength");
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(checkIndexLength, i + 1));
                    SysUtil.abort();
                }
                if (row.getCell("description").getValue() != null && row.getCell("description").getValue().toString().length() > 2000) {
                    String checkDescLength = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"5_checkDescLength");
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(checkDescLength, i + 1));
                    SysUtil.abort();
                }
                if (nameMap.containsKey(name.toString())) {
                    String checkNameDup = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"6_checkNameDup");
                    msg.append(MessageFormat.format(checkNameDup, i + 1, nameMap.get(name.toString()))).append("\n");
                    continue;
                }
                nameMap.put(name.toString(), i + 1);
                continue;
            }
            if (name == null || StringUtils.isEmpty((String)name.toString())) {
                msg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"7_nameNull"), i + 1)).append("\n");
            }
            if (formulas != null && !StringUtils.isEmpty((String)formulas.toString())) continue;
            msg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"8_indexNull"), i + 1)).append("\n");
        }
        if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"1_dataError"), (String)msg.toString(), (int)1);
            SysUtil.abort();
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow(this.tblMain.getSelectManager().getActiveRowIndex());
        row.getCell("valueType").setValue((Object)RptNotesIndexValueTypeEnum.Amount);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow();
        row.getCell("valueType").setValue((Object)RptNotesIndexValueTypeEnum.Amount);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        int mode = 0;
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                Object obj = this.tblMain.getCell(i, "id").getValue();
                if (!this.isCanEdit(null, i)) continue;
                if (obj != null) {
                    this.deleteIds.add(obj.toString());
                }
                this.tblMain.removeRow(i);
            }
        } else {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            for (int i = selectRows.length - 1; i >= 0; --i) {
                Object obj = this.tblMain.getCell(selectRows[i], "id").getValue();
                if (!this.isCanEdit(null, selectRows[i])) continue;
                if (obj != null) {
                    this.deleteIds.add(obj.toString());
                }
                this.tblMain.removeRow(selectRows[i]);
            }
        }
    }

    public Object getClientValue(Object key) {
        Object obj = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), "formulas").getValue();
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
            if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                this.deleteIds.clear();
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReportNotesIndexFactory.getRemoteInstance();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            StringBuffer msg = new StringBuffer();
            ArrayList<Integer> deleteRowsForNoId = new ArrayList<Integer>();
            ArrayList<ObjectStringPK> deleteRowsForId = new ArrayList<ObjectStringPK>();
            if (selectRows != null && selectRows.length > 0) {
                IRow row = null;
                for (int i : selectRows) {
                    row = this.tblMain.getRow(i);
                    if (!this.isCanEdit(row, -1)) {
                        msg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"11_cantDelete"), i + 1)).append("\n");
                        continue;
                    }
                    if (row.getCell("id").getValue() == null) {
                        deleteRowsForNoId.add(i);
                        continue;
                    }
                    deleteRowsForId.add(new ObjectStringPK(row.getCell("id").getValue().toString()));
                }
            }
            if (msg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"10_indexCantDelete"), (String)msg.toString(), (int)1);
                return;
            }
            for (int i = deleteRowsForNoId.size() - 1; i >= 0; --i) {
                this.tblMain.removeRow(((Integer)deleteRowsForNoId.get(i)).intValue());
            }
            if (!deleteRowsForId.isEmpty()) {
                IObjectPK[] ids = new IObjectPK[deleteRowsForId.size()];
                ReportNotesIndexFactory.getRemoteInstance().deleteBatchData(deleteRowsForId.toArray(ids));
            }
            this.refresh(e);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        Object selectedObj = ReportNotesClientUtil.getSelectedKeyValue(this.tblMain, "name");
        super.refresh(e);
        if (selectedObj != null) {
            ReportNotesClientUtil.setSelectRow(this.tblMain, "name", selectedObj);
        }
        this.deleteIds.clear();
    }

    public boolean destroyWindow() {
        try {
            ArrayList<Object[]> addNewList = new ArrayList<Object[]>();
            ArrayList<Object[]> modifyList = new ArrayList<Object[]>();
            this.getEditList(addNewList, modifyList);
            if (!(addNewList.isEmpty() && modifyList.isEmpty() && this.deleteIds.isEmpty() || MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"9_confirmExit")) == 0)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            this.handleException(e);
        }
        return super.destroyWindow();
    }

    protected static enum handleType {
        addnew,
        modify;

    }
}

