/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.newrpt.CslMergeSoluInfo;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.newrpt.cslworktable.client.TemplateSelector;
import com.kingdee.eas.fi.newrpt.cslworktable.util.CslWorkTableUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesFacadeFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesTemplateInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.client.AbstractReportNotesListUI;
import com.kingdee.eas.fi.newrpt.rptnotes.client.FileHandle;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ProgressHandleImpl;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ProgressHandleInterface;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ReportNotesClientUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.client.ReportNotesDescriptionEditUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReportNotesListUI
extends AbstractReportNotesListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportNotesListUI.class);
    protected Map<String, Boolean> openedFiles_canEdit = new HashMap<String, Boolean>();
    protected Set<String> selectTmplates = new HashSet<String>();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSelectOrgBound.setSelected(true, false);
        this.chkIncludeChild.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ReportNotesListUI.this.chkIncludeChild_itemStateChanged(e);
                }
                catch (Exception exc) {
                    ReportNotesListUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.openRptNotes(false, false);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.openRptNotes(false, true);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelect = false;
        boolean isTemplate = false;
        int failCount = 0;
        int successCount = 0;
        StringBuffer detailMsg = new StringBuffer();
        StringBuffer canDel = new StringBuffer();
        IRow row = null;
        ReportNotesInfo info = null;
        String checkAudit = null;
        String checkCreate = null;
        String checkOpen = null;
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            isSelect = (Boolean)row.getCell("select").getValue();
            isTemplate = (Boolean)row.getUserObject();
            if (!isSelect) continue;
            if (!isTemplate) {
                info = this.getReportNotesInfo(row);
                if (AuditedStatusEnum.AUDITED.equals((Object)((AuditedStatusEnum)row.getCell("auditStatus").getValue()))) {
                    if (checkAudit == null) {
                        checkAudit = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"51_cantDelete");
                    }
                    detailMsg.append(this.getRptNoteString(info)).append(checkAudit).append("\n");
                    ++failCount;
                    continue;
                }
                String id = row.getCell("id").getValue().toString();
                if (this.openedFiles_canEdit.containsKey(id)) {
                    if (checkOpen == null) {
                        checkOpen = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"52_cantDelete");
                    }
                    detailMsg.append(this.getRptNoteString(info)).append(checkOpen).append("\n");
                    ++failCount;
                    continue;
                }
                ids.add(id);
                canDel.append(this.getRptNoteString(info)).append("\n");
                ++successCount;
                continue;
            }
            if (checkCreate == null) {
                checkCreate = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"32_cantCreate");
            }
            detailMsg.append("[").append(row.getCell("orgUnitName").getValue()).append("]").append(row.getCell("name").getValue()).append("(").append(row.getCell("templateNumber").getValue()).append(")").append(checkCreate).append("\n");
            ++failCount;
        }
        if (successCount <= 0) {
            if (detailMsg.length() >= 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"62_noSelectNote"), (String)detailMsg.toString(), (int)1);
            } else {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"62_noSelectNote"));
            }
            return;
        }
        canDel.insert(0, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"64_canDelete") + "\n");
        if (detailMsg.length() > 0) {
            canDel.append("\n").append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"65_cantdelete"));
            canDel.append("\n").append(detailMsg);
        }
        if (MsgBox.showConfirm3((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"63_deleteNotes"), successCount), (String)canDel.toString()) == 0) {
            successCount = 0;
            failCount = 0;
            detailMsg.setLength(0);
            for (String id : ids) {
                try {
                    ReportNotesClientUtil.handleMutexLock(this.getVOChangeListener(), id, (Component)((Object)this), true, false);
                    ReportNotesFactory.getRemoteInstance().delete((IObjectPK)new ObjectStringPK(id));
                    ReportNotesClientUtil.handleMutexLock(this.getVOChangeListener(), id, (Component)((Object)this), false, false);
                    ++successCount;
                }
                catch (Exception ex) {
                    logger.error((Object)("actionBatchAddRpt_actionPerformed error:" + (info != null ? info.toString() : null)), (Throwable)ex);
                    detailMsg.append(this.getRptNoteString(info)).append(ex.getMessage()).append("\n");
                    ++failCount;
                }
            }
            if (detailMsg.length() <= 0) {
                this.showSuccessMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"33_deleteSuccess"), successCount));
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"34_removeResult"), successCount, failCount), (String)detailMsg.toString(), (int)1);
            }
            this.refreshTable(null);
        }
    }

    protected String getRptNoteString(ReportNotesInfo info) {
        if (info != null) {
            StringBuffer str = new StringBuffer();
            str.append("[").append(info.getCompany().getName()).append("]");
            str.append(info.getName()).append("(").append(info.getNumber()).append(")");
            return str.toString();
        }
        return null;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelect = false;
        boolean isTemplate = false;
        int failCount = 0;
        int successCount = 0;
        StringBuffer erroMsg = new StringBuffer();
        IRow row = null;
        ReportNotesInfo info = null;
        String checkOpened = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            isSelect = (Boolean)row.getCell("select").getValue();
            isTemplate = (Boolean)row.getUserObject();
            if (!isSelect) continue;
            if (!isTemplate) {
                if (AuditedStatusEnum.UNAUDITED.equals((Object)((AuditedStatusEnum)row.getCell("auditStatus").getValue()))) {
                    info = this.getReportNotesInfo(row);
                    try {
                        String id = row.getCell("id").getValue().toString();
                        if (this.openedFiles_canEdit.containsKey(id) && this.openedFiles_canEdit.get(id).booleanValue()) {
                            if (checkOpened == null) {
                                checkOpened = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"35_openedCantAudit");
                            }
                            erroMsg.append(info.getName()).append("(").append(info.getNumber()).append(")").append(checkOpened).append("\n");
                            ++failCount;
                            continue;
                        }
                        Map result = ReportNotesFacadeFactory.getRemoteInstance().auditOrUnAudit((IObjectPK)new ObjectStringPK(id), new ReportNotesInfo().getBOSType().toString(), true);
                        ++successCount;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("actionBatchAddRpt_actionPerformed error:" + info.toString()), (Throwable)ex);
                        erroMsg.append(info.getName()).append("(").append(info.getNumber()).append(")").append(ex.getMessage()).append("\n");
                        ++failCount;
                    }
                    continue;
                }
                erroMsg.append(row.getCell("name").getValue()).append("(").append(row.getCell("templateNumber").getValue()).append(")").append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"17_temAudited")).append("\n");
                ++failCount;
                continue;
            }
            erroMsg.append(row.getCell("name").getValue()).append("(").append(row.getCell("templateNumber").getValue()).append(")").append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"36_unCreateCantAudit")).append("\n");
            ++failCount;
        }
        if (erroMsg.length() <= 0) {
            this.showSuccessMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"37_auditSuccess"), successCount));
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"38_auditResult"), successCount, failCount), (String)erroMsg.toString(), (int)1);
        }
        this.refreshTable(null);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelect = false;
        boolean isTemplate = false;
        int failCount = 0;
        int successCount = 0;
        StringBuffer erroMsg = new StringBuffer();
        IRow row = null;
        ReportNotesInfo info = null;
        String checkOpen = null;
        String checkAudit = null;
        String checkCreate = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            isSelect = (Boolean)row.getCell("select").getValue();
            isTemplate = (Boolean)row.getUserObject();
            if (!isSelect) continue;
            if (!isTemplate) {
                info = this.getReportNotesInfo(row);
                if (AuditedStatusEnum.AUDITED.equals((Object)((AuditedStatusEnum)row.getCell("auditStatus").getValue()))) {
                    try {
                        String id = row.getCell("id").getValue().toString();
                        if (this.openedFiles_canEdit.containsKey(id) && this.openedFiles_canEdit.get(id).booleanValue()) {
                            if (checkOpen == null) {
                                checkOpen = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"39_openedCantUnAudit");
                            }
                            erroMsg.append(info.getName()).append("(").append(info.getNumber()).append(")").append(checkOpen).append("\n");
                            ++failCount;
                            continue;
                        }
                        Map result = ReportNotesFacadeFactory.getRemoteInstance().auditOrUnAudit((IObjectPK)new ObjectStringPK(id), new ReportNotesInfo().getBOSType().toString(), false);
                        ++successCount;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("actionBatchAddRpt_actionPerformed error:" + info.toString()), (Throwable)ex);
                        erroMsg.append(info.getName()).append("(").append(info.getNumber()).append(")").append(ex.getMessage()).append("\n");
                        ++failCount;
                    }
                    continue;
                }
                if (checkAudit == null) {
                    checkAudit = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"27_notAudit");
                }
                erroMsg.append(row.getCell("name").getValue()).append("(").append(row.getCell("templateNumber").getValue()).append(")").append(checkAudit).append("\n");
                ++failCount;
                continue;
            }
            if (checkCreate == null) {
                checkCreate = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"40_unCreateCantUnAudit");
            }
            erroMsg.append(row.getCell("name").getValue()).append("(").append(row.getCell("templateNumber").getValue()).append(")").append(checkCreate).append("\n");
            ++failCount;
        }
        if (erroMsg.length() <= 0) {
            this.showSuccessMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"41_unAuditSuccess"), successCount));
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"42_unAuditResult"), successCount, failCount), (String)erroMsg.toString(), (int)1);
        }
        this.refreshTable(null);
    }

    public void closeFile(String id) throws Exception {
        if (this.openedFiles_canEdit.containsKey(id)) {
            boolean isCanEdit = this.openedFiles_canEdit.get(id);
            this.openedFiles_canEdit.remove(id);
            if (isCanEdit) {
                ReportNotesClientUtil.handleMutexLock(this.getVOChangeListener(), id, (Component)((Object)this), false);
            }
            this.openedFiles_canEdit.remove(id);
        }
    }

    @Override
    public boolean destroyWindow() {
        if (!this.openedFiles_canEdit.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"43_openedCantExit"));
            return false;
        }
        return super.destroyWindow();
    }

    protected void openRptNotes(boolean isMutClick, boolean isView) throws Exception {
        int i;
        IRow row = null;
        boolean isSelectTemplate = false;
        if (isMutClick) {
            row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (row.getCell("wordAttachId").getValue() == null || StringUtils.isEmpty((String)row.getCell("wordAttachId").getValue().toString())) {
                isSelectTemplate = true;
            }
        } else {
            IRow firstTemplateRow = null;
            isSelectTemplate = true;
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                row = this.tblMain.getRow(i);
                if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
                if (row.getCell("wordAttachId").getValue() != null && !StringUtils.isEmpty((String)row.getCell("wordAttachId").getValue().toString())) {
                    isSelectTemplate = false;
                    break;
                }
                if (firstTemplateRow != null) continue;
                firstTemplateRow = row;
            }
            if (isSelectTemplate) {
                row = firstTemplateRow;
            }
        }
        if (row == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"61_noSelectNotes"));
            return;
        }
        if (isSelectTemplate) {
            if (isView) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"84_viewCreaded"));
                return;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"60_selectTemplaet")) != 0) {
                return;
            }
            this.actionClearAll_actionPerformed(null);
            row.getCell("select").setValue((Object)true);
            String rowKey = this.getRowKey(row);
            this.batchAddNotesByProgress(1, false, true);
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                row = this.tblMain.getRow(i);
                if (!rowKey.equals(this.getRowKey(row))) continue;
                this.tblMain.getSelectManager().select(i, 0);
                this.tblMain.getLayoutManager().scrollRowToShow(i);
                break;
            }
        }
        if (row != null) {
            String dir;
            String wordAttachId;
            FileHandle fileHandle;
            String filePath;
            String id = row.getCell("id").getValue().toString();
            if (this.openedFiles_canEdit.containsKey(id)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"44_NotesOpened"));
                return;
            }
            boolean isEditOpen = AuditedStatusEnum.UNAUDITED.equals((Object)((AuditedStatusEnum)row.getCell("auditStatus").getValue()));
            if (row.getCell("wordAttachId") != null && row.getCell("wordAttachId").getValue() != null && !StringUtils.isEmpty((String)(filePath = (fileHandle = new FileHandle()).download(wordAttachId = row.getCell("wordAttachId").getValue().toString(), dir = System.getProperty("java.io.tmpdir"), isEditOpen, (Component)((Object)this))))) {
                try {
                    if (isEditOpen) {
                        ReportNotesClientUtil.handleMutexLock(this.getVOChangeListener(), id, (Component)((Object)this), true);
                    }
                    this.openedFiles_canEdit.put(id, isEditOpen);
                    ReportNotesClientUtil.openFile(filePath);
                    ReportNotesClientUtil.saveThread(filePath, id, row, isEditOpen, null, (Component)((Object)this), true);
                }
                catch (Exception ex) {
                    this.closeFile(id);
                }
                return;
            }
        }
    }

    @Override
    public void actionBatchAddRpt_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        boolean isSelect = false;
        boolean isTemplate = false;
        int workTotle = 0;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            isSelect = (Boolean)row.getCell("select").getValue();
            isTemplate = (Boolean)row.getUserObject();
            if (!isSelect) continue;
            if (isTemplate) {
                ++workTotle;
                continue;
            }
            row.getCell("select").setValue((Object)false);
        }
        if (workTotle <= 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"58_noSelectTemplate"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"59_selectTemplate"), workTotle)) != 0) {
            return;
        }
        this.batchAddNotesByProgress(workTotle, true, false);
    }

    protected void batchAddNotesByProgress(int workTotle, final boolean isShowInfo, boolean isSyn) throws Exception {
        ProgressHandleImpl progressHandleImpl = new ProgressHandleImpl();
        progressHandleImpl.setWorkTotle(workTotle);
        progressHandleImpl.setSyn(isSyn);
        progressHandleImpl.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"55_notesCreate"));
        ProgressHandleInterface progressHandleItf = new ProgressHandleInterface(){

            @Override
            public boolean batchProcess(ProgressHandleImpl progressHandle) {
                ReportNotesListUI.this.batchAdd(progressHandle);
                ReportNotesListUI.this.refreshTable(null);
                if (!isShowInfo && StringUtils.isEmpty((String)progressHandle.getErrorDetailResult())) {
                    progressHandle.setTotleResult(null);
                }
                return true;
            }
        };
        progressHandleImpl.progressHandle((CoreUI)this, progressHandleItf);
    }

    protected void batchAdd(ProgressHandleImpl progressHandle) {
        boolean isSelect = false;
        boolean isTemplate = false;
        int failCount = 0;
        int successCount = 0;
        int worked = 0;
        StringBuffer erroMsg = new StringBuffer();
        IRow row = null;
        ReportNotesInfo info = null;
        String handling = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"56_handling");
        StringBuffer monitorName = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            isSelect = (Boolean)row.getCell("select").getValue();
            isTemplate = (Boolean)row.getUserObject();
            if (!isSelect) continue;
            monitorName.setLength(0);
            monitorName.append(handling).append(worked + 1).append("/").append(progressHandle.getWorkTotle());
            monitorName.append("......[").append(row.getCell("name").getValue()).append("(").append(row.getCell("orgUnitName").getValue());
            monitorName.append(")]");
            progressHandle.setMonitorName(monitorName.toString());
            if (isTemplate) {
                info = this.getReportNotesInfo(row);
                try {
                    ReportNotesFactory.getRemoteInstance().addnew(info);
                    ++successCount;
                }
                catch (Exception ex) {
                    logger.error((Object)("actionBatchAddRpt_actionPerformed error:" + info.toString()), (Throwable)ex);
                    erroMsg.append(info.getName()).append("(").append(info.getNumber()).append(")");
                    if (ex instanceof BOSException) {
                        erroMsg.append(((BOSException)((Object)ex)).getCause().getMessage()).append("\n");
                    } else {
                        erroMsg.append(ex.getMessage()).append("\n");
                    }
                    ++failCount;
                }
            } else {
                erroMsg.append(row.getCell("name").getValue()).append("(").append(row.getCell("templateNumber").getValue()).append(")").append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"45_created")).append("\n");
                ++failCount;
            }
            progressHandle.setWorked(++worked);
        }
        if (erroMsg.length() <= 0) {
            progressHandle.setTotleResult(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"46_createSuccess"), successCount));
        } else {
            progressHandle.setErrorDetailResult(erroMsg.toString());
            progressHandle.setTotleResult(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"47_createResult"), successCount, failCount));
        }
    }

    protected ReportNotesInfo getReportNotesInfo(IRow row) {
        ReportNotesInfo info = new ReportNotesInfo();
        info.setOrgTreeNumber(row.getCell("orgTreeNumber").getValue().toString());
        info.setOrgUnitNumber(row.getCell("orgUnitNumber").getValue().toString());
        FullOrgUnitInfo companyInfo = new FullOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)row.getCell("orgUnitId").getValue().toString()));
        companyInfo.setName(row.getCell("orgUnitName").getValue().toString());
        companyInfo.setNumber(row.getCell("orgUnitNumber").getValue().toString());
        info.setCompany(companyInfo);
        info.setPeriodType((RptPeriodTypeEnum)this.periodType.getSelectedItem());
        info.setYear(this.year.getIntegerVlaue());
        info.setPeriod(this.period.getIntegerVlaue());
        info.setCurrency((CurrencyInfo)this.currencyCom.getSelectedItem());
        ReportNotesTemplateInfo templateInfo = new ReportNotesTemplateInfo();
        templateInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        info.setTemplate(templateInfo);
        info.setNumber(row.getCell("templateNumber").getValue().toString());
        info.setName(row.getCell("name").getValue().toString());
        return info;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.setTblMainSort(e);
            return;
        }
        if (e.getClickCount() == 2 && e.getButton() == 1 && e.getType() != 0) {
            this.openRptNotes(true, false);
        } else if (e.getButton() == 1 && e.getClickCount() == 1 && this.isCtrlPress) {
            this.tblMain.getEditManager().stopEditing();
            IRow row = this.tblMain.getRow(e.getRowIndex());
            boolean isSelect = (Boolean)row.getCell("select").getValue();
            row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
            this.tblMain.checkParsed();
        }
    }

    @Override
    protected Map getCondition() {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        if (this.btnSelectOrgBound.isSelected() && this.orgTreeF7.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)CslWorkTableUtil.getResourceString("7_OrgTreeCantNull", null));
            return condition;
        }
        if (!(this.unCreateRpt.isSelected() || this.creating.isSelected() || this.aduited.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)CslWorkTableUtil.getResourceString("7_SelectRptStatus", null));
            return condition;
        }
        if (this.treeMain.getLastSelectedPathComponent() == null) {
            return condition;
        }
        if (((KDTreeNode)this.treeMain.getLastSelectedPathComponent()).getTextColor().equals(Color.gray)) {
            this.tblMain.removeRows();
            return condition;
        }
        condition.put("isSelectOrgTree", this.btnSelectOrgBound.isSelected());
        if (this.btnSelectOrgBound.isSelected()) {
            condition.put("orgTreeNumber", ((OrgTreeInfo)this.orgTreeF7.getData()).getNumber());
            OrgStructureInfo orgInfo = (OrgStructureInfo)((KDTreeNode)this.treeMain.getLastSelectedPathComponent()).getUserObject();
            if (orgInfo != null) {
                if (this.chkIncludeChild.isSelected()) {
                    ArrayList<String> orgUnitNumbers = new ArrayList<String>();
                    orgUnitNumbers.add(orgInfo.getUnit().getNumber());
                    KDTreeNode curNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
                    int childCount = curNode.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        orgUnitNumbers.add(((OrgStructureInfo)((KDTreeNode)curNode.getChildAt(i)).getUserObject()).getUnit().getNumber());
                    }
                    condition.put("orgUnitNumbers", orgUnitNumbers);
                } else {
                    condition.put("orgUnitNumber", orgInfo.getUnit().getNumber());
                }
            }
            if (!this.selectTmplates.isEmpty()) {
                condition.put("groups", this.selectTmplates);
            }
        } else {
            Object obj = ((KDTreeNode)this.treeMain.getLastSelectedPathComponent()).getUserObject();
            if (obj != null && obj instanceof ReportNotesTemplateInfo) {
                condition.put("group", ((ReportNotesTemplateInfo)obj).getGroup());
            } else {
                this.tblMain.removeRows();
                return null;
            }
        }
        RptPeriodTypeEnum queryPeriodType = (RptPeriodTypeEnum)this.periodType.getSelectedItem();
        condition.put("periodType", queryPeriodType.getValue());
        condition.put("year", this.year.getIntegerVlaue());
        condition.put("period", this.period.getIntegerVlaue());
        CurrencyInfo currency = (CurrencyInfo)this.currencyCom.getSelectedItem();
        condition.put("currencyId", currency.getId().toString());
        condition.put("currencyName", currency.getName());
        condition.put("rptStatus", new Boolean[]{this.unCreateRpt.isSelected(), this.creating.isSelected(), this.aduited.isSelected(), this.commited.isSelected()});
        return condition;
    }

    @Override
    protected void refreshTable(String sortStr) {
        try {
            this.unCreateRptTxt.setText("0");
            this.creatingTxt.setText("0");
            this.auditedTxt.setText("0");
            Map conditions = this.getCondition();
            if (conditions != null && !conditions.isEmpty()) {
                if (!StringUtils.isEmpty((String)sortStr)) {
                    conditions.put("sortStr", sortStr);
                }
                Set<String> checkedKeys = this.getCheckedKeys();
                String selectKey = this.getSelectedKey();
                this.tblMain.removeRows();
                int[] statusStat = new int[]{0, 0, 0};
                List reports = ReportNotesFactory.getRemoteInstance().getRptNotes(conditions);
                if (reports != null && !reports.isEmpty()) {
                    this.tblMain.setRowCount(reports.size());
                    int colCount = this.tblMain.getColumnCount();
                    IRow row = null;
                    String columKey = null;
                    boolean isTemplate = false;
                    for (Object report : reports) {
                        if (((Map)report).get("templateNumber".toLowerCase()) != null && ((Map)report).get("rptType".toLowerCase()) != null && this.selectKeyList.contains(((Map)report).get("templateNumber".toLowerCase()).toString() + ((Map)report).get("rptType".toLowerCase()).toString())) {
                            ((Map)report).put("select", true);
                        }
                        row = this.tblMain.addRow();
                        isTemplate = ((Map)report).get("isTemplate".toLowerCase()).toString().equals("1");
                        for (int i = 0; i < colCount; ++i) {
                            columKey = this.tblMain.getColumnKey(i).toLowerCase();
                            if (this.key_Enum.containsKey(columKey) && ((Map)report).get(columKey) != null) {
                                row.getCell(i).setValue((Object)CslWorkTableUIUtil.getEnum((Class)this.key_Enum.get(columKey), Integer.valueOf(((Map)report).get(columKey).toString())));
                                continue;
                            }
                            if (this.key_Enum.containsKey(columKey + (isTemplate ? "1" : "0")) && ((Map)report).get(columKey) != null) {
                                row.getCell(i).setValue((Object)CslWorkTableUIUtil.getEnum((Class)this.key_Enum.get(columKey + (isTemplate ? "1" : "0")), Integer.valueOf(((Map)report).get(columKey).toString())));
                                continue;
                            }
                            row.getCell(i).setValue(((Map)report).get(columKey));
                        }
                        row.setUserObject((Object)isTemplate);
                        this.setRowColor(row, statusStat);
                    }
                    this.unCreateRptTxt.setText(String.valueOf(statusStat[0]));
                    this.creatingTxt.setText(String.valueOf(statusStat[1]));
                    this.auditedTxt.setText(String.valueOf(statusStat[2]));
                    this.setCheckAndSelectRowByKey(checkedKeys, selectKey);
                }
                this.tblMain.checkParsed();
                conditions.clear();
            }
        }
        catch (Exception e) {
            logger.error((Object)"refreshTable error", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        this.selectKeyList.clear();
    }

    @Override
    protected void refreshTreeAndTable(CslMergeSoluInfo soluInfo, KDBizPromptBox orgTreeF7, KDTree treeMain, KDTable tblMain, OrgTreeCollection orgTreeColl, Date rptDate, String selectOrgUnitNumber, ListUI owner, boolean isOrgF7Change, boolean isRptDataChange) throws Exception {
        if (this.btnSelectOrgBound.isSelected()) {
            CslWorkTableUIUtil.refreshOrgTreeAndOrgUnitTree(soluInfo, orgTreeF7, treeMain, tblMain, orgTreeColl, rptDate, selectOrgUnitNumber, owner, isOrgF7Change, isRptDataChange, false);
        } else {
            this.refreshTable(null);
        }
    }

    protected void refreshRptTree() throws Exception {
        Object selectObj;
        String selectId = null;
        if (this.treeMain.getLastSelectedPathComponent() != null && (selectObj = ((KDTreeNode)this.treeMain.getLastSelectedPathComponent()).getUserObject()) != null && selectObj instanceof ReportNotesTemplateInfo) {
            selectId = ((ReportNotesTemplateInfo)selectObj).getId().toString();
        }
        HashMap<String, Integer> condition = new HashMap<String, Integer>();
        RptPeriodTypeEnum queryPeriodType = (RptPeriodTypeEnum)this.periodType.getSelectedItem();
        condition.put("periodType", queryPeriodType.getValue());
        List templates = ReportNotesFacadeFactory.getRemoteInstance().getNotesTemplates(condition);
        KDTreeNode rootNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"77_rpt"));
        rootNode.setUserObject(null);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
        this.treeMain.setModel((TreeModel)model);
        KDTreeNode childNode = null;
        KDTreeNode selectNode = null;
        for (Object obj : templates) {
            ReportNotesTemplateInfo info = (ReportNotesTemplateInfo)obj;
            childNode = new KDTreeNode((Object)info);
            childNode.setText("[ " + info.getNumber() + " ] " + info.getName());
            rootNode.add((MutableTreeNode)childNode);
            if (selectId == null || !selectId.equals(info.getId().toString())) continue;
            selectNode = childNode;
        }
        this.treeMain.repaint();
        this.treeMain.expandAllNodes(true, (TreeNode)rootNode);
        if (selectNode != null) {
            this.treeMain.setSelectionNode(selectNode);
        } else {
            this.treeMain.setSelectionRow(0);
        }
    }

    @Override
    protected void setRowColor(IRow row, int[] statusStat) throws Exception {
        int index = -1;
        if (((Boolean)row.getUserObject()).booleanValue()) {
            row.getStyleAttributes().setBackground(this.unCreateRptTxt.getCustomBackgroundColor());
            index = 0;
        } else if (AuditedStatusEnum.UNAUDITED.equals((Object)((AuditedStatusEnum)row.getCell("auditStatus").getValue()))) {
            row.getStyleAttributes().setBackground(this.creatingTxt.getCustomBackgroundColor());
            index = 1;
        } else if (AuditedStatusEnum.AUDITED.equals((Object)((AuditedStatusEnum)row.getCell("auditStatus").getValue()))) {
            row.getStyleAttributes().setBackground(this.auditedTxt.getCustomBackgroundColor());
            index = 2;
        }
        if (index > -1 && statusStat != null) {
            statusStat[index] = statusStat[index] + 1;
        }
    }

    @Override
    protected void initOrgTree() throws Exception {
        if (this.solutionF7.getValue() != null) {
            this.orgTreeF7.setEnabled(false);
        } else {
            if (this.orgUnionf7 == null) {
                this.orgUnionf7 = new MnsUnionF7((IUIObject)this);
                this.orgUnionf7.setShowAssistantOrg(true);
                this.orgUnionf7.setCheckedAssistantOrgChkBox(true);
                this.orgUnionf7.setEnableCurOrgTreeRootNode(true);
                this.orgUnionf7.setMultiSelect(false);
                this.orgUnionf7.setSelectMode(2);
                this.orgUnionf7.setCascadingSelection(false);
                HashSet selectOrgIdSet = new HashSet();
                this.orgUnionf7.setCheckedOrgIDs(selectOrgIdSet);
                this.orgUnionf7.setUnChangeableOrgIDs(selectOrgIdSet);
                if (this.orgTreeColl == null) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                ReportNotesListUI.this.orgUnionf7.setCanStart(false);
                                ReportNotesListUI.this.orgTreeColl = CslWorkTableUIUtil.getAllOrgTreeColl();
                                ReportNotesListUI.this.isOrgTreeCollInited = true;
                                ReportNotesListUI.this.orgUnionf7.setOrgTreeColl(CslWorkTableUIUtil.getOrgTreeColl(ReportNotesListUI.this.orgTreeColl, (Date)ReportNotesListUI.this.rptDate.getValue()));
                                ReportNotesListUI.this.orgUnionf7.initUI();
                                ReportNotesListUI.this.orgUnionf7.reRoadOrgTree();
                            }
                            catch (Exception e) {
                                logger.error((Object)"getOrgTreeCollection error", (Throwable)e);
                            }
                            finally {
                                ReportNotesListUI.this.isOrgTreeCollInited = true;
                                ReportNotesListUI.this.orgUnionf7.setCanStart(true);
                            }
                        }
                    }.start();
                }
            }
            this.orgTreeF7.setSelector((KDPromptSelector)this.orgUnionf7);
            this.orgTreeF7.setEditable(false);
            this.orgTreeF7.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    if (ReportNotesListUI.this.orgTreeF7.getValue() != null) {
                        if (ReportNotesListUI.this.orgTreeF7.getData() instanceof FullOrgUnitInfo) {
                            ReportNotesListUI.this.curOrgUnitInfo = (FullOrgUnitInfo)ReportNotesListUI.this.orgTreeF7.getData();
                            OrgTreeInfo curOrgInfo = ReportNotesListUI.this.orgUnionf7.getSelectedTree();
                            if (ReportNotesListUI.this.curOrgTreeInfo != null && !ReportNotesListUI.this.curOrgTreeInfo.getId().toString().equals(curOrgInfo.getId().toString())) {
                                ReportNotesListUI.this.templateF7.setValue(null);
                            }
                            ReportNotesListUI.this.curOrgTreeInfo = curOrgInfo;
                            ReportNotesListUI.this.orgTreeF7.setData((Object)ReportNotesListUI.this.curOrgTreeInfo);
                            try {
                                while (!ReportNotesListUI.this.isOrgTreeCollInited) {
                                    Thread.sleep(10L);
                                }
                                CslWorkTableUIUtil.refreshOrgTreeAndOrgUnitTree(ReportNotesListUI.this.curSoluInfo, ReportNotesListUI.this.orgTreeF7, ReportNotesListUI.this.treeMain, ReportNotesListUI.this.tblMain, ReportNotesListUI.this.orgTreeColl, (Date)ReportNotesListUI.this.rptDate.getValue(), ReportNotesListUI.this.curOrgUnitInfo != null ? ReportNotesListUI.this.curOrgUnitInfo.getNumber() : null, ReportNotesListUI.this.getCurUIObject(), true, false, false);
                                if (((DefaultTreeModel)ReportNotesListUI.this.treeMain.getModel()).getRoot() != null) {
                                    ReportNotesListUI.this.treeMain.expandAllNodes(true, (TreeNode)((KDTreeNode)((DefaultTreeModel)ReportNotesListUI.this.treeMain.getModel()).getRoot()));
                                }
                            }
                            catch (Exception e1) {
                                logger.error((Object)"year.addChangeListener", (Throwable)e1);
                                ExceptionHandler.handle((Throwable)e1);
                            }
                        } else if (ReportNotesListUI.this.orgTreeF7.getData() instanceof OrgTreeInfo) {
                            ReportNotesListUI.this.curOrgTreeInfo = (OrgTreeInfo)ReportNotesListUI.this.orgTreeF7.getData();
                        }
                        if (ReportNotesListUI.this.orgTreeF7.getData() != null && ReportNotesListUI.this.orgUnionf7 != null) {
                            ReportNotesListUI.this.orgUnionf7.setCurrOrgTree((OrgTreeInfo)ReportNotesListUI.this.orgTreeF7.getData());
                        }
                    } else {
                        ReportNotesListUI.this.curOrgUnitInfo = null;
                        ReportNotesListUI.this.curOrgTreeInfo = null;
                        ((DefaultTreeModel)ReportNotesListUI.this.treeMain.getModel()).setRoot(null);
                        ReportNotesListUI.this.tblMain.removeRows();
                    }
                }
            });
        }
    }

    @Override
    public void actionAddDescription_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelect = false;
        boolean isTemplate = false;
        boolean hasSelect = false;
        this.tblMain.getEditManager().stopEditing();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            isSelect = (Boolean)this.tblMain.getRow(i).getCell("select").getValue();
            isTemplate = (Boolean)this.tblMain.getRow(i).getUserObject();
            if (!isSelect || isTemplate) continue;
            hasSelect = true;
            String name = this.tblMain.getRow(i).getCell("name").getValue().toString().trim();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.tblMain.getRow(i).getCell("id").getValue().toString());
            uiContext.put((Object)"name", (Object)name);
            uiContext.put((Object)"description", this.tblMain.getRow(i).getCell("description").getValue());
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            IUIWindow window = uiFactory.create(ReportNotesDescriptionEditUI.class.getName(), (Map)uiContext);
            ((UINewFrame)window).setResizable(false);
            window.show();
            return;
        }
        if (!hasSelect) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"76_selectRpt"));
            this.abort();
        }
    }

    @Override
    protected void initTemplateF7Filter() throws Exception {
        this.templateF7.setSelector((KDPromptSelector)new TemplateSelector(this, "com.kingdee.eas.fi.newrpt.rptnotes.RptNotesTemplateDisF7Query"));
        this.templateF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (ReportNotesListUI.this.templateF7.getData() != null) {
                    if (ReportNotesListUI.this.templateF7.getData() instanceof Object[]) {
                        ReportNotesListUI.this.selectTmplates.clear();
                        StringBuffer sb = new StringBuffer();
                        for (Object obj : (Object[])ReportNotesListUI.this.templateF7.getData()) {
                            if (sb.length() > 1) {
                                sb.append(";");
                            }
                            sb.append(((ReportNotesTemplateInfo)obj).getName());
                            ReportNotesListUI.this.selectTmplates.add(((ReportNotesTemplateInfo)obj).getGroup());
                        }
                        ReportNotesListUI.this.templateF7.setData((Object)sb.toString());
                    }
                } else {
                    ReportNotesListUI.this.selectTmplates.clear();
                }
            }
        });
    }

    @Override
    public void getTemplateF7EntityView(EntityViewInfo view) throws Exception {
        if (this.curOrgTreeInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)CslWorkTableUtil.getResourceString("6_selectOrgTree", null));
            return;
        }
        if (view.getFilter() == null) {
            view.setFilter(new FilterInfo());
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("isFreezed", (Object)0));
        view.getFilter().getFilterItems().add(new FilterItemInfo("periodType", (Object)((RptPeriodTypeEnum)this.periodType.getSelectedItem()).getValue()));
        if (this.curOrgTreeInfo != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("RPTNOTESTEMPLATEDISPENSE.orgTreeNumber", (Object)this.curOrgTreeInfo.getNumber()));
        }
    }

    @Override
    protected void btnSelectOrgBound_actionPerformed(ActionEvent e) throws Exception {
        boolean isOrgBoundSelect = this.btnSelectOrgBound.isSelected();
        if (isOrgBoundSelect) {
            this.klcOrgTree.setEnabled(isOrgBoundSelect);
            this.btnSelectReport.setSelected(!isOrgBoundSelect, false);
            this.templateF7.setEnabled(isOrgBoundSelect);
            this.refreshTreeAndTable(null, this.orgTreeF7, this.treeMain, this.tblMain, this.orgTreeColl, (Date)this.rptDate.getValue(), null, (ListUI)this, true, true);
            this.chkIncludeChild.setEnabled(isOrgBoundSelect);
            this.chkIncludeChild.setSelected(isOrgBoundSelect);
        } else {
            this.btnSelectReport.setSelected(true, false);
            this.btnSelectReport_actionPerformed(null);
        }
    }

    @Override
    protected void btnSelectReport_actionPerformed(ActionEvent e) throws Exception {
        boolean isRptSelected = this.btnSelectReport.isSelected();
        if (isRptSelected) {
            this.klcOrgTree.setEnabled(!isRptSelected);
            this.chkIncludeChild.setEnabled(!isRptSelected);
            this.chkIncludeChild.setSelected(!isRptSelected, false);
            this.btnSelectOrgBound.setSelected(!isRptSelected, false);
            this.templateF7.setValue(null);
            this.templateF7.setEnabled(!isRptSelected);
            this.refreshRptTree();
            this.tblMain.removeRows();
        } else {
            this.btnSelectOrgBound.setSelected(true, false);
            this.btnSelectOrgBound_actionPerformed(null);
        }
    }

    @Override
    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        if (this.btnSelectOrgBound.isSelected()) {
            this.refreshTable(null);
        }
    }

    @Override
    protected void initSolut() throws Exception {
    }

    protected Set<String> getCheckedKeys() {
        int rowCount = this.tblMain.getRowCount();
        HashSet<String> keys = new HashSet<String>();
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            keys.add(this.getRowKey(row));
        }
        return keys;
    }

    protected String getRowKey(IRow row) {
        return row.getCell("orgUnitNumber").getValue().toString() + row.getCell("templateNumber").getValue().toString();
    }

    protected String getSelectedKey() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows != null && selectRows.length > 0) {
            IRow row = this.tblMain.getRow(selectRows[0]);
            return row.getCell("orgUnitNumber").getValue().toString() + row.getCell("templateNumber").getValue().toString();
        }
        return null;
    }

    protected void setCheckAndSelectRowByKey(Set<String> checkedKeys, String selectKey) {
        if (checkedKeys != null && !checkedKeys.isEmpty()) {
            int rowCount = this.tblMain.getRowCount();
            IRow row = null;
            String key = null;
            for (int i = 0; i < rowCount; ++i) {
                row = this.tblMain.getRow(i);
                key = row.getCell("orgUnitNumber").getValue().toString() + row.getCell("templateNumber").getValue().toString();
                if (key.equals(selectKey)) {
                    this.tblMain.getSelectManager().select(i, 0);
                    this.tblMain.getLayoutManager().scrollRowToShow(i);
                }
                if (!checkedKeys.contains(key)) continue;
                row.getCell("select").setValue((Object)true);
            }
        }
    }

    @Override
    protected void initGroupButton() {
        this.treeView.getControlPane().show();
        this.treeView.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"72_orgunit"));
        int count = this.treeView.getControlPane().getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (i <= 0 || i == count - 1 || i == count - 5 || i == count - 6) continue;
            this.treeView.getControlPane().getComponent(i).setVisible(false);
        }
    }
}

