/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.rptnotes.client.AbstractReportNotesTemplateFilterUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class ReportNotesTemplateFilterUI
extends AbstractReportNotesTemplateFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportNotesTemplateFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        this.comboPeriodType.insertItemAt((Object)selectAll, 0);
        this.reSetUI();
    }

    protected void reSetUI() {
        this.comboPeriodType.setSelectedIndex(0);
        this.txtNumber.setText("");
        this.txtName.setText("");
        this.chkIsAudited.setSelected(false);
        this.chkIsFreezed.setSelected(false);
        this.chkIncludeHis.setSelected(false);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItem;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        if (this.comboPeriodType.getSelectedItem() != null && this.comboPeriodType.getSelectedIndex() != 0) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            FilterItemInfo filterItemPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemPeriodType);
            ++formulaIndex;
        }
        if (this.txtNumber.getText() != null && this.txtNumber.getText().trim().length() > 0) {
            FilterItemInfo filterItemNumber = new FilterItemInfo("number", (Object)("%" + this.txtNumber.getText().trim() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(filterItemNumber);
            ++formulaIndex;
        }
        if (this.txtName.getText() != null && this.txtName.getText().trim().length() > 0) {
            FilterItemInfo filterItemName = new FilterItemInfo("name", (Object)("%" + this.txtName.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(filterItemName);
            ++formulaIndex;
        }
        if (this.chkIsAudited.isSelected()) {
            FilterItemInfo filterItemIsAudited = new FilterItemInfo("auditedStatus", (Object)new Integer(AuditedStatusEnum.AUDITED.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemIsAudited);
            ++formulaIndex;
        }
        if (!this.chkIsFreezed.isSelected()) {
            filterItem = new FilterItemInfo("isFreezed", (Object)Boolean.FALSE);
            this.filterInfo.getFilterItems().add(filterItem);
            ++formulaIndex;
        }
        filterItem = null;
        filterItem = !this.chkIncludeHis.isSelected() ? new FilterItemInfo("versionStatus", (Object)2, CompareType.NOTEQUALS) : new FilterItemInfo("versionStatus", (Object)100, CompareType.NOTEQUALS);
        this.filterInfo.getFilterItems().add(filterItem);
        ++formulaIndex;
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < formulaIndex; ++i) {
            if (i == 0) {
                sbFormula.append(" (#0)");
                continue;
            }
            sbFormula.append(" and (#" + i + ")");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo view) {
        this.reSetUI();
        super.loadData(view);
        FilterItemCollection fic = view.getFilter() == null ? new FilterItemCollection() : view.getFilter().getFilterItems();
        boolean isPeriodTypeExist = false;
        boolean hasFreezedField = true;
        for (int i = 0; i < fic.size(); ++i) {
            FilterItemInfo filterItemInfo = fic.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                Integer periodTypeInt = (Integer)filterItemInfo.getCompareValue();
                RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)periodTypeInt);
                this.comboPeriodType.setSelectedItem((Object)periodType);
                isPeriodTypeExist = true;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("name")) {
                String name = (String)filterItemInfo.getCompareValue();
                if (name.startsWith("%")) {
                    name = name.substring(1);
                }
                if (name.endsWith("%")) {
                    name = name.substring(0, name.length() - 1);
                }
                this.txtName.setText(name);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (number.startsWith("%")) {
                    number = number.substring(1);
                }
                if (number.endsWith("%")) {
                    number = number.substring(0, number.length() - 1);
                }
                this.txtNumber.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditedStatus")) {
                Integer intAuditStatus = (Integer)filterItemInfo.getCompareValue();
                if (AuditedStatusEnum.getEnum((int)intAuditStatus).equals((Object)AuditedStatusEnum.AUDITED)) {
                    this.chkIsAudited.setSelected(true);
                    continue;
                }
                this.chkIsAudited.setSelected(false);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isFreezed")) {
                hasFreezedField = false;
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("versionStatus")) continue;
            int versionStatus = (Integer)filterItemInfo.getCompareValue();
            this.chkIncludeHis.setSelected(versionStatus == 100);
        }
        this.chkIsFreezed.setSelected(hasFreezedField);
        if (!isPeriodTypeExist) {
            this.comboPeriodType.setSelectedIndex(0);
        }
    }

    public void clear() {
        super.clear();
        this.reSetUI();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

