/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.client.DynaHeadItem;
import com.kingdee.eas.fi.gr.dynamic.util.TextFieldPlainDocument;
import com.kingdee.eas.fi.newrpt.rptnotes.IRptNotesDynaDataScheme;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeItemCollection;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesDynaDataSchemeItemInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.RptNotesUnionDataTypeEnum;
import com.kingdee.eas.fi.newrpt.rptnotes.client.AbstractRptNotesDynaDataSchemeEditUI;
import com.kingdee.eas.fi.newrpt.rptnotes.sortEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class RptNotesDynaDataSchemeEditUI
extends AbstractRptNotesDynaDataSchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RptNotesDynaDataSchemeEditUI.class);
    private ArrayList dynaItemList = new ArrayList();
    private final String SOURCE_PATH = "com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource";
    private final String SEQ = "seq";
    private final String ITEMNUMBER = "itemNumber";
    private final String ITEMNAME = "itemName";
    private final String DATAELEMENT = "dataElement";
    private final String VALUETYPE = "valueType";
    private final String SORTRULE = "sortRule";
    private final String SORTTYPE = "sortType";
    private final String SHOWROWCOUNT = "showRowCount";
    private final String ISSHOWSUM = "isShowSum";

    public void onLoad() throws Exception {
        this.menuAndToolBtnInstall();
        this.initControlListener();
        this.kdtItems.checkParsed();
        this.kdtRules.checkParsed();
        this.kdtItems.getStyleAttributes().setLocked(true);
        KDCheckBox kdCbIsShowSum = new KDCheckBox();
        this.kdtRules.getColumn("isShowSum").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kdCbIsShowSum));
        KDComboBox sortRuleCom = new KDComboBox();
        this.kdtRules.getColumn("sortRule").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)sortRuleCom));
        KDComboBox sortTypeCom = new KDComboBox();
        sortTypeCom.addItem((Object)sortEnum.NoSort);
        sortTypeCom.addItem((Object)sortEnum.Asc);
        sortTypeCom.addItem((Object)sortEnum.Desc);
        this.kdtRules.getColumn("sortType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)sortTypeCom));
        KDTextField showRowCountTxf = new KDTextField();
        TextFieldPlainDocument limitNumberDocument = new TextFieldPlainDocument();
        limitNumberDocument.setMaxLen(7);
        showRowCountTxf.setDocument((Document)limitNumberDocument);
        this.kdtRules.getColumn("showRowCount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)showRowCountTxf));
        super.onLoad();
        if ("EDIT".equals(this.getOprtState())) {
            this.actionEdit.setEnabled(false);
        }
    }

    private void initControlListener() {
        this.kdcbConsolidation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSselected = RptNotesDynaDataSchemeEditUI.this.kdcbConsolidation.isSelected();
                RptNotesDynaDataSchemeEditUI.this.changeDataType("kdcbConsolidation", isSselected);
            }
        });
        this.kdcbSum.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSelected = RptNotesDynaDataSchemeEditUI.this.kdcbConsolidation.isSelected();
                RptNotesDynaDataSchemeEditUI.this.changeDataType("kdcbSum", isSelected);
            }
        });
    }

    private void changeDataType(String kdCheckBoxName, boolean isSselected) {
        block9: {
            int i;
            block8: {
                int i2;
                if (!"kdcbConsolidation".equals(kdCheckBoxName)) break block8;
                ChangeListener[] changeListeners = this.kdcbSum.getChangeListeners();
                for (i2 = 0; i2 < changeListeners.length; ++i2) {
                    this.kdcbSum.removeChangeListener(changeListeners[i2]);
                }
                if (isSselected) {
                    this.kdcbSum.setSelected(false);
                } else {
                    this.kdcbSum.setSelected(true);
                }
                for (i2 = 0; i2 < changeListeners.length; ++i2) {
                    this.kdcbSum.addChangeListener(changeListeners[i2]);
                }
                break block9;
            }
            if (!"kdcbSum".equals(kdCheckBoxName)) break block9;
            ChangeListener[] changeListeners = this.kdcbConsolidation.getChangeListeners();
            for (i = 0; i < changeListeners.length; ++i) {
                this.kdcbConsolidation.removeChangeListener(changeListeners[i]);
            }
            if (isSselected) {
                this.kdcbConsolidation.setSelected(false);
            } else {
                this.kdcbConsolidation.setSelected(true);
            }
            for (i = 0; i < changeListeners.length; ++i) {
                this.kdcbConsolidation.addChangeListener(changeListeners[i]);
            }
        }
    }

    private void menuAndToolBtnInstall() {
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuBiz.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initControls();
        this.iniItems();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getCompany().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    private void initControls() {
        RptNotesUnionDataTypeEnum unionDataType = this.editData.getUnionDataType();
        if (unionDataType != null && 2 == unionDataType.getValue()) {
            this.kdcbSum.setSelected(true);
            this.editData.setUnionDataType(RptNotesUnionDataTypeEnum.SUM_DATA);
        } else {
            this.kdcbConsolidation.setSelected(true);
            this.editData.setUnionDataType(RptNotesUnionDataTypeEnum.CONSOLIDATION_DATA);
        }
        if (!"ADDNEW".equals(this.getOprtState())) {
            if (this.editData.isIsByName()) {
                this.kDButtonGroup.setValue(0);
            } else {
                this.kDButtonGroup.setValue(1);
            }
        } else {
            this.kDButtonGroup.setValue(0);
        }
    }

    private void iniItems() {
        this.kdtItems.removeRows();
        this.kdtRules.removeRows();
        IRow addRow = this.kdtRules.addRow();
        addRow.getCell("isShowSum").setValue((Object)this.editData.isIsShowSum());
        int showRowCount = this.editData.getShowRowCount();
        if (showRowCount > 0 || showRowCount == 0 && !"ADDNEW".equals(this.getOprtState())) {
            addRow.getCell("showRowCount").setValue((Object)showRowCount);
        }
        RptNotesDynaDataSchemeItemCollection items = this.editData.getItems();
        items.sort("seq");
        if (items.isEmpty()) {
            addRow.getCell("sortType").setValue((Object)sortEnum.NoSort);
        } else {
            RptNotesDynaDataSchemeItemInfo rDataSchemeItemInfo;
            sortEnum sEnum = sortEnum.NoSort;
            String sortType = null;
            HashMap<String, RPTItemInfo> itemNumberMap = new HashMap<String, RPTItemInfo>();
            for (int i = 0; i < items.size(); ++i) {
                rDataSchemeItemInfo = items.get(i);
                RPTItemInfo rptItemInfo = new RPTItemInfo();
                rptItemInfo.setNumber(rDataSchemeItemInfo.getItemNumber());
                rptItemInfo.setName((String)rDataSchemeItemInfo.get("rptitemname"));
                rDataSchemeItemInfo.remove("rptitemname");
                itemNumberMap.put(rDataSchemeItemInfo.getItemNumber(), rptItemInfo);
            }
            if (!itemNumberMap.isEmpty()) {
                for (int i = 0; i < items.size(); ++i) {
                    IRow row = this.kdtItems.addRow();
                    rDataSchemeItemInfo = items.get(i);
                    String itemNumber = rDataSchemeItemInfo.getItemNumber();
                    RPTItemInfo rInfo = (RPTItemInfo)itemNumberMap.get(itemNumber);
                    String itemName = rInfo.getName();
                    int dataElement = rDataSchemeItemInfo.getDataElement();
                    DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((int)dataElement);
                    ValueTypeEnum valueType = rDataSchemeItemInfo.getValueType();
                    if (sortType == null && "0" != rDataSchemeItemInfo.getSortType().getValue()) {
                        sEnum = rDataSchemeItemInfo.getSortType();
                        sortType = itemName + "/" + dataElementInfo.getName() + "/" + valueType;
                    }
                    row.getCell("itemNumber").setValue((Object)itemNumber);
                    row.getCell("itemNumber").setUserObject((Object)rInfo);
                    row.getCell("itemName").setValue((Object)itemName);
                    row.getCell("dataElement").setValue((Object)dataElementInfo.getName());
                    row.getCell("dataElement").setUserObject((Object)dataElementInfo);
                    row.getCell("valueType").setValue((Object)valueType);
                }
            }
            addRow.getCell("sortType").setValue((Object)sEnum);
            this.resetSortRule();
            if (sortType != null) {
                addRow.getCell("sortRule").setValue(sortType);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.kdcbConsolidation.isSelected()) {
            this.editData.setUnionDataType(RptNotesUnionDataTypeEnum.CONSOLIDATION_DATA);
        } else if (this.kdcbSum.isSelected()) {
            this.editData.setUnionDataType(RptNotesUnionDataTypeEnum.SUM_DATA);
        }
        this.editData.setIsByName(this.byName.isSelected());
        IRow sortRuleRow = this.kdtRules.getRow(0);
        Boolean isShowSum = (Boolean)sortRuleRow.getCell("isShowSum").getValue();
        this.editData.setIsShowSum(isShowSum);
        Object showRowCount = sortRuleRow.getCell("showRowCount").getValue();
        if (showRowCount != null) {
            if (showRowCount instanceof Integer) {
                this.editData.setShowRowCount((Integer)showRowCount);
            } else if (!StringUtils.isEmpty((String)((String)showRowCount))) {
                this.editData.setShowRowCount(Integer.parseInt((String)showRowCount));
            }
        } else if (!"ADDNEW".equals(this.getOprtState()) && showRowCount == null) {
            this.editData.setShowRowCount(-1);
        }
        this.editData.setSyncOldValue(true);
        FullOrgUnitInfo foInfo = new FullOrgUnitInfo();
        foInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setCompany(foInfo);
        String sortRule = null;
        sortEnum sortType = (sortEnum)((Object)sortRuleRow.getCell("sortType").getValue());
        if (!"0".equals(sortType.getValue())) {
            sortRule = (String)sortRuleRow.getCell("sortRule").getValue();
        }
        RptNotesDynaDataSchemeItemCollection items = this.editData.getItems();
        items.clear();
        int rowCount = this.kdtItems.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String sortRuleFlag = (String)this.kdtItems.getRow(i).getCell("seq").getUserObject();
            String itemNumber = (String)this.kdtItems.getRow(i).getCell("itemNumber").getValue();
            DataElementInfo daElementInfo = (DataElementInfo)this.kdtItems.getRow(i).getCell("dataElement").getUserObject();
            RptNotesDynaDataSchemeItemInfo rpItemInfo = new RptNotesDynaDataSchemeItemInfo();
            rpItemInfo.setSeq(i + 1);
            rpItemInfo.setItemNumber(itemNumber);
            rpItemInfo.setDataElement(daElementInfo.getInterSeq());
            rpItemInfo.setValueType((ValueTypeEnum)this.kdtItems.getRow(i).getCell("valueType").getValue());
            if (sortRule != null && sortRule.equals(sortRuleFlag)) {
                rpItemInfo.setSortType(sortType);
            } else {
                rpItemInfo.setSortType(sortEnum.NoSort);
            }
            rpItemInfo.setScheme(this.editData);
            this.editData.getItems().add(rpItemInfo);
        }
        this.editData.setSyncOldValue(false);
    }

    public void verifyData() throws Exception {
        super.verifyData();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"80_number_not_blank"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"81_name_not_blank"));
            SysUtil.abort();
        }
        if (this.editData.getItems().isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"82_items_not_blank"));
            SysUtil.abort();
        }
    }

    @Override
    protected void kbtnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnAddNew_actionPerformed(e);
        this.bindingDynaItemListFromTable(this.dynaItemList, this.kdtItems);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"DynaHeadItemList", (Object)this.dynaItemList);
        uiContext.put((Object)"ID", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gr.dynamic.client.AddDynaItemUI", (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.bindingDynaItemListToTable(this.dynaItemList, this.kdtItems);
        this.kdtRules.getRow(0).getCell("sortRule").setValue(null);
        this.resetSortRule();
    }

    @Override
    protected void kbtnMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnMoveUp_actionPerformed(e);
        this.checkSelected(this.kdtItems);
        ArrayList list = this.getSelectedRows(this.kdtItems);
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = 0; i < index.length; ++i) {
            int curIndex = (Integer)index[i];
            if (curIndex <= 0) continue;
            this.kdtItems.addRow(curIndex - 1, this.kdtItems.removeRow(curIndex));
            this.kdtItems.getSelectManager().select(curIndex - 1, 0);
        }
        this.resetSortRule();
    }

    @Override
    protected void kbtnMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnMoveDown_actionPerformed(e);
        this.checkSelected(this.kdtItems);
        ArrayList list = this.getSelectedRows(this.kdtItems);
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = index.length; i > 0; --i) {
            int curIndex = (Integer)index[i - 1];
            if (curIndex >= this.kdtItems.getRowCount() - 1) continue;
            this.kdtItems.addRow(curIndex + 1, this.kdtItems.removeRow(curIndex));
            this.kdtItems.getSelectManager().select(curIndex + 1, 0);
        }
        this.resetSortRule();
    }

    @Override
    protected void kbtnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnDelete_actionPerformed(e);
        this.checkSelected(this.kdtItems);
        ArrayList list = this.getSelectedRows(this.kdtItems);
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = index.length; i > 0; --i) {
            this.kdtItems.removeRow(((Integer)index[i - 1]).intValue());
        }
        this.kdtRules.getRow(0).getCell("sortRule").setValue(null);
        this.resetSortRule();
    }

    private void resetSortRule() {
        ArrayList<String> sortRuleList = new ArrayList<String>();
        KDComboBox sortRuleCom = new KDComboBox();
        StringBuilder sortRule = new StringBuilder();
        for (int i = 0; i < this.kdtItems.getRowCount(); ++i) {
            String itemName = (String)this.kdtItems.getRow(i).getCell("itemName").getValue();
            String dataElement = (String)this.kdtItems.getRow(i).getCell("dataElement").getValue();
            String valueType = ((ValueTypeEnum)this.kdtItems.getRow(i).getCell("valueType").getValue()).toString();
            sortRule.append(itemName).append("/").append(dataElement).append("/").append(valueType);
            this.kdtItems.getRow(i).getCell("seq").setUserObject((Object)sortRule.toString());
            sortRuleList.add(sortRule.toString());
            sortRule.setLength(0);
        }
        if (sortRuleList.size() > 0) {
            Iterator iterator = sortRuleList.iterator();
            while (iterator.hasNext()) {
                sortRuleCom.addItem(iterator.next());
            }
        }
        this.kdtRules.getColumn("sortRule").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)sortRuleCom));
    }

    private void checkSelected(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected ArrayList getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex = new Integer(j);
                if (list.contains(tempIndex)) continue;
                list.add(tempIndex);
            }
        }
        return list;
    }

    private void bindingDynaItemListToTable(ArrayList dynaItemList, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(10);
        table.getDataRequestManager().setDataRequestMode(0);
        int count = dynaItemList.size();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = (DynaHeadItem)dynaItemList.get(i);
            r = table.addRow();
            this.bindInfoToRow(dyna, r, i);
        }
    }

    private void bindInfoToRow(DynaHeadItem dyna, IRow iRow, int i) {
        iRow.getCell("seq").setValue((Object)(i + 1));
        iRow.getCell("itemNumber").setValue((Object)dyna.rptItem.getNumber());
        iRow.getCell("itemNumber").setUserObject((Object)dyna.rptItem);
        iRow.getCell("itemName").setValue((Object)dyna.rptItem.getName());
        iRow.getCell("dataElement").setValue((Object)dyna.dataElement.getName());
        iRow.getCell("dataElement").setUserObject((Object)dyna.dataElement);
        iRow.getCell("valueType").setValue((Object)dyna.valueType);
    }

    private void bindingDynaItemListFromTable(ArrayList dynaItemList, KDTable table) {
        table.getDataRequestManager().setDataRequestMode(0);
        int count = table.getRowCount();
        dynaItemList.clear();
        DynaHeadItem dyna = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            dyna = new DynaHeadItem();
            r = table.getRow(i);
            this.bindInfoFromRow(dyna, r);
            dynaItemList.add(i, dyna);
        }
    }

    private void bindInfoFromRow(DynaHeadItem dyna, IRow iRow) {
        dyna.rptItem = (RPTItemInfo)iRow.getCell("itemNumber").getUserObject();
        dyna.dataElement = (DataElementInfo)iRow.getCell("dataElement").getUserObject();
        dyna.valueType = (ValueTypeEnum)iRow.getCell("valueType").getValue();
    }

    protected IObjectValue createNewData() {
        RptNotesDynaDataSchemeInfo rptNotesDynaDataSchemeInfo = new RptNotesDynaDataSchemeInfo();
        rptNotesDynaDataSchemeInfo.setIsByName(true);
        return rptNotesDynaDataSchemeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptNotesDynaDataSchemeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isShowSum"));
        sic.add(new SelectorItemInfo("showRowCount"));
        sic.add(new SelectorItemInfo("unionDataType"));
        sic.add(new SelectorItemInfo("isByName"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("items.seq"));
        sic.add(new SelectorItemInfo("items.itemNumber"));
        sic.add(new SelectorItemInfo("items.dataElement"));
        sic.add(new SelectorItemInfo("items.valueType"));
        sic.add(new SelectorItemInfo("items.sortType"));
        return sic;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        if (pk == null) {
            return super.getValue(pk);
        }
        return ((IRptNotesDynaDataScheme)this.getBizInterface()).getContainsRptNameValue(pk);
    }
}

