/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptFillCondition;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.samecontrol.CslGetDataRuleCollection;
import com.kingdee.eas.fi.newrpt.samecontrol.CslGetDataRuleFactory;
import com.kingdee.eas.fi.newrpt.samecontrol.CslOrgUnitFactory;
import com.kingdee.eas.fi.newrpt.samecontrol.CslOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.samecontrol.DisposalType;
import com.kingdee.eas.fi.newrpt.samecontrol.ICslGetDataRule;
import com.kingdee.eas.fi.newrpt.samecontrol.app.MnsRptCalcDisposalData;
import com.kingdee.eas.fi.newrpt.samecontrol.mnsCalc.MnsDisposalColumnCollection;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class SameControlUtil {
    private static Logger logger = Logger.getLogger(SameControlUtil.class);

    public static void calMnsDisposal(Context ctx, MnsRptCalcParam mnsRptCalcParam, HashMap itemNumbers, Map itemRows, Map items, Map sheetData, String sheetID, Map<String, MnsDisposalColumnCollection> disposalMnsColumnCollMap, MnsColumnCollection sumColColl, MnsColumnCollection comColColl, Map<Integer, Map<Integer, MnsColumnCollection>> dataType_AdjustTypeColl) throws BOSException {
        try {
            for (String yearPeriod : disposalMnsColumnCollMap.keySet()) {
                MnsDisposalColumnCollection disposalMnsColl = disposalMnsColumnCollMap.get(yearPeriod);
                String[] yearPeriods = yearPeriod.split(",");
                mnsRptCalcParam.getReport().setYear(Integer.valueOf(yearPeriods[0]).intValue());
                mnsRptCalcParam.getReport().setPeriod(Integer.valueOf(yearPeriods[1]).shortValue());
                MnsRptCalcDisposalData calcDisposalData = new MnsRptCalcDisposalData(mnsRptCalcParam, dataType_AdjustTypeColl);
                calcDisposalData.setMnsColumnCollection((MnsColumnCollection)disposalMnsColl);
                calcDisposalData.initParams(itemNumbers, itemRows, sheetData, items);
                calcDisposalData.setSumMnsColumnCollection(sumColColl);
                calcDisposalData.setCslMnsColumnCollection(comColColl);
                calcDisposalData.calcData();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"calMnsDisposal", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static MnsDisposalColumnCollection getDisposalColumnCollection(Map<String, MnsDisposalColumnCollection> columnColls, int year, int period) {
        String colKey = year + "," + period;
        MnsDisposalColumnCollection coll = columnColls.get(colKey);
        if (coll == null) {
            coll = new MnsDisposalColumnCollection(5);
            columnColls.put(colKey, coll);
        }
        return coll;
    }

    public static Map<String, String> getDisposalFormulas(Context ctx, Set<String> dataElementNumbers) throws Exception {
        ICslGetDataRule iCslGetDataRule;
        CslGetDataRuleCollection coll;
        HashMap<String, String> formulas = new HashMap<String, String>();
        if (dataElementNumbers != null && !dataElementNumbers.isEmpty() && (coll = (iCslGetDataRule = ctx == null ? CslGetDataRuleFactory.getRemoteInstance() : CslGetDataRuleFactory.getLocalInstance(ctx)).getCslGetDataRuleCollection("select dateElementNumber,formula where dateElementNumber in(" + CslRptUtil.collection2String(dataElementNumbers, (String)",", (boolean)true) + ") and isFreezed=0 ")) != null) {
            for (int i = 0; i < coll.size(); ++i) {
                if (StringUtils.isEmpty((String)coll.get(i).getFormula())) continue;
                formulas.put(coll.get(i).getDateElementNumber(), coll.get(i).getFormula());
            }
        }
        return formulas;
    }

    public static List<CslOrgUnitInfo> getPreDisposalCompanys(Context ctx, List<String> companyNumbers, MnsRptCalcParam mnsRptCalcParam, int year, int period) throws BOSException {
        try {
            int periodType;
            String OrgUnitNumber;
            CslReportInfo report = mnsRptCalcParam.getReport();
            if (report.getOrgTree() == null || StringUtils.isEmpty((String)report.getOrgTree().getNumber())) {
                throw new Exception("OrgTree can't null.");
            }
            if (report.getOrgUnit() == null || StringUtils.isEmpty((String)report.getOrgUnit().getNumber()) || report.getYear() <= 0 || report.getPeriod() <= 0 || report.getPeriodType() == null) {
                throw new Exception("OrgUnitGroup can't null.");
            }
            if (report.getYear() <= 0 || report.getPeriod() <= 0 || report.getPeriodType() == null) {
                throw new Exception("Year and Period and PeriodType must >0.");
            }
            String orgTreeNumber = report.getOrgTree().getNumber();
            List<CslOrgUnitInfo> cslOrgUnitInfos = SameControlUtil.getDisposalCompanys(ctx, orgTreeNumber, OrgUnitNumber = report.getOrgUnit().getNumber(), year, period, periodType = report.getPeriodType().getValue());
            if (cslOrgUnitInfos != null && !cslOrgUnitInfos.isEmpty()) {
                for (int i = 0; i < cslOrgUnitInfos.size(); ++i) {
                    FullOrgUnitInfo disposalCompany = cslOrgUnitInfos.get(i).getCompany();
                    if (!companyNumbers.contains(disposalCompany.getNumber())) continue;
                    if (DisposalType.Clear.equals((Object)cslOrgUnitInfos.get(i).getDisposalType())) {
                        companyNumbers.remove(disposalCompany.getNumber());
                        continue;
                    }
                    cslOrgUnitInfos.remove(i);
                    --i;
                }
            }
            return cslOrgUnitInfos;
        }
        catch (Exception ex) {
            logger.error((Object)"getDisposalCompanys error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static List<CslOrgUnitInfo> getDisposalCompanys(Context ctx, List<OrgUnitInfo> companys, MnsRptFillCondition condition) throws BOSException {
        try {
            int periodType;
            int period;
            int year;
            String OrgUnitNumber;
            if (condition.getOrgTree() == null || StringUtils.isEmpty((String)condition.getOrgTree().getNumber())) {
                throw new Exception("OrgTree can't null.");
            }
            if (condition.getOrgUnitGroup() == null || StringUtils.isEmpty((String)condition.getOrgUnitGroup().getNumber()) || condition.getYear() <= 0 || condition.getPeriod() <= 0 || condition.getPeriodType() <= 0) {
                throw new Exception("OrgUnitGroup can't null.");
            }
            if (condition.getYear() <= 0 || condition.getPeriod() <= 0 || condition.getPeriodType() <= 0) {
                throw new Exception("Year and Period and PeriodType must >0.");
            }
            String orgTreeNumber = condition.getOrgTree().getNumber();
            List<CslOrgUnitInfo> cslOrgUnitInfos = SameControlUtil.getDisposalCompanys(ctx, orgTreeNumber, OrgUnitNumber = condition.getOrgUnitGroup().getNumber(), year = condition.getYear(), period = condition.getPeriod(), periodType = condition.getPeriodType());
            if (cslOrgUnitInfos != null && !cslOrgUnitInfos.isEmpty()) {
                HashMap<String, OrgUnitInfo> orgUnitInfos = new HashMap<String, OrgUnitInfo>();
                for (OrgUnitInfo orgUnit : companys) {
                    orgUnitInfos.put(orgUnit.getId().toString(), orgUnit);
                }
                for (int i = 0; i < cslOrgUnitInfos.size(); ++i) {
                    FullOrgUnitInfo disposalCompany = cslOrgUnitInfos.get(i).getCompany();
                    OrgUnitInfo orgTreeCompany = (OrgUnitInfo)orgUnitInfos.get(disposalCompany.getId().toString());
                    if (orgTreeCompany == null) continue;
                    if (DisposalType.Clear.equals((Object)cslOrgUnitInfos.get(i).getDisposalType())) {
                        companys.remove(orgTreeCompany);
                        orgUnitInfos.remove(disposalCompany.getId().toString());
                        continue;
                    }
                    cslOrgUnitInfos.remove(i);
                    --i;
                }
                orgUnitInfos.clear();
            }
            return cslOrgUnitInfos;
        }
        catch (Exception ex) {
            logger.error((Object)"getDisposalCompanys error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static void buildClearCompanySql(Object sql, List<String> clearCompanys, String tableName, ElimTypeEnum elimType) {
        if (clearCompanys != null && !clearCompanys.isEmpty() && elimType != null && elimType.equals((Object)ElimTypeEnum.exchange)) {
            StringBuffer curSql = new StringBuffer();
            curSql.append(" and ").append(tableName).append(".fcompanyid not in(").append(CslRptUtil.list2String(clearCompanys, (String)",", (boolean)true)).append(") and ").append(tableName).append(".ftargetcompanyid not in(").append(CslRptUtil.list2String(clearCompanys, (String)",", (boolean)true)).append(")");
            if (sql instanceof StringBuffer) {
                ((StringBuffer)sql).append(curSql);
            } else if (sql instanceof SQLBuilder) {
                ((SQLBuilder)sql).append((Object)curSql);
            }
        }
    }

    public static void buildAddCompanySql(Object sql, List[] disposalCompanys, String idField, String numberField) {
        if (disposalCompanys != null && !disposalCompanys[0].isEmpty()) {
            StringBuffer curSql = new StringBuffer();
            curSql.append(" union select fid as ").append(idField);
            if (!StringUtils.isEmpty((String)numberField)) {
                curSql.append(",fnumber as ").append(numberField);
            }
            curSql.append(" from t_org_baseunit where fid in(").append(CslRptUtil.list2String((List)disposalCompanys[0], (String)",", (boolean)true)).append(")");
            if (sql instanceof StringBuffer) {
                ((StringBuffer)sql).append(curSql);
            } else if (sql instanceof SQLBuilder) {
                ((SQLBuilder)sql).append((Object)curSql);
            }
        }
    }

    public static void buildClearCompanySql(Object sql, List[] disposalCompanys, String field) {
        if (disposalCompanys != null && !disposalCompanys[1].isEmpty()) {
            StringBuffer curSql = new StringBuffer();
            curSql.append(" and ").append(field).append(" not in(").append(CslRptUtil.list2String((List)disposalCompanys[1], (String)",", (boolean)true)).append(")");
            if (sql instanceof StringBuffer) {
                ((StringBuffer)sql).append(curSql);
            } else if (sql instanceof SQLBuilder) {
                ((SQLBuilder)sql).append((Object)curSql);
            }
        }
    }

    public static Set<String> getAllChildrenOrgUnitNumbers(Context ctx, String orgTreeId, String longNumber) throws BOSException {
        HashSet<String> orgUnitNumbers = new HashSet<String>();
        if (!StringUtils.isEmpty((String)orgTreeId) && !StringUtils.isEmpty((String)longNumber)) {
            try {
                SQLBuilder sql = new SQLBuilder();
                sql.append(" select distinct unit.fnumber unitNumber ");
                sql.append(" From t_org_structure struct ");
                sql.append(" inner join t_org_baseunit unit on unit.fid=struct.funitid ");
                sql.append(" where struct.ftreeid = ?", (Object)orgTreeId);
                sql.append(" and struct.flongnumber like '").append(longNumber).append("!%'");
                sql.append(" and unit.fisunion=1 ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                while (rowSet != null && rowSet.next()) {
                    orgUnitNumbers.add(rowSet.getString("unitNumber"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"getAllChildrenOrgUnitNumbers error.", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        return orgUnitNumbers;
    }

    public static Set<Object>[] getCurPeriodDisposalCompanysForElim(Context ctx, String orgTreeNumber, String OrgUnitNumber, int year, int period, int periodType, boolean isByCompany, boolean isIncludeChildren, String orgTreeId, String longNUmber) throws BOSException {
        HashSet<String> orgUnitNumbers = new HashSet<String>();
        if (!isByCompany) {
            orgUnitNumbers.add(OrgUnitNumber);
            if (isIncludeChildren) {
                orgUnitNumbers.addAll(SameControlUtil.getAllChildrenOrgUnitNumbers(ctx, orgTreeId, longNUmber));
            }
        }
        return SameControlUtil.getCurPeriodDisposalCompanysForElim(ctx, orgTreeNumber, orgUnitNumbers, year, period, periodType, orgTreeId, isByCompany);
    }

    public static void removeExistUnit(Context ctx, List<String>[] disposeCompanys, String treeId, String longNumber) throws BOSException {
        SameControlUtil.removeExistUnit(ctx, disposeCompanys, treeId, longNumber, false);
    }

    public static void removeExistUnit(Context ctx, List<String>[] disposeCompanys, String treeId, String longNumber, boolean isByCompany) throws BOSException {
        try {
            if (disposeCompanys != null && !disposeCompanys[0].isEmpty()) {
                SQLBuilder sql = new SQLBuilder();
                sql.append(" Select t1.FUnitId From t_org_structure t1 ");
                sql.append(" join t_org_baseunit t2 on t1.funitid=t2.fid ");
                sql.append("  where t2.fisgrouping=0 and t1.fisleaf=1 and t1.ftreeid='").append(treeId).append("'");
                if (!isByCompany) {
                    sql.append(" and t1.flongnumber like '").append(longNumber).append("!%' ");
                }
                sql.append(" and t1.FUnitId in(").append(CslRptUtil.list2String(disposeCompanys[0], (String)",", (boolean)true)).append(")");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL());
                while (rowSet != null && rowSet.next()) {
                    String companyId = rowSet.getString("FUnitId");
                    disposeCompanys[0].remove(companyId);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"getCurPeriodDisposalCompanysForElim error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static Set<Object>[] getCurPeriodDisposalCompanysForElim(Context ctx, String orgTreeNumber, String orgUnitNumber, int year, int period, int periodType, String orgTreeId, boolean isByCompany) throws BOSException {
        HashSet<String> orgUnitNumbers = new HashSet<String>();
        orgUnitNumbers.add(orgUnitNumber);
        return SameControlUtil.getCurPeriodDisposalCompanysForElim(ctx, orgTreeNumber, orgUnitNumbers, year, period, periodType, orgTreeId, isByCompany);
    }

    public static Set<Object>[] getCurPeriodDisposalCompanysForElim(Context ctx, String orgTreeNumber, Set<String> orgUnitNumbers, int year, int period, int periodType, String orgTreeId, boolean isByCompany) throws BOSException {
        HashSet[] comanysArr = new HashSet[]{new HashSet(), new HashSet()};
        try {
            if (StringUtils.isEmpty((String)orgTreeNumber)) {
                throw new Exception("orgTreeNumber can't null.");
            }
            if (!isByCompany && (orgUnitNumbers == null || orgUnitNumbers.isEmpty())) {
                throw new Exception("OrgUnitNumber can't null.");
            }
            java.util.Date lastDate = FiscalPeriodHelper.getPeriodLastDate(null, (int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (boolean)false);
            int[] yearPeriod = FiscalPeriodHelper.getPeriod((java.util.Date)lastDate, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY, null, (boolean)false);
            SQLBuilder sql = new SQLBuilder();
            sql.append("  select distinct company.fid fcompanyId,cslOrg.FIsHandleExch,cslOrg.FDisposalType,company.fnumber companyNumber,orgUnit.fnumber orgUnitNumber,company.fisunion");
            sql.append("  from T_Csl_CslOrgUnit cslOrg  \r\n");
            sql.append("  inner join t_org_tree tree on tree.fid=cslOrg.FOrgTreeId \r\n");
            sql.append("  inner join t_org_baseunit company on company.fid=cslOrg.fcompanyid \r\n");
            sql.append("  inner join t_org_baseunit orgUnit on orgUnit.fid=cslOrg.FDisposalOrgUnitId \r\n");
            sql.append("  inner join ( \r\n");
            sql.append("\t\tselect max(incslOrg.fdate) fdate,incompany.fnumber fcompanyNumber \r\n");
            sql.append(" \t\tfrom T_Csl_CslOrgUnit incslOrg \r\n");
            sql.append(" \t\tinner join t_org_tree intree on intree.fid=incslOrg.FOrgTreeId  \r\n");
            sql.append(" \t\tinner join t_org_baseunit incompany on incompany.fid=incslOrg.fcompanyid  \r\n");
            sql.append(" \t\tinner join t_org_baseunit inorgunit on inorgunit.fid=incslOrg.fdisposalOrgUnitId  \r\n");
            sql.append(" \t\twhere intree.fnumber=?", (Object)orgTreeNumber);
            if (isByCompany) {
                sql.append(" \t\tand incslOrg.FIsHandleExch=0 and incslOrg.FDisposalType=2 ");
            } else {
                sql.append(" \t\tand (inorgunit.fnumber in ", orgUnitNumbers).append(" and incslOrg.FIsHandleExch=1 or incslOrg.FIsHandleExch=0 and incslOrg.FDisposalType=2 )");
            }
            sql.append(" \t\tand incslOrg.fyear=?", (Object)year);
            sql.append(" \t\tand incslOrg.fperiod=?", (Object)yearPeriod[1]);
            sql.append(" \t\tgroup by incompany.fnumber \r\n");
            sql.append(" ) disposalOrg on cslOrg.fdate=disposalOrg.fdate and company.fnumber=disposalOrg.fcompanyNumber ");
            sql.append("  where tree.fnumber=?", (Object)orgTreeNumber);
            sql.append("  and cslOrg.fyear=?", (Object)year);
            sql.append("  and cslOrg.fperiod=?", (Object)yearPeriod[1]);
            sql.append(" order by company.fnumber ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            HashSet<String> clearOrgUnits = new HashSet<String>();
            while (rowSet != null && rowSet.next()) {
                String companyId = rowSet.getString("fcompanyId");
                boolean isHandleExch = rowSet.getBoolean("FIsHandleExch");
                int disposalType = rowSet.getInt("FDisposalType");
                if (!isHandleExch && 2 == disposalType) {
                    if (rowSet.getBoolean("fisunion")) {
                        clearOrgUnits.add(companyId);
                        continue;
                    }
                    comanysArr[0].add(companyId);
                    continue;
                }
                FullOrgUnitInfo disedUnit = new FullOrgUnitInfo();
                disedUnit.setId(BOSUuid.read((String)rowSet.getString("fcompanyId")));
                disedUnit.setNumber(rowSet.getString("companyNumber"));
                disedUnit.setIsUnion(rowSet.getBoolean("fisunion"));
                FullOrgUnitInfo parentInfo = new FullOrgUnitInfo();
                parentInfo.setNumber(rowSet.getString("orgUnitNumber"));
                disedUnit.setParent(parentInfo);
                comanysArr[1].add(disedUnit);
            }
            if (!clearOrgUnits.isEmpty()) {
                sql.reset();
                sql.append(" select distinct str2.FUnitId \r\n");
                sql.append(" from t_org_structure str1  \r\n");
                sql.append(" inner join t_org_structure str2 on str2.ftreeid=? ", (Object)orgTreeId).append(" and str2.flongnumber like concat(str1.flongnumber,'!%') ");
                sql.append(" inner join t_org_baseunit unit on unit.fid=str2.funitid ");
                sql.append(" where str1.FUnitId in ", clearOrgUnits);
                sql.append(" and unit.fisUnion=0 ");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                while (rowSet != null && rowSet.next()) {
                    comanysArr[0].add(rowSet.getString("FUnitId"));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"getCurPeriodDisposalCompanysForElim error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return comanysArr;
    }

    public static List<CslOrgUnitInfo> getDisposalCompanys(Context ctx, String orgTreeNumber, String OrgUnitNumber, int year, int period, int periodType) throws BOSException, EASBizException {
        try {
            if (ctx != null) {
                return SameControlUtil.getDisposalCompanysForServer(ctx, orgTreeNumber, OrgUnitNumber, year, period, periodType);
            }
            return CslOrgUnitFactory.getRemoteInstance().getDisposalCompanys(orgTreeNumber, OrgUnitNumber, year, period, periodType);
        }
        catch (Exception e) {
            logger.error((Object)"getDisposalCompanys error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static List<CslOrgUnitInfo> getDisposalCompanysForServer(Context ctx, String orgTreeNumber, String OrgUnitNumber, int year, int period, int periodType) throws Exception {
        ArrayList<CslOrgUnitInfo> infos = new ArrayList<CslOrgUnitInfo>();
        try {
            if (StringUtils.isEmpty((String)orgTreeNumber)) {
                throw new Exception("orgTreeNumber can't null.");
            }
            if (StringUtils.isEmpty((String)OrgUnitNumber)) {
                throw new Exception("OrgUnitNumber can't null.");
            }
            String lan = ctx.getLocale().getLanguage();
            Timestamp date = new Timestamp(FiscalPeriodHelper.getPeriodLastDate(null, (int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (boolean)false).getTime());
            SQLBuilder sql = new SQLBuilder();
            sql.append("  select distinct company.fnumber fcompanyNumber, company.fid fcompanyId, company.fName_").append(lan).append(" fcompanyName");
            sql.append(",company.fsimplename,company.fisUnion,cslOrg.FIsHandleExch,cslOrg.FDisposalType,cslOrg.fdate ");
            sql.append("  from t_org_structure struct  \r\n");
            sql.append("  inner join t_org_tree tree on tree.fid=struct.ftreeid \r\n");
            sql.append("  inner join t_org_baseunit company  on company.fid=struct.funitid \r\n");
            sql.append("  inner join ( \r\n");
            sql.append("\t\tselect max(incslOrg.fdate) fdate,incompany.fnumber fcompanyNumber,incslOrg.flastDate ");
            sql.append(" \t\tfrom T_Csl_CslOrgUnit incslOrg \r\n");
            sql.append(" \t\tinner join t_org_tree intree on intree.fid=incslOrg.FOrgTreeId  \r\n");
            sql.append(" \t\tinner join t_org_baseunit incompany on incompany.fid=incslOrg.fcompanyid  \r\n");
            sql.append(" \t\tinner join t_org_baseunit inorgunit on inorgunit.fid=incslOrg.fdisposalOrgUnitId  \r\n");
            sql.append(" \t\twhere intree.fnumber=?", (Object)orgTreeNumber);
            sql.append(" \t\tand inorgunit.fnumber=?", (Object)OrgUnitNumber);
            sql.append(" \t\tand incslOrg.fyear=?", (Object)year);
            sql.append(" \t\tand incslOrg.fdate<=?", (Object)date);
            sql.append(" \t\tgroup by incompany.fnumber,incslOrg.flastDate \r\n");
            sql.append(" ) disposalOrg on company.fnumber=disposalOrg.fcompanyNumber ");
            sql.append(" and tree.FStartDate<=disposalOrg.flastDate and (tree.FEndDate>=disposalOrg.flastDate or tree.FEndDate is null)  \r\n");
            sql.append(" inner join T_Csl_CslOrgUnit cslOrg on cslOrg.fdate=disposalOrg.Fdate  \r\n");
            sql.append(" inner join t_org_baseunit cslOrgcompany on cslOrgcompany.fid=cslOrg.fcompanyid and cslOrgcompany.fnumber=disposalOrg.fcompanyNumber \r\n");
            sql.append("  where tree.fnumber=?", (Object)orgTreeNumber);
            sql.append("  and cslOrg.fyear=?", (Object)year);
            sql.append(" order by company.fnumber ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            while (rowSet != null && rowSet.next()) {
                CslOrgUnitInfo info = new CslOrgUnitInfo();
                FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                orgUnit.put("id", (Object)rowSet.getString("fcompanyId"));
                orgUnit.setNumber(rowSet.getString("fcompanyNumber"));
                orgUnit.setName(rowSet.getString("fcompanyName"));
                orgUnit.setSimpleName(rowSet.getString("fsimplename"));
                orgUnit.setIsUnion(rowSet.getBoolean("fisUnion"));
                info.setCompany(orgUnit);
                info.setIsHandleExch(rowSet.getInt("FIsHandleExch"));
                info.setDisposalType(DisposalType.getEnum(rowSet.getInt("FDisposalType")));
                info.setDate(rowSet.getDate("fdate"));
                infos.add(info);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"getDisposalCompanys error.", (Throwable)ex);
            throw ex;
        }
        return infos;
    }

    public static void addBookVariable(Book book, String varName, boolean varValue) {
        SameControlUtil.addBookVariable(book, varName, String.valueOf(varValue));
    }

    public static void addBookVariable(Book book, String varName, String varValue) {
        BookProperties p = SameControlUtil.getBookProperties(book);
        VariableEntry entry = new VariableEntry(varName, book.getName());
        entry.setValue(varValue);
        entry.setVisible(false);
        p.getVariables().addOrReplace(entry);
        p.restoreToBook(book);
    }

    public static boolean getBookVariable(Book book, String varName) {
        String variable = SameControlUtil.getBookVariableStr(book, varName);
        return variable == null ? false : Boolean.valueOf(variable);
    }

    public static String getBookVariableStr(Book book, String varName) {
        VariableEntry variable = SameControlUtil.getBookProperties(book).getVariables().get(varName, book.getName());
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    public static BookProperties getBookProperties(Book book) {
        BookProperties p = BookProperties.loadFromBook((Book)book);
        if (p == null) {
            p = new BookProperties();
            p.restoreToBook(book);
        }
        return p;
    }

    public static OrgTreeCollection getOrgTreeCollection() throws EASBizException, BOSException {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        OrgTreeCollection otc = CslRptUtil.getAllUnionTreesOrderByNumberNew(null, (String)user.getId().toString(), null);
        if (otc != null && otc.size() > 0) {
            OrgTreeInfo info = null;
            for (int i = 0; i < otc.size(); ++i) {
                info = otc.get(i);
                if (!info.isIsHide() && !UnionVersionStatusEnum.UNSTART.equals((Object)info.getStatus())) continue;
                otc.remove(info);
                --i;
            }
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.samecontrol.CslsameControlResource", (String)"NoOrgBound"));
            SysUtil.abort();
        }
        return otc;
    }

    public static String getElimOrgUnitsTable(Context ctx, String orgBoundId, String orgUnitId, String longNumber, String OrgUnitNumber, String orgTreeNumber, int year, int period, int periodType, int level, ElimTypeEnum elimType, int mergeMode) throws BOSException {
        return SameControlUtil.getElimOrgUnitsTable(ctx, orgBoundId, orgUnitId, longNumber, OrgUnitNumber, orgTreeNumber, null, year, period, periodType, level, elimType, mergeMode, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getElimOrgUnitsTable(Context ctx, String orgBoundId, String orgUnitId, String longNumber, String OrgUnitNumber, String orgTreeNumber, List<String> clearCompanys, int year, int period, int periodType, int level, ElimTypeEnum elimType, int mergeMode, boolean isByCompany) throws BOSException {
        String string;
        String virtualStructTable;
        String disCompanyTable;
        block40: {
            block41: {
                Set<Object>[] companys = null;
                if (isByCompany) {
                    if (StringUtils.isEmpty((String)orgBoundId) || StringUtils.isEmpty((String)orgUnitId) || !ElimTypeEnum.exchange.equals((Object)elimType)) return null;
                    companys = SameControlUtil.getCurPeriodDisposalCompanysForElim(ctx, orgTreeNumber, OrgUnitNumber, year, period, periodType, isByCompany, true, orgBoundId, longNumber);
                    if (clearCompanys == null || companys == null || companys.length < 2 || companys[0].isEmpty()) return null;
                    for (Object obj : companys[0]) {
                        clearCompanys.add((String)obj);
                    }
                    return null;
                }
                disCompanyTable = null;
                virtualStructTable = null;
                String companyTempTable = null;
                try {
                    String curLongNumber;
                    if (StringUtils.isEmpty((String)orgBoundId) || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)longNumber) || StringUtils.isEmpty((String)orgTreeNumber)) return companyTempTable;
                    SQLBuilder sql = new SQLBuilder();
                    IRowSet rsTemp = null;
                    if (0 == mergeMode) {
                        companyTempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_company(FCompanyId varchar(44))");
                        sql.reset();
                        sql.append(" insert into ").append(companyTempTable).append("(FCompanyId)");
                        sql.append(" Select distinct b.funitid from t_org_structure b \r\n");
                        sql.append("   Where b.FTreeID = ?", (Object)orgBoundId).append(" and b.FIsLeaf = 1 and b.flongnumber like '" + longNumber + "!%'");
                        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                    }
                    if (ElimTypeEnum.exchange.equals((Object)elimType)) {
                        String curDisOrgTreeId;
                        companys = SameControlUtil.getCurPeriodDisposalCompanysForElim(ctx, orgTreeNumber, OrgUnitNumber, year, period, periodType, isByCompany, true, orgBoundId, longNumber);
                        if (clearCompanys != null && companys != null && companys.length >= 2 && !companys[0].isEmpty()) {
                            for (Object obj : companys[0]) {
                                clearCompanys.add((String)obj);
                            }
                        }
                        ArrayList<String> companyNubmers = new ArrayList<String>();
                        ArrayList<String> unitNubmers = new ArrayList<String>();
                        ArrayList<String> companyIds = new ArrayList<String>();
                        ArrayList<String> parentNumbers = new ArrayList<String>();
                        if (companys != null && companys.length >= 2 && !companys[1].isEmpty()) {
                            for (Object company : companys[1]) {
                                FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)company;
                                if (unitInfo.isIsUnion()) {
                                    unitNubmers.add(unitInfo.getNumber());
                                } else {
                                    companyNubmers.add(unitInfo.getNumber());
                                    companyIds.add(unitInfo.getId().toString());
                                }
                                parentNumbers.add(unitInfo.getParent().getNumber());
                            }
                        }
                        String disOrgTreeId = orgBoundId;
                        if ((0 == mergeMode && !unitNubmers.isEmpty() || 1 == mergeMode) && !StringUtils.isEmpty((String)(curDisOrgTreeId = SameControlUtil.getDisOrgTreeId(ctx, orgBoundId, unitNubmers, year, period, periodType, mergeMode)))) {
                            disOrgTreeId = curDisOrgTreeId;
                        }
                        if (0 == mergeMode) {
                            if (!companyIds.isEmpty()) {
                                sql.reset();
                                sql.append(" insert into ").append(companyTempTable).append("(FCompanyId) ");
                                sql.append(" select distinct a.fid from t_org_baseunit a left join ").append(companyTempTable).append(" b on b.FCompanyId=a.fid");
                                sql.append(" where a.fid in ", companyIds).append(" and b.FCompanyId is null ");
                                DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                            }
                            if (!unitNubmers.isEmpty()) {
                                sql.reset();
                                sql.append(" insert into ").append(companyTempTable).append("(FCompanyId)");
                                sql.append(" select distinct bu2.fid \r\n");
                                sql.append(" from t_org_structure t1  \r\n");
                                sql.append(" inner join t_org_baseunit t2 on t1.FUnitId=t2.FId ");
                                sql.append(" inner join t_org_structure str1 on str1.flongnumber like concat(t1.flongnumber,'!%') ");
                                sql.append(" inner join t_org_baseunit bu2 on str1.FUnitId=bu2.FId ");
                                sql.append(" left join ").append(companyTempTable).append(" tmp on tmp.fcompanyid=bu2.fid ");
                                sql.append(" where t1.FTreeId = ? ", (Object)disOrgTreeId);
                                sql.append(" and t2.fnumber in ", unitNubmers);
                                sql.append(" and str1.FTreeId = ? ", (Object)disOrgTreeId);
                                sql.append(" and bu2.fisUnion=0 and tmp.fcompanyid is null ");
                                DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                            }
                            if (companys != null && !companys[0].isEmpty() && elimType != null) {
                                sql.reset();
                                sql.append(" delete ").append(companyTempTable).append(" where FCompanyId in ", companys[0]);
                                DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                            }
                            string = companyTempTable;
                            if (DebugLogger.isDebug || disCompanyTable == null) break block40;
                            break block41;
                        }
                        disCompanyTable = SameControlUtil.getDisCompanyTable(ctx, disOrgTreeId, orgBoundId, unitNubmers, companyNubmers, parentNumbers);
                    }
                    if (1 != mergeMode) return companyTempTable;
                    companyTempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_company(FCompanyId varchar(44),FTargetCompanyId varchar(44))");
                    sql.reset();
                    sql.append(" select distinct t1.FLongNumber \r\n");
                    sql.append(" from t_org_structure t1 join t_org_baseunit t2 on t1.FUnitId=t2.FId \r\n");
                    sql.append(" where t1.FTreeId = '").append(orgBoundId).append("'");
                    sql.append(" And t1.FLongNumber like '").append(longNumber).append("!%'");
                    sql.append(" And t1.FLevel = ").append((Object)(level + 1));
                    sql.append(" And t2.FIsCompanyOrgUnit = 0");
                    rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    HashSet<String> childLongNumbers = new HashSet<String>();
                    while (rsTemp.next()) {
                        childLongNumbers.add(rsTemp.getString("FLongNumber"));
                    }
                    if (!StringUtils.isEmpty((String)disCompanyTable)) {
                        virtualStructTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_virtualStruct(FCompanyId varchar(44),FLongNumber NVARCHAR(100))");
                        sql.reset();
                        sql.append(" insert into ").append(virtualStructTable).append("(FCompanyId,FLongNumber)");
                        sql.append(" Select t1.FUnitId As FCompanyId,t1.FLongNumber From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid ");
                        sql.append("  where t2.fisgrouping=0 and t1.fisleaf=1 and t1.flongnumber like '").append(longNumber).append("!%' and t1.ftreeid=?", (Object)orgBoundId);
                        if (!StringUtils.isEmpty((String)disCompanyTable)) {
                            sql.append(" union select FCompanyId,FLongNumber from ").append(disCompanyTable);
                        }
                        sql.append(" \r\n");
                        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                        rsTemp = DbUtil.executeQuery((Context)ctx, (String)("select distinct FLongNumber from " + disCompanyTable));
                        int index = longNumber.length() + 1;
                        while (rsTemp.next()) {
                            curLongNumber = rsTemp.getString("FLongNumber");
                            int i = curLongNumber.indexOf("!", index);
                            if (i <= 0) continue;
                            childLongNumbers.add(curLongNumber.substring(0, i));
                        }
                    }
                    sql.reset();
                    sql.append(" insert into ").append(companyTempTable).append("(FCompanyId,FTargetCompanyId)");
                    sql.append(" select distinct x.FCompanyId,x.FTargetCompanyId from (");
                    sql.append(" Select x1.FCompanyId,x1.FLongNumber as FLongNumber,x2.FTargetCompanyId,x2.FlongNumber As FTargetLongNumber \r\n");
                    sql.append(" From \r\n");
                    if (virtualStructTable != null && elimType != null && elimType.equals((Object)ElimTypeEnum.exchange)) {
                        sql.append(" (select FCompanyId,FLongNumber from ").append(virtualStructTable).append(") x1, ");
                        sql.append(" (select FCompanyId as FTargetCompanyId,FLongNumber from ").append(virtualStructTable).append(") x2 ");
                    } else {
                        sql.append(" (Select t1.FUnitId As FCompanyId,t1.FLongNumber From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid ");
                        sql.append("  where t2.fisgrouping=0 and t1.fisleaf=1 and t1.flongnumber like '").append(longNumber).append("!%' and t1.ftreeid=?", (Object)orgBoundId);
                        if (!StringUtils.isEmpty((String)disCompanyTable)) {
                            sql.append(" union select FCompanyId,FLongNumber from ").append(disCompanyTable);
                        }
                        sql.append(") x1, \r\n");
                        sql.append(" (Select t1.FUnitId As FTargetCompanyId,t1.FLongNumber From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid ");
                        sql.append("  where t2.fisgrouping=0 and t1.fisleaf=1 and t1.flongnumber like '").append(longNumber).append("!%' and t1.ftreeid=?", (Object)orgBoundId);
                        if (!StringUtils.isEmpty((String)disCompanyTable)) {
                            sql.append(" union select FCompanyId,FLongNumber from ").append(disCompanyTable);
                        }
                        sql.append(") x2 \r\n");
                    }
                    sql.append(" ) x ");
                    sql.append(" where 1=1 ");
                    if (companys != null && !companys[0].isEmpty() && elimType != null && elimType.equals((Object)ElimTypeEnum.exchange)) {
                        sql.append(" and x.fcompanyid not in(").append(CslRptUtil.collection2String(companys[0], (String)",", (boolean)true)).append(") and x.ftargetcompanyid not in(").append(CslRptUtil.collection2String(companys[0], (String)",", (boolean)true)).append(")");
                    }
                    for (String childLongNumber : childLongNumbers) {
                        sql.append(" and (Left(Replace(x.FLongNumber,'").append(childLongNumber).append("!','@#$'),3)<>'@#$' \r\n");
                        sql.append(" or Left(Replace(x.FTargetLongNumber,'").append(childLongNumber).append("!','@#$'),3)<>'@#$') \r\n");
                    }
                    DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                    if (StringUtils.isEmpty((String)virtualStructTable) || elimType == null || !elimType.equals((Object)ElimTypeEnum.exchange)) return companyTempTable;
                    sql.reset();
                    sql.append("select flongnumber from ").append(virtualStructTable);
                    sql.append(" where FLongNumber like '").append(longNumber).append("!%!%'");
                    sql.append(" and FCompanyId in (select fcompanyid from ").append(disCompanyTable).append(")");
                    rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL());
                    HashSet<String> companyLongNumbers = new HashSet<String>();
                    while (rsTemp != null && rsTemp.next()) {
                        curLongNumber = rsTemp.getString("flongnumber");
                        int index = curLongNumber.indexOf("!", longNumber.length() + 1);
                        if (index <= 0) continue;
                        companyLongNumbers.add(curLongNumber.substring(0, index));
                    }
                    if (companyLongNumbers.isEmpty()) return companyTempTable;
                    for (String curlongNumber : companyLongNumbers) {
                        sql.reset();
                        sql.append(" delete from ").append(companyTempTable);
                        sql.append(" where fcompanyid in(select fcompanyid from ").append(virtualStructTable).append(" where FLongNumber like '").append(curlongNumber).append("!%')");
                        sql.append(" and FTargetCompanyId in(select fcompanyid from ").append(virtualStructTable).append(" where FLongNumber like '").append(curlongNumber).append("!%')");
                        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                    }
                    return companyTempTable;
                }
                catch (Exception ex) {
                    if (companyTempTable != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(companyTempTable);
                    }
                    logger.error((Object)"getElimOrgUnitsTable", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(disCompanyTable);
        }
        if (DebugLogger.isDebug || virtualStructTable == null) return string;
        TempTablePool.getInstance((Context)ctx).releaseTable(virtualStructTable);
        return string;
        finally {
            if (!DebugLogger.isDebug && disCompanyTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(disCompanyTable);
            }
            if (!DebugLogger.isDebug && virtualStructTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(virtualStructTable);
            }
        }
    }

    public static String getDisCompanyTable(Context ctx, String disOrgTreeId, String orgBoundId, List<String> unitNubmers, List<String> companyNubmers, List<String> parentNumbers) throws Exception {
        if (!(companyNubmers.isEmpty() && unitNubmers.isEmpty() || orgBoundId.equals(disOrgTreeId))) {
            IRowSet rowSet;
            String disCompanyTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_company(FCompanyId varchar(44),flongnumber nvarchar(200),fplongNubmer nvarchar(200))");
            SQLBuilder sql = new SQLBuilder();
            if (!companyNubmers.isEmpty()) {
                sql.reset();
                sql.append(" insert into ").append(disCompanyTable).append("(flongnumber,FCompanyId,fplongNubmer)");
                sql.append(" select distinct t1.FLongNumber,t2.fid,t3.flongNumber fplongNubmer \r\n");
                sql.append(" from t_org_structure t1 inner join t_org_baseunit t2 on t1.FUnitId=t2.FId \r\n");
                sql.append(" inner join t_org_structure t3 on t3.fid=t1.fparentid \r\n");
                sql.append(" where t1.FTreeId = ? ", (Object)disOrgTreeId);
                sql.append(" and t2.fnumber in ", companyNubmers);
                DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            }
            if (!unitNubmers.isEmpty()) {
                sql.reset();
                sql.append(" select distinct str1.FLongNumber,bu2.fid fcompanyId,t3.flongnumber fplongNubmer \r\n");
                sql.append(" from t_org_structure t1  \r\n");
                sql.append(" inner join t_org_baseunit t2 on t1.FUnitId=t2.FId ");
                sql.append(" inner join t_org_structure str1 on str1.flongnumber like concat(t1.flongnumber,'!%') ");
                sql.append(" inner join t_org_baseunit bu2 on str1.FUnitId=bu2.FId ");
                sql.append(" inner join t_org_structure t3 on t3.fid=t1.fparentid ");
                sql.append(" where t1.FTreeId = ? ", (Object)disOrgTreeId);
                sql.append(" and t2.fnumber in ", unitNubmers);
                sql.append(" and str1.FTreeId = ? ", (Object)disOrgTreeId);
                sql.append(" and bu2.fisUnion=0 ");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                sql.reset();
                if (rowSet != null && rowSet.size() > 0) {
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                    while (rowSet.next()) {
                        String plongNumber = rowSet.getString("fplongNubmer");
                        String longNumber = rowSet.getString("FLongNumber");
                        String companyId = rowSet.getString("fcompanyId");
                        longNumber = plongNumber + longNumber.substring(longNumber.lastIndexOf("!"));
                        paramsList.add(new Object[]{longNumber, companyId, plongNumber});
                    }
                    sql.append(" insert into ").append(disCompanyTable).append("(flongnumber,FCompanyId,fplongNubmer) values(?,?,?)");
                    DbUtil.executeBatch((Context)ctx, (String)sql.getSQL(), paramsList);
                }
            }
            if (!parentNumbers.isEmpty()) {
                sql.reset();
                sql.append(" select disBefore.flongnumber beforeNumber,disAfter.flongnumber afterNumber");
                sql.append(" from t_org_structure disBefore  \r\n");
                sql.append(" inner join t_org_baseunit unitBefore on unitBefore.fid=disBefore.funitid ");
                sql.append(" inner join t_org_baseunit unitAfter on unitAfter.fnumber=unitBefore.fnumber ");
                sql.append(" inner join t_org_structure disAfter on disAfter.funitid=unitAfter.fid ");
                sql.append(" where disBefore.ftreeid=? ", (Object)disOrgTreeId);
                sql.append(" and disAfter.ftreeid=? ", (Object)orgBoundId);
                sql.append(" and unitAfter.fnumber in ", parentNumbers);
                sql.append(" and unitBefore.fnumber in ", parentNumbers);
                sql.append(" and disBefore.flongnumber<>disAfter.flongnumber ");
                sql.append(" order by length(disBefore.flongnumber) desc ");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                HashMap<String, String> longNumbers = new HashMap<String, String>();
                while (rowSet != null && rowSet.next()) {
                    longNumbers.put(rowSet.getString("beforeNumber"), rowSet.getString("afterNumber"));
                }
                if (!longNumbers.isEmpty()) {
                    for (String beforeNumber : longNumbers.keySet()) {
                        sql.reset();
                        sql.append(" update ").append(disCompanyTable).append(" set flongnumber=replace(flongnumber,'").append(beforeNumber).append("','").append((String)longNumbers.get(beforeNumber)).append("')").append(" where fplongNubmer=? ", (Object)beforeNumber);
                        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                    }
                }
                longNumbers.clear();
            }
            return disCompanyTable;
        }
        return null;
    }

    public static String getDisOrgTreeId(Context ctx, String orgBoundId, List<String> unitNubmers, int year, int period, int periodType, int mergeMode) throws Exception {
        if (0 == mergeMode && !unitNubmers.isEmpty() || 1 == mergeMode) {
            java.util.Date lastDate = FiscalPeriodHelper.getPeriodLastDate(null, (int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (boolean)false);
            lastDate = FiscalPeriodHelper.getPrePeriodLastDayByDate((java.util.Date)lastDate, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY, null, (boolean)false);
            Date date = new Date(lastDate.getTime());
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select oldTree.fid from t_org_tree newTree ");
            sql.append(" inner join t_org_tree oldTree on newTree.fnumber=oldTree.fnumber ");
            sql.append(" where newTree.fid=? ", (Object)orgBoundId).append(" and oldTree.fstartdate<=?", (Object)date);
            sql.append(" and (oldTree.fenddate>=?", (Object)date).append(" or oldTree.fenddate is null )");
            IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            if (rsTemp != null && rsTemp.next()) {
                return rsTemp.getString("fid");
            }
        }
        return null;
    }
}

