/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.newrpt.samecontrol.CslGetDataRuleFactory;
import com.kingdee.eas.fi.newrpt.samecontrol.CslGetDataRuleInfo;
import com.kingdee.eas.fi.newrpt.samecontrol.ICslGetDataRule;
import com.kingdee.eas.fi.newrpt.samecontrol.client.AbstractCslGetDataRuleEditUI;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CslGetDataRuleEditUI
extends AbstractCslGetDataRuleEditUI
implements IFormulaPickerListener {
    private static final Logger logger = CoreUIObject.getLogger(CslGetDataRuleEditUI.class);
    private String rsePatch = "com.kingdee.eas.fi.newrpt.samecontrol.CslsameControlResource";

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    protected IObjectValue createNewData() {
        CslGetDataRuleInfo info = new CslGetDataRuleInfo();
        if (this.getOprtState() == OprtState.ADDNEW) {
            info.setCreatOrgUnit((FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit());
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslGetDataRuleFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void initListener() {
        this.dataElementNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CslGetDataRuleEditUI.this.dataElementNumber.getValue() != null) {
                    if (CslGetDataRuleEditUI.this.dataElementNumber.getValue() instanceof String) {
                        try {
                            CslGetDataRuleEditUI.this.getDataElementName();
                        }
                        catch (BOSException e1) {
                            logger.error((Object)"getDataElementName()", (Throwable)e1);
                        }
                    } else {
                        CslGetDataRuleEditUI.this.dataElementName.setText(((DataElementInfo)CslGetDataRuleEditUI.this.dataElementNumber.getValue()).getName());
                    }
                } else {
                    CslGetDataRuleEditUI.this.dataElementName.setText(null);
                }
            }
        });
    }

    private void init() throws Exception {
        this.dataElementNumber.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.dataElementNumber.setEditFormat("$number$");
        this.dataElementNumber.setDisplayFormat("$number$");
        this.dataElementNumber.setEditable(true);
        this.dataElementNumber.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isSys", (Object)true, CompareType.NOTEQUALS));
        view.setFilter(filterInfo);
        this.dataElementNumber.setEntityViewInfo(view);
        this.btnFormula.setIcon(EASResource.getIcon((String)"imgTbtn_formulaguide"));
        if (this.dataElementNumber.getValue() != null) {
            this.getDataElementName();
        }
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.dataElementNumber.setEnabled(true);
        }
        this.modifyTitle();
    }

    private void getDataElementName() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", this.dataElementNumber.getValue(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        DataElementCollection coll = DataElementFactory.getRemoteInstance().getDataElementCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            this.dataElementName.setText(coll.get(0).getName());
        }
    }

    @Override
    protected void btnFormula_actionPerformed(ActionEvent e) throws Exception {
        FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
        picker.addFormulaPickerListener((IFormulaPickerListener)this);
        picker.open();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.dataElementNumber.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"No_dataElementNumber"));
            SysUtil.abort();
        }
        if (this.getOprtState() == OprtState.ADDNEW) {
            FilterInfo filter = new FilterInfo();
            String number = null;
            if (!(this.dataElementNumber.getValue() instanceof String)) {
                filter.getFilterItems().add(new FilterItemInfo("dateElementNumber", (Object)((DataElementInfo)this.dataElementNumber.getValue()).getNumber(), CompareType.EQUALS));
                number = ((DataElementInfo)this.dataElementNumber.getValue()).getNumber();
            } else {
                filter.getFilterItems().add(new FilterItemInfo("dateElementNumber", this.dataElementNumber.getValue(), CompareType.EQUALS));
                number = (String)this.dataElementNumber.getValue();
            }
            if (this.getBizInterface().exists(filter)) {
                MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)this.rsePatch, (String)"Exist_Number"), number));
                SysUtil.abort();
            }
        }
        super.verifyInput(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("isSystem"));
        if (this.editData != null && this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            CslGetDataRuleInfo info = ((ICslGetDataRule)this.getBizInterface()).getCslGetDataRuleInfo((IObjectPK)pk, sc);
            if (info.getIsSystem() != 0) {
                MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"is_System"));
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.dataElementNumber.getValue() != null) {
            if (this.dataElementNumber.getValue() instanceof String) {
                this.editData.setDateElementNumber((String)this.dataElementNumber.getValue());
            } else {
                this.editData.setDateElementNumber(((DataElementInfo)this.dataElementNumber.getValue()).getNumber());
            }
        }
    }

    public void pickerSetout(FormulaPickerUI picker) {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.modifyTitle();
        this.dataElementNumber.setEnabled(true);
    }

    public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
        if (isOk) {
            this.txtFormula.setText(this.txtFormula.getText() + formulaLine);
        }
    }

    private void modifyTitle() {
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)this.rsePatch, (String)"AddNewRule"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)this.rsePatch, (String)"ViewRule"));
        } else {
            this.setUITitle(EASResource.getString((String)this.rsePatch, (String)"EditRule"));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.modifyTitle();
    }
}

