/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.newrpt.samecontrol.CslOrgUnitFactory;
import com.kingdee.eas.fi.newrpt.samecontrol.CslOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.samecontrol.ICslOrgUnit;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.newrpt.samecontrol.client.AbstractCslOrgUnitEditUI;
import com.kingdee.eas.fi.newrpt.samecontrol.client.OrgTreeF7;
import com.kingdee.eas.fi.newrpt.samecontrol.client.OrgUnitF7SelectorOfCslOrg;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CslOrgUnitEditUI
extends AbstractCslOrgUnitEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CslOrgUnitEditUI.class);
    protected MnsUnionF7 orgUnionf7 = null;
    protected OrgTreeCollection orgTreeColl = null;
    protected boolean isOrgTreeCollInited = false;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private String rsePatch = "com.kingdee.eas.fi.newrpt.samecontrol.CslsameControlResource";

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    protected IObjectValue createNewData() {
        CslOrgUnitInfo info = new CslOrgUnitInfo();
        if (this.getOprtState() == OprtState.ADDNEW) {
            info.setCreatOrgUnit((FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit());
        }
        info.setIsHandleExch(new Integer(1));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslOrgUnitFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initListener();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getDisposalType() == null) {
            this.comboDisposalType.setSelectedIndex(0);
        }
        if (this.editData.getIsHandleExch() == 0 && this.getOprtState() != OprtState.ADDNEW) {
            this.kDCheckBox1.setSelected(false);
        }
        if (this.editData.getDate() == null) {
            Date date = null;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(this.df.format(System.currentTimeMillis()));
            }
            catch (ParseException e1) {
                logger.error((Object)"new SimpleDateFormat().parse(df.format(System.currentTimeMillis())) ", (Throwable)e1);
            }
            this.pkDate.setValue(date);
        }
        if (this.editData.getOrgTree() != null) {
            this.prmtOrgTree.setValue((Object)this.editData.getOrgTree());
        }
        if (this.editData.getCompany() != null) {
            this.prmtCompany.setValue((Object)this.editData.getCompany());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.kDCheckBox1.isSelected()) {
            this.editData.setIsHandleExch(new Integer(1));
        } else {
            this.editData.setIsHandleExch(new Integer(0));
        }
    }

    protected void initListener() {
        this.prmtOrgTree.addDataChangeListener(new DataChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null) {
                    CslOrgUnitEditUI.this.prmtCompany.setValue(null);
                    CslOrgUnitEditUI.this.prmtDisposalOrgUnit.setValue(null);
                    CslOrgUnitEditUI.this.prmtCslOfOrgUnit.setValue(null);
                    CslOrgUnitEditUI.this.prmtCompany.setSelector((KDPromptSelector)new OrgUnitF7SelectorOfCslOrg());
                    return;
                }
                if (eventObj.getOldValue() != null && ((OrgTreeInfo)eventObj.getOldValue()).getNumber().equals(((OrgTreeInfo)eventObj.getNewValue()).getNumber())) {
                    return;
                }
                CslOrgUnitEditUI.this.prmtCompany.setValue(null);
                CslOrgUnitEditUI.this.prmtDisposalOrgUnit.setValue(null);
                CslOrgUnitEditUI.this.prmtCslOfOrgUnit.setValue(null);
                String orgTreeNumber = ((OrgTreeInfo)CslOrgUnitEditUI.this.prmtOrgTree.getValue()).getNumber();
                CslOrgUnitEditUI.this.prmtCompany.setSelector((KDPromptSelector)new OrgUnitF7SelectorOfCslOrg(orgTreeNumber));
                try {
                    CslOrgUnitEditUI.this.orgUnionf7.setCanStart(false);
                    CslOrgUnitEditUI.this.orgTreeColl = SameControlUtil.getOrgTreeCollection();
                    for (int i = 0; i < CslOrgUnitEditUI.this.orgTreeColl.size(); ++i) {
                        if (CslOrgUnitEditUI.this.orgTreeColl.get(i).getNumber().equals(orgTreeNumber)) continue;
                        CslOrgUnitEditUI.this.orgTreeColl.removeObject(i);
                        --i;
                    }
                    CslOrgUnitEditUI.this.orgUnionf7.setOrgTreeColl(CslOrgUnitEditUI.this.orgTreeColl);
                    CslOrgUnitEditUI.this.orgUnionf7.initUI();
                    CslOrgUnitEditUI.this.orgUnionf7.reRoadOrgTree();
                }
                catch (Exception e1) {
                    logger.error((Object)"getOrgTreeCollection error", (Throwable)e1);
                }
                finally {
                    CslOrgUnitEditUI.this.orgUnionf7.setCanStart(true);
                }
            }
        });
        this.prmtCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OrgTreeInfo info;
                FullOrgUnitInfo info2;
                if (CslOrgUnitEditUI.this.prmtCompany.getValue() != null && (info2 = CslOrgUnitEditUI.this.getDirectsuperior(info = (OrgTreeInfo)((OrgUnitInfo)CslOrgUnitEditUI.this.prmtCompany.getValue()).get("OrgTreeInfo"), (OrgUnitInfo)CslOrgUnitEditUI.this.prmtCompany.getValue())) != null) {
                    CslOrgUnitEditUI.this.prmtDisposalOrgUnit.setValue((Object)info2);
                }
            }
        });
        this.comboDisposalType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CslOrgUnitEditUI.this.comboDisposalType.getSelectedIndex() == 1) {
                    CslOrgUnitEditUI.this.prmtCslOfOrgUnit.setValue(null);
                    CslOrgUnitEditUI.this.prmtCslOfOrgUnit.setEnabled(false);
                } else {
                    CslOrgUnitEditUI.this.prmtCslOfOrgUnit.setEnabled(true);
                }
            }
        });
    }

    private FullOrgUnitInfo getDirectsuperior(OrgTreeInfo treeInfo, OrgUnitInfo unitInfo) {
        if (treeInfo != null && unitInfo != null) {
            String treeid = treeInfo.getId().toString();
            String unitid = unitInfo.getId().toString();
            FullOrgUnitInfo info = null;
            try {
                info = ((ICslOrgUnit)this.getBizInterface()).getDirectsuperior(treeid, unitid);
            }
            catch (Exception e) {
                logger.error((Object)"getDirectsuperior()", (Throwable)e);
            }
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        OrgTreeF7 f7 = new OrgTreeF7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.sorgse"));
        this.prmtOrgTree.setSelector((KDPromptSelector)f7);
        this.prmtOrgTree.setEditable(false);
        this.prmtOrgTree.setDisplayFormat("$name$");
        if (this.prmtOrgTree.getValue() != null) {
            String orgTreeNumber = ((OrgTreeInfo)this.prmtOrgTree.getValue()).getNumber();
            this.prmtCompany.setSelector((KDPromptSelector)new OrgUnitF7SelectorOfCslOrg(orgTreeNumber));
        } else {
            this.prmtCompany.setSelector((KDPromptSelector)new OrgUnitF7SelectorOfCslOrg());
        }
        this.prmtCompany.setEditable(false);
        if (this.orgUnionf7 == null) {
            this.orgUnionf7 = new MnsUnionF7((IUIObject)this);
            this.orgUnionf7.setShowAssistantOrg(true);
            this.orgUnionf7.setCheckedAssistantOrgChkBox(true);
            this.orgUnionf7.setEnableCurOrgTreeRootNode(true);
            this.orgUnionf7.setMultiSelect(false);
            this.orgUnionf7.setSelectMode(2);
            this.orgUnionf7.setCascadingSelection(false);
            HashSet selectOrgIdSet = new HashSet();
            this.orgUnionf7.setCheckedOrgIDs(selectOrgIdSet);
            this.orgUnionf7.setUnChangeableOrgIDs(selectOrgIdSet);
            try {
                this.orgUnionf7.setCanStart(false);
                if (this.prmtOrgTree.getValue() == null) {
                    this.orgTreeColl = SameControlUtil.getOrgTreeCollection();
                } else {
                    OrgTreeInfo info = (OrgTreeInfo)this.prmtOrgTree.getValue();
                    this.orgTreeColl = SameControlUtil.getOrgTreeCollection();
                    for (int i = 0; i < this.orgTreeColl.size(); ++i) {
                        if (this.orgTreeColl.get(i).getNumber().equals(info.getNumber())) continue;
                        this.orgTreeColl.removeObject(i);
                        --i;
                    }
                }
                this.orgUnionf7.setOrgTreeColl(this.orgTreeColl);
                this.orgUnionf7.initUI();
                this.orgUnionf7.reRoadOrgTree();
            }
            catch (Exception e) {
                logger.error((Object)"getOrgTreeCollection error", (Throwable)e);
            }
            finally {
                this.orgUnionf7.setCanStart(true);
            }
        }
        this.prmtDisposalOrgUnit.setSelector((KDPromptSelector)this.orgUnionf7);
        this.prmtDisposalOrgUnit.setEditable(false);
        this.prmtCslOfOrgUnit.setSelector((KDPromptSelector)this.orgUnionf7);
        this.prmtCslOfOrgUnit.setEditable(false);
        this.modifyTitle();
        if (this.comboDisposalType.getSelectedIndex() == 1) {
            this.prmtCslOfOrgUnit.setValue(null);
            this.prmtCslOfOrgUnit.setEnabled(false);
        } else {
            this.prmtCslOfOrgUnit.setEnabled(true);
        }
        if (this.comboDisposalType.getSelectedIndex() == 1) {
            this.prmtCslOfOrgUnit.setEnabled(false);
        }
    }

    private void modifyTitle() {
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)this.rsePatch, (String)"AddNewTitle"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)this.rsePatch, (String)"ViewTitle"));
        } else {
            this.setUITitle(EASResource.getString((String)this.rsePatch, (String)"EditTitle"));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtOrgTree.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"NoSelectOrgTree"));
            SysUtil.abort();
        }
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"NoSelectCompany"));
            SysUtil.abort();
        }
        if (this.prmtDisposalOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"NoSelectDisposalOrgUnit"));
            SysUtil.abort();
        }
        if (this.prmtCslOfOrgUnit.getValue() == null && this.comboDisposalType.getSelectedIndex() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"NoSelectCslOfOrgUnit"));
            SysUtil.abort();
        }
        if (this.pkDate.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"NoSelectPkDate"));
            SysUtil.abort();
        }
        if (this.comboDisposalType.getSelectedIndex() == 0 && ((FullOrgUnitInfo)this.prmtDisposalOrgUnit.getValue()).getId().toString().equals(((FullOrgUnitInfo)this.prmtCslOfOrgUnit.getValue()).getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"PleaseCheck"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)this.getYearOrPeriod((Date)this.pkDate.getValue(), 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)(this.getYearOrPeriod((Date)this.pkDate.getValue(), 2) + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgTree.number", (Object)((OrgTreeInfo)this.prmtOrgTree.getValue()).getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)((FullOrgUnitInfo)this.prmtCompany.getValue()).getId().toString(), CompareType.EQUALS));
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.getBizInterface().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"IsExist"));
            SysUtil.abort();
        }
        this.editData.setLastDate(this.getLastDate((Date)this.pkDate.getValue()));
        this.editData.setYear(this.getYearOrPeriod((Date)this.pkDate.getValue(), 1));
        this.editData.setPeriod(this.getYearOrPeriod((Date)this.pkDate.getValue(), 2) + 1);
        if (this.kDCheckBox1.isSelected()) {
            this.editData.setIsHandleExch(new Integer(1));
        } else {
            this.editData.setIsHandleExch(new Integer(0));
        }
        super.verifyInput(e);
    }

    private Date getLastDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        Date lastDate = c.getTime();
        return lastDate;
    }

    private int getYearOrPeriod(Date date, int i) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int YearOrPeriod = c.get(i);
        return YearOrPeriod;
    }

    @Override
    protected void kDCheckBox1_actionPerformed(ActionEvent e) throws Exception {
        if (!this.kDCheckBox1.isSelected()) {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"IsNoSelect"));
            this.kDCheckBox1.setSelected(false);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)this.rsePatch, (String)"IsSelect"));
            this.kDCheckBox1.setSelected(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("orgTree.*"));
        sic.add(new SelectorItemInfo("disposalOrgUnit.*"));
        sic.add(new SelectorItemInfo("cslOfOrgUnit.*"));
        sic.add(new SelectorItemInfo("date"));
        sic.add(new SelectorItemInfo("disposalType"));
        sic.add(new SelectorItemInfo("isHandleExch"));
        return sic;
    }

    @Override
    protected void prmtDisposalOrgUnit_willShow(SelectorEvent e) throws Exception {
        if (this.prmtOrgTree.getValue() == null) {
            e.setCanceled(true);
            MsgBox.showWarning((String)EASResource.getString((String)this.rsePatch, (String)"PleaseSelectOrgTree"));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtCslOfOrgUnit_willShow(SelectorEvent e) throws Exception {
        if (this.prmtOrgTree.getValue() == null) {
            e.setCanceled(true);
            MsgBox.showWarning((String)EASResource.getString((String)this.rsePatch, (String)"PleaseSelectOrgTree"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.modifyTitle();
        this.kDCheckBox1.setSelected(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.comboDisposalType.getSelectedIndex() == 1) {
            this.prmtCslOfOrgUnit.setEnabled(false);
        }
        this.modifyTitle();
    }
}

