/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.client.UnionVersionF7UI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class OrgTreeF7UI
extends UnionVersionF7UI {
    private static final long serialVersionUID = 1L;

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkDisplayArchive.setVisible(false);
        this.initTreeListeners();
    }

    private void initTreeListeners() {
        this.kDTree1.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)OrgTreeF7UI.this.kDTree1.getLastSelectedPathComponent();
                    if (treeNode == null) {
                        return;
                    }
                    TreeNodeObject userObject = (TreeNodeObject)treeNode.getUserObject();
                    if (userObject != null) {
                        try {
                            OrgTreeF7UI.this.onClickForBtnOK();
                        }
                        catch (Exception exc) {
                            ExceptionHandler.handle((Component)((Object)OrgTreeF7UI.this), (Throwable)exc);
                        }
                    }
                }
            }
        });
    }

    protected void buildTree() throws Exception {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(null);
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.newrpt.samecontrol.OrgTreeQueryForF7"));
        String oql = "where OrgTree.type = 8 and OrgTree.status = 1 and OrgTree.layerType <>6";
        oql = oql + " and (isHide = 0 or isHide is null)";
        queryExecutor.setObjectView(oql);
        IRowSet rowSet = queryExecutor.executeQuery();
        List treeList = this.getCurrentUserUnionTree();
        while (rowSet.next()) {
            String id = rowSet.getString("id");
            if (!treeList.contains(id)) continue;
            root.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)new TreeNodeObject(rowSet.getString("number"), rowSet.getString("name"), id)));
        }
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        this.kDTree1.setModel((TreeModel)treeModel);
        this.kDTree1.setRootVisible(false);
        this.kDTree1.setShowCheckBox(false);
        this.kDTree1.repaint();
    }

    private List getCurrentUserUnionTree() throws Exception {
        ArrayList<String> treeList = new ArrayList<String>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectStringPK pk = new ObjectStringPK(userInfo.getId().toString());
        OrgTreeCollection treeCol = PermissionFactory.getRemoteInstance().getAllUnionTrees((IObjectPK)pk);
        if (treeCol != null && treeCol.size() > 0) {
            for (int i = 0; i < treeCol.size(); ++i) {
                treeList.add(treeCol.get(i).getId().toString());
            }
        }
        return treeList;
    }

    public Object getData() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.kDTree1.getLastSelectedPathComponent();
        if (treeNode == null) {
            return null;
        }
        TreeNodeObject nodeObject = (TreeNodeObject)treeNode.getUserObject();
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setNumber(nodeObject.getNumber());
        treeInfo.setName(nodeObject.getName());
        treeInfo.setId(BOSUuid.read((String)nodeObject.getID()));
        return treeInfo;
    }

    private static class TreeNodeObject {
        private String number;
        private String name;
        private String id;

        public TreeNodeObject(String number, String name, String id) {
            this.number = number;
            this.name = name;
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public String toString() {
            return new StringBuffer(this.number).append(" - ").append(this.name).toString();
        }
    }
}

