/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import org.apache.log4j.Logger;

public class OrgUnitF7SelectorOfCslOrg
extends KDDialog
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger(OrgUnitF7SelectorOfCslOrg.class);
    private String resClassName = "com.kingdee.eas.fi.newrpt.samecontrol.CslsameControlResource";
    private OrgUnitInfo orgUnit = null;
    private String orgTreeNumber = null;

    public OrgUnitF7SelectorOfCslOrg() {
    }

    public OrgUnitF7SelectorOfCslOrg(String orgTreeNumber) {
        this.orgTreeNumber = orgTreeNumber;
    }

    public boolean isCanceled() {
        return false;
    }

    public Object getData() {
        return this.orgUnit;
    }

    public void show() {
        this.createOrgTree();
    }

    public void createOrgTree() {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7(true, 3);
        try {
            OrgTreeCollection otc = SameControlUtil.getOrgTreeCollection();
            if (this.orgTreeNumber == null || this.orgTreeNumber.isEmpty()) {
                MsgBox.showWarning((String)EASResource.getString((String)this.resClassName, (String)"PleaseSelectOrgTree"));
                SysUtil.abort();
            }
            if (this.orgTreeNumber != null && otc != null) {
                for (int i = 0; i < otc.size(); ++i) {
                    if (this.orgTreeNumber.equals(otc.get(i).getNumber())) continue;
                    otc.removeObject(i);
                    --i;
                }
            }
            f7.setOrgTrees(otc);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"f7.setOrgTrees(getOrgTreeCollection())", e);
        }
        f7.setMultiSelect(false);
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        f7.setNeedAddOrgRange(false);
        f7.show();
        OrgTreeInfo info = f7.getSelectedOrgTree();
        if (!f7.isCanceled()) {
            this.orgUnit = (OrgUnitInfo)f7.getData();
        } else {
            SysUtil.abort();
        }
        if (this.orgUnit == null) {
            return;
        }
        if (!this.orgUnit.getLongNumber().contains("!")) {
            MsgBox.showWarning((String)EASResource.getString((String)this.resClassName, (String)"NoSelectTopUnit"));
            this.createOrgTree();
        }
        this.orgUnit.put("OrgTreeInfo", (Object)info);
    }
}

