/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.sqlGetData;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterFactory;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.IDBCenter;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ISqlUtilFacade;
import com.kingdee.eas.fi.rpt.SqlUtilFacadeFactory;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.SqlResult;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FillSqlGetDataHelp {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.sqlGetData.FillSqlGetDataHelp");
    private Context ctx;
    private Sheet sheet;
    private Point basePoint;
    private Point endPoint;
    private DynaParameters dynaParam;
    private ReportVariables vars;
    private IReportPropertyAdapter adapt;
    private Book book;
    private Map<String, String> filterAndValue = new HashMap<String, String>();
    private int indexIncrement = 1;

    public FillSqlGetDataHelp() {
        this.putValueToMap();
    }

    public FillSqlGetDataHelp(Context ctx, Sheet sheet, Point basePoint, DynaParameters dynaParam, ReportVariables vars, IReportPropertyAdapter adapt, Book book) {
        this.ctx = ctx;
        this.sheet = sheet;
        this.basePoint = basePoint;
        this.dynaParam = dynaParam;
        if (basePoint != null) {
            this.endPoint = this.getDynaRange(sheet, basePoint);
        }
        this.vars = vars;
        this.adapt = adapt;
        this.book = book;
        if (dynaParam != null) {
            DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(dynaParam, basePoint, sheet, true, true);
            int beforeDynaItemCount = indexHandle.getBeforeDynaItemSumRangeCount();
            this.indexIncrement = beforeDynaItemCount + 1;
        }
        this.putValueToMap();
    }

    private void putValueToMap() {
        this.filterAndValue.put("{orgunitid}", "'" + (String)this.adapt.getReportProperty("OrgUnit.Id") + "'");
        this.filterAndValue.put("{orgunitnum}", "'" + (String)this.adapt.getReportProperty("OrgUnit.Number") + "'");
        this.filterAndValue.put("{companynum}", "'" + this.getCompanyNum() + "'");
        this.filterAndValue.put("{companynum}", "'" + this.getCompanyNum() + "'");
        this.filterAndValue.put("{companyId}", "'" + this.getCompanyID() + "'");
        this.filterAndValue.put("{companyid}", "'" + this.getCompanyID() + "'");
        this.filterAndValue.put("{currency}", "'" + this.getCurrencyNumber() + "'");
        this.filterAndValue.put("{startyear}", String.valueOf(this.getSheetStartYear() + this.getReportYear()));
        int endYear = this.getSheetEndYear() + this.getReportYear();
        this.filterAndValue.put("{endyear}", String.valueOf(endYear));
        this.filterAndValue.put("{startperiod}", String.valueOf(this.getSheetStartPeriod() + this.getReportPeriod()));
        int endPeriod = this.getSheetEndPeriod() + this.getReportPeriod();
        this.filterAndValue.put("{endperiod}", String.valueOf(endPeriod));
        this.filterAndValue.put("{startdate}", "{ts'" + (this.getSheetStartYear() + this.getReportYear()) + "-" + (this.getSheetStartPeriod() + this.getReportPeriod()) + "-1 00:00:00'}");
        this.filterAndValue.put("{enddate}", "{ts'" + endYear + "-" + endPeriod + "-" + this.getLastDayOfMonth(endYear, endPeriod) + " 23:59:59'}");
    }

    public int getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        return lastDay;
    }

    public static FillSqlGetDataHelp getInstance(Context ctx, Sheet sheet, Point basePoint, DynaParameters param, ReportVariables vars, IReportPropertyAdapter adapt, Book book) {
        return new FillSqlGetDataHelp(ctx, sheet, basePoint, param, vars, adapt, book);
    }

    private void preSqlDataFillSheet(String sql, boolean needShowIndex, String dbCenterNumber) throws BOSException {
        String exeSql = this.getExeSql(sql);
        ISqlUtilFacade exeSqlUtil = this.ctx == null ? SqlUtilFacadeFactory.getRemoteInstance() : SqlUtilFacadeFactory.getLocalInstance((Context)this.ctx);
        IRowSet rowset = null;
        if (dbCenterNumber == null) {
            SqlResult rs = exeSqlUtil.execute(exeSql);
            rowset = this.getJdbcRowSet(rs);
        } else {
            try {
                DBCenterInfo dbCenter = this.getDBCenterInfo(dbCenterNumber);
                rowset = exeSqlUtil.excuteQueryByDbCenter(dbCenter, exeSql, null);
            }
            catch (EASBizException e) {
                logger.error((Object)"preSqlDataFillSheet: ", (Throwable)e);
            }
        }
        if (rowset != null) {
            this.preRangeFormula(rowset, this.dynaParam.getSpreadStyle(), needShowIndex);
        }
    }

    private DBCenterInfo getDBCenterInfo(String dbCenterNumber) throws BOSException, EASBizException {
        IDBCenter iDBCenter = this.ctx == null ? DBCenterFactory.getRemoteInstance() : DBCenterFactory.getLocalInstance(this.ctx);
        DBCenterInfo dbCenter = iDBCenter.getDBCenterInfo("where number = '" + dbCenterNumber + "'");
        if (dbCenter != null && !StringUtils.isEmpty((String)dbCenter.getDbPassWord())) {
            String secret = new String(Base64.decode((String)dbCenter.getDbPassWord()));
            dbCenter.setDbPassWord(secret);
        }
        return dbCenter;
    }

    private void insertRowRange(int site, int range) {
        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(site, site + range)).insert(true, InsertType.NOSTYLE);
    }

    private void deleteRowRange(int startRowIndex, int endRowIndex) {
        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(startRowIndex, endRowIndex)).delete();
    }

    private void insertColRange(int site, int range) {
        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getColRange(site, site + range)).insert(true, InsertType.NOSTYLE);
    }

    private void deleteColRange(int startColIndex, int endColIndex) {
        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(startColIndex, endColIndex)).delete();
    }

    private String constructFormula(ItemFormula itemFormula, String dnumber) {
        if (itemFormula == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(itemFormula.getItemNumber() + "\",\"");
        strBuffer.append(dnumber + "\",");
        strBuffer.append(itemFormula.getYearOffSet() + ",");
        strBuffer.append(itemFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(itemFormula.getDataElementNumber() + "\",\"");
        ValueTypeEnum type = ValueTypeEnum.getEnum((int)itemFormula.getValueType());
        if (type == null) {
            return null;
        }
        strBuffer.append(ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private void preRangeFormula(IRowSet rowset, int spreadStyle, boolean needShowIndex) {
        try {
            int insertCount;
            boolean isVertical = spreadStyle == 0;
            int formulaDynaStartIndex = isVertical ? this.basePoint.x : this.basePoint.y;
            int formulaDynaEndIndex = isVertical ? this.endPoint.x : this.endPoint.y;
            int n = insertCount = rowset.size() == 0 ? 1 - this.dynaParam.getDefaultCounter() : rowset.size() - this.dynaParam.getDefaultCounter();
            if (isVertical) {
                if (insertCount > 0) {
                    this.insertRowRange(this.basePoint.y + this.indexIncrement + 1, insertCount - 1);
                } else if (insertCount < 0) {
                    this.deleteRowRange(this.basePoint.y + this.indexIncrement + 1, this.basePoint.y + this.indexIncrement - insertCount);
                }
            } else if (insertCount > 0) {
                this.insertColRange(this.basePoint.x + this.indexIncrement + 1, insertCount - 1);
            } else if (insertCount < 0) {
                this.deleteColRange(this.basePoint.x + this.indexIncrement + 1, this.basePoint.x + this.indexIncrement - insertCount);
            }
            this.dynaParam.setDefaultCounter(rowset.size() == 0 ? 1 : rowset.size());
            this.dynaParam.setDynaItemSource(1);
            DynamicTemplateUtility.saveParametersToCell((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x), (DynaParameters)this.dynaParam);
            while (formulaDynaStartIndex <= formulaDynaEndIndex) {
                int rowIndex = isVertical ? this.basePoint.y : formulaDynaStartIndex;
                int colIndex = isVertical ? formulaDynaStartIndex : this.basePoint.x;
                ItemFormula itemFormula = (ItemFormula)this.sheet.getRange(rowIndex, colIndex).getUserObject("ITEM");
                String formula = (String)this.sheet.getRange(rowIndex, colIndex).getUserObject("tempFomula");
                if (StringUtils.isEmpty((String)formula)) {
                    formula = this.sheet.getRange(rowIndex + 1, colIndex).getFormula();
                }
                if (isVertical) {
                    rowIndex += this.indexIncrement;
                } else {
                    colIndex += this.indexIncrement;
                }
                if (formulaDynaStartIndex == (isVertical ? this.basePoint.x : this.basePoint.y) || itemFormula != null) {
                    HashMap<String, Integer> showValueIndex = new HashMap<String, Integer>();
                    while (rowset.next()) {
                        if (formulaDynaStartIndex == (isVertical ? this.basePoint.x : this.basePoint.y)) {
                            String showValue;
                            String string = showValue = rowset.getObject("showValue") == null ? null : rowset.getObject("showValue").toString();
                            if (needShowIndex) {
                                int index = 0;
                                if (showValueIndex.get(showValue) != null) {
                                    index = (Integer)showValueIndex.get(showValue) + 1;
                                }
                                this.sheet.getRange(rowIndex, colIndex).setValue(new Variant((Object)(index != 0 ? showValue + index : showValue)));
                                showValueIndex.put(showValue, index);
                            } else {
                                this.sheet.getRange(rowIndex, colIndex).setValue(new Variant((Object)showValue));
                            }
                        } else {
                            String showDynaItem;
                            String dynaItem = rowset.getObject("dynaItem") == null ? null : rowset.getObject("dynaItem").toString();
                            String string = showDynaItem = rowset.getObject("showValue") == null ? null : rowset.getObject("showValue").toString();
                            if (needShowIndex) {
                                int index = 0;
                                if (showValueIndex.get(showDynaItem) != null) {
                                    index = (Integer)showValueIndex.get(showDynaItem) + 1;
                                }
                                showValueIndex.put(showDynaItem, index);
                                showDynaItem = index != 0 ? showDynaItem + "" + index : showDynaItem;
                            }
                            String newItemFormula = this.constructFormula(itemFormula, showDynaItem);
                            this.sheet.getRange(rowIndex, colIndex).setUserObject("ITEM", (Object)new ItemFormula(newItemFormula));
                            if (formula != null && formula.length() > 0) {
                                String newFormula = this.getNewFormula(formula, dynaItem);
                                this.sheet.getRange(rowIndex, colIndex).setFormula(newFormula);
                            }
                        }
                        if (isVertical) {
                            ++rowIndex;
                            continue;
                        }
                        ++colIndex;
                    }
                    rowset.beforeFirst();
                }
                ++formulaDynaStartIndex;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String getNewFormula(String formula, String dynaItem) {
        String newFormulaTemp = formula.replace("{@}", "{aaaaaaaaaaa}");
        newFormulaTemp = newFormulaTemp.replaceAll("(?i)dynaitem", dynaItem);
        newFormulaTemp = newFormulaTemp.replace("@", dynaItem);
        newFormulaTemp = newFormulaTemp.replace("{aaaaaaaaaaa}", "{@}");
        return newFormulaTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillDataFormSql() throws BOSException {
        Protection pro = null;
        boolean willProtect = false;
        String proPass = null;
        pro = this.sheet.getSheetOption().getProtection(false);
        if (pro != null && pro.isProtected()) {
            proPass = pro.getEncryptedPassword();
            pro.setPassword(proPass);
            pro.stop(proPass);
            willProtect = true;
        }
        try {
            Range sqlRang = this.sheet.getRange(this.basePoint.y, this.basePoint.x);
            String sqlParam = (String)sqlRang.getUserObject("sqlText");
            String sql = null;
            boolean needShowIndex = true;
            String dbCenterNumber = null;
            if (sqlParam != null) {
                String[] sqlTextTemp = sqlParam.split("!");
                sql = sqlTextTemp[0];
                if (sqlTextTemp.length == 2) {
                    needShowIndex = Boolean.parseBoolean(sqlTextTemp[1]);
                }
                if (sqlTextTemp.length == 3) {
                    needShowIndex = Boolean.parseBoolean(sqlTextTemp[1]);
                    dbCenterNumber = sqlTextTemp[2];
                }
            }
            Locale locale = null;
            locale = this.ctx == null ? SysContext.getSysContext().getLocale() : this.ctx.getOriginLocale();
            if (sql == null || !sql.trim().toLowerCase(locale).startsWith("select") && !sql.trim().toLowerCase(locale).startsWith("/*dialect*/") && !sql.trim().toLowerCase(locale).startsWith("call")) {
                boolean bl = false;
                return bl;
            }
            this.setFormulaToHeadRow(this.dynaParam.getSpreadStyle());
            Map tempStyle = new HashMap();
            tempStyle = DynamicTemplateUtility.getCurBasePointFirstLineStyle(tempStyle, (Sheet)this.sheet, (Point)this.basePoint);
            this.preSqlDataFillSheet(sql, needShowIndex, dbCenterNumber);
            DynamicTemplateUtility.setCurBasePointFirstLineStyle(tempStyle, (Sheet)this.sheet, (Point)this.basePoint);
            DynamicTemplateUtility.reAdjustSheetCurBasePointAlign((Point)this.basePoint, (Sheet)this.sheet, (boolean)true, (int)0);
            this.dynaParam.setDynaItemSource(0);
            DynamicTemplateUtility.saveParametersToCell((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x), (DynaParameters)this.dynaParam);
        }
        catch (Exception e) {
            logger.error((Object)"fill Data Form Sql error:", (Throwable)e);
        }
        finally {
            if (willProtect) {
                pro.startWithEncryptedPassword(proPass);
            }
        }
        return true;
    }

    private void setFormulaToHeadRow(int spreadStyle) {
        String formulaStr = null;
        if (spreadStyle == 0) {
            for (int i = this.basePoint.x + 1; i <= this.endPoint.x; ++i) {
                formulaStr = this.sheet.getRange(this.basePoint.y + this.indexIncrement, i).getFormula();
                if (formulaStr == null) continue;
                Object object = this.sheet.getRange(this.basePoint.y, i).getUserObject("tempFomula");
                if (formulaStr.startsWith("=sqlGetData")) {
                    if (!formulaStr.contains("\"@\"") && !formulaStr.contains("{@}") || object != null) continue;
                    this.sheet.getRange(this.basePoint.y, i).setUserObject("tempFomula", (Object)formulaStr);
                    continue;
                }
                if (!formulaStr.startsWith("=") || object != null) continue;
                this.sheet.getRange(this.basePoint.y, i).setUserObject("tempFomula", (Object)formulaStr);
            }
        } else {
            for (int i = this.basePoint.y + 1; i <= this.endPoint.y; ++i) {
                formulaStr = this.sheet.getRange(i, this.basePoint.y + this.indexIncrement).getFormula();
                if (formulaStr == null) continue;
                Object object = this.sheet.getRange(this.basePoint.y, i).getUserObject("tempFomula");
                if (formulaStr.startsWith("=sqlGetData")) {
                    if (!formulaStr.contains("\"@\"") && !formulaStr.contains("{@}") || object != null) continue;
                    this.sheet.getRange(i, this.basePoint.x).setUserObject("tempFomula", (Object)formulaStr);
                    continue;
                }
                if (!formulaStr.startsWith("=") || object != null) continue;
                this.sheet.getRange(i, this.basePoint.x).setUserObject("tempFomula", (Object)formulaStr);
            }
        }
    }

    public String getExeSql(String sqlText) {
        for (Map.Entry<String, String> entry : this.filterAndValue.entrySet()) {
            sqlText = sqlText.replace(entry.getKey(), entry.getValue());
        }
        return sqlText;
    }

    public IRowSet getJdbcRowSet(SqlResult rs) {
        if (rs != null && rs.getRowSets().size() > 0) {
            int size = rs.getRowSets().size();
            return (IRowSet)rs.getRowSets().get(size - 1);
        }
        return null;
    }

    protected int getSheetStartYear() {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.getIntValue("StartYear", this.sheet.getSheetName(), 0);
    }

    protected int getReportYear() {
        return (Integer)this.adapt.getReportProperty("Report.Year");
    }

    protected int getSheetStartPeriod() {
        return this.vars.getIntValue("StartPeriod", this.sheet.getSheetName(), 0);
    }

    protected int getSheetEndPeriod() {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.getIntValue("EndPeriod", this.sheet.getSheetName(), 0);
    }

    protected int getReportPeriod() {
        return (Integer)this.adapt.getReportProperty("Report.Period");
    }

    protected int getSheetEndYear() {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.getIntValue("EndYear", this.sheet.getSheetName(), 0);
    }

    protected String getCompanyID() {
        return (String)this.adapt.getReportProperty("Company.ID");
    }

    protected String getCompanyNum() {
        return (String)this.adapt.getReportProperty("Company.Number");
    }

    protected String getCurrencyNumber() {
        String currency = this.vars.getStringValue("Currency", this.sheet.getSheetName());
        if (StringUtils.isEmpty((String)currency)) {
            currency = (String)this.adapt.getReportProperty("Currency.Number");
        }
        return currency;
    }

    public int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    public int getRowCount(Sheet curSheet, int top, int left) {
        int height;
        for (int i = height = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    public Point getDynaRange(Sheet sheet, Point basePoint) {
        Point point = null;
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
        int colSize = param.getDefaultCounter();
        int x = basePoint.y;
        int y = basePoint.x;
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        if (param.getSpreadStyle() == 0) {
            int x1 = x + colSize + indexHandle.getSumRangeCount();
            point = new Point(this.getColCount(sheet, x, y), x1);
        } else if (param.getSpreadStyle() == 1) {
            int y1 = y + colSize + indexHandle.getSumRangeCount();
            point = new Point(y1, this.getRowCount(sheet, x, y));
        }
        return point;
    }
}

