/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.stat;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.eas.fi.newrpt.stat.IBookCheck;
import com.kingdee.eas.fi.newrpt.stat.Limit;
import com.kingdee.eas.fi.newrpt.stat.StatisticalResult;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.Map;

public abstract class AbstractBookCheck
implements IBookCheck {
    private static final String STATRES = "com.kingdee.eas.fi.newrpt.stat.BookStatResource";
    protected final int STAT_CELL_CONUT = 0;
    protected final int STAT_SHEET_CONUT = 1;
    protected final int STAT_FUNCTION_COUNT = 2;
    protected final int STAT_EXCELFUNCTION_COUNT = 3;
    protected final int STAT_BIZFUNCTION_COUNT = 4;
    private BookFormulaHelper.StatResult statResult;
    protected Book book;
    protected Map<String, Limit> limitMap;
    protected Limit limit;

    public AbstractBookCheck(Book book, Map<String, Limit> limitMap) {
        this.book = book;
        this.limitMap = limitMap;
        this.setLimit(this.initLimit());
    }

    private BookFormulaHelper.StatResult getStatResult() {
        if (this.statResult == null) {
            this.statResult = BookFormulaHelper.statBook((Book)this.book);
        }
        return this.statResult;
    }

    protected int getStatCount(int statType) {
        switch (statType) {
            case 1: {
                return this.book.getSheetCount();
            }
            case 0: {
                return this.getStatResult().getCellHasContentCount();
            }
            case 2: {
                return this.getStatResult().getFunctionCount();
            }
            case 3: {
                return this.getStatResult().getExcelFunctionCount();
            }
            case 4: {
                return this.getStatResult().getBizFunctionCount();
            }
        }
        return 0;
    }

    protected Map getFunctionMap() {
        return this.getStatResult().getFunctionMap();
    }

    protected void setLimit(Limit limit) {
        this.limit = limit;
    }

    protected String getString(String resName) {
        return EASResource.getString((String)STATRES, (String)resName);
    }

    protected String getString(String resName, Object[] arguments) {
        return MessageFormat.format(this.getString(resName), arguments);
    }

    protected abstract Limit initLimit();

    @Override
    public abstract StatisticalResult check();
}

