/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.MergeReportHandlerFacadeFactory;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.designer.IMergeReportHandler;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MergeReportHandlerImp
implements IMergeReportHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.util.MergeReportHandlerImp");

    @Override
    public Map<String, List> getOrgStructureInfoAndTemplate(Context ctx, String fastMergeSoleId, PeriodInfo periodInfo, RptPeriodTypeEnum periodType) throws Exception {
        logger.error((Object)("enterinfo:::ctx=" + ctx + ",fastMergeSoleId=" + fastMergeSoleId + ",PeriodInfo=[" + (periodInfo == null ? null : "periodYear=" + periodInfo.getPeriodYear() + ",periodNumber=" + periodInfo.getPeriodNumber()) + "],RptPeriodTypeEnum=" + periodType));
        HashMap<String, List> resultsMap = new HashMap<String, List>();
        if (ctx == null) {
            try {
                return MergeReportHandlerFacadeFactory.getRemoteInstance().getOrgStructureInfoAndTemplate(fastMergeSoleId, periodInfo, periodType);
            }
            catch (Exception e) {
                logger.error((Object)"getOrgStructureInfoAndTemplate error", (Throwable)e);
                throw e;
            }
        }
        if (StringUtils.isEmpty((String)fastMergeSoleId)) {
            logger.error((Object)"fastMergeSoleId isEmpty...");
            return resultsMap;
        }
        int periodYear = periodInfo.getPeriodYear();
        int periodNumber = periodInfo.getPeriodNumber();
        if (periodYear == 0 || periodNumber == 0) {
            logger.error((Object)"periodYear or periodNumber isZero...");
            return resultsMap;
        }
        Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)periodYear, (int)periodNumber, (RptPeriodTypeEnum)periodType);
        String dateSql = CslRptUtil.formatDateForSql((Date)periodLastDate);
        try {
            StringBuffer sqlSb = new StringBuffer();
            sqlSb.append("select structure.FID,structure.FLONGNUMBER,structure.FTREEID,structure.FUNITID,structure.FDISPLAYNAME_" + ctx.getLocale() + "  from T_ORG_Structure structure ");
            sqlSb.append("join T_ORG_BaseUnit unit on unit.fid = structure.funitid ");
            sqlSb.append("join T_ORG_Tree ttree on structure.FTreeId = ttree.fid ");
            sqlSb.append("join T_ORG_Tree tree on ttree.fnumber = tree.fnumber ");
            sqlSb.append("join T_CSL_FastMergeSolu fastMergeSolu on tree.fid = fastMergeSolu.FOrgBoundID ");
            sqlSb.append("join T_CSL_FastMergeOrgUnit fastMergeOrgUnit on fastMergeOrgUnit.FFastMergeSoluID = fastMergeSolu.FID ");
            sqlSb.append("join T_ORG_BaseUnit unit2 on unit2.fid = fastMergeOrgUnit.FORGUNITID and unit2.fnumber = unit.fnumber ");
            sqlSb.append("where fastMergeSolu.fid='" + fastMergeSoleId + "' ");
            sqlSb.append("and ttree.FSTARTDATE  <=" + dateSql + " and (ttree.FENDDATE  >= " + dateSql + " or ttree.FENDDATE is null)");
            IRowSet rowResult = DbUtil.executeQuery((Context)ctx, (String)sqlSb.toString());
            while (rowResult.next()) {
                ArrayList<OrgStructureInfo> orgStrList = (ArrayList<OrgStructureInfo>)resultsMap.get("orgs");
                if (orgStrList == null) {
                    orgStrList = new ArrayList<OrgStructureInfo>();
                    resultsMap.put("orgs", orgStrList);
                }
                OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
                orgTreeInfo.setId(BOSUuid.read((String)rowResult.getString("FTreeId")));
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rowResult.getString("FUnitId")));
                OrgStructureInfo orgInfo = new OrgStructureInfo();
                orgInfo.setId(BOSUuid.read((String)rowResult.getString("FID")));
                orgInfo.setLongNumber(rowResult.getString("FLongNumber"));
                orgInfo.setTree(orgTreeInfo);
                orgInfo.setUnit(fullOrgUnitInfo);
                orgStrList.add(orgInfo);
            }
            StringBuffer templateSqlSb = new StringBuffer();
            templateSqlSb.append("select template.FID,template.FNUMBER,template.FNAME,template.FTemplateType,template.FPeriodType from T_RPT_Template template ");
            templateSqlSb.append("join T_CSL_FastMergeTemplate fastMergeTemplate on template.FID = fastMergeTemplate.FTemplateID ");
            templateSqlSb.append("join T_CSL_FastMergeSolu fastMergeSolu on fastMergeSolu.FID = fastMergeTemplate.FFastMergeSoluID ");
            templateSqlSb.append("where fastMergeSolu.fid='" + fastMergeSoleId + "'");
            IRowSet rowTemplateResult = DbUtil.executeQuery((Context)ctx, (String)templateSqlSb.toString());
            while (rowTemplateResult.next()) {
                ArrayList<TemplateInfo> templateList = (ArrayList<TemplateInfo>)resultsMap.get("templates");
                if (templateList == null) {
                    templateList = new ArrayList<TemplateInfo>();
                    resultsMap.put("templates", templateList);
                }
                TemplateInfo templateInfo = new TemplateInfo();
                templateInfo.setId(BOSUuid.read((String)rowTemplateResult.getString("FID")));
                templateInfo.setNumber(rowTemplateResult.getString("FNUMBER"));
                templateInfo.setName(rowTemplateResult.getString("FNAME"));
                templateInfo.setTemplateType(RptTmpTypeEnum.getEnum((int)rowTemplateResult.getInt("FtemplateType")));
                templateInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowTemplateResult.getInt("FPeriodType")));
                templateList.add(templateInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            throw e;
        }
        logger.error((Object)("exitinfo:::" + resultsMap));
        return resultsMap;
    }

    @Override
    public CslReportInfo getReportInfo(Context ctx, OrgStructureInfo structureInfo, TemplateInfo templateInfo, CurrencyInfo currencyInfo, EntityViewInfo viewInfo) throws Exception {
        logger.error((Object)("enterinfo:::ctx=" + ctx + ",OrgStructureInfo=[" + (structureInfo == null ? null : "treeId=" + (structureInfo.getTree() == null ? null : structureInfo.getTree().getId()) + ",unitId=" + (structureInfo.getUnit() == null ? null : structureInfo.getUnit().getId())) + "],TemplateInfo=[" + (templateInfo == null ? null : "templateNumber=" + templateInfo.getNumber()) + "],CurrencyInfo=[" + (currencyInfo == null ? null : "currencyId=" + currencyInfo.getId()) + "],EntityViewInfo=" + viewInfo));
        if (structureInfo == null || templateInfo == null || currencyInfo == null || viewInfo == null || structureInfo.getTree() == null || structureInfo.getUnit() == null) {
            return null;
        }
        String treeId = structureInfo.getTree().getId().toString();
        String unitId = structureInfo.getUnit().getId().toString();
        String currencyId = currencyInfo.getId().toString();
        String templateNumber = templateInfo.getNumber();
        String[] orgTreeAndUnit = this.handleOrgTreeVersion(ctx, treeId, unitId, templateInfo, viewInfo);
        if (orgTreeAndUnit != null && orgTreeAndUnit.length == 2) {
            treeId = orgTreeAndUnit[0];
            unitId = orgTreeAndUnit[1];
        }
        FilterInfo filter = viewInfo.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)treeId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)unitId));
        filter.getFilterItems().add(new FilterItemInfo("template.number", (Object)templateNumber));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        try {
            ICslReport iCslReport = null;
            iCslReport = ctx != null ? CslReportFactory.getLocalInstance((Context)ctx) : CslReportFactory.getRemoteInstance();
            CslReportCollection cslReportCollection = iCslReport.getCslReportCollection(viewInfo);
            logger.error((Object)("exitinfo:::CslReportInfo=" + cslReportCollection));
            return cslReportCollection == null || cslReportCollection.size() == 0 ? null : cslReportCollection.get(0);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            throw e;
        }
    }

    private String[] handleOrgTreeVersion(Context ctx, String treeId, String unitId, TemplateInfo templateInfo, EntityViewInfo viewInfo) throws Exception {
        try {
            FilterItemCollection coll = viewInfo.getFilter().getFilterItems();
            int year = -1;
            int period = -1;
            for (int i = 0; i < coll.size() && (year <= 0 || period < 0); ++i) {
                if ("year".equals(coll.get(i).getPropertyName().toLowerCase())) {
                    if (coll.get(i).getCompareValue() == null) continue;
                    year = Integer.valueOf(coll.get(i).getCompareValue().toString());
                    continue;
                }
                if (!"period".equals(coll.get(i).getPropertyName().toLowerCase()) || coll.get(i).getCompareValue() == null) continue;
                period = Integer.valueOf(coll.get(i).getCompareValue().toString());
            }
            if (year > 0 && period >= 0) {
                RptPeriodTypeEnum periodType = templateInfo.getPeriodType();
                if (periodType == null) {
                    String oql = "select periodType where ";
                    oql = templateInfo.getId() != null ? oql + " id='" + templateInfo.getId().toString() + "'" : oql + " number='" + templateInfo.getNumber() + "'";
                    TemplateCollection templates = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(oql);
                    if (templates != null && templates.size() > 0) {
                        periodType = templates.get(0).getPeriodType();
                    }
                }
                if (periodType != null) {
                    Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType);
                    String dateSql = CslRptUtil.formatDateForSql((Date)periodLastDate);
                    SQLBuilder sqlSb = new SQLBuilder();
                    sqlSb.append("select distinct structure.ftreeid ftreeid,structure.funitid funitid from T_ORG_Structure structure ");
                    sqlSb.append(" inner join T_ORG_BaseUnit newUnit on newUnit.fid = structure.funitid ");
                    sqlSb.append(" inner join T_ORG_BaseUnit oldUnit on newUnit.fnumber = oldUnit.fnumber ");
                    sqlSb.append(" inner join T_ORG_Tree newTree on structure.FTreeId = newTree.fid ");
                    sqlSb.append(" inner join T_ORG_Tree oldTree on oldTree.fnumber = newTree.fnumber ");
                    sqlSb.append(" where oldTree.fid=? ", (Object)treeId);
                    sqlSb.append(" and oldUnit.fid=? ", (Object)unitId);
                    sqlSb.append("and newTree.FSTARTDATE  <=" + dateSql + " and (newTree.FENDDATE  >= " + dateSql + " or newTree.FENDDATE is null)");
                    IRowSet rowResult = DbUtil.executeQuery((Context)ctx, (String)sqlSb.getSQL(), (Object[])sqlSb.getParams());
                    if (rowResult != null && rowResult.next()) {
                        return new String[]{rowResult.getString("ftreeid"), rowResult.getString("funitid")};
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"handle orgTree error.", (Throwable)e);
        }
        return null;
    }
}

