/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.BatchSynRptItemDataToVerticalHandler;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class RptItemDataSyn {
    private static Logger logger = Logger.getLogger((String)RptItemDataSyn.class.getName());
    private int batchSize = 1000;
    public LinkedBlockingQueue queue = new LinkedBlockingQueue(2000);
    public boolean isThreadRunning = false;
    public LinkedBlockingQueue singleQueue = new LinkedBlockingQueue(2000);
    public AtomicInteger atomic = new AtomicInteger(0);
    public ConcurrentHashMap logMap = new ConcurrentHashMap(200);
    public static RptItemDataSyn rptItemDataSyn = null;

    public static synchronized RptItemDataSyn getInstance() {
        if (rptItemDataSyn == null) {
            rptItemDataSyn = new RptItemDataSyn();
        }
        return rptItemDataSyn;
    }

    public boolean batchSynRptItemDataToVertical(Context ctx) throws BOSException, EASBizException {
        String logId = null;
        try {
            logId = Uuid.create().toString();
            this.deleteHandle(ctx, logId);
            this.synRptItemDatas(ctx, logId);
        }
        catch (Exception ex) {
            logger.error((Object)"rptItemDataSynToVertical error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            try {
                this.insertLog(ctx, logId);
            }
            catch (Exception e) {
                logger.error((Object)"insertLog error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return true;
    }

    public void sysSingleRptItemData(Context ctx, String rptId, boolean isRpt, boolean isDelete) throws BOSException, EASBizException {
        this.sysSingleRptItemData(ctx, rptId, isRpt, false, isDelete);
    }

    public void sysSingleRptItemData(Context ctx, String rptId, boolean isRpt, boolean isUpdateStatus, boolean isDelete) {
        try {
            NewRptUtil.printDebugLog(logger, "sysSingleRptItemData rptId:" + rptId);
            if (rptId != null) {
                RptObj rptObj = new RptObj();
                rptObj.rptId = rptId;
                rptObj.isRpt = isRpt ? 1 : 0;
                int n = rptObj.isSynStatus = isUpdateStatus ? 1 : 0;
                if (isDelete) {
                    rptObj.isAddnew = 2;
                }
                rptObj.ctx = ctx;
                this.singleQueue.add(rptObj);
            }
            this.startSynThread(ctx);
        }
        catch (Throwable ex) {
            logger.error((Object)"sysRptItemData error.", ex);
        }
    }

    public void sysRptCommitStatus(Context ctx, List rptIds) {
        for (Object rptId : rptIds) {
            this.sysSingleRptItemData(ctx, (String)rptId, true, true, false);
        }
    }

    public void addBatchSynRptItemDataJob(Context ctx) throws Exception {
        Calendar currDate = Calendar.getInstance();
        Timestamp curTime = new Timestamp(currDate.getTimeInMillis());
        currDate.set(11, 0);
        currDate.set(12, 0);
        currDate.set(13, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = sdf.format(currDate.getTime());
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select 1 from T_Csl_RptItemSynLog where Ftype=0 and FSynDate=?", (Object[])new Object[]{curDate});
        if (rowSet == null || !rowSet.next()) {
            BatchSynRptItemDataToVerticalHandler handle = new BatchSynRptItemDataToVerticalHandler();
            JobInstanceConfig jobInstance = new JobInstanceConfig((IJobHandler)handle, true, false, 1, "BatchSynRptItemDataToVerticalHandle", null, JobIsolationLevel.Server);
            currDate.add(5, 1);
            currDate.set(11, 1);
            Timestamp scheduledTime = new Timestamp(currDate.getTimeInMillis());
            Job job = new Job(ctx, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"165_RptItemDataSyn"), jobInstance, null, scheduledTime, null, -1, null);
            try {
                JobManager.instance().add(job);
            }
            catch (Exception e) {
                logger.error((Object)"RptAutoWeaveUtil.createWeaveRptJob", (Throwable)e);
            }
            DbUtil.execute((Context)ctx, (String)" insert into T_Csl_RptItemSynLog(FID,Ftype,FSynTime,FSynDate)values(?,?,?,?)", (Object[])new Object[]{Uuid.create().toString(), 0, curTime, curDate});
        }
    }

    public void startSynThread(Context ctx) throws Exception {
        if (this.isThreadRunning) {
            return;
        }
        this.isThreadRunning = true;
        try {
            this.addBatchSynRptItemDataJobByNewRequies(ctx);
        }
        catch (Throwable ex) {
            logger.error((Object)"addBatchSynRptItemDataJob error.", ex);
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            if (!RptItemDataSyn.this.singleQueue.isEmpty()) {
                                RptObj rptObj = null;
                                try {
                                    rptObj = (RptObj)RptItemDataSyn.this.singleQueue.remove();
                                    NewRptUtil.printDebugLog(logger, "sysRptItemData start:" + rptObj.rptId + "; isRpt:" + rptObj.isRpt);
                                    if (rptObj.isRpt == 1) {
                                        RptItemDataSyn.this.handleSingeRptByNewRequies(rptObj.ctx, null, rptObj);
                                        continue block4;
                                    }
                                    RptItemDataSyn.this.handleAdjustByNewRequies(rptObj.ctx, null, rptObj);
                                    continue block4;
                                }
                                catch (Throwable e) {
                                    logger.error((Object)"sysRptItemData error.", e);
                                    continue;
                                }
                            }
                            Thread.sleep(60000L);
                        }
                    }
                    catch (Throwable ex) {
                        logger.error((Object)"sysRptItemData error.", ex);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.start();
    }

    public void synRptItemDatas(Context ctx, String logId) throws Exception {
        Connection conn;
        block12: {
            TempTablePool pool = null;
            String tmpTable = null;
            conn = null;
            try {
                SQLBuilder sql = new SQLBuilder();
                sql.append("create table t_csl_tmp(freportid varchar(44),ftemplateid varchar(44),flastupdatetime DateTime, fisAddNew int, fisRpt int) ");
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = pool.createTempTable(sql.getSQL());
                this.setRptToTmpTable(ctx, tmpTable);
                sql.reset();
                sql.append("select freportid,ftemplateid,flastupdatetime,fisAddNew,fisRpt from ").append(tmpTable).append(" where fisRpt=1 order by flastupdatetime asc ");
                conn = EJBFactory.getConnection((Context)ctx);
                SqlParams sp = new SqlParams();
                sp.setParams(sql.getParams());
                RptRowSet rst = null;
                int start = 0;
                while ((rst = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (SqlParams)sp, (int)start, (int)this.batchSize, (Connection)conn)) != null && rst.getRowCount() > 0) {
                    while (rst.next()) {
                        RptObj rptObj = new RptObj();
                        rptObj.rptId = rst.getString("freportid");
                        rptObj.isAddnew = rst.getInt("fisAddNew");
                        rptObj.lastUpdateTime = rst.getObject("flastupdatetime");
                        rptObj.templateId = rst.getString("ftemplateid");
                        this.queue.add(rptObj);
                    }
                    this.threadHandle(ctx, logId);
                    start += rst.getRowCount();
                    while (!this.queue.isEmpty() || this.atomic.get() > 0) {
                        Thread.sleep(100L);
                    }
                }
                this.handleAdjust(ctx, logId, tmpTable, null);
                if (!this.logMap.isEmpty()) {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select fname from t_csl_cslreport where fid in (" + CslRptUtil.changeIdIter2String(((ConcurrentHashMap.KeySetView)this.logMap.keySet()).iterator()) + ")"));
                    StringBuffer logMsg = new StringBuffer();
                    while (rowSet.next()) {
                        logMsg.append(rowSet.getString("fname")).append(",");
                    }
                    throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"166_RptItemDataSyn") + logMsg.toString() + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"167_RptItemDataSyn"));
                }
                if (pool == null || tmpTable == null || DebugLogger.isDebug) break block12;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"synRptItemDatas error.", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (pool != null && tmpTable != null && !DebugLogger.isDebug) {
                        pool.releaseTable(tmpTable);
                    }
                    if (conn != null) {
                        SQLUtils.cleanup(conn);
                    }
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        if (conn != null) {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void threadHandle(final Context ctx, final String logId) throws Exception {
        for (int i = 0; i < 2; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        RptItemDataSyn.this.atomic.incrementAndGet();
                        while (!RptItemDataSyn.this.queue.isEmpty()) {
                            RptObj obj = null;
                            try {
                                obj = (RptObj)RptItemDataSyn.this.queue.remove();
                                RptItemDataSyn.this.handleSingeRptByNewRequies(ctx, logId, obj);
                            }
                            catch (Exception e) {
                                logger.error((Object)"synRptItemDatas error.", (Throwable)e);
                                if (obj == null) continue;
                                RptItemDataSyn.this.logMap.put(obj.rptId, "");
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"synRptItemDatas error.", (Throwable)ex);
                        RptItemDataSyn.this.queue.clear();
                    }
                    finally {
                        RptItemDataSyn.this.atomic.decrementAndGet();
                    }
                }
            };
            thread.start();
        }
    }

    public synchronized void addBatchSynRptItemDataJobByNewRequies(Context ctx) throws Exception {
        CslRptUtil.invokeByManual((Object)this, (String)"addBatchSynRptItemDataJob", (Class[])new Class[]{Context.class}, (Object[])new Object[]{ctx}, (int)3);
    }

    public void handleSingeRptByNewRequies(Context ctx, String logId, RptObj rptObj) throws Exception {
        try {
            CslRptUtil.invokeByManual((Object)this, (String)"handleSingeRpt", (Class[])new Class[]{Context.class, String.class, RptObj.class}, (Object[])new Object[]{ctx, logId, rptObj}, (int)3);
        }
        catch (Exception ex) {
            logger.error((Object)"writeLog error:", (Throwable)ex);
        }
    }

    public void handleAdjustByNewRequies(Context ctx, String logId, RptObj rptObj) throws Exception {
        try {
            CslRptUtil.invokeByManual((Object)this, (String)"handleAdjust", (Class[])new Class[]{Context.class, String.class, RptObj.class}, (Object[])new Object[]{ctx, logId, rptObj}, (int)3);
        }
        catch (Exception ex) {
            logger.error((Object)"writeLog error:", (Throwable)ex);
        }
    }

    public void handleAdjust(Context ctx, String logId, RptObj rptObj) throws Exception {
        this.handleAdjust(ctx, logId, null, rptObj);
    }

    public void handleAdjust(Context ctx, String logId, String tmpTable, RptObj rptObj) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("delete T_Csl_RptItemData where freportid in");
        if (rptObj != null) {
            sql.append("(?)", (Object)rptObj.rptId);
            this.deleteDetailLog(ctx, rptObj.rptId);
        } else {
            sql.append("(select freportid from ").append(tmpTable).append(" where fisAddNew=?", (Object)0).append(" and fisRpt=? ", (Object)0);
            sql.append(")");
        }
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        if (rptObj == null) {
            sql.reset();
            sql.append(" delete from T_Csl_RptItemSynDetailLog where freportid in ");
            sql.append("(select freportid from ").append(tmpTable).append(" where fisAddNew=?", (Object)0).append(" and fisRpt=? ", (Object)0);
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        }
        if (rptObj != null && rptObj.isAddnew == 2) {
            return;
        }
        sql.reset();
        sql.append("insert into T_Csl_RptItemData(FID,FReportId,FCompanyId,FCompanyNumber,FCurrencyId,FCurrencyNumber,FTargetCurrencyId,FTargetCurrencyNum,");
        sql.append("FPeriodType,FYear,FPeriod,FDataSource,FIsAdjusted,FCommitstatus,FDataelementNum,FValueType,FItemNumber,FValue,FcompanyName_l1,FcompanyName_l2,FcompanyName_l3,");
        sql.append("FItemName_l1,FItemName_l2,FItemName_l3,FDataElementName_l1,FDataElementName_l2,FDataElementName_l3,FTargetCurrencyName_l1,FTargetCurrencyName_l2,FTargetCurrencyName_l3,fauditedstatus)");
        sql.append(" select adEntry.fid fid,adjust.fid freportid,company.fid FCompanyId,company.fnumber FCompanyNumber,currency.fid FCurrencyId");
        sql.append(" ,currency.fnumber FCurrencyNumber,targetCur.fid FTargetCurrencyId,targetCur.fnumber FTargetCurrencyNum, adjust.fperiodtype,adjust.fyear,adjust.fperiod");
        sql.append(",adjust.fdatasource,1 FIsAdjusted,3 FCommitstatus,dataelement.fnumber FDataelementNum,adjust.fvaluetype,");
        sql.append("rptitem.fnumber FItemNumber,(isnull(sum(adEntry.fdebit),0)-isnull(sum(adEntry.fcredit),0))*(2*rptitem.FDC-1) FValue");
        sql.append(",company.fname_l1,company.fname_l2,company.fname_l3,rptitem.fname_l1,rptitem.fname_l2,rptitem.fname_l3,dataelement.fname_l1,");
        sql.append("dataelement.fname_l2,dataelement.fname_l3,targetCur.fname_l1,targetCur.fname_l2,targetCur.fname_l3,adjust.FCheckedStatus");
        sql.append(" from t_csl_adjust adjust ");
        sql.append(" inner join t_csl_adjustentry adEntry on adEntry.fadjustid = adjust.fid ");
        sql.append(" inner join t_org_baseunit company on company.fid=adjust.forgunit ");
        sql.append(" inner join t_csl_rptitem rptitem on rptitem.fid=adEntry.Fitemid ");
        sql.append(" inner join t_bd_currency currency on currency.fid=adjust.fsourcecurrencyid ");
        sql.append(" inner join t_bd_currency targetCur on targetCur.fid=adjust.fcurrencyid ");
        sql.append(" inner join t_csl_dataelement dataelement on dataelement.finterseq=adEntry.Fdataelement ");
        sql.append(" left join T_Csl_RptItemData rptData on rptData.fid=adEntry.fid ");
        sql.append(" where adjust.fid in");
        if (rptObj != null) {
            sql.append("(?)", (Object)rptObj.rptId);
        } else {
            sql.append("(select freportid from ").append(tmpTable).append(" where fisRpt=? ", (Object)0).append(")");
        }
        sql.append(" and rptData.fid is null ");
        sql.append("group by adEntry.fid,adjust.fid,company.fid,company.fnumber,currency.fid,currency.fnumber,targetCur.fid,targetCur.fnumber,adjust.fperiodtype");
        sql.append(",adjust.fyear,adjust.fperiod,adjust.fdatasource,dataelement.fnumber,adjust.fvaluetype,rptitem.fnumber,rptitem.FDC");
        sql.append(",company.fname_l1,company.fname_l2,company.fname_l3,rptitem.fname_l1,rptitem.fname_l2,rptitem.fname_l3,dataelement.fname_l1,");
        sql.append("dataelement.fname_l2,dataelement.fname_l3,targetCur.fname_l1,targetCur.fname_l2,targetCur.fname_l3,adjust.FCheckedStatus ");
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        sql.reset();
        sql.append(" insert into T_Csl_RptItemSynDetailLog(fid,FLogid,FReportId,frptLastUpdateTime,foperate) ");
        sql.append(" select adEntry.fid fid,(").append(logId == null ? null : "'" + logId + "'").append(") FLogid,adjust.fid freportid,adjust.flastupdatetime frptLastUpdateTime, 1 foperate ");
        sql.append(" from t_csl_adjust adjust ");
        sql.append(" inner join t_csl_adjustentry adEntry on adEntry.fadjustid = adjust.fid ");
        sql.append(" left join T_Csl_RptItemSynDetailLog synlog on synlog.fid = adEntry.fid ");
        sql.append("  where adjust.fid in ");
        if (rptObj != null) {
            sql.append("(?)", (Object)rptObj.rptId);
        } else {
            sql.append("(select freportid from ").append(tmpTable).append(" where fisRpt=? ", (Object)0);
            sql.append(")");
        }
        sql.append(" and synlog.fid is null ");
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
    }

    public void handleUpdateRptStatus(Context ctx, String logId, RptObj rptObj) throws Exception {
        if (rptObj.isSynStatus == 1) {
            SQLBuilder sql = new SQLBuilder();
            sql.append("update T_Csl_RptItemData set fcommitstatus=(select top 1 fcommittedstatus from t_csl_cslreport where fid=?)", (Object)rptObj.rptId);
            sql.append(" where freportid=? ", (Object)rptObj.rptId);
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        }
    }

    public void handleSingeRpt(Context ctx, String logId, RptObj rptObj) throws Exception {
        if (rptObj.isSynStatus == 1) {
            this.handleUpdateRptStatus(ctx, logId, rptObj);
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        if (rptObj.isAddnew != 1) {
            sql.append(" delete T_Csl_RptItemData where FReportId = ? ", (Object)rptObj.rptId);
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            this.deleteDetailLog(ctx, rptObj.rptId);
        }
        if (rptObj.isAddnew == 2) {
            return;
        }
        rptObj = this.initRptObj(ctx, rptObj);
        if (StringUtils.isEmpty((String)rptObj.templateId)) {
            return;
        }
        int insertBatchSize = 5000;
        String insertSql = " insert into T_Csl_RptItemData(FID,FReportId,FCompanyId,FCompanyNumber,FCurrencyId,FCurrencyNumber,FTargetCurrencyId,FTargetCurrencyNum,FPeriodType,FYear,FPeriod,FDataSource,FIsAdjusted,FCommitstatus,FDataelementNum,FValueType,FItemNumber,FValue,FcompanyName_l1,FcompanyName_l2,FcompanyName_l3,FItemName_l1,FItemName_l2,FItemName_l3,FDataElementName_l1,FDataElementName_l2,FDataElementName_l3,FTargetCurrencyName_l1,FTargetCurrencyName_l2,FTargetCurrencyName_l3,fauditedstatus) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        Map<String, List<String[]>> itemMaps = this.getItemMaps(ctx, rptObj);
        if (itemMaps != null && !itemMaps.isEmpty()) {
            for (String itemTableName : itemMaps.keySet()) {
                sql.reset();
                List<String[]> itemList = itemMaps.get(itemTableName);
                if (itemList.isEmpty()) continue;
                sql.append(" select ");
                for (String[] item : itemList) {
                    sql.append(item[1]).append(",");
                }
                sql.append("item.fcompanyId,unit.fnumber companyNumber,item.fcurrencyid currencyId,currency.fnumber currencyNumber,targetCurr.fid targetCurrencyId ");
                sql.append(" ,targetCurr.fnumber targetCurrencyNum,item.fperiodType,item.fyear,item.fperiod,item.FDataSource,item.FIsAdjusted ");
                sql.append(" ,item.FCommitstatus,dataElement.fnumber FDataelementNum,item.FValueType,unit.fname_l1 unitName1,unit.fname_l2 unitName2,unit.fname_l3 unitName3");
                sql.append(" ,dataElement.fname_l1 dataElementName1,dataElement.fname_l2 dataElementName2,dataElement.fname_l3 dataElementName3,targetCurr.fname_l1 tarCurrencyName1");
                sql.append(" ,targetCurr.fname_l2 tarCurrencyName2,targetCurr.fname_l3 tarCurrencyName3,rpt.fauditedstatus ");
                sql.append(" from ").append(itemTableName).append(" itemTable ");
                sql.append(" inner join t_csl_itemdataentry item on item.fid=itemTable.fid ");
                sql.append(" inner join t_org_baseunit unit on unit.fid=item.fcompanyid ");
                sql.append(" inner join t_bd_currency currency on currency.fid=item.fcurrencyid ");
                sql.append(" inner join t_bd_currency targetCurr on targetCurr.fid=item.ftargetcurrencyid ");
                sql.append(" inner join t_csl_dataelement dataElement on dataElement.finterseq=item.fdataelement ");
                sql.append(" inner join t_csl_cslreport rpt on rpt.fid=item.freportid ");
                sql.append(" where item.freportid=? ", (Object)rptObj.rptId);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                while (rowSet != null && rowSet.next()) {
                    RowObj rowObj = null;
                    for (String[] item : itemList) {
                        BigDecimal value = rowSet.getBigDecimal(item[1]);
                        if (value == null) continue;
                        if (rowObj == null) {
                            rowObj = new RowObj();
                            rowObj.rptId = rptObj.rptId;
                            rowObj.companyId = rowSet.getString("fcompanyId");
                            rowObj.companyNumber = rowSet.getString("companyNumber");
                            rowObj.currencyId = rowSet.getString("currencyId");
                            rowObj.currencyNumber = rowSet.getString("currencyNumber");
                            rowObj.targetCurrencyId = rowSet.getString("targetCurrencyId");
                            rowObj.targetCurrencyNum = rowSet.getString("targetCurrencyNum");
                            rowObj.periodType = rowSet.getInt("fperiodType");
                            rowObj.year = rowSet.getInt("fyear");
                            rowObj.period = rowSet.getInt("fperiod");
                            rowObj.dataSource = rowSet.getInt("FDataSource");
                            rowObj.IsAdjusted = rowSet.getInt("FIsAdjusted");
                            rowObj.commitstatus = rowSet.getInt("FCommitstatus");
                            rowObj.dataelementNum = rowSet.getString("FDataelementNum");
                            rowObj.valueType = rowSet.getInt("FValueType");
                            rowObj.unitName_l1 = rowSet.getString("unitName1");
                            rowObj.unitName_l2 = rowSet.getString("unitName2");
                            rowObj.unitName_l3 = rowSet.getString("unitName3");
                            rowObj.dataElementName_l1 = rowSet.getString("dataElementName1");
                            rowObj.dataElementName_l2 = rowSet.getString("dataElementName2");
                            rowObj.dataElementName_l3 = rowSet.getString("dataElementName3");
                            rowObj.tarCurrencyName_l1 = rowSet.getString("tarCurrencyName1");
                            rowObj.tarCurrencyName_l2 = rowSet.getString("tarCurrencyName2");
                            rowObj.tarCurrencyName_l3 = rowSet.getString("tarCurrencyName3");
                            rowObj.auditedstatus = rowSet.getInt("fauditedstatus");
                        } else {
                            rowObj.clone();
                        }
                        rowObj.value = value;
                        rowObj.itemNumber = item[0];
                        rowObj.itemName_l1 = item[2];
                        rowObj.itemName_l2 = item[3];
                        rowObj.itemName_l3 = item[4];
                        params.add(rowObj.toRowParam());
                        if (params.size() < insertBatchSize) continue;
                        DbUtil.executeBatch((Context)ctx, (String)insertSql, params);
                        params.clear();
                    }
                }
                if (params.size() <= 0) continue;
                DbUtil.executeBatch((Context)ctx, (String)insertSql, params);
            }
            this.insertDetailLog(ctx, logId, rptObj);
        }
    }

    public RptObj initRptObj(Context ctx, RptObj rptObj) throws Exception {
        if (StringUtils.isEmpty((String)rptObj.templateId)) {
            String templateId;
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select top 1 case when tmp.fgrouptemplateid is null then tmp.fid else tmp.fgrouptemplateid end ftemplateId,rpt.flastupdatetime");
            sql.append(", case when log.freportid is null then 1 else 0 end fisAddNew ");
            sql.append(" from t_csl_cslreport rpt");
            sql.append(" inner join t_rpt_template tmp on tmp.fid=rpt.ftemplateid ");
            sql.append(" left join (select max(frptLastUpdateTime) frptLastUpdateTime,freportid from T_Csl_RptItemSynDetailLog group by freportid) log on rpt.fid=log.FReportId ");
            sql.append(" where (log.freportid is null or rpt.flastupdatetime<>log.frptLastUpdateTime )");
            sql.append(" and rpt.fid=? ", (Object)rptObj.rptId);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            if (rowSet != null && rowSet.next() && !StringUtils.isEmpty((String)(templateId = rowSet.getString("ftemplateId")))) {
                rptObj.templateId = templateId;
                rptObj.lastUpdateTime = rowSet.getTimestamp("flastupdatetime");
                rptObj.isAddnew = rowSet.getInt("fisAddNew");
            }
        }
        return rptObj;
    }

    public Map<String, List<String[]>> getItemMaps(Context ctx, RptObj rptObj) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select distinct item.fnumber,itemMap.ftablename,itemMap.ffieldname,item.fname_l1,item.fname_l2,item.fname_l3 ");
        sql.append(" from  (select distinct fitemnumber from t_csl_templetitemlist where ftemplateid=? ) tmpList", (Object)rptObj.templateId);
        sql.append(" inner join t_csl_rptitem item on item.fnumber=tmpList.fitemnumber ");
        sql.append(" inner join t_csl_itemfieldmapped itemMap on itemMap.fitemid=item.fid ");
        sql.append(" order by itemMap.ftablename ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        HashMap<String, List<String[]>> itemMaps = new HashMap<String, List<String[]>>();
        while (rowSet != null && rowSet.next()) {
            String itemNumber = rowSet.getString("fnumber");
            String tablename = rowSet.getString("ftablename");
            String fieldname = rowSet.getString("ffieldname");
            ArrayList<String[]> items = (ArrayList<String[]>)itemMaps.get(tablename);
            if (items == null) {
                items = new ArrayList<String[]>();
                itemMaps.put(tablename, items);
            }
            items.add(new String[]{itemNumber, fieldname, rowSet.getString("fname_l1"), rowSet.getString("fname_l2"), rowSet.getString("fname_l3")});
        }
        return itemMaps;
    }

    public void setRptToTmpTable(Context ctx, String tmpTable) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("insert into ").append(tmpTable).append("(freportid,ftemplateid,flastupdatetime,fisAddNew,fisRpt) ");
        sql.append(" select distinct rpt.fid,case when tmp.fgrouptemplateid is null then tmp.fid else tmp.fgrouptemplateid end,rpt.flastupdatetime");
        sql.append(", case when rptItem.freportid is null then 1 else 0 end fisAddNew,1 isRpt ");
        sql.append(" from t_csl_itemdata item");
        sql.append(" inner join t_csl_cslreport rpt on item.freportid=rpt.fid ");
        sql.append(" inner join t_rpt_template tmp on tmp.fid=rpt.ftemplateid ");
        sql.append(" left join (select max(frptLastUpdateTime) frptLastUpdateTime,freportid from T_Csl_RptItemSynDetailLog group by freportid) log on rpt.fid=log.FReportId ");
        sql.append(" left join t_csl_rptitemdata rptItem on rptItem.freportid=rpt.fid ");
        sql.append(" where (rpt.flastupdatetime<>log.frptLastUpdateTime or rptItem.fid is null)");
        sql.append(" and item.fdatasource in(1,2,3,4,6,7) and item.FIsAdjusted<>1 ");
        sql.append(" and exists(select 1 from t_csl_itemdataentry en where en.fitemdataid=item.fid) ");
        DbUtil.execute((Context)ctx, (String)sql.getSQL());
        sql.reset();
        sql.append("insert into ").append(tmpTable).append("(freportid,flastupdatetime,fisAddNew,fisRpt) ");
        sql.append(" select distinct rpt.fid,rpt.flastupdatetime");
        sql.append(", case when rptItem.freportid is null then 1 else 0 end fisAddNew, 0 isRpt ");
        sql.append(" from t_csl_itemdata item");
        sql.append(" inner join t_csl_adjust rpt on item.freportid=rpt.fid ");
        sql.append(" left join (select max(frptLastUpdateTime) frptLastUpdateTime,freportid from T_Csl_RptItemSynDetailLog group by freportid) log on rpt.fid=log.FReportId ");
        sql.append(" left join t_csl_rptitemdata rptItem on rptItem.freportid=rpt.fid ");
        sql.append(" where (rpt.flastupdatetime<>log.frptLastUpdateTime or rptItem.fid is null)");
        sql.append(" and item.fdatasource in(1,2,3) and item.FIsAdjusted=1 ");
        sql.append(" and exists(select 1 from t_csl_itemdataentry en where en.fitemdataid=item.fid) ");
        DbUtil.execute((Context)ctx, (String)sql.getSQL());
    }

    public boolean deleteHandle(Context ctx, String logId) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("delete from T_Csl_RptItemData where freportid in(");
        sql.append(" select itemdata.freportid from T_Csl_RptItemData itemdata ");
        sql.append(" left join t_csl_cslreport rpt on rpt.fid=itemdata.freportid ");
        sql.append(" where rpt.fid is null )");
        DbUtil.execute((Context)ctx, (String)sql.getSQL());
        sql.reset();
        sql.append("delete from T_Csl_RptItemSynDetailLog where fid in(");
        sql.append(" select distinct detailLog.fid from T_Csl_RptItemSynDetailLog detailLog ");
        sql.append(" left join t_csl_cslreport rpt on rpt.fid=detailLog.freportid ");
        sql.append(" where rpt.fid is null )");
        DbUtil.execute((Context)ctx, (String)sql.getSQL());
        return true;
    }

    public boolean insertLog(Context ctx, String logId) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" insert into T_Csl_RptItemSynLog(FID,FSynTime) values(?,?) ");
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])new Object[]{logId, new Timestamp(new Date().getTime())});
        return true;
    }

    public boolean insertDetailLog(Context ctx, String logId, RptObj rptObj) throws Exception {
        DbUtil.execute((Context)ctx, (String)"insert into T_Csl_RptItemSynDetailLog(fid,FLogid,FReportId,frptLastUpdateTime,foperate) values(?,?,?,?,?)", (Object[])new Object[]{Uuid.create().toString(), logId, rptObj.rptId, rptObj.lastUpdateTime, rptObj.isAddnew});
        return true;
    }

    public void deleteDetailLog(Context ctx, String rptId) throws Exception {
        DbUtil.execute((Context)ctx, (String)" delete from T_Csl_RptItemSynDetailLog where freportid=? ", (Object[])new Object[]{rptId});
    }

    public class RowObj
    implements Cloneable {
        public String rptId = null;
        public String companyId = null;
        public String companyNumber = null;
        public String currencyId = null;
        public String currencyNumber = null;
        public String targetCurrencyId = null;
        public String targetCurrencyNum = null;
        public int periodType = -1;
        public int year = -1;
        public int period = -1;
        public int dataSource = -1;
        public int IsAdjusted = -1;
        public int commitstatus = -1;
        public String dataelementNum = null;
        public String itemNumber = null;
        public String itemName_l1 = null;
        public String itemName_l2 = null;
        public String itemName_l3 = null;
        public int valueType = -1;
        public BigDecimal value = BigDecimal.ZERO;
        public String unitName_l1 = null;
        public String unitName_l2 = null;
        public String unitName_l3 = null;
        public String dataElementName_l1 = null;
        public String dataElementName_l2 = null;
        public String dataElementName_l3 = null;
        public String tarCurrencyName_l1 = null;
        public String tarCurrencyName_l2 = null;
        public String tarCurrencyName_l3 = null;
        public int auditedstatus = -1;

        public Object[] toRowParam() {
            Object[] param = new Object[31];
            int i = 0;
            param[i++] = Uuid.create().toString();
            param[i++] = this.rptId;
            param[i++] = this.companyId;
            param[i++] = this.companyNumber;
            param[i++] = this.currencyId;
            param[i++] = this.currencyNumber;
            param[i++] = this.targetCurrencyId;
            param[i++] = this.targetCurrencyNum;
            param[i++] = this.periodType;
            param[i++] = this.year;
            param[i++] = this.period;
            param[i++] = this.dataSource;
            param[i++] = this.IsAdjusted;
            param[i++] = this.commitstatus;
            param[i++] = this.dataelementNum;
            param[i++] = this.valueType;
            param[i++] = this.itemNumber;
            param[i++] = this.value;
            param[i++] = this.unitName_l1;
            param[i++] = this.unitName_l2;
            param[i++] = this.unitName_l3;
            param[i++] = this.itemName_l1;
            param[i++] = this.itemName_l2;
            param[i++] = this.itemName_l3;
            param[i++] = this.dataElementName_l1;
            param[i++] = this.dataElementName_l2;
            param[i++] = this.dataElementName_l3;
            param[i++] = this.tarCurrencyName_l1;
            param[i++] = this.tarCurrencyName_l2;
            param[i++] = this.tarCurrencyName_l3;
            param[i++] = this.auditedstatus;
            return param;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class RptObj {
        public String rptId = null;
        public String templateId = null;
        public int isAddnew = 0;
        public int isRpt = 1;
        public Object lastUpdateTime = null;
        public Context ctx = null;
        public int isSynStatus = 0;
    }
}

