/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptLoggerUtils {
    static RptLoggerUtils loggerUtil = null;

    public static RptLoggerUtils getInstance() {
        if (loggerUtil == null) {
            loggerUtil = new RptLoggerUtils();
        }
        return loggerUtil;
    }

    public void printLog(Logger logger, IRowSet rs, String title) {
        try {
            if (DebugLogger.isDebug && rs != null) {
                StringBuffer sb = new StringBuffer();
                IRowSetMetaData rowSetMeta = rs.getRowSetMetaData();
                int columnCount = rowSetMeta.getColumnCount();
                String columnName = null;
                sb.append(title).append("----------------");
                while (rs.next()) {
                    for (int i = 1; i <= columnCount; ++i) {
                        columnName = rowSetMeta.getColumnName(i);
                        sb.append(columnName).append("=").append(rs.getObject(columnName)).append(";");
                    }
                    sb.append("\n");
                }
                logger.error((Object)sb.toString());
                rs.beforeFirst();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void printList(Logger logger, List result, String title) {
        try {
            if (DebugLogger.isDebug && result != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(title).append("----------------");
                for (Object obj : result) {
                    if (obj instanceof Object[]) {
                        Object[] objs = (Object[])obj;
                        for (int i = 0; i < objs.length; ++i) {
                            sb.append(i).append("=").append(objs[i]).append(";");
                        }
                    } else {
                        sb.append(obj).append(";");
                    }
                    sb.append("\n");
                }
                logger.error((Object)sb.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void printMap(Logger logger, Map result, String title) {
        try {
            if (DebugLogger.isDebug && result != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(title).append("----------------");
                for (Object obj : result.keySet()) {
                    sb.append(obj).append("=").append(result.get(obj)).append(";");
                    sb.append("\n");
                }
                logger.error((Object)sb.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void printLog(Logger logger, String msg, String title) {
        if (DebugLogger.isDebug && msg != null) {
            logger.error((Object)(title + "---------------" + msg));
        }
    }
}

