/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense_new;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispense_hisFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispense_newFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.INewOrgTreeCatch;
import com.kingdee.eas.fi.newrpt.util.NewOrgTreeCatch;
import com.kingdee.eas.fi.newrpt.util.OrgTreeSynHandle;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class TemplateDispenseNewUtil {
    private static Logger logger = Logger.getLogger(TemplateDispenseNewUtil.class);
    public static String templatedis_new = "t_Csl_Templetdispense_new";
    public static String templatedis_old = "t_Csl_Templetdispense_his";
    public static String templatedis = "t_Csl_Templetdispense";
    public static Set<String> newTempletDisOrgTreeSet = Collections.newSetFromMap(new ConcurrentHashMap());
    public static boolean isGetLocal = true;

    public static boolean isInNewTemplateDisTable(Context ctx, String OrgTreeId) throws BOSException {
        return TemplateDispenseNewUtil.getNewTempletDisOrgTreeSet(ctx).contains(OrgTreeId);
    }

    public static Set<String> getLocalNewTempletDisOrgTreeSet(Context ctx) throws BOSException {
        try {
            if (newTempletDisOrgTreeSet.isEmpty()) {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select distinct fid from T_CSL_NewTempletDisOrgTree ");
                while (rowSet.next()) {
                    newTempletDisOrgTreeSet.add(rowSet.getString("fid"));
                }
            }
            logger.error((Object)("cslrpt getLocalNewTempletDisOrgTreeSet:" + newTempletDisOrgTreeSet.toArray()));
        }
        catch (Exception ex) {
            logger.error((Object)"initNewOrgTreeIdSet error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return newTempletDisOrgTreeSet;
    }

    public static void clearNewTempletDisOrgTreeSet() {
        newTempletDisOrgTreeSet.clear();
    }

    public static String getDisTable(Context ctx, String orgTreeId) throws BOSException {
        String disTable = templatedis_new;
        if (!TemplateDispenseNewUtil.isInNewTemplateDisTable(ctx, orgTreeId)) {
            disTable = templatedis_old;
        }
        return disTable;
    }

    public static void updateDispenseByUserNewTable(Context ctx, IObjectPK pk, TempletDispenseInfo dispense) throws BOSException, EASBizException {
        try {
            int dispTableType = TemplateDispenseNewUtil.getDispTableType(ctx, pk);
            if (dispTableType == 1) {
                TempletDispense_newFactory.getLocalInstance((Context)ctx).update(pk, (CoreBaseInfo)dispense);
            } else if (dispTableType == 0) {
                TempletDispense_hisFactory.getLocalInstance((Context)ctx).update(pk, (CoreBaseInfo)dispense);
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateDispenseByUserNewTable error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void deleteDispenseByUserNewTable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            int dispTableType = TemplateDispenseNewUtil.getDispTableType(ctx, pk);
            if (dispTableType == 1) {
                TempletDispense_newFactory.getLocalInstance((Context)ctx).delete(pk);
            } else if (dispTableType == 0) {
                TempletDispense_hisFactory.getLocalInstance((Context)ctx).delete(pk);
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateDispenseByUserNewTable error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static IObjectPK[] deleteDispenseByUserNewTable(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        try {
            IObjectPK[] pkArray = TempletDispense_newFactory.getLocalInstance((Context)ctx).delete(filter);
            IObjectPK[] pkArray2 = TempletDispense_hisFactory.getLocalInstance((Context)ctx).delete(filter);
            if (pkArray != null && pkArray2 != null) {
                IObjectPK[] pkAll = new IObjectPK[pkArray.length + pkArray2.length];
                System.arraycopy(pkArray, 0, pkAll, 0, pkArray.length);
                System.arraycopy(pkArray2, 0, pkAll, pkArray.length, pkArray2.length);
                return pkAll;
            }
            if (pkArray != null) {
                return pkArray;
            }
            if (pkArray2 != null) {
                return pkArray2;
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateDispenseByUserNewTable error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static void deleteDispenseByUserNewTable(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        try {
            TempletDispense_newFactory.getLocalInstance((Context)ctx).delete(arrayPK);
            TempletDispense_hisFactory.getLocalInstance((Context)ctx).delete(arrayPK);
        }
        catch (Exception e) {
            logger.error((Object)"updateDispenseByUserNewTable error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static IObjectPK[] deleteDispenseByUserNewTable(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            IObjectPK[] pkArray = TempletDispense_newFactory.getLocalInstance((Context)ctx).delete(oql);
            IObjectPK[] pkArray2 = TempletDispense_hisFactory.getLocalInstance((Context)ctx).delete(oql);
            if (pkArray != null && pkArray2 != null) {
                IObjectPK[] pkAll = new IObjectPK[pkArray.length + pkArray2.length];
                System.arraycopy(pkArray, 0, pkAll, 0, pkArray.length);
                System.arraycopy(pkArray2, 0, pkAll, pkArray.length, pkArray2.length);
                return pkAll;
            }
            if (pkArray != null) {
                return pkArray;
            }
            if (pkArray2 != null) {
                return pkArray2;
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateDispenseByUserNewTable error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static int getDispTableType(Context ctx, IObjectPK pk) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select ftype from ").append(templatedis).append(" where fid=?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
        if (rowSet != null && rowSet.next()) {
            return rowSet.getInt("ftype");
        }
        return -1;
    }

    public static String getDispTableByType(int type) {
        if (type == 1) {
            return templatedis_new;
        }
        return templatedis_old;
    }

    public static IObjectPK addNewDispenseByUserNewTable(Context ctx, IObjectPK pk, TempletDispenseInfo dispense, boolean isClearOrgTreeSet) throws BOSException, EASBizException {
        IObjectPK curPk = TemplateDispenseNewUtil.addNewDispenseByUserNewTable(ctx, pk, dispense);
        if (isClearOrgTreeSet) {
            newTempletDisOrgTreeSet.clear();
        }
        return curPk;
    }

    private static IObjectPK addNewDispenseByUserNewTable(Context ctx, IObjectPK pk, TempletDispenseInfo dispense) throws BOSException, EASBizException {
        ITempletDispense_new ITempletDisp;
        OrgTreeInfo orgTree = dispense.getOrgBound();
        boolean isAddNewTable = true;
        IObjectPK curPk = pk;
        if (orgTree != null) {
            if (orgTree.containsKey("status") && orgTree.getStatus() != null) {
                isAddNewTable = orgTree.getStatus().getValue() == 1;
            } else {
                Set<String> newOrgTreeIdSet = TemplateDispenseNewUtil.getNewTempletDisOrgTreeSet(ctx);
                isAddNewTable = newOrgTreeIdSet.contains(orgTree.getId().toString());
            }
        }
        if (isAddNewTable) {
            ITempletDisp = TempletDispense_newFactory.getLocalInstance((Context)ctx);
            if (pk == null) {
                curPk = ITempletDisp.addnew((CoreBaseInfo)dispense);
            } else {
                ITempletDisp.addnew(pk, (CoreBaseInfo)dispense);
            }
        } else {
            ITempletDisp = TempletDispense_hisFactory.getLocalInstance((Context)ctx);
            if (pk == null) {
                curPk = ITempletDisp.addnew((CoreBaseInfo)dispense);
            } else {
                ITempletDisp.addnew(pk, (CoreBaseInfo)dispense);
            }
        }
        return curPk;
    }

    public static void deleteFromDispense(Context ctx, List dispenseIds, String dispenseIdTable) throws BOSException {
        TempTablePool pool = null;
        String tmpTableName = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            StringBuffer strSQL = new StringBuffer();
            strSQL.append("create table t_csl_dispenseIds(FID VARCHAR(44),FTYPE INT)");
            tmpTableName = pool.createTempTable(strSQL.toString());
            strSQL.setLength(0);
            strSQL.append("insert into ").append(tmpTableName).append("(fid,ftype )");
            strSQL.append(" select dis.fid,dis.ftype FROM T_CSL_TempletDispense dis \r\n");
            strSQL.append(" left join T_CSL_CslReport rpt on  dis.FDispenseSrcID = rpt.FTemplateID \r\n");
            strSQL.append("  and dis.FOrgBoundID = rpt.FOrgTreeID  \r\n");
            strSQL.append("  and dis.FCompanyID = rpt.FOrgUnitID  \r\n");
            strSQL.append("  and dis.fsourceType = 1  \r\n");
            if (!StringUtils.isEmpty((String)dispenseIdTable)) {
                strSQL.append(" inner join ").append(dispenseIdTable).append(" disIds on disIds.fid= dis.fid ");
            }
            strSQL.append(" where rpt.fid is null ");
            if (StringUtils.isEmpty((String)dispenseIdTable)) {
                strSQL.append(" and dis.fid in(").append(CslRptUtil.list2String((List)dispenseIds, (String)",", (boolean)true)).append(")");
            }
            DbUtil.execute((Context)ctx, (String)strSQL.toString());
            strSQL.setLength(0);
            strSQL.append(" delete from ").append(templatedis_new);
            strSQL.append(" where fid in(select fid from ").append(tmpTableName);
            strSQL.append(" where ftype=1 ) ");
            DbUtil.execute((Context)ctx, (String)strSQL.toString());
            strSQL.setLength(0);
            strSQL.append(" delete from ").append(templatedis_old);
            strSQL.append(" where fid in(select fid from ").append(tmpTableName);
            strSQL.append(" where ftype=0 ) ");
            DbUtil.execute((Context)ctx, (String)strSQL.toString());
        }
        catch (Exception e) {
            try {
                logger.error((Object)"deleteFromDispense error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(tmpTableName) && !DebugLogger.isDebug) {
                    pool.releaseTable(tmpTableName);
                }
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tmpTableName) && !DebugLogger.isDebug) {
            pool.releaseTable(tmpTableName);
        }
    }

    public static void deleteFromDispense(Context ctx, String deletSql, Object[] params) throws BOSException {
        try {
            int startIndex = deletSql.toLowerCase().indexOf("t_csl_templetdispense");
            String where = deletSql.substring(startIndex + "t_csl_templetdispense".length());
            StringBuffer sql = new StringBuffer();
            sql.append("delete from ").append(templatedis_new).append(" ").append(where);
            String deleteNewSql = sql.toString();
            sql.setLength(0);
            sql.append("delete from ").append(templatedis_old).append(" ").append(where);
            String deleteOldSql = sql.toString();
            if (params != null && params.length > 0) {
                DbUtil.execute((Context)ctx, (String)deleteNewSql, (Object[])params);
                DbUtil.execute((Context)ctx, (String)deleteOldSql, (Object[])params);
            } else {
                DbUtil.execute((Context)ctx, (String)deleteNewSql);
                DbUtil.execute((Context)ctx, (String)deleteOldSql);
            }
        }
        catch (Exception e) {
            logger.error((Object)"deleteFromDispense error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void deleteDispenseByOrgTree(Context ctx, OrgTreeInfo orgTree) throws BOSException {
        try {
            String table = TemplateDispenseNewUtil.getDisTable(ctx, orgTree.getId().toString());
            StringBuffer sql = new StringBuffer();
            sql.append(" delete ").append(table);
            sql.append(" where forgboundid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTree.getId().toString()});
        }
        catch (Exception e) {
            logger.error((Object)"deleteDispenseByOrgTree error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            TemplateDispenseNewUtil.clearNewTempletDisOrgTreeSet();
        }
    }

    public static void updateDispense(Context ctx, String updateSql, Object[] params, boolean isUpdateNew) throws BOSException {
        try {
            int startIndex = updateSql.toLowerCase().indexOf("t_csl_templetdispense");
            String where = updateSql.substring(startIndex + "t_csl_templetdispense".length());
            StringBuffer sql = new StringBuffer();
            sql.append("update ").append(templatedis_new).append(" ").append(where);
            String updateNewSql = sql.toString();
            sql.setLength(0);
            sql.append("update ").append(templatedis_old).append(" ").append(where);
            String updateOldSql = sql.toString();
            if (params != null && params.length > 0) {
                DbUtil.execute((Context)ctx, (String)updateNewSql, (Object[])params);
                if (!isUpdateNew) {
                    DbUtil.execute((Context)ctx, (String)updateOldSql, (Object[])params);
                }
            } else {
                DbUtil.execute((Context)ctx, (String)updateNewSql);
                if (!isUpdateNew) {
                    DbUtil.execute((Context)ctx, (String)updateOldSql);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateDispense error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void addNewJob(Context ctx) throws BOSException {
        OrgTreeSynHandle handle = new OrgTreeSynHandle();
        JobInstanceConfig jobInstance = new JobInstanceConfig((IJobHandler)handle, true, false, 1, "OrgTreeSynHandle", null, JobIsolationLevel.Server);
        Calendar currDate = Calendar.getInstance();
        currDate.add(5, 1);
        currDate.set(11, 1);
        currDate.set(12, 0);
        currDate.set(13, 0);
        Timestamp scheduledTime = new Timestamp(currDate.getTimeInMillis());
        Job job = new Job(ctx, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"168_TemplateDispenseNewUtil"), jobInstance, null, scheduledTime, null, -1, null);
        try {
            JobManager.instance().add(job);
        }
        catch (Exception e) {
            logger.error((Object)"RptAutoWeaveUtil.createWeaveRptJob", (Throwable)e);
        }
    }

    public static void insertIntoDispense(Context ctx, String insertPartSql, String selectPartSql, Object[] params) throws Exception {
        try {
            StringBuffer sql = new StringBuffer();
            String newInsertSql = null;
            String oldInsertSql = null;
            if (insertPartSql != null && insertPartSql.indexOf("t_Csl_Templetdispense") > 0) {
                newInsertSql = insertPartSql.replace("t_Csl_Templetdispense", templatedis_new);
                oldInsertSql = insertPartSql.replace("t_Csl_Templetdispense", templatedis_old);
            }
            if (newInsertSql != null) {
                sql.append(newInsertSql);
            } else {
                sql.append(" insert into ").append(templatedis_new);
            }
            sql.append(" select newDis.* from (").append(selectPartSql).append(") newDis ");
            sql.append(" inner join T_CSL_NewTempletDisOrgTree newTree on newTree.fid=newDis.FORGBOUNDID ");
            String insertNewPart = sql.toString();
            sql.setLength(0);
            if (oldInsertSql != null) {
                sql.append(oldInsertSql);
            } else {
                sql.append(" insert into ").append(templatedis_old);
            }
            sql.append(" select newDis.* from (").append(selectPartSql).append(") newDis ");
            sql.append(" left join T_CSL_NewTempletDisOrgTree newTree on newTree.fid=newDis.FORGBOUNDID ");
            sql.append(" where newTree.fid is null ");
            String insertOldPart = sql.toString();
            if (params != null && params.length > 0) {
                DbUtil.execute((Context)ctx, (String)insertNewPart, (Object[])params);
                DbUtil.execute((Context)ctx, (String)insertOldPart, (Object[])params);
            } else {
                DbUtil.execute((Context)ctx, (String)insertNewPart);
                DbUtil.execute((Context)ctx, (String)insertOldPart);
            }
        }
        catch (Exception e) {
            logger.error((Object)"insertIntoDispense error.", (Throwable)e);
            throw e;
        }
    }

    public static void moveDisp(Context ctx) throws Exception {
        try {
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("select distinct newOrgTree.fid fid from T_CSL_NewTempletDisOrgTree newOrgTree ").append(" inner join t_org_tree tree on tree.fid=newOrgTree.fid ").append(" where tree.fstatus=2 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet != null) {
                while (rowSet.next()) {
                    CslRptUtil.invokeByManualForStatic(TemplateDispenseNewUtil.class, (String)"moveDisp", (Class[])new Class[]{Context.class, String.class, String.class, Integer.TYPE}, (Object[])new Object[]{ctx, rowSet.getString("fid"), null, 1}, (int)3);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"moveDisp error", (Throwable)e);
            throw e;
        }
    }

    public static void insertTempletDisOrgTree(Context ctx, String orgTreeId) throws Exception {
        try {
            String sql = "select fid from T_CSL_NewTempletDisOrgTree where fid=? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
            if (rowSet == null || rowSet.size() <= 0) {
                sql = "insert into T_CSL_NewTempletDisOrgTree(fid) values(?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
                TemplateDispenseNewUtil.clearAllServerNewTempletDisOrgTreeSet(ctx);
            }
        }
        catch (Exception e) {
            logger.error((Object)"insertTempletDisOrgTree error", (Throwable)e);
            throw e;
        }
    }

    public static void deleteTempletDisOrgTree(Context ctx, String orgTreeId) throws Exception {
        try {
            String sql = "delete T_CSL_NewTempletDisOrgTree where fid=? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{orgTreeId});
            TemplateDispenseNewUtil.clearAllServerNewTempletDisOrgTreeSet(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"deleteTempletDisOrgTree error", (Throwable)e);
            throw e;
        }
    }

    public static void moveDisp(Context ctx, String oldTreeId, String newTreeId, int status) throws Exception {
        try {
            StringBuffer sql = new StringBuffer();
            if (status == 0) {
                sql.append(" delete from ").append(templatedis_new).append(" where forgboundid='").append(newTreeId).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else {
                sql.append(" insert into ").append(templatedis_old).append(" select dis.* from ").append(templatedis_new).append(" dis ").append(" inner join t_org_tree tree on tree.fid=dis.forgboundid ").append(" where dis.forgboundid=? and tree.fstatus<>1 ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldTreeId});
                sql.setLength(0);
                sql.append(" delete from ").append(templatedis_new).append(" where fid in (select dis.fid from ").append(templatedis_new).append(" dis ").append(" inner join t_org_tree tree on tree.fid=dis.forgboundid ").append(" where dis.forgboundid=? and tree.fstatus<>1) ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldTreeId});
                TemplateDispenseNewUtil.deleteTempletDisOrgTree(ctx, oldTreeId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"moveDisp error", (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getNewTempletDisOrgTreeSet(Context ctx) throws BOSException {
        Set<String> orgTreeSet = null;
        isGetLocal = true;
        if (isGetLocal) {
            newTempletDisOrgTreeSet.clear();
            orgTreeSet = TemplateDispenseNewUtil.getLocalNewTempletDisOrgTreeSet(ctx);
        } else {
            INewOrgTreeCatch IRpcHandleFacade2 = null;
            try {
                IRpcHandleFacade2 = TemplateDispenseNewUtil.getOrgTreeSetIntface(ctx);
                orgTreeSet = IRpcHandleFacade2.getNewTempletDisOrgTreeSet();
            }
            catch (Exception e) {
                isGetLocal = true;
                logger.error((Object)"getNewTempletDisOrgTreeSet error.", (Throwable)e);
            }
            if (orgTreeSet == null || orgTreeSet.isEmpty()) {
                TemplateDispenseNewUtil.clearNewTempletDisOrgTreeSet();
                orgTreeSet = TemplateDispenseNewUtil.getLocalNewTempletDisOrgTreeSet(ctx);
                try {
                    IRpcHandleFacade2.refreshNewTempletDisOrgTreeSet(orgTreeSet);
                    isGetLocal = false;
                    logger.error((Object)"refreshNewTempletDisOrgTreeSet end.");
                }
                catch (Exception e) {
                    isGetLocal = true;
                    orgTreeSet = TemplateDispenseNewUtil.getNewTempletDisOrgTreeSet(ctx);
                    logger.error((Object)"getNewTempletDisOrgTreeSet error.", (Throwable)e);
                }
            }
        }
        return orgTreeSet;
    }

    public static void repaireDispense(Context ctx) {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(templatedis_new);
            sql.append(" select old.* from ").append(templatedis_old).append(" old ");
            sql.append(" inner join T_CSL_NewTempletDisOrgTree newTree on newTree.fid=old.FORGBOUNDID  ");
            sql.append(" left join ").append(templatedis_new).append(" disNew on disNew.fid=old.fid ");
            sql.append(" where disNew.fid is null ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from ").append(templatedis_old).append(" where fid in(");
            sql.append(" select dis.fid from ").append(templatedis_old).append(" dis ");
            sql.append(" inner join T_CSL_NewTempletDisOrgTree newTree on newTree.fid=dis.FORGBOUNDID) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("insert into ").append(templatedis_old);
            sql.append(" select disNew.* from ").append(templatedis_new).append(" disNew ");
            sql.append(" left join T_CSL_NewTempletDisOrgTree newTree on newTree.fid=disNew.FORGBOUNDID  ");
            sql.append(" left join ").append(templatedis_old).append(" disOld on disOld.fid=disNew.fid ");
            sql.append(" where disOld.fid is null and newTree.fid is null ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from ").append(templatedis_new).append(" where fid in(");
            sql.append(" select dis.fid from ").append(templatedis_new).append(" dis ");
            sql.append(" left join T_CSL_NewTempletDisOrgTree newTree on newTree.fid=dis.FORGBOUNDID where newTree.fid is null) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"repaireDispense error.", (Throwable)e);
        }
    }

    public static void clearAllServerNewTempletDisOrgTreeSet(Context ctx) throws BOSException {
        try {
            INewOrgTreeCatch IRpcHandleFacade2 = TemplateDispenseNewUtil.getOrgTreeSetIntface(ctx);
            Set<String> orgTreeSet = TemplateDispenseNewUtil.getLocalNewTempletDisOrgTreeSet(ctx);
            IRpcHandleFacade2.refreshNewTempletDisOrgTreeSet(orgTreeSet);
        }
        catch (Exception e) {
            isGetLocal = true;
            logger.error((Object)"clearAllServerNewTempletDisOrgTreeSet error.", (Throwable)e);
        }
        finally {
            TemplateDispenseNewUtil.clearNewTempletDisOrgTreeSet();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static INewOrgTreeCatch getOrgTreeSetIntface(Context ctx) throws BOSException {
        String url = "";
        ORMServiceLocation loc = new ORMServiceLocation("NetCtrl");
        if (loc == null || loc.isLocal()) return new NewOrgTreeCatch(true);
        try {
            url = loc.getServiceURL();
            if (StringUtils.isEmpty((String)url)) {
                return new NewOrgTreeCatch(true);
            }
            IORMModel oRMModel = RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.fi.newrpt.util.NewOrgTreeCatch", INewOrgTreeCatch.class);
            return (INewOrgTreeCatch)oRMModel;
        }
        catch (Exception err) {
            try {
                throw new BOSException("getOrgTreeSetIntface error.", (Throwable)err);
            }
            catch (Exception err2) {
                logger.error((Object)err2.getMessage(), (Throwable)err2);
                throw new BOSException("getOrgTreeSetIntface error.", (Throwable)err2);
            }
        }
    }
}

