/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.CslRptCache;
import com.kingdee.eas.fi.newrpt.util.ICslRptCacheIntf;
import com.kingdee.eas.fi.newrpt.util.TemplateItemListSynHandle;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class TemplateItemListNewUtil {
    private static Logger logger = Logger.getLogger(TemplateItemListNewUtil.class);
    public static String templateItemList_new = "T_CSL_TempletItemList_new";
    public static String templateItemList_his = "T_CSL_TempletItemList_his";
    public static String templateItemList = "T_CSL_TempletItemList";
    public static CslRptCache cache = new CslRptCache();

    public static String getTemplateItemListTableName(Context ctx, String templateTable) throws BOSException {
        try {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select tpl.fid from t_rpt_template tpl ");
            sql.append(" inner join ").append(templateTable).append(" tmp on tpl.fgroup=tmp.fgroup and tpl.fversionnumber=tmp.fversionnumber ");
            sql.append(" left join T_CSL_TempletItemList_log tmplog on tmplog.fid=tpl.fid ");
            sql.append(" where tmplog.fid is null ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() <= 0) {
                return templateItemList_new;
            }
        }
        catch (Exception e) {
            logger.error((Object)"getTemplateItemListTableName error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return templateItemList;
    }

    public static String getTemplateItemListTableNameById(Context ctx, String tamplateId, String defalutTable) throws BOSException {
        try {
            HashMap<String, String> tables = TemplateItemListNewUtil.getTemplateItemListTableName(ctx, new String[]{tamplateId}, defalutTable);
            if (tables != null) {
                return tables.get(tamplateId);
            }
            if (!StringUtils.isEmpty((String)defalutTable)) {
                return defalutTable;
            }
            return templateItemList;
        }
        catch (Exception e) {
            logger.error((Object)"getTemplateItemListTableName(Context ctx,String tamplateId) error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String getTemplateItemListTableName(Context ctx, Set templateIds, String defalutTable) throws BOSException {
        try {
            if (templateIds != null && !templateIds.isEmpty()) {
                SQLBuilder sql = new SQLBuilder();
                sql.append("select fid from T_CSL_TempletItemList_log  ");
                sql.append(" where fid in ", (Collection)templateIds);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                if (templateIds.size() == rowSet.size()) {
                    return templateItemList_new;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getTemplateItemListTableName(Context ctx, Set templateIds, String defalutTable) error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return defalutTable;
    }

    public static HashMap<String, String> getTemplateItemListTableName(Context ctx, String[] templateIds, String defalutTable) throws BOSException {
        try {
            if (templateIds != null && templateIds.length > 0) {
                SQLBuilder sql = new SQLBuilder();
                sql.append("select fid from T_CSL_TempletItemList_log  ");
                sql.append(" where fid in ", templateIds);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                HashMap<String, String> result = new HashMap<String, String>();
                while (rowSet.next()) {
                    result.put(rowSet.getString("fid"), templateItemList_new);
                }
                String table = StringUtils.isEmpty((String)defalutTable) ? templateItemList : defalutTable;
                for (String templateId : templateIds) {
                    if (result.containsKey(templateId)) continue;
                    result.put(templateId, table);
                }
                return result;
            }
        }
        catch (Exception e) {
            logger.error((Object)"getTemplateItemListTableName(Context ctx, List<String> templateIds) error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static HashMap<String, String> getTemplateItemListTableName(Context ctx, Collection<String> templateIds) throws BOSException {
        try {
            if (templateIds != null && templateIds.size() > 0) {
                SQLBuilder sql = new SQLBuilder();
                sql.append("select fid from T_CSL_TempletItemList_log  ");
                sql.append(" where fid in ", templateIds);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                HashMap<String, String> result = new HashMap<String, String>();
                while (rowSet.next()) {
                    result.put(rowSet.getString("fid"), templateItemList_new);
                }
                for (String templateId : templateIds) {
                    if (result.containsKey(templateId)) continue;
                    result.put(templateId, templateItemList_his);
                }
                return result;
            }
        }
        catch (Exception e) {
            logger.error((Object)"getTemplateItemListTableName(Context ctx, List<String> templateIds) error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static OneToManyMap getTemplateItemListTableNameByGroup(Context ctx, Collection<String> templateIds) throws BOSException {
        try {
            if (templateIds != null && templateIds.size() > 0) {
                SQLBuilder sql = new SQLBuilder();
                sql.append("select fid from T_CSL_TempletItemList_log  ");
                sql.append(" where fid in ", templateIds);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                OneToManyMap result = new OneToManyMap();
                HashSet<String> newtblId = new HashSet<String>();
                while (rowSet.next()) {
                    result.put((Object)templateItemList_new, (Object)rowSet.getString("fid"));
                    newtblId.add(rowSet.getString("fid"));
                }
                for (String templateId : templateIds) {
                    if (newtblId.contains(templateId)) continue;
                    result.put((Object)templateItemList_his, (Object)templateId);
                }
                return result;
            }
        }
        catch (Exception e) {
            logger.error((Object)"getTemplateItemListTableName(Context ctx, List<String> templateIds) error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static Object[] getTemplateItemListTableAndIsLastTmp(Context ctx, String templateId) throws BOSException {
        try {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select tpl.fversionstatus,tmplog.fid tmplogFid from t_rpt_template tpl ");
            sql.append(" left join T_CSL_TempletItemList_log tmplog on tmplog.fid=tpl.fid ");
            sql.append(" where tpl.fid=? ", (Object)templateId);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            if (rowSet != null && rowSet.next()) {
                String table = StringUtils.isEmpty((String)rowSet.getString("tmplogFid")) ? templateItemList_his : templateItemList_new;
                int versionStatus = rowSet.getInt("fversionstatus");
                boolean isLastTmp = versionStatus == 1 || versionStatus == 0;
                return new Object[]{table, isLastTmp};
            }
            return new Object[]{null, true};
        }
        catch (Exception e) {
            logger.error((Object)"getTemplateItemListTableAndIsLastTmp error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void insertTemplateItemListLog(Context ctx, String[] templateIds) throws BOSException {
        try {
            SQLBuilder sql = new SQLBuilder();
            sql.append("insert into T_CSL_TempletItemList_log(fid) ");
            sql.append(" select tmp.fid from t_rpt_template tmp ");
            sql.append(" left join T_CSL_TempletItemList_log log on log.fid=tmp.fid ");
            sql.append(" where log.fid is null and tmp.fid in ", templateIds);
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            TemplateItemListNewUtil.addNewJob(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"insertTemplateItemListLog error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void deleteTemplateItemListLog(Context ctx, String templateId) throws BOSException {
        try {
            DbUtil.execute((Context)ctx, (String)"delete T_CSL_TempletItemList_log where fid =?", (Object[])new Object[]{templateId});
        }
        catch (Exception e) {
            logger.error((Object)"insertTemplateItemListLog error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void repairData(Context ctx) throws BOSException {
        try {
            SQLBuilder sql = new SQLBuilder();
            DbUtil.execute((Context)ctx, (String)"delete T_CSL_TempletItemList_log ");
            sql.reset();
            sql.append(" insert into T_CSL_TempletItemList_log(fid) ");
            sql.append(" select fid from t_rpt_template tmp ");
            sql.append(" inner join (select fgroup,max(fauditedtime) fauditedtime from t_rpt_template group by fgroup) maxTmp ");
            sql.append(" on maxTmp.fgroup=tmp.fgroup and maxTmp.fauditedtime=tmp.fauditedtime ");
            sql.append(" where tmp.fid in(select ftemplateid from T_CSL_TempletItemList) ");
            DbUtil.execute((Context)ctx, (String)sql.getSQL());
            sql.reset();
            sql.append(" insert into ").append(templateItemList_his);
            sql.append(" select newlist.* from ").append(templateItemList_new).append(" newlist ");
            sql.append(" left join T_CSL_TempletItemList_log log on log.fid=newlist.ftemplateid ");
            sql.append(" where log.fid is null ");
            DbUtil.execute((Context)ctx, (String)sql.getSQL());
            sql.reset();
            sql.append(" delete ").append(templateItemList_new).append(" where fid in(");
            sql.append(" select newlist.fid from ").append(templateItemList_new).append(" newlist ");
            sql.append(" left join T_CSL_TempletItemList_log log on log.fid=newlist.ftemplateid ");
            sql.append(" where log.fid is null) ");
            DbUtil.execute((Context)ctx, (String)sql.getSQL());
        }
        finally {
            ICslRptCacheIntf cslRptCache = TemplateItemListNewUtil.getCslRptCacheIntface(ctx);
            cslRptCache.isAddedJob(false);
        }
    }

    public static synchronized void addNewJob(Context ctx) throws BOSException {
        try {
            ICslRptCacheIntf cslRptCache = TemplateItemListNewUtil.getCslRptCacheIntface(ctx);
            if (cslRptCache.isAddedJob(true)) {
                return;
            }
            TemplateItemListSynHandle handle = new TemplateItemListSynHandle();
            JobInstanceConfig jobInstance = new JobInstanceConfig((IJobHandler)handle, true, false, 1, "TemplateItemListSynHandle", null, JobIsolationLevel.Server);
            Calendar currDate = Calendar.getInstance();
            currDate.add(5, 1);
            currDate.set(11, 1);
            currDate.set(12, 0);
            currDate.set(13, 0);
            Timestamp scheduledTime = new Timestamp(currDate.getTimeInMillis());
            Job job = new Job(ctx, "templetItemListAudit", jobInstance, null, scheduledTime, null, -1, null);
            JobManager.instance().add(job);
        }
        catch (Exception e) {
            logger.error((Object)"TemplateItemListSynHandle error.", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICslRptCacheIntf getCslRptCacheIntface(Context ctx) throws BOSException {
        String url = "";
        ORMServiceLocation loc = new ORMServiceLocation("NetCtrl");
        if (loc == null || loc.isLocal()) return cache;
        try {
            url = loc.getServiceURL();
            if (StringUtils.isEmpty((String)url)) {
                return cache;
            }
            IORMModel oRMModel = RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.fi.newrpt.util.CslRptCache", ICslRptCacheIntf.class);
            return (ICslRptCacheIntf)oRMModel;
        }
        catch (Exception err) {
            try {
                throw new BOSException("getCslRptCacheIntface error.", (Throwable)err);
            }
            catch (Exception err2) {
                logger.error((Object)err2.getMessage(), (Throwable)err2);
                throw new BOSException("getCslRptCacheIntface error.", (Throwable)err2);
            }
        }
    }
}

