/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ebgateway.common.data;

import com.kingdee.bos.ebgateway.common.data.AbstractParser;
import com.kingdee.bos.util.EASResource;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataObject
extends AbstractParser {
    private String name;
    private Map properties = new HashMap();

    public static DataObject parse(String name, String xmlValue) {
        DataObject object = new DataObject();
        object.name = name;
        object.properties = DataObject.xml2Object(xmlValue);
        return object;
    }

    private static Map xml2Object(String xml) {
        HashMap<String, LinkedList<String>> _properties = new HashMap<String, LinkedList<String>>();
        Pattern pattern = Pattern.compile("<([^<>]+)\\s*>([^<>]*)</\\1\\s*>");
        Matcher matcher = pattern.matcher(xml);
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            LinkedList<String> _values = (LinkedList<String>)_properties.get(name);
            if (_values == null) {
                _values = new LinkedList<String>();
                _properties.put(name.trim(), _values);
            }
            _values.add(DataObject.unescapeXml(value));
        }
        return _properties;
    }

    private static String escapeXml(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String unescapeXml(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    protected static void checkName(String name) {
        if (name == null || "".equals(name)) {
            throw new NullPointerException(EASResource.getString((String)"com.kingdee.eas.fm.be.BEBosResource", (String)"004_PROPERTY_EMPTY"));
        }
        if (!name.matches("[a-zA-Z0-9_\\-\\$]+")) {
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.be.BEBosResource", (String)"005_PROPERTY_LIMIT"));
        }
    }

    public void setProperty(String name, String value) {
        this.setPropertyArray(name, new String[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeName(String name) {
        DataObject dataObject = this;
        synchronized (dataObject) {
            this.properties.remove(name);
        }
    }

    public void setPropertyArray(String name, String[] values) {
        DataObject.checkName(name);
        this.removeName(name);
        HashMap _properties = new HashMap();
        LinkedList<String> _values = (LinkedList<String>)_properties.get(name);
        if (_values == null) {
            _values = new LinkedList<String>();
            _properties.put(name.trim(), _values);
        }
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (value == null) continue;
            _values.add(value);
        }
        this.properties.put(name, _values);
    }

    @Override
    public String getProperty(String name) {
        List list = (List)this.properties.get(name);
        if (list != null) {
            return (String)list.get(0);
        }
        return null;
    }

    @Override
    public String[] getPropertyArray(String name) {
        List list = (List)this.properties.get(name);
        if (list != null) {
            return list.toArray(new String[0]);
        }
        return null;
    }

    public Set propertyNames() {
        return this.properties.keySet();
    }

    public String pack() {
        Set keySet = this.properties.keySet();
        StringBuffer buf = new StringBuffer();
        for (String name : keySet) {
            Object o = this.properties.get(name);
            if (o instanceof String) {
                buf.append("<").append(name).append(">").append(DataObject.escapeXml((String)o)).append("</").append(name).append(">");
                continue;
            }
            List strs = (List)o;
            for (int i = 0; i < strs.size(); ++i) {
                String str = (String)strs.get(i);
                if (str == null) continue;
                buf.append("<").append(name).append(">").append(DataObject.escapeXml(str)).append("</").append(name).append(">");
            }
        }
        return buf.toString();
    }

    @Override
    protected String getPropertyPrefix() {
        return this.name + ".";
    }
}

