/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;

public class AccountBankBalanceFilterParam
implements FilterParam {
    private static final long serialVersionUID = -5465311395066961349L;
    private String currencyId;
    private String[] companyId;
    private String bankInterface;
    private AccountBankInfo[] bankAccts;
    private String[] bankAcctIds;
    private Date beginDate;
    private Date endDate;
    private boolean isOnLine;
    private boolean isClose;
    private boolean isDataImport;

    public String getBankInterface() {
        return this.bankInterface;
    }

    public void setBankInterface(String bankInterface) {
        this.bankInterface = bankInterface;
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void setClose(boolean isClose) {
        this.isClose = isClose;
    }

    public boolean isDataImport() {
        return this.isDataImport;
    }

    public void setDataImport(boolean isDataImport) {
        this.isDataImport = isDataImport;
    }

    public AccountBankInfo[] getBankAccts() {
        return this.bankAccts;
    }

    public void setBankAccts(AccountBankInfo[] bankAcctIds) {
        this.bankAccts = bankAcctIds;
    }

    public String[] getBankAcctIds() {
        return this.bankAcctIds;
    }

    public void setBankAcctIds(String[] bankAcctIds) {
        this.bankAcctIds = bankAcctIds;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String[] getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String[] companyId) {
        this.companyId = companyId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isOnLine() {
        return this.isOnLine;
    }

    public void setOnLine(boolean isOnLine) {
        this.isOnLine = isOnLine;
    }

    public FilterInfo getFilter() {
        int i;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (!FMHelper.isEmpty((Object[])this.companyId)) {
            HashSet<String> list = new HashSet<String>(this.companyId.length);
            for (i = 0; i < this.companyId.length; ++i) {
                list.add(this.companyId[i]);
            }
            filterItems.add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        } else {
            CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
            filterItems.add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        }
        if (this.currencyId != null) {
            filterItems.add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (this.bankAccts != null) {
            HashSet<String> idSet = new HashSet<String>();
            for (i = 0; i < this.bankAccts.length; ++i) {
                idSet.add(this.bankAccts[i].getId().toString());
            }
            filterItems.add(new FilterItemInfo("accountBank.id", idSet, CompareType.INCLUDE));
        }
        filterItems.add(new FilterItemInfo("bizDate", (Object)DateTimeUtils.truncateDate((Date)this.beginDate), CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("bizDate", (Object)DateTimeUtils.truncateDate((Date)DateUtil.getNextDay((Date)this.endDate)), CompareType.LESS));
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizDate"));
        sorter.add(new SorterItemInfo("company.name"));
        sorter.add(new SorterItemInfo("currency.name"));
        return sorter;
    }
}

