/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.SysUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;

public class TransDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = 6469057082293987289L;
    private String currencyId;
    private String[] companyId;
    private String bankInterface;
    private AccountBankInfo[] bankAccts;
    private String[] bankAcctIds;
    private BigDecimal miniAmount;
    private BigDecimal maxAmount;
    private Date beginDate;
    private Date endDate;
    private boolean isOnLine;
    private int transType;
    private boolean isClose;
    private boolean isDataImport;
    private static final int ALL_TYPE = 3;
    private static final int REC_TYPE = 2;
    private static final int PAY_TYPE = 1;

    public boolean isClose() {
        return this.isClose;
    }

    public void setClose(boolean isClose) {
        this.isClose = isClose;
    }

    public boolean isDataImport() {
        return this.isDataImport;
    }

    public void setDataImport(boolean isDataImport) {
        this.isDataImport = isDataImport;
    }

    public boolean isOnLine() {
        return this.isOnLine;
    }

    public void setOnLine(boolean isOnLine) {
        this.isOnLine = isOnLine;
    }

    public int getTransType() {
        return this.transType;
    }

    public void setTransType(int transType) {
        this.transType = transType;
    }

    public AccountBankInfo[] getBankAccts() {
        return this.bankAccts;
    }

    public void setBankAccts(AccountBankInfo[] bankAccts) {
        this.bankAccts = bankAccts;
    }

    public String[] getBankAcctIds() {
        return this.bankAcctIds;
    }

    public void setBankAcctIds(String[] bankAcctIds) {
        this.bankAcctIds = bankAcctIds;
    }

    public String getBankInterface() {
        return this.bankInterface;
    }

    public void setBankInterface(String bankInterfaceId) {
        this.bankInterface = bankInterfaceId;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String[] getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String[] companyId) {
        this.companyId = companyId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(BigDecimal maxAmount) {
        this.maxAmount = maxAmount;
    }

    public BigDecimal getMiniAmount() {
        return this.miniAmount;
    }

    public void setMiniAmount(BigDecimal miniAmount) {
        this.miniAmount = miniAmount;
    }

    public FilterInfo getFilter() {
        int i;
        HashSet<String> list;
        FilterInfo fi = new FilterInfo();
        if (this.currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (!FMHelper.isEmpty((Object[])this.companyId)) {
            list = new HashSet<String>(this.companyId.length);
            for (i = 0; i < this.companyId.length; ++i) {
                list.add(this.companyId[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        } else {
            CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        }
        if (this.beginDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("bizTime", (Object)FMConstants.FORMAT_DAY.format(this.beginDate), CompareType.GREATER_EQUALS));
        }
        if (this.endDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("bizTime", (Object)FMConstants.FORMAT_DAY.format(DateUtil.getNextDay((Date)this.endDate)), CompareType.LESS));
        }
        if (!this.isDataImport) {
            fi.getFilterItems().add(new FilterItemInfo("isDataImport", (Object)new Integer(0)));
        }
        if (!EmptyUtil.isEmpty((Object[])this.bankAccts)) {
            list = new HashSet(this.bankAccts.length);
            for (i = 0; i < this.bankAccts.length; ++i) {
                list.add(this.bankAccts[i].getId().toString());
            }
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", list, CompareType.INCLUDE));
        }
        if (this.transType == 2) {
            fi.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(0)));
            if (this.miniAmount != null) {
                fi.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.miniAmount, CompareType.GREATER_EQUALS));
            }
            if (this.maxAmount != null) {
                fi.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.maxAmount, CompareType.LESS_EQUALS));
            }
        } else if (this.transType == 1) {
            fi.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(1)));
            if (this.miniAmount != null) {
                fi.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.miniAmount, CompareType.GREATER_EQUALS));
            }
            if (this.maxAmount != null) {
                fi.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.maxAmount, CompareType.LESS_EQUALS));
            }
        } else {
            FilterInfo fi1 = new FilterInfo();
            fi1.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(1)));
            if (this.miniAmount != null) {
                fi1.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.miniAmount, CompareType.GREATER_EQUALS));
            }
            if (this.maxAmount != null) {
                fi1.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.maxAmount, CompareType.LESS_EQUALS));
            }
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(0)));
            if (this.miniAmount != null) {
                fi2.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.miniAmount, CompareType.GREATER_EQUALS));
            }
            if (this.maxAmount != null) {
                fi2.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.maxAmount, CompareType.LESS_EQUALS));
            }
            try {
                fi1.mergeFilter(fi2, "or");
                fi.mergeFilter(fi1, "and");
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
        return fi;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizDate"));
        sorter.add(new SorterItemInfo("company.name"));
        sorter.add(new SorterItemInfo("bankAccount.bankAccountNumber"));
        sorter.add(new SorterItemInfo("currency.name"));
        sorter.add(new SorterItemInfo("sortedID"));
        return sorter;
    }
}

