/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.AccountBankBalanceFilterParam;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BeRpcCacheInfo;
import com.kingdee.eas.fm.be.SharedAcctFacadeFactory;
import com.kingdee.eas.fm.be.client.AbstractAccountBankBalanceFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class AccountBankBalanceFilterUI
extends AbstractAccountBankBalanceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBankBalanceFilterUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";
    private Map bankInterMap = new HashMap();
    private BeRpcCacheInfo RpcCacheInfo;
    private boolean isRestAcctData = true;

    public AccountBankBalanceFilterUI() throws Exception {
    }

    public AccountBankBalanceFilterUI(BeRpcCacheInfo RpcCacheInfo) throws Exception {
        this.RpcCacheInfo = RpcCacheInfo;
    }

    protected void init() throws Exception {
        super.init();
        this.dtpBegin.setValue((Object)DateUtil.getDayBegin());
        this.dtpEndo.setValue((Object)DateUtil.getDayBegin());
        CurrencyCollection curCol = this.RpcCacheInfo.getAllCurrencyColl();
        this.cboCurrency.removeAllItems();
        this.cboCurrency.addItems(curCol.toArray());
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        this.initBankInterface();
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.reSetF7BankAccountQuery();
        this.chkClose.setSelected(false);
        this.chkIsDataImport.setSelected(false);
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.cboBankInterface.removeAllItems();
        AccountBankCollection colls = this.RpcCacheInfo.getBankAcctCol();
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.cboBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.cboBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    public void clear() {
        super.clear();
        this.isOffline.setSelected(true);
        this.chkClose.setSelected(false);
        this.chkIsDataImport.setSelected(false);
        this.dtpBegin.setValue((Object)DateUtil.getDayBegin());
        this.dtpEndo.setValue((Object)DateUtil.getDayBegin());
        this.f7BankAccount.setData(null);
        this.setCompanyIds(new String[]{this.currentCompany.getId().toString()});
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)array);
        this.reSetF7BankAccountQuery();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"34_AccountBankBalanceFilterUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    protected void cboBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    public Object getParam() {
        AccountBankBalanceFilterParam para = new AccountBankBalanceFilterParam();
        HashSet<String> idSet = new HashSet<String>();
        Object[] acctBank = (Object[])this.f7BankAccount.getData();
        if (!EmptyUtil.isEmpty((Object[])acctBank)) {
            for (int i = 0; i < acctBank.length; ++i) {
                idSet.add(((AccountBankInfo)acctBank[i]).getBankAccountNumber());
            }
            Map result = null;
            try {
                result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(idSet);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            para.setBankAccts((AccountBankInfo[])result.get("acctBank"));
            String[] companyIds = (String[])result.get("companys");
            para.setCompanyId(companyIds);
        } else {
            para.setBankAccts(null);
            para.setCompanyId(null);
        }
        if (this.cboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setCurrencyId(null);
        } else {
            para.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        }
        para.setBeginDate(DateTimeUtils.truncateDate((Date)this.dtpBegin.getSqlDate()));
        para.setEndDate(DateTimeUtils.truncateDate((Date)this.dtpEndo.getSqlDate()));
        if (this.isOnline.isSelected()) {
            para.setOnLine(true);
        } else {
            para.setOnLine(false);
        }
        para.setClose(this.chkClose.isSelected());
        para.setDataImport(this.chkIsDataImport.isSelected());
        if (this.cboBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.cboBankInterface.getSelectedItem();
            para.setBankInterface(bankInterface.getNumber());
        } else {
            para.setBankInterface(null);
        }
        return para;
    }

    @Override
    protected void isOnline_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkIsDataImport.isSelected() && this.isRestAcctData) {
            this.reSetF7BankAccountQuery();
        }
        if (this.isOnline.isSelected()) {
            this.chkClose.setSelected(false);
            this.chkClose.setEnabled(false);
            this.dtpBegin.setEnabled(true);
            this.dtpEndo.setEnabled(true);
            this.chkIsDataImport.setSelected(false);
            this.chkIsDataImport.setEnabled(false);
        } else {
            this.chkClose.setEnabled(true);
            this.dtpBegin.setEnabled(true);
            this.dtpEndo.setEnabled(true);
            this.chkIsDataImport.setEnabled(true);
        }
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof AccountBankBalanceFilterParam)) {
            return;
        }
        AccountBankBalanceFilterParam para = (AccountBankBalanceFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String[] companyIds = para.getCompanyId();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        this.chkClose.setSelected(para.isClose());
        this.chkIsDataImport.setSelected(para.isDataImport());
        this.dtpBegin.setValue((Object)para.getBeginDate());
        this.dtpEndo.setValue((Object)para.getEndDate());
        if (para.isOnLine()) {
            this.isOnline.setSelected(true);
        } else {
            this.isOffline.setSelected(true);
        }
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.cboBankInterface.setSelectedItem(this.cboBankInterface.getItemAt(this.cboBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.cboBankInterface.getItemAt(index));
        }
        if (para.getBankAccts() != null) {
            AccountBankCollection coll = new AccountBankCollection();
            for (int index = 0; index < para.getBankAccts().length; ++index) {
                coll.add(para.getBankAccts()[index]);
            }
            this.f7BankAccount.setData((Object)coll.toArray());
        } else if (para.getBankAcctIds() != null) {
            try {
                if (para.getBankAcctIds() != null) {
                    Set set = FMHelper.asSet((String[])para.getBankAcctIds());
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    AccountBankCollection coll = null;
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    private void reSetF7BankAccountQuery() {
        this.f7BankAccount.setData(null);
    }

    public boolean verify() {
        try {
            this.checkPermission(this.isOnline.isSelected());
        }
        catch (Exception e) {
            MsgBox.showError((String)e.getMessage());
            SysUtil.abort();
        }
        BEClientHelper.verifyDate((Component)((Object)this), this.dtpBegin, this.dtpEndo);
        if (this.cboCurrency.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckCurrency"));
            SysUtil.abort();
        }
        if (this.f7BankAccount.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckAccountBank"));
            SysUtil.abort();
        }
        return true;
    }

    private void checkPermission(boolean isOnline) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        String userId = ContextHelperFactory.getRemoteInstance().getCurrentUser().getId().toString();
        boolean BE020 = ContextHelperFactory.getRemoteInstance().getBooleanParam("BE020", (IObjectPK)new ObjectUuidPK(companyId));
        if (BE020 && isOnline) {
            permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyId), "acctBankBalance_04onLineView");
        }
    }

    @Override
    protected void f7BankAccount_willCommit(CommitEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    @Override
    protected void f7BankAccount_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    private void initAccountBankEvi() {
        BankInterface bankInterface;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        if (this.cboBankInterface.getSelectedItem() instanceof BankInterface && !FMHelper.isEmpty((String)(bankInterface = (BankInterface)this.cboBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankInterface.getNumber()));
        }
        if (!this.chkClose.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        if (!this.chkIsDataImport.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        }
        FilterInfo currencyFilter = new FilterInfo();
        CurrencyInfo selectedCurrency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (selectedCurrency != null) {
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)selectedCurrency.getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(false)));
            currencyFilter.setMaskString("#0 or #1");
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
            filterInfo.mergeFilter(currencyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setEntityViewInfo(evi);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    protected void f7Company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void cboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    protected Class getParamClass() {
        return AccountBankBalanceFilterParam.class;
    }

    @Override
    protected void f7BankAccount_dataChanged(DataChangeEvent e) throws Exception {
        this.isOnline.setEnabled(true);
        Object[] acctBank = (Object[])this.f7BankAccount.getData();
        if (!EmptyUtil.isEmpty((Object[])acctBank)) {
            this.isRestAcctData = false;
            for (int i = 0; i < acctBank.length; ++i) {
                AccountBankInfo accountBank = (AccountBankInfo)acctBank[i];
                if (!accountBank.isIsClosed()) continue;
                this.isOnline.setEnabled(false);
                this.isOffline.setSelected(true);
                break;
            }
            this.isRestAcctData = true;
        }
    }

    @Override
    protected void chkIsDataImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkIsDataImport.isSelected()) {
            this.cboBankInterface.setSelectedItem(this.cboBankInterface.getItemAt(this.cboBankInterface.getItemCount() - 1));
        } else {
            this.reSetF7BankAccountQuery();
        }
    }
}

