/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BankAcctBalServiceClient
implements Callable {
    int threadSize = 5;
    protected int taskNum;
    private String[] oneBatchBankAcctIds;
    private String bankInterface;
    private String currencyId;
    private Date beginDate;
    private Date endDate;

    public BankAcctBalServiceClient() {
    }

    public BankAcctBalServiceClient(String currencyId, String bankInterface, String[] param1, Date beginDate, Date endDate, int taskNum) {
        this.oneBatchBankAcctIds = param1;
        this.currencyId = currencyId;
        this.bankInterface = bankInterface;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.taskNum = taskNum;
    }

    public Map queryBalance(String currencyId, AccountBankInfo[] bankAccts, Date beginDate, Date endDate) throws BOSException, EASBizException {
        this.currencyId = currencyId;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.bankInterface = bankAccts[0].getBankInterFaceID();
        return this.mulThreadQueryBalance(bankAccts);
    }

    private Map queryBalance(String[] oneBatchBankAcctIds) throws BOSException, EASBizException {
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        return bankFacade.getBalance(this.currencyId, oneBatchBankAcctIds, this.beginDate, this.endDate);
    }

    private Map mulThreadQueryBalance(AccountBankInfo[] bankAccts) throws BOSException {
        HashMap<String, String> resultList = new HashMap<String, String>();
        Map<String, List<String>> result = this.DivideGroupNew(bankAccts);
        if (this.threadSize > result.size()) {
            this.threadSize = result.size();
        }
        ExecutorService pool = Executors.newFixedThreadPool(this.threadSize);
        int i = 0;
        ArrayList list = new ArrayList();
        for (String bank : result.keySet()) {
            List<String> bankAcctIds = result.get(bank);
            if (bankAcctIds == null || bankAcctIds.size() <= 0) continue;
            String[] ids = new String[bankAcctIds.size()];
            BankAcctBalServiceClient c = this.getCommitToBeService(bankAcctIds.toArray(ids), i);
            Future f = pool.submit(c);
            list.add(f);
            ++i;
        }
        pool.shutdown();
        Map resultOne = null;
        HashSet FaillSet = new HashSet();
        Object failed = null;
        int successCount = 0;
        boolean sucCount = false;
        for (Future future : list) {
            try {
                resultOne = (Map)future.get();
                if (!EmptyUtil.isEmpty(resultOne.get("detailMsg"))) {
                    FaillSet.add(resultOne.get("detailMsg"));
                }
                successCount += Integer.valueOf((String)resultOne.get("successCount")).intValue();
            }
            catch (InterruptedException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer mainBuffer = new StringBuffer();
        String string = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"116_AccountBalanceMainMsg");
        mainBuffer.append(MessageFormat.format(string, String.valueOf(successCount), String.valueOf(bankAccts.length - successCount)));
        resultList.put("summaryMsg", mainBuffer.toString());
        String detailMsg = "";
        if (!EmptyUtil.isEmpty(FaillSet)) {
            detailMsg = detailMsg + ((Object)FaillSet).toString();
        }
        resultList.put("detailMsg", detailMsg);
        return resultList;
    }

    private BankAcctBalServiceClient getCommitToBeService(String[] param1, int taskNum) {
        return new BankAcctBalServiceClient(this.currencyId, this.bankInterface, param1, this.beginDate, this.endDate, taskNum);
    }

    private Map<String, List<String>> DivideGroupNew(AccountBankInfo[] bankAccts) {
        HashMap<String, List<String>> group = new HashMap<String, List<String>>();
        for (int i = 0; i < bankAccts.length; ++i) {
            List<String> bankAcctIds;
            AccountBankInfo bankAcct = bankAccts[i];
            String bank = bankAcct.getBankInterFaceID();
            if (group.containsKey(bank)) {
                bankAcctIds = (List)group.get(bank);
                bankAcctIds.add(bankAcct.getId().toString());
                continue;
            }
            bankAcctIds = new ArrayList();
            bankAcctIds.add(bankAcct.getId().toString());
            group.put(bank, bankAcctIds);
        }
        return group;
    }

    public Object call() throws Exception {
        System.out.println(">>>" + this.taskNum + " \u4efb\u52a1\u542f\u52a8");
        Date dateTmp1 = new Date();
        Map resultMap = this.queryBalance(this.oneBatchBankAcctIds);
        Date dateTmp2 = new Date();
        long time = dateTmp2.getTime() - dateTmp1.getTime();
        System.out.println(">>>" + this.taskNum + " \u4efb\u52a1\u7ec8\u6b62; \u8017\u65f6" + time);
        return resultMap;
    }
}

