/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.client.AbstractBankAgentPayBillFilterUI;
import com.kingdee.eas.fm.be.client.BankAgentPayBillFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankAgentPayBillFilterUI
extends AbstractBankAgentPayBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BankAgentPayBillFilterUI.class);
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private static final int OTHER_STATUS = 99;
    private static final int ALL_STATUS = 100;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.dtpBegin.setValue((Object)DateUtil.getDayBegin());
        this.dtpEnd.setValue((Object)DateUtil.getDayBegin());
        this.dtpBegin.setSupportedEmpty(false);
        this.dtpEnd.setSupportedEmpty(false);
        this.rdbAll.setSelected(true);
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        NewCompanyF7 selector = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        selector.setUIActionPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.be.client", "BankAgentPayBillListUI"), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            selector.setMultiSelect(false);
        } else {
            selector.setMultiSelect(true);
        }
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.prmtCompany.setValue((Object)this.currentCompany);
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initF7BankAccount();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public Object getParam() {
        BankAgentPayBillFilterParam paramInfo = new BankAgentPayBillFilterParam();
        if (this.cboCurrency.getSelectedItem() == FMSysDefinedEnum.ALL_ITEMS) {
            paramInfo.setCurrencyInfo(null);
        } else {
            paramInfo.setCurrencyInfo((CurrencyInfo)this.cboCurrency.getSelectedItem());
        }
        paramInfo.setStartDate((java.util.Date)this.dtpBegin.getValue());
        paramInfo.setEndDate((java.util.Date)this.dtpEnd.getValue());
        paramInfo.setBankAcctIds(AccessHelper.getF7Ids((KDBizPromptBox)this.f7BankAccount));
        if (this.rdbFailure.isSelected()) {
            paramInfo.setBillStatus(5);
        } else if (this.rdbSucceed.isSelected()) {
            paramInfo.setBillStatus(6);
        } else if (this.rdbOther.isSelected()) {
            paramInfo.setBillStatus(99);
        } else {
            paramInfo.setBillStatus(100);
        }
        paramInfo.setMainOrgCollIDSet(AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCompany)));
        return paramInfo;
    }

    public void setParam(Object param) {
        BankAgentPayBillFilterParam paramInfo = (BankAgentPayBillFilterParam)param;
        if (paramInfo.getCurrencyInfo() == null) {
            UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)paramInfo.getCurrencyInfo());
        }
        this.dtpEnd.setValue((Object)paramInfo.getEndDate());
        this.dtpBegin.setValue((Object)paramInfo.getStartDate());
        if (paramInfo.getBillStatus() == 5) {
            this.rdbFailure.setSelected(true);
        } else if (paramInfo.getBillStatus() == 6) {
            this.rdbSucceed.setSelected(true);
        } else if (paramInfo.getBillStatus() == 99) {
            this.rdbOther.setSelected(true);
        } else {
            this.rdbAll.setSelected(true);
        }
        try {
            if (paramInfo.getBankAcctIds() != null) {
                Set set = FMHelper.asSet((String[])paramInfo.getBankAcctIds());
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                ev.setFilter(filter);
                AccountBankCollection coll = null;
                IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                coll = bankAcct.getAccountBankCollection(ev);
                this.f7BankAccount.setData((Object)coll.toArray());
            }
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        if (!EmptyUtil.isEmpty((Collection)paramInfo.getMainOrgCollIDSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramInfo.getMainOrgCollIDSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
    }

    private void initF7BankAccount() {
        this.f7BankAccount.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> list = new HashSet<String>();
        list.add(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString());
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)((java.util.Date)this.dtpBegin.getValue()), (java.util.Date)((java.util.Date)this.dtpEnd.getValue()));
        Date startDate = this.dtpBegin.getSqlDate();
        Date endDate = this.dtpEnd.getSqlDate();
        if (startDate.compareTo(DateUtil.getDayBegin()) > 0 || endDate.compareTo(DateUtil.getDayBegin()) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"35_BankAgentPayBillFilterUI"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)startDate, (java.util.Date)endDate);
        if (FMHelper.isEmpty((Object)this.prmtCompany.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"36_BankAgentPayBillFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return BankAgentPayBillFilterParam.class;
    }
}

