/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.be.BankInterfaceCurrencyCollection;
import com.kingdee.eas.fm.be.BankInterfaceCurrencyFactory;
import com.kingdee.eas.fm.be.BankInterfaceCurrencyInfo;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.client.AbstractBankInterfaceCurrencyUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BankInterfaceCurrencyUI
extends AbstractBankInterfaceCurrencyUI {
    private static final Logger logger = CoreUIObject.getLogger(BankInterfaceCurrencyUI.class);
    private BankInterfaceCurrencyInfo InterfaceCurrency = null;
    private BankInterfaceTypeEnum curBankInterfaceType;

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.InterfaceCurrency != null) {
            this.txtCurrencyCode.setText(this.InterfaceCurrency.getCurrencyCode());
            this.txtDesc.setText(this.InterfaceCurrency.getDescription());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.InterfaceCurrency.setCurrencyCode(this.txtCurrencyCode.getText());
        this.InterfaceCurrency.setDescription(this.txtDesc.getText());
        this.InterfaceCurrency.setBankInterfaceType((BankInterfaceTypeEnum)this.cboBankInterface.getSelectedItem());
    }

    protected IObjectValue createNewData() {
        BankInterfaceCurrencyInfo info = new BankInterfaceCurrencyInfo();
        info.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankInterfaceCurrencyFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        BankInterfaceCurrencyFactory.getRemoteInstance().submit((CoreBaseInfo)this.InterfaceCurrency);
        this.showSubmitSuccess();
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void onLoad() throws Exception {
        this.txtCurrencyCode.setMaxLength(50);
        this.txtDesc.setMaxLength(100);
        FMClientHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        this.cboBankInterface.addItems(BankInterfaceTypeEnum.getEnumList().toArray());
        super.onLoad();
        this.curBankInterfaceType = (BankInterfaceTypeEnum)this.getUIContext().get("bankInterface");
        FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.curBankInterfaceType);
        if (this.editData != null) {
            this.loadFields();
            this.initOldData((IObjectValue)this.editData);
        }
    }

    @Override
    protected void cboBankInterface_actionPerformed(ActionEvent e) throws Exception {
        super.cboBankInterface_actionPerformed(e);
        this.setInterfaceCurrency();
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.cboCurrency_actionPerformed(e);
        this.setInterfaceCurrency();
    }

    public void setInterfaceCurrency() throws BOSException {
        BankInterfaceTypeEnum bankInterface = (BankInterfaceTypeEnum)this.cboBankInterface.getSelectedItem();
        if (bankInterface == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        if (this.InterfaceCurrency != null && bankInterface.equals((Object)this.InterfaceCurrency.getBankInterfaceType()) && currency.getId().toString().equals(this.InterfaceCurrency.getCurrency().getId().toString())) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(bankInterface.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currency.getId().toString()));
        BankInterfaceCurrencyCollection co = BankInterfaceCurrencyFactory.getRemoteInstance().getBankInterfaceCurrencyCollection(view);
        this.InterfaceCurrency = co.size() > 0 ? co.get(0) : (BankInterfaceCurrencyInfo)this.createNewData();
        if (this.editData != null) {
            this.loadFields();
            this.initOldData((IObjectValue)this.editData);
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
    }
}

