/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.BankInfo;
import com.kingdee.eas.base.core.fm.BankVersionInfo;
import com.kingdee.eas.base.core.fm.CertUser;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankConfigFacdeFactory;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.BankVersionCollection;
import com.kingdee.eas.fm.be.BankVersionFactory;
import com.kingdee.eas.fm.be.client.AbstractBankInterfaceListUI;
import com.kingdee.eas.fm.be.client.BEBankListUI;
import com.kingdee.eas.fm.be.client.BankInterfaceCurrencyUI;
import com.kingdee.eas.fm.be.client.BankInterfaceUI;
import com.kingdee.eas.fm.be.client.OpenAreaUI;
import com.kingdee.eas.fm.be.client.SubmitPasswordEditUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.FMIsqlUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BankInterfaceListUI
extends AbstractBankInterfaceListUI {
    private static final Logger logger = CoreUIObject.getLogger(BankInterfaceListUI.class);
    private Map map = new HashMap();
    private boolean isMnlBankCert = false;
    private BankInfo[] allBanks;

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return BankInterfaceUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void actionBankInterfaceCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.actionBankInterfaceCurrency_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bankInterface", (Object)this.getSelectedBankInterfaceType());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BankInterfaceCurrencyUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionOpenArea_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpenArea_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bankInterface", (Object)this.getSelectedBankInterfaceType());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(OpenAreaUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private BankInterfaceTypeEnum getSelectedBankInterfaceType() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("type");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            for (int i = 0; i < this.allBanks.length; ++i) {
                BankInterfaceTypeEnum keyValue;
                BankInfo bank = this.allBanks[i];
                if (!this.allBanks[i].getName().equals(cell.getValue()) || (keyValue = BankInterfaceTypeEnum.getEnum((String)this.allBanks[i].getShortName())) == null) continue;
                return keyValue;
            }
        }
        return null;
    }

    @Override
    public void actionPWD_actionPerformed(ActionEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addHelp();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        this.tblMain.getColumn("certUser").getStyleAttributes().setHided(!this.isMnlBankCert);
        this.initWorkButton();
        this.putKeyToMap();
        this.fillTable();
    }

    public void refreshList() throws Exception {
        this.fillTable();
    }

    private void fillTable() throws EASBizException, BOSException {
        int j;
        int i;
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        Map keyMap = null;
        IRow row = null;
        this.tblMain.removeRows();
        this.allBanks = BankConfigFacdeFactory.getRemoteInstance().getAvaliableBanks();
        BankVersionInfo[] allVertions = BankConfigFacdeFactory.getRemoteInstance().getAvaliableVersions();
        HashMap<String, BankInfo> shortName2Bank = new HashMap<String, BankInfo>();
        HashMap<String, BankVersionInfo> shortName2Version = new HashMap<String, BankVersionInfo>();
        for (i = 0; i < this.allBanks.length; ++i) {
            BankInfo bank = this.allBanks[i];
            BankVersionInfo[] versions = bank.getVersions();
            for (j = 0; j < versions.length; ++j) {
                shortName2Bank.put(versions[j].getShortName(), bank);
            }
        }
        for (i = 0; i < allVertions.length; ++i) {
            shortName2Version.put(allVertions[i].getShortName(), allVertions[i]);
        }
        if (this.isMnlBankCert) {
            for (i = 0; i < allVertions.length; ++i) {
                String versionShortName = allVertions[i].getShortName();
                CertUser[] certs = BankConfigFacdeFactory.getRemoteInstance().getCertUsersByVersion(versionShortName);
                for (j = 0; j < certs.length; ++j) {
                    CertUser cert = certs[j];
                    BankInfo bankInfo = (BankInfo)shortName2Bank.get(cert.getBankVersion());
                    BankVersionInfo versionInfo = (BankVersionInfo)shortName2Version.get(cert.getBankVersion());
                    row = this.tblMain.addRow();
                    row.getCell("type").setValue((Object)bankInfo.getName());
                    row.getCell("version").setValue((Object)versionInfo.getName());
                    row.getCell("certUser").setValue((Object)cert.getCertUserName());
                    keyMap = BankConfigFacdeFactory.getRemoteInstance().getBankServiceConfig(bankInfo.getShortName(), versionInfo.getShortName(), cert.getCertUserID());
                    this.setFieldByMap(row, keyMap);
                }
            }
        } else {
            for (i = 0; i < this.allBanks.length; ++i) {
                row = this.tblMain.addRow();
                row.getCell("type").setValue((Object)this.allBanks[i].getName());
                keyMap = BankConfigFacdeFactory.getRemoteInstance().getBankServiceConfig(this.allBanks[i].getShortName(), null, "");
                String version = (String)keyMap.get("version");
                BankVersionInfo versionInfo = (BankVersionInfo)shortName2Version.get(version);
                row.getCell("version").setValue((Object)versionInfo.getName());
                this.setFieldByMap(row, keyMap);
            }
        }
        endTime = System.currentTimeMillis();
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"52_BankInterfaceListUI") + (endTime - startTime) / 1000L + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"108_BankInterfaceListUI")));
    }

    private String getNameByNumber(String version) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)version));
        view.setFilter(filter);
        BankVersionCollection coll = BankVersionFactory.getRemoteInstance().getBankVersionCollection(view);
        if (coll != null && coll.size() == 1) {
            version = coll.get(0).getName();
        }
        return version;
    }

    private void putKeyToMap() {
        this.map.put("AuthNo", "authNo");
        this.map.put("Client", "clientId");
        this.map.put("CorpNo", "corpNo");
        this.map.put("EncryptedPort", "encryptedPort");
        this.map.put("LocalPort", "localPort");
        this.map.put("OpNo", "oPNo");
        this.map.put("ServerAddr", "serverAddr");
        this.map.put("SessionID", "sessionId");
        this.map.put("SignedPort", "signedPort");
        this.map.put("TimeOut", "timeOut");
        this.map.put("UserID", "userId");
        this.map.put("pwd", "pwd");
        this.map.put("usbkey", "usbkey");
        this.map.put("sequenceSeed", "sequenceSeed");
        this.map.put("grpidt", "grpidt");
        this.map.put("downloadDir", "downloadDir");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBankInterfaceCurrency.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnOpenArea.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnPWD.setIcon(EASResource.getIcon((String)"imgTbtn_setpassword"));
        this.btnEdit.setText(this.resHelper.getString("ActionEdit.NAME"));
        this.btnSavePassword.setIcon(EASResource.getIcon((String)"imgTbtn_setpassword"));
        this.actionBEBankNo.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_checklose"));
        this.actionRemove.setVisible(false);
        this.actionQuery.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPWD.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionSavePassword.setEnabled(true);
        this.actionOpenArea.setVisible(false);
        this.actionAddNew.setVisible(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        IRow row;
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        String permIteName = "bankInterface_edit";
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        PermissionHelper.checkFunctionPermission((IObjectPK)userPK, null, (String)permIteName);
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bankinterface", row.getCell("type").getValue());
            uiContext.put((Object)"bankVersion", row.getCell("version").getValue());
            if (this.isMnlBankCert) {
                uiContext.put((Object)"certUser", row.getCell("certUser").getValue());
            }
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BankInterfaceUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        IRow row;
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bankinterface", row.getCell("type").getValue());
            if (this.isMnlBankCert) {
                uiContext.put((Object)"bankVersion", row.getCell("version").getValue());
                uiContext.put((Object)"certUser", row.getCell("certUser").getValue());
            }
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BankInterfaceUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillTable();
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FMIsqlUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionSavePassword_actionPerformed(ActionEvent e) throws Exception {
        super.actionSavePassword_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SubmitPasswordEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionBEBankNo_actionPerformed(ActionEvent e) throws Exception {
        super.actionBEBankNo_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(BEBankListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected String getKeyFieldName() {
        return "type";
    }

    private void setFieldByMap(IRow row, Map keyMap) {
        String key2 = null;
        String cellKey = null;
        for (String key2 : keyMap.keySet()) {
            if (key2 == null || (cellKey = (String)this.map.get(key2)) == null) continue;
            if ("pwd".equalsIgnoreCase(cellKey) && !FMHelper.isEmpty(keyMap.get(key2))) {
                row.getCell(cellKey).setValue((Object)"******");
                continue;
            }
            if ("usbkey".equalsIgnoreCase(cellKey) && !FMHelper.isEmpty(keyMap.get(key2))) {
                row.getCell(cellKey).setValue((Object)"******");
                continue;
            }
            row.getCell(cellKey).setValue(keyMap.get(key2));
        }
    }
}

