/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.client.BankInterfaceTypeF7UI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BankInterfaceTypeF7Selector
implements KDPromptSelector {
    KDBizPromptBox prmt;
    IUIObject ui;
    IUIWindow uiWindow;
    FilterInfo filter;

    public BankInterfaceTypeF7Selector(IUIObject ui, KDBizPromptBox prmt, FilterInfo otherFilter) {
        this.init(ui, prmt, otherFilter);
    }

    private void init(IUIObject ui, KDBizPromptBox prmt, FilterInfo otherFilter) {
        this.ui = ui;
        this.prmt = prmt;
        prmt.addCommitListener((CommitListener)new BankInterfaceTypeF7CommitListener());
        prmt.setCommitParser((IParser)new BankInterfaceTypeF7Parser());
        this.filter = otherFilter;
    }

    public void show() {
        UIContext map = new UIContext((Object)this.ui);
        map.put("isEnabledMultiSelection", this.prmt.isEnabledMultiSelection());
        map.put("filter", this.filter);
        try {
            this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BankInterfaceTypeF7UI.class.getName(), (Map)map, null, OprtState.VIEW);
            this.uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean isCanceled() {
        if (this.uiWindow != null) {
            return ((BankInterfaceTypeF7UI)this.uiWindow.getUIObject()).isCanceled;
        }
        return true;
    }

    public Object getData() {
        return ((BankInterfaceTypeF7UI)this.uiWindow.getUIObject()).getRstData();
    }

    public boolean isEmpty(KDBizPromptBox prmt) {
        if (prmt.isEnabledMultiSelection()) {
            Object value = prmt.getData();
            if (value instanceof Object[] && FMHelper.isEmpty((Object[])((Object[])value))) {
                return true;
            }
            if (value instanceof List && ((List)value).size() <= 0) {
                return true;
            }
            if (prmt.getData() == null) {
                return true;
            }
        } else if (prmt.getData() == null) {
            return true;
        }
        return false;
    }

    class BankInterfaceTypeF7Parser
    implements IParser {
        BankInterfaceTypeF7Parser() {
        }

        public Object stringToValue(String str) {
            if (FMHelper.isEmpty((String)str)) {
                return null;
            }
            BankInterfaceTypeEnum bitEnum = BankInterfaceTypeEnum.getEnum((String)(str = str.trim()));
            if (bitEnum == null) {
                return null;
            }
            ArrayList<BankInterface> list = new ArrayList<BankInterface>();
            try {
                list.add(this.filterBankInter(str));
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            return list;
        }

        private BankInterface filterBankInter(String str) throws BOSException {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("bankInterFaceID"));
            view.getSelector().add(new SelectorItemInfo("bankInterFace"));
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            fi.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
            fi.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)("%" + str + "%"), CompareType.LIKE));
            view.setFilter(fi);
            AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            if (colls.size() > 0) {
                BankInterface info = new BankInterface();
                info.setName(colls.get(0).getBankInterFace());
                info.setNumber(colls.get(0).getBankInterFaceID());
                return info;
            }
            return null;
        }

        public void applyPattern(String pattern) {
        }

        public IRowSet getRowSetForPopupF8(String arg0) {
            return null;
        }

        public void setQuickQureyEntityViewInfo(EntityViewInfo arg0) {
        }
    }

    class BankInterfaceTypeF7CommitListener
    implements CommitListener {
        BankInterfaceTypeF7CommitListener() {
        }

        public void willCommit(CommitEvent e) {
            if (e == null) {
                return;
            }
        }
    }
}

