/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BankLogTypeEnum;
import com.kingdee.eas.fm.be.client.AbstractBankLogFilterUI;
import com.kingdee.eas.fm.be.client.BankLogFilterParam;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankLogFilterUI
extends AbstractBankLogFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BankLogFilterUI.class);
    private BankLogFilterParam param = null;
    private Map bankInterMap = new HashMap();

    public Object getParam() {
        if (this.param == null) {
            this.param = new BankLogFilterParam();
        }
        this.param.setBeginDate(DateTimeUtils.truncateDate((Date)this.kDBeginDate.getSqlDate()));
        this.param.setEndDate(DateTimeUtils.truncateDate((Date)DateTimeUtils.addDay((Date)this.kDEndDate.getSqlDate(), (long)1L)));
        if (this.kDCombLogType.getSelectedItem() instanceof BankLogTypeEnum) {
            this.param.setBanklogType((BankLogTypeEnum)((Object)this.kDCombLogType.getSelectedItem()));
        } else {
            this.param.setBanklogType(null);
        }
        if (this.kDCheckBoxException.isSelected()) {
            this.param.setException(Boolean.TRUE);
        } else {
            this.param.setException(Boolean.FALSE);
        }
        Set companyIdSet = this.getCompanyIdSet();
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        companyIdSet.add(currentCompany.getId().toString());
        this.param.setCompanyIdSet(companyIdSet);
        if (this.cboBankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)((BankInterface)this.cboBankInterface.getSelectedItem()).getNumber())) {
            BankInterface bankInterface = (BankInterface)this.cboBankInterface.getSelectedItem();
            this.param.setBankInterface(bankInterface.getName());
        } else {
            this.param.setBankInterface(null);
        }
        return this.param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        this.param = (BankLogFilterParam)((Object)param);
        this.kDBeginDate.setValue((Object)this.param.getBeginDate());
        this.kDEndDate.setValue((Object)this.param.getEndDate());
        if (this.param.getBanklogType() == null) {
            this.kDCombLogType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            this.kDCombLogType.setSelectedItem((Object)this.param.getBanklogType());
        }
        this.kDCheckBoxException.setSelected(this.param.isException().booleanValue());
        this.setCompanyIdSet(this.param.getCompanyIdSet());
        if (FMHelper.isEmpty((String)this.param.getBankInterface())) {
            this.cboBankInterface.setSelectedItem(this.cboBankInterface.getItemAt(this.cboBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(this.param.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.cboBankInterface.getItemAt(index));
        }
    }

    protected void setDefaultValue() {
        this.kDBeginDate.setValue((Object)new Date());
        this.kDEndDate.setValue((Object)new Date());
        this.initLogType();
        this.kDCheckBoxException.setSelected(false);
    }

    public void init() throws EASBizException, BOSException {
        this.kDBeginDate.setValue((Object)new Date());
        this.kDEndDate.setValue((Object)new Date());
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
        this.initLogType();
        this.initBankInterface();
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.cboBankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankInterFaceID"));
        sic.add(new SelectorItemInfo("bankInterFace"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.cboBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(k));
            ++k;
        }
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (EmptyUtil.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getName())) continue;
            this.cboBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getName(), new Integer(k));
            ++k;
        }
    }

    private void initLogType() {
        this.kDCombLogType.removeAllItems();
        this.kDCombLogType.addItems(BankLogTypeEnum.getEnumList().toArray());
        this.kDCombLogType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.kDCombLogType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public boolean verify() {
        Date endDate;
        Date beginDate;
        super.verify();
        boolean rst = true;
        if (FMHelper.isEmpty((Object)this.kDBeginDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BankLogResource", (String)"beginDateIsNull"));
            SysUtil.abort();
        }
        if (FMHelper.isEmpty((Object)this.kDEndDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BankLogResource", (String)"endDateIsNull"));
            SysUtil.abort();
        }
        if ((beginDate = (Date)this.kDBeginDate.getValue()).after(endDate = (Date)this.kDEndDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BankLogResource", (String)"checkBeginDateEndDate"));
            SysUtil.abort();
        }
        return rst;
    }

    protected Class getParamClass() {
        return BankLogFilterParam.class;
    }
}

