/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BeRpcCacheInfo;
import com.kingdee.eas.fm.be.client.AbstractBankPayingBillFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.be.client.BankPayingBillFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankPayingBillFilterUI
extends AbstractBankPayingBillFilterUI {
    private CompanyOrgUnitInfo company = null;
    private static final int ALL_STATUS = 100;
    private static final int OTHER_STATUS = 99;
    private Map bankInterMap = new HashMap();
    private BeRpcCacheInfo RpcCacheInfo;
    private static final Logger logger = CoreUIObject.getLogger(BankPayingBillFilterUI.class);
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";

    public BankPayingBillFilterUI() throws Exception {
    }

    public BankPayingBillFilterUI(BeRpcCacheInfo RpcCacheInfo) throws Exception {
        this.RpcCacheInfo = RpcCacheInfo;
    }

    public Object getParam() {
        BankPayingBillFilterParam para = new BankPayingBillFilterParam();
        if (this.cboCurrency.getSelectedItem() == null || !this.cboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        }
        para.setBankAcctId(AccessHelper.getF7Ids((KDBizPromptBox)this.f7BankAccount));
        para.setBeginDate(this.dtpBegin.getSqlDate());
        para.setEndDate(this.dtpEndo.getSqlDate());
        if (this.rdbFailure.isSelected()) {
            para.setStatus(5);
        } else if (this.rdbSucceed.isSelected()) {
            para.setStatus(6);
        } else if (this.rdbBankProcess.isSelected()) {
            para.setStatus(7);
        } else if (this.rdbNotComfirm.isSelected()) {
            para.setStatus(4);
        } else if (this.rdbPrepSubmit.isSelected()) {
            para.setStatus(1);
        } else if (this.rdbSubmitFail.isSelected()) {
            para.setStatus(3);
        } else if (this.rdbSubmitSuccess.isSelected()) {
            para.setStatus(2);
        } else {
            para.setStatus(100);
        }
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem();
            para.setBankInterface(bankInterface.getNumber());
        } else {
            para.setBankInterface(null);
        }
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof BankPayingBillFilterParam)) {
            return;
        }
        BankPayingBillFilterParam para = (BankPayingBillFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.dtpBegin.setValue((Object)para.getBeginDate());
        this.dtpEndo.setValue((Object)para.getEndDate());
        if (para.getStatus() == 5) {
            this.rdbFailure.setSelected(true);
        } else if (para.getStatus() == 6) {
            this.rdbSucceed.setSelected(true);
        } else if (para.getStatus() == 7) {
            this.rdbBankProcess.setSelected(true);
        } else if (para.getStatus() == 4) {
            this.rdbNotComfirm.setSelected(true);
        } else if (para.getStatus() == 1) {
            this.rdbPrepSubmit.setSelected(true);
        } else if (para.getStatus() == 3) {
            this.rdbSubmitFail.setSelected(true);
        } else if (para.getStatus() == 2) {
            this.rdbSubmitSuccess.setSelected(true);
        } else {
            this.rdbAll.setSelected(true);
        }
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.cmbxBankInterface, (Object)this.cmbxBankInterface.getItemAt(index));
        }
        String val = ContextHelperFactory.getRemoteInstance().getStringParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        String[] companyIds = para.getCompanyIds();
        if (!"2".equals(val)) {
            try {
                this.setCompanyIds(companyIds);
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        if (val.equals("0") && !GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            try {
                if (para.getBankAcctId() != null) {
                    AccountBankCollection coll = null;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        } else {
            try {
                if (para.getBankAcctId() != null) {
                    Set set = FMHelper.asSet((String[])para.getBankAcctId());
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    AccountBankCollection coll = null;
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    protected void init() throws Exception {
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        super.init();
        this.initBankInterface();
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"BE003_info"));
        sb.append("\r\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"BE003_info1"));
        sb.append("\r\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"BE003_info2"));
        sb.append("\r\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"BE003_info3"));
        this.kDTextArea1.setText(sb.toString());
        this.kDTextArea1.setEnabled(false);
    }

    @Override
    protected void cmbxBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.f7BankAccount.setData(null);
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.cmbxBankInterface.removeAllItems();
        AccountBankCollection colls = this.RpcCacheInfo.getBankAcctCol();
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
        this.cmbxBankInterface.setSelectedIndex(this.bankInterMap.size() - 1);
    }

    @Override
    protected void f7BankAccount_willCommit(CommitEvent e) throws Exception {
        this.initF7BankAccount();
    }

    @Override
    protected void f7BankAccount_willShow(SelectorEvent e) throws Exception {
        this.initF7BankAccount();
    }

    private void initF7BankAccount() {
        BankInterface bankInterface;
        this.f7BankAccount.setData(null);
        String val = ContextHelperFactory.getRemoteInstance().getStringParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        FilterInfo filterInfo = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            int i;
            HashSet<Object> list;
            if (val.equals("2") || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                list = new HashSet<Object>(companyId.length);
                for (i = 0; i < companyId.length; ++i) {
                    list.add(companyId[i]);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            }
            if (val.equals("1")) {
                list = new HashSet(companyId.length);
                for (i = 0; i < companyId.length; ++i) {
                    list.add(companyId[i]);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface && !FMHelper.isEmpty((String)(bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankInterface.getNumber()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setEntityViewInfo(evi);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public boolean verify() {
        return BEClientHelper.verifyDate((Component)((Object)this), this.dtpBegin, this.dtpEndo);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
        this.initF7BankAccount();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"NoCompany"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.company.getBaseCurrency());
        this.f7BankAccount.setData(null);
        Date date = new Date();
        this.dtpBegin.setValue((Object)date);
        this.dtpEndo.setValue((Object)date);
        this.rdbPrepSubmit.setSelected(false);
        this.rdbSubmitSuccess.setSelected(false);
        this.rdbSubmitFail.setSelected(false);
        this.rdbSucceed.setSelected(false);
        this.rdbFailure.setSelected(false);
        this.rdbBankProcess.setSelected(false);
        this.rdbNotComfirm.setSelected(false);
        this.rdbAll.setSelected(true);
    }

    protected Class getParamClass() {
        return BankPayingBillFilterParam.class;
    }
}

