/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.be.client.AbstractBankPayingDialogUI;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BankPayingDialogUI
extends AbstractBankPayingDialogUI {
    private static final Logger logger = CoreUIObject.getLogger(BankPayingDialogUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getRecCompany() != null) {
            this.prmtRecCompany.setData((Object)this.editData.getRecCompany());
        }
    }

    private SettlementBillInfo getSettlementBillInfo() {
        String id = (String)this.getUIContext().get("billId");
        SettlementBillInfo info = null;
        try {
            if (id != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("payeeAmount"));
                sic.add(new SelectorItemInfo("payeeFullName"));
                sic.add(new SelectorItemInfo("payeeBankAcctNum"));
                sic.add(new SelectorItemInfo("payeeBankAcct.id"));
                sic.add(new SelectorItemInfo("payerBankAcct.id"));
                sic.add(new SelectorItemInfo("payerBankAcct.*"));
                sic.add(new SelectorItemInfo("payerBankAcct.number"));
                sic.add(new SelectorItemInfo("payerBankAcct.bankAccountNumber"));
                sic.add(new SelectorItemInfo("payerBankAcct.openArea.id"));
                sic.add(new SelectorItemInfo("payerBankAcct.openArea.number"));
                sic.add(new SelectorItemInfo("payerBankAcct.openArea.*"));
                sic.add(new SelectorItemInfo("payeeBankAcct.number"));
                sic.add(new SelectorItemInfo("payeeBankAcct.bankInterfaceType"));
                sic.add(new SelectorItemInfo("payerBankAcct.bankInterfaceType"));
                sic.add(new SelectorItemInfo("payeeBankAcct.bank.name"));
                sic.add(new SelectorItemInfo("payeeBankAcct.company.name"));
                sic.add(new SelectorItemInfo("payerCurrency.id"));
                sic.add(new SelectorItemInfo("applyUnit.id"));
                sic.add(new SelectorItemInfo("*"));
                info = SettlementBillFactory.getRemoteInstance().getSettlementBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
            }
        }
        catch (Exception e) {
            SysUtil.abort();
        }
        return info;
    }

    @Override
    public void storeFields() {
        if (this.chkIsEmergency.isSelected()) {
            this.editData.setIsEmergency(true);
        } else {
            this.editData.setIsEmergency(false);
        }
        super.storeFields();
        Object recCompany = this.prmtRecCompany.getData();
        if (recCompany instanceof String) {
            this.editData.setRecCompany((String)recCompany);
        }
        if (recCompany instanceof SupplierInfo) {
            SupplierInfo info = (SupplierInfo)recCompany;
            this.editData.setRecCompany(info.getName());
        }
    }

    protected IObjectValue createNewData() {
        try {
            FSClientHelper.checkClearingHouseCompany();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BankPayingBillInfo bankPayingBillInfo = new BankPayingBillInfo();
        SettlementBillInfo info = this.getSettlementBillInfo();
        if (info.getPayerBankAcct().getBankInterfaceType() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InterfaceNoSet"));
            SysUtil.abort();
        }
        if (info.getAmount().compareTo(CasConstants.ZERO) < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"71_BankPayingDialogUI"));
            SysUtil.abort();
        }
        if (info != null) {
            bankPayingBillInfo.setSrcBillNumber(info.getNumber());
            String srcBillId = info.getId().toString();
            bankPayingBillInfo.setSourceBillId(srcBillId);
            bankPayingBillInfo.setSrcBillType(BillTypeEnum.SETTLEMENT_BILL);
            bankPayingBillInfo.setCompany(info.getCompany());
            Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
            bankPayingBillInfo.setSubmitTime(time);
            bankPayingBillInfo.setExpectTransTime(time);
            bankPayingBillInfo.setPayAccountBank(info.getPayerBankAcct());
            bankPayingBillInfo.setCurrency(info.getCurrency());
            bankPayingBillInfo.setPayAmount(info.getAmount());
            bankPayingBillInfo.setRecAccountBank(info.getPayeeBankAcctNum());
            Integer type = (Integer)this.getUIContext().get("type");
            if (type != null && info.getPayeeBankAcct() != null && type == 4) {
                bankPayingBillInfo.setRecBank(info.getPayeeBankAcct().getBank().getName());
                bankPayingBillInfo.setRecCompany(info.getPayeeBankAcct().getCompany().getName());
            } else {
                bankPayingBillInfo.setRecCompany(info.getPayeeFullName());
            }
            bankPayingBillInfo.setBankInterfaceType(info.getPayerBankAcct().getBankInterfaceType());
            bankPayingBillInfo.setState(BankPayingBillStateEnum.TF);
        }
        return bankPayingBillInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankPayingBillFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.checkIfPay();
        this.txtAreaCode.setEditable(false);
        this.initF7Component();
        this.setF7RecCity();
        this.setF7RecRegion();
    }

    private void checkIfPay() throws Exception {
        BankPayingBillStateEnum state;
        String id = (String)this.getUIContext().get("billId");
        FilterInfo fi = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)id));
        view.setFilter(fi);
        BankPayingBillCollection oldColl = BankPayingBillFactory.getRemoteInstance().getBankPayingBillCollection(view);
        if (oldColl != null && oldColl.size() > 0 && (state = oldColl.get(0).getState()) != BankPayingBillStateEnum.DE && state != BankPayingBillStateEnum.OF && state != BankPayingBillStateEnum.TF) {
            throw new BEException(BEException.HASCOMMIT);
        }
    }

    private void initF7Component() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        BankInterfaceTypeEnum bankInterface = this.editData.getBankInterfaceType();
        if (bankInterface != null) {
            filter.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(bankInterface.getValue())));
            view.setFilter(filter);
            this.prmtOpenArea.setEntityViewInfo(view);
        }
        this.prmtOpenArea.setHasCUDefaultFilter(false);
        this.prmtOpenArea.setQueryInfo("com.kingdee.eas.fm.be.F7OpenAreaQuery");
        this.prmtOpenArea.setDisplayFormat("$name$");
        this.prmtRecProvince.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7ProvinceQuery");
        Integer type = (Integer)this.getUIContext().get("type");
        if (type != null && type == 2) {
            String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.editData.getCompany().getId()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            this.prmtRecCompany.setEntityViewInfo(evi);
            GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
            selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtRecCompany, (Component)new F7SupplierTreeDetailListUI(), (Object)this.ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
            this.prmtRecCompany.setSelector((KDPromptSelector)selectorLisenterSupplier);
            this.prmtRecCompany.addSelectorListener((SelectorListener)selectorLisenterSupplier);
            this.prmtRecCompany.setEditable(true);
        } else {
            this.prmtRecCompany.setEnabled(false);
            this.txtBank.setEnabled(false);
        }
    }

    private void setF7RecCity() {
        ProvinceInfo province;
        Object recProvince = this.prmtRecProvince.getData();
        if (recProvince instanceof ProvinceInfo && (province = (ProvinceInfo)recProvince) != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("province.id", (Object)province.getId().toString()));
            view.setFilter(filter);
            this.prmtRecCity.setEntityViewInfo(view);
        }
        this.prmtRecCity.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CityQuery");
    }

    private void setF7RecRegion() {
        CityInfo city;
        Object recCity = this.prmtRecCity.getData();
        if (recCity instanceof CityInfo && (city = (CityInfo)recCity) != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("city.id", (Object)city.getId().toString()));
            view.setFilter(filter);
            this.prmtRecRegion.setEntityViewInfo(view);
        }
        this.prmtRecRegion.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7RegionQuery");
    }

    @Override
    protected void prmtOpenArea_dataChanged(DataChangeEvent e) throws Exception {
        OpenAreaInfo info = (OpenAreaInfo)this.prmtOpenArea.getData();
        if (info != null) {
            this.txtAreaCode.setText(info.getNumber());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.editData.getRecCompany() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecCompanyNotNull"));
            SysUtil.abort();
        }
        if (this.editData.getRecBank() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecBankNotNull"));
            SysUtil.abort();
        }
        if (this.editData.getRecProvince() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecProvinceNotNull"));
            SysUtil.abort();
        }
        if (this.editData.getRecCity() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecCityNotNull"));
            SysUtil.abort();
        }
        if (this.editData.getRecRegion() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecRegionNotNull"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        BankPayingBillCollection coll = new BankPayingBillCollection();
        IObjectPK pk = BankPayingBillFactory.getRemoteInstance().submit((CoreBaseInfo)this.editData);
        try {
            BankPayingBillInfo info = BankPayingBillFactory.getRemoteInstance().getBankPayingBillInfo(pk);
            this.editData.setNumber(info.getNumber());
        }
        catch (Exception exception) {
            // empty catch block
        }
        coll.add(this.editData);
        this.btnSubmit.setEnabled(false);
        this.setSave(true);
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SummitSucess"));
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isSave()) {
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    protected void prmtRecCompany_dataChanged(DataChangeEvent e) throws Exception {
        Object recCompany = this.prmtRecCompany.getData();
        if (recCompany instanceof SupplierInfo) {
            SupplierInfo info = (SupplierInfo)recCompany;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("province.id"));
            sic.add(new SelectorItemInfo("province.name"));
            sic.add(new SelectorItemInfo("city.id"));
            sic.add(new SelectorItemInfo("city.name"));
            sic.add(new SelectorItemInfo("region.id"));
            sic.add(new SelectorItemInfo("region.name"));
            if (info != null && info.getId() != null) {
                SupplierInfo newInfo = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getId()), sic);
                this.prmtRecProvince.setData((Object)newInfo.getProvince());
                this.prmtRecCity.setData((Object)newInfo.getCity());
                this.prmtRecRegion.setData((Object)newInfo.getRegion());
            }
        }
    }

    @Override
    protected void prmtRecCity_dataChanged(DataChangeEvent e) throws Exception {
        this.setF7RecRegion();
        this.prmtRecRegion.setData(null);
    }

    @Override
    protected void prmtRecProvince_dataChanged(DataChangeEvent e) throws Exception {
        this.setF7RecCity();
        this.setF7RecRegion();
        this.prmtRecCity.setData(null);
        this.prmtRecRegion.setData(null);
    }

    public static void verifyIsCanCancleAccept(List ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        HashSet list = new HashSet(ids);
        FilterInfo fi = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("sourceBillId", list, CompareType.INCLUDE));
        view.setFilter(fi);
        BankPayingBillCollection oldColl = BankPayingBillFactory.getRemoteInstance().getBankPayingBillCollection(view);
        if (oldColl != null && oldColl.size() > 0) {
            int size = oldColl.size();
            for (int i = 0; i < size; ++i) {
                BankPayingBillStateEnum state = oldColl.get(i).getState();
                if (state != BankPayingBillStateEnum.OS && state != BankPayingBillStateEnum.TS) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"72_BankPayingDialogUI"));
                SysUtil.abort();
            }
        }
    }
}

