/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillFactory;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.BankTransDownBillStateEnum;
import com.kingdee.eas.fm.be.client.AbstractBankTransDownBillEditUI;
import com.kingdee.eas.fm.be.client.BankTransDownBillHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.client.TransUpDownBillHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class BankTransDownBillEditUI
extends AbstractBankTransDownBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BankTransDownBillEditUI.class);
    private CompanyOrgUnitInfo company = null;
    private BankTransDownBillHandler handler = new BankTransDownBillHandler();

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "TRANS_DOWN_EDIT";
        }
        return "TRANS_DOWN_VIEW";
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (String)this.getOprtState());
        this.initUI();
        super.onLoad();
        if ("CONFIRM".equals(this.getOprtState())) {
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntrys, (boolean)false);
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntrys, (boolean)false, null);
        }
        this.setPropEvi();
    }

    private void initUI() {
        this.txttotalAmt.setRemoveingZeroInDispaly(false);
        this.txttotalAmt.setHorizontalAlignment(4);
        this.txttotalCounts.setHorizontalAlignment(4);
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.handler.initKDTable(this.kdtEntrys);
    }

    private void setPropEvi() {
        String companyId = this.editData.getCompany().getId().toString();
        this.prmtMotherAcctBank.setEntityViewInfo(TransUpDownBillHandler.getMotherAcctBankEvi((String)companyId));
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.actionBatchFill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copyline"));
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSubmit.setVisible(false);
        this.actionBatchFill.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionCopyLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
    }

    public void initDataStatus() {
        super.initDataStatus();
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        ItemAction[] actions = new ItemAction[]{this.actionPrint, this.actionPrintPreview, this.actionCopy, this.actionRemove, this.actionMultiapprove, this.actionWorkFlowG, this.actionAuditResult, this.actionNextPerson, this.actionCreateFrom, this.actionConfirm, this.actionCopyFrom};
        this.setActionVisible(false, actions);
        BankPayingBillStateEnum state = ((BankTransDownBillInfo)this.getDataObject()).getState();
        if (state.equals((Object)BankTransDownBillStateEnum.SUBMITED)) {
            this.actionSave.setVisible(false);
            this.actionSave.setEnabled(false);
        } else if (state.equals((Object)BankTransDownBillStateEnum.SAVED)) {
            this.actionSave.setVisible(true);
        }
        if ("CONFIRM".equals(this.getOprtState())) {
            this.lockUIForViewStatus();
            this.chkisUrgent.setEnabled(false);
            this.kdtEntrys.getStyleAttributes().setLocked(true);
            this.kdtEntrys.getColumn("isSuccessed").getStyleAttributes().setLocked(false);
            actions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionSave, this.actionSubmit, this.actionAttachment, this.actionBatchFill, this.actionAddLine, this.actionInsertLine, this.actionCopyLine, this.actionRemoveLine};
            this.setActionVisible(false, actions);
            this.actionConfirm.setVisible(true);
        } else if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            this.actionBatchFill.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionCopyLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionTraceDown.setEnabled(true);
            this.actionTraceUp.setEnabled(true);
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.actionBatchFill.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionAddLine.setEnabled(true);
            this.actionCopyLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        } else if ("EDIT".equals(this.getOprtState())) {
            this.actionBatchFill.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionAddLine.setEnabled(true);
            this.actionCopyLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionTraceDown.setEnabled(true);
            this.actionTraceUp.setEnabled(true);
        }
    }

    private void setActionVisible(boolean visible, ItemAction[] actions) {
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setVisible(visible);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.company == null) {
            this.company = this.editData.getCompany();
        }
    }

    @Override
    public void loadFields() {
        if (FMHelper.isEmpty((String)this.editData.getNumber())) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        } else {
            this.txtNumber.setEnabled(false);
        }
        super.loadFields();
        this.txttotalAmt.setValue((Object)this.editData.getTotalAmt());
    }

    @Override
    public void storeFields() {
        this.editData.getEntrys().clear();
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankTransDownBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BankTransDownBillInfo info = new BankTransDownBillInfo();
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BankTransDownBillEntryInfo entryInfo = new BankTransDownBillEntryInfo();
        entryInfo.setSeq(1);
        entryInfo.setAmount(Constants.ZERO);
        return entryInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("currency.*");
        sic.add("company.*");
        sic.add("fivouchered");
        sic.add("state");
        return sic;
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        this.setExRate();
    }

    @Override
    protected void prmtMotherAcctBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo motherAcctBankInfo = (AccountBankInfo)this.prmtMotherAcctBank.getValue();
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String motherAcctBankId = motherAcctBankInfo != null ? motherAcctBankInfo.getId().toString() : null;
        String currencyId = currencyInfo.getId().toString();
        this.handler.batchFill(this.kdtEntrys, motherAcctBankId, currencyId);
        this.handler.setEntrySeq(this.kdtEntrys);
        this.handler.setTotalCounts(this.kdtEntrys, this.txttotalCounts);
        this.handler.setTotalAmt(this.kdtEntrys, this.txttotalAmt);
    }

    @Override
    protected void prmtMotherAcctBank_preChange(PreChangeEvent e) throws Exception {
        if (e.getOldData() == null) {
            return;
        }
        int result = TransUpDownBillHandler.confirmClearEntry((CoreUIObject)this, (KDTable)this.kdtEntrys);
        if (result != 0) {
            e.setResult(0);
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2 || this.comboCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String currencyId = currencyInfo.getId().toString();
        int currencyPrec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currencyId));
        this.txttotalAmt.setPrecision(currencyPrec);
        this.handler.initAmtEditor(this.kdtEntrys, currencyId);
        this.setExRate();
        AccountBankInfo motherAcctBankInfo = (AccountBankInfo)this.prmtMotherAcctBank.getValue();
        String motherAcctBankId = motherAcctBankInfo != null ? motherAcctBankInfo.getId().toString() : null;
        this.handler.batchFill(this.kdtEntrys, motherAcctBankId, currencyId);
        this.handler.setEntrySeq(this.kdtEntrys);
        this.handler.setTotalCounts(this.kdtEntrys, this.txttotalCounts);
        this.handler.setTotalAmt(this.kdtEntrys, this.txttotalAmt);
    }

    private void setExRate() throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String currencyId = currencyInfo.getId().toString();
        String companyId = null;
        companyId = this.company != null ? this.company.getId().toString() : ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        Date date = (Date)this.pkBizDate.getValue();
    }

    @Override
    protected void kdtEntrys_editStarting(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntrys.getColumn("unitAcctBank").getColumnIndex()) {
            AccountBankInfo motherAcctBankInfo = (AccountBankInfo)this.prmtMotherAcctBank.getValue();
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (motherAcctBankInfo == null || currencyInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"motherABAndCurrIsNeed"));
                e.setCancel(true);
                SysUtil.abort();
            }
            KDBizPromptBox prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.kdtEntrys.getColumn(colIndex).getEditor()).getComponent();
            this.handler.setUnitAcctBankEvi(motherAcctBankInfo.getId().toString(), prmtBox);
        }
    }

    @Override
    public void kdtEntrys_editValueChanged(KDTEditEvent e) {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntrys.getRow(rowIndex);
        ICell cell = this.kdtEntrys.getCell(rowIndex, colIndex);
        if (colIndex == this.kdtEntrys.getColumn("unitAcctBank").getColumnIndex()) {
            AccountBankInfo unitAcctBankInfo = (AccountBankInfo)cell.getValue();
            if (unitAcctBankInfo == null) {
                row.getCell("subAcct").setValue(null);
                row.getCell("unit").setValue(null);
                return;
            }
            unitAcctBankInfo.setDisplayFormat("$number$ $name$");
            row.getCell("unitAcctBank").setValue((Object)unitAcctBankInfo);
            String currencyId = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString();
            TransAmtInfo amtInfo = this.handler.getTransAmtInfo(unitAcctBankInfo.getId().toString(), currencyId);
            if (amtInfo != null) {
                row.getCell("subAcct").setValue((Object)amtInfo.getSubAcct());
                row.getCell("unit").setValue((Object)amtInfo.getUnit());
                row.getCell("amount").setValue((Object)amtInfo.getAmount());
            }
            this.handler.setTotalAmt(this.kdtEntrys, this.txttotalAmt);
        } else if (colIndex == this.kdtEntrys.getColumn("amount").getColumnIndex()) {
            this.handler.setTotalAmt(this.kdtEntrys, this.txttotalAmt);
        }
    }

    public boolean isModify() {
        if ("CONFIRM".equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTable)this.kdtEntrys);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtEntrys, (String)"unitAcctBank");
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtEntrys, (String)"amount");
        TransUpDownBillHandler.checkEntryValid((IUIObject)this, (KDTable)this.kdtEntrys);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeSaveOrSubmit();
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }

    private void checkBeforeSaveOrSubmit() throws EASBizException, BOSException {
        if (this.editData.getId() == null) {
            return;
        }
        BankTransDownBillHandler.checkBeforeEdit(this.editData.getId().toString());
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeSaveOrSubmit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionBatchFill_actionPerformed(ActionEvent e) throws Exception {
        AccountBankInfo motherAcctBankInfo = (AccountBankInfo)this.prmtMotherAcctBank.getValue();
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (motherAcctBankInfo == null || currencyInfo == null) {
            EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"motherABAndCurrIsNeed");
            SysUtil.abort();
        }
        String motherAcctBankId = motherAcctBankInfo.getId().toString();
        String currencyId = currencyInfo.getId().toString();
        this.handler.batchFill(this.kdtEntrys, motherAcctBankId, currencyId);
        this.handler.setEntrySeq(this.kdtEntrys);
        this.handler.setTotalCounts(this.kdtEntrys, this.txttotalCounts);
        this.handler.setTotalAmt(this.kdtEntrys, this.txttotalAmt);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        this.handler.setEntrySeq(table);
        this.handler.setTotalCounts(table, this.txttotalCounts);
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
        this.handler.setEntrySeq(table);
        this.handler.setTotalCounts(table, this.txttotalCounts);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        this.handler.setEntrySeq(table);
        this.handler.setTotalCounts(table, this.txttotalCounts);
        this.handler.setTotalAmt(table, this.txttotalAmt);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }
}

