/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransUpBillEntryFactory;
import com.kingdee.eas.fm.be.BankTransUpBillFactory;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.IBankTransUpBill;
import com.kingdee.eas.fm.be.IBankTransUpBillEntry;
import com.kingdee.eas.fm.be.client.AbstractBankTransUpBillListUI;
import com.kingdee.eas.fm.be.client.BankPayingBillUpdateStateUI;
import com.kingdee.eas.fm.be.client.BankTransUpBillEditUI;
import com.kingdee.eas.fm.be.client.BankTransUpBillFilterUI;
import com.kingdee.eas.fm.be.client.BankTransUpBillPrintDataProvider;
import com.kingdee.eas.fm.common.client.DefaultOriginalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BankTransUpBillListUI
extends AbstractBankTransUpBillListUI {
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";
    private static final Logger logger = CoreUIObject.getLogger(BankTransUpBillListUI.class);
    BankTransUpBillFilterUI filterUI = null;

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0) {
            BizEnumValueInfo srcBillType = (BizEnumValueInfo)this.tblMain.getRow(i).getCell("srcBillType").getValue();
            Object value = this.tblMain.getRow(i).getCell("srcBillId").getValue();
            if (value == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"37_BankAgentPayBillListUI"));
                return;
            }
            String billId = value.toString();
            if (billId != null) {
                if (srcBillType.getInt() == 1 || srcBillType.getInt() == 2) {
                    // empty if block
                }
                CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)company);
            }
        } else {
            this.setMessageText(EASResource.getString((String)resourcePath, (String)"SelectOneRow"));
            this.showMessage();
        }
    }

    public BankTransUpBillListUI() throws Exception {
        DefaultTablePrecisionFormat precFmt = new DefaultTablePrecisionFormat();
        DefaultOriginalCurrencyPrecProvider origCurrPrecProvider = new DefaultOriginalCurrencyPrecProvider("currency.id");
        precFmt.setPrecProvider((ITablePrecisionProvider)origCurrPrecProvider);
        precFmt.initFormat(this.tblMain, new String[]{"totalAmt", "amount"});
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (String)this.getOprtState());
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionSyncStateByBill.setEnabled(true);
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow footRow = super.appendFootRow();
        if (footRow != null) {
            int i;
            String[] numberCols = new String[]{"totalAmt", "totalCounts"};
            int[] numberColsPrecision = new int[]{4, 0};
            BigDecimal totalAmt = new BigDecimal(0.0);
            int totalCounts = 0;
            ArrayList<String> idList = new ArrayList<String>();
            boolean needUpdate = false;
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                String parentid = (String)row.getCell("id").getValue();
                if (idList.contains(parentid)) {
                    needUpdate = true;
                    continue;
                }
                idList.add(parentid);
                if (row.equals(footRow)) continue;
                totalAmt = totalAmt.add((BigDecimal)row.getCell("totalAmt").getValue());
                Integer tmpCount = (Integer)row.getCell("totalCounts").getValue();
                totalCounts += tmpCount.intValue();
            }
            if (needUpdate) {
                this.tblMain.getFootRow(0).getCell("totalAmt").setValue((Object)totalAmt);
                this.tblMain.getFootRow(0).getCell("totalCounts").setValue((Object)new Integer(totalCounts));
            }
            for (i = 0; i < numberCols.length; ++i) {
                this.tblMain.getFootRow(0).getCell(numberCols[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)numberColsPrecision[i]));
            }
        }
        return footRow;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSyncStateByBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
        this.actionUnConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unpayment"));
        this.actionSendReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_send"));
        this.actionWithdrawReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_replied"));
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionBitBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionViewDetail.setEnabled(true);
        this.actionBitBack.setEnabled(true);
        this.actionWorkFlowG.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAudit.setVisible(false);
        this.actionAntiAudit.setVisible(false);
        this.actionConfirm.setVisible(false);
        this.actionUnConfirm.setVisible(false);
        this.actionSendReceipt.setVisible(false);
        this.actionWithdrawReceipt.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
    }

    @Override
    protected String getEditUIName() {
        return BankTransUpBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankTransUpBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BankTransUpBillFilterUI();
        }
        return this.filterUI;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = this.tblMain.getColumn("seq").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return super.getQueryProcessor();
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    private void changeButtonStatus() {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBoforeEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkBoforeEdit() throws TransBillException {
        this.checkSelected();
        int index = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index);
        int state = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
        String number = (String)row.getCell("number").getValue();
        if (state != 1 && state != 2) {
            throw new TransBillException(TransBillException.STATEERROREDIT, new Object[]{number});
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    private Set getSelectedIdSet() {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        return idSet;
    }

    @Override
    public void actionSyncStateByBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        super.actionSyncStateByBill_actionPerformed(e);
        if (idList == null || idList.size() == 0) {
            return;
        }
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        try {
            bankFacade.syncStateByTransUpIds(idList);
        }
        catch (BEException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)((Object)e1));
            if (e1.getSubCode().equals("046")) {
                this.setMessageText(EASResource.getString((String)resourcePath, (String)"UnsupportedService"));
            } else {
                this.setMessageText(EASResource.getString((String)resourcePath, (String)"SyncFailure"));
            }
            this.showMessage();
            SysUtil.abort();
        }
        try {
            TransUpBillFacadeFactory.getRemoteInstance().confirmAfterSyncState((List)idList);
        }
        catch (Exception e1) {
            logger.error((Object)("transUpConfirm fail! " + e1));
        }
        this.actionRefresh_actionPerformed(e);
        this.setMessageText(EASResource.getString((String)resourcePath, (String)"SyncSucess"));
        this.showMessage();
    }

    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        super.actionBitBack_actionPerformed(e);
        this.checkSelected();
        for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                String id = row.getCell("id").getValue().toString();
                IBankTransUpBill transUp = BankTransUpBillFactory.getRemoteInstance();
                BankTransUpBillInfo info = transUp.getBankTransUpBillInfo((IObjectPK)new ObjectUuidPK(id));
                if (!info.isIsBitBack()) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"39_BankAgentPayBillListUI"));
                return;
            }
        }
        if (!this.confirmBitBack()) {
            return;
        }
        ArrayList ids = this.getSelectedIdValues();
        IBankTransUpBill pay = BankTransUpBillFactory.getRemoteInstance();
        pay.bitBack(ids);
        FMClientHelper.showSuccessInfo((CoreUI)this, (ItemAction)this.actionBitBack);
        this.refreshList();
    }

    protected boolean confirmBitBack() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"confirmBitBack")));
    }

    @Override
    public void actionTdPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTdPrint_actionPerformed(e);
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        BankTransUpBillPrintDataProvider data = new BankTransUpBillPrintDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/BE/BANKTRANSUP", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTdPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTdPreview_actionPerformed(e);
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        BankTransUpBillPrintDataProvider data = new BankTransUpBillPrintDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/BE/BANKTRANSUP", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionEditState_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("entrys.state").getValue()).getInt();
        if (state != 4) {
            throw new BEException(BEException.UPDATESTATEERROR1);
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<Object> idList = new ArrayList<Object>(selectRows.length);
        int n = selectRows.length;
        for (int i = 0; i < n; ++i) {
            idList.add(this.tblMain.getRow(selectRows[i]).getCell("entrys.id").getValue());
        }
        if (idList.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        String uiName = BankPayingBillUpdateStateUI.class.getName();
        uiContext.put((Object)"sourceWindow", (Object)this.getEditUIName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        BankPayingBillStateEnum updateState = ((BankPayingBillUpdateStateUI)uiWindow.getUIObject()).getResult();
        if (updateState == null) {
            return;
        }
        IBankTransUpBillEntry bankTransUpBillEntry = BankTransUpBillEntryFactory.getRemoteInstance();
        Map result = bankTransUpBillEntry.updateState(new HashSet(idList), updateState);
        List resultList = (List)result.get("resultList");
        if (!EmptyUtil.isEmpty((Collection)resultList)) {
            this.showActionResult(resultList, "\u4fee\u6539\u5355\u636e\u72b6\u6001", "");
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u5355\u636e");
        }
    }

    private void showActionResult(List<BankPayResult> resultList, String title, String spentTimeHint) throws Exception {
        int size = resultList.size();
        if (resultList == null || size == 0) {
            return;
        }
        if (size == 1 && resultList.get(0).getId().equals("error")) {
            BankPayResult bankPayResult = resultList.get(0);
            MsgBox.showInfo((Component)((Object)this), (String)bankPayResult.getErrorDetail());
            return;
        }
        StringBuilder hintBuilder = new StringBuilder();
        StringBuffer errorDetail = new StringBuffer();
        int fail = 0;
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String numberTitle = "\u7f16\u53f7\uff1a";
        String successTitle = "\u6210\u529f\uff1a";
        String failureTitle = "\u5931\u8d25\uff1a";
        String recordTile = "\u7b14";
        for (int j = 0; j < size; ++j) {
            BankPayResult resultInfo = resultList.get(j);
            if (EmptyUtil.isEmpty((String)resultInfo.getErrorDetail())) continue;
            errorDetail.append("\u7f16\u53f7\uff1a").append(resultInfo.getNumber()).append("\uff1a");
            errorDetail.append("\u3010" + resultInfo.getErrorDetail() + "\u3011").append(LINE_SEPARATOR);
            ++fail;
        }
        if (fail == 0) {
            hintBuilder.append(title + "\u6210\u529f\uff1a").append(" ").append(size).append(" ").append("\u7b14");
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showInfo((Component)((Object)this), (String)hintBuilder.toString());
            this.refreshList();
        } else {
            hintBuilder.append(title + "\u6210\u529f\uff1a").append(" ").append(size - fail).append(" ").append("\u7b14").append(" , ");
            hintBuilder.append("\u5931\u8d25\uff1a").append(fail).append("\u7b14");
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)hintBuilder.toString(), (String)errorDetail.toString(), (int)0);
            if (size != fail) {
                this.refreshList();
            }
        }
    }
}

