/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JTextField;

public abstract class BankTransUpDownBillHandler {
    public static final String resClassName = "com.kingdee.eas.fm.fs.TransBillResource";
    private static final String COL_SEQ = "seq";
    public static final String COL_UNITACCTBANK = "unitAcctBank";
    public static final String COL_SUBACCT = "subAcct";
    public static final String COL_UNIT = "unit";
    public static final String COL_AMOUNT = "amount";
    public static final String COL_ISSUCCESSED = "isSuccessed";
    private static final String COL_DESC = "description";
    protected TransUpDownBillHelper helper = null;
    protected static final boolean[][] billActionStatus = new boolean[][]{{false, false, false, false, false, false, false}, {true, false, false, false, false, false, false}, {false, true, true, false, false, false, true}, {false, false, false, true, true, true, false}};
    protected static final boolean[][] voucherActionStatus = new boolean[][]{{false, false}, {true, false}, {false, true}};

    public static int confirmClearEntry(CoreUIObject ui, KDTable table) {
        if (table == null || table.getRowCount3() <= 0) {
            return 0;
        }
        String msg = EASResource.getString((String)resClassName, (String)"confirmClearEntry");
        return MsgBox.showConfirm3((Component)ui, (String)msg);
    }

    public static String getResString(String resName) {
        return EASResource.getString((String)resClassName, (String)resName);
    }

    public void initKDTable(KDTable table) {
        table.checkParsed();
        table.getColumn(COL_SEQ).getStyleAttributes().setHided(true);
        table.getColumn(COL_SEQ).getStyleAttributes().setLocked(true);
        table.getColumn(COL_UNIT).getStyleAttributes().setLocked(true);
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(true);
        prmt.setDisplayFormat("$number$ $name$");
        prmt.setEditFormat("$number$");
        prmt.setCommitFormat("$number$");
        prmt.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmt);
        table.getColumn(COL_UNITACCTBANK).setEditor((ICellEditor)editor);
        KDTextField txt = new KDTextField();
        txt.setMaxLength(80);
        KDTDefaultCellEditor editor2 = new KDTDefaultCellEditor((JTextField)txt);
        table.getColumn(COL_DESC).setEditor((ICellEditor)editor2);
    }

    public void initAmtEditor(KDTable table, String currencyId) throws Exception {
        if (FMHelper.isEmpty((String)currencyId)) {
            return;
        }
        table.checkParsed();
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currencyId));
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)table, (String)COL_AMOUNT, (int)prec, (BigDecimal)Constants.MIN_VALUE);
        FMClientHelper.setNumberFormat((KDTable)table, (String)COL_AMOUNT, (String)currencyId);
    }

    public static boolean isLocalCurrency(String currencyId, CompanyOrgUnitInfo company) {
        CurrencyInfo localCurrency;
        boolean isLocCurrency = false;
        if (currencyId == null) {
            return isLocCurrency;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (currencyId.equals((localCurrency = company.getBaseCurrency()).getId().toString())) {
            isLocCurrency = true;
        }
        return isLocCurrency;
    }

    public void setTotalAmt(KDTable table, KDFormattedTextField txtTotalAmt) {
        BigDecimal sumAmt = this.getEntrySumAmt(table, COL_AMOUNT, false);
        txtTotalAmt.setValue((Object)sumAmt);
    }

    public void setConfirmedAmt(KDTable table, KDFormattedTextField txtConfirmedAmt) {
        BigDecimal sumAmt = this.getEntrySumAmt(table, COL_AMOUNT, true);
        txtConfirmedAmt.setValue((Object)sumAmt);
    }

    public BigDecimal getEntrySumAmt(KDTable table, String colName, boolean isCalConfirm) {
        if (table == null || table.getRowCount3() < 1 || colName == null) {
            return Constants.ZERO;
        }
        IRow row = null;
        Object obj = null;
        BigDecimal sumAmt = Constants.ZERO;
        BigDecimal tempAmt = Constants.ZERO;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            boolean isConfirmed;
            row = table.getRow(i);
            if (isCalConfirm && ((obj = row.getCell(COL_ISSUCCESSED).getValue()) == null || !(isConfirmed = ((Boolean)obj).booleanValue())) || row.getCell(colName).getValue() == null) continue;
            tempAmt = (BigDecimal)row.getCell(colName).getValue();
            sumAmt = sumAmt.add(tempAmt);
        }
        return sumAmt;
    }

    public void setEntrySeq(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        int seq = 1;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            row.getCell(COL_SEQ).setValue((Object)new Integer(seq++));
        }
    }

    public void setTotalCounts(KDTable table, KDFormattedTextField txt) {
        int counts = this.getCounts(table, false);
        txt.setValue((Object)new Integer(counts));
    }

    public void setConfirmedCounts(KDTable table, KDFormattedTextField txt) {
        int counts = this.getCounts(table, true);
        txt.setValue((Object)new Integer(counts));
    }

    private int getCounts(KDTable table, boolean isCalConfirm) {
        if (table == null || table.getRowCount3() < 1) {
            return 0;
        }
        if (!isCalConfirm) {
            return table.getRowCount3();
        }
        int count = 0;
        Object obj = null;
        IRow row = null;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            boolean isConfirmed;
            row = table.getRow(i);
            obj = row.getCell(COL_ISSUCCESSED).getValue();
            if (obj == null || !(isConfirmed = ((Boolean)obj).booleanValue())) continue;
            ++count;
        }
        return count;
    }

    public static EntityViewInfo getMotherAcctBankEvi(String companyId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getSettleTypeEvi() {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public EntityViewInfo getUnitAcctBankEvi(String motherAcctBankId) throws EASBizException, BOSException {
        Set idSet = this.helper.getUnitAcctBankIdSet(motherAcctBankId);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public void setUnitAcctBankEvi(String motherAcctBankId, KDBizPromptBox prmtBox) throws EASBizException, BOSException {
        prmtBox.setEntityViewInfo(this.getUnitAcctBankEvi(motherAcctBankId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        prmtBox.setSelectorCollection(sic);
    }

    public TransAmtInfo getTransAmtInfo(String unitAcctBankId, String currencyId) throws EASBizException, BOSException {
        return this.helper.getTransAmtInfo(unitAcctBankId, currencyId);
    }

    public void batchFill(KDTable table, String motherAcctBankId, String currencyId) throws EASBizException, BOSException {
        table.removeRows();
        if (FMHelper.isEmpty((String)motherAcctBankId) || FMHelper.isEmpty((String)currencyId)) {
            return;
        }
        List list = this.helper.getTransAmtList(motherAcctBankId, currencyId);
        TransAmtInfo amtInfo = null;
        IRow row = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            amtInfo = (TransAmtInfo)list.get(i);
            row = table.addRow();
            amtInfo.getAcctBank().setDisplayFormat("$number$ $name$");
            row.getCell(COL_UNITACCTBANK).setValue((Object)amtInfo.getAcctBank());
            row.getCell(COL_UNIT).setValue((Object)amtInfo.getUnit());
            row.getCell(COL_AMOUNT).setValue((Object)amtInfo.getAmount());
        }
    }

    public void fillEntryAmt(KDTable table, String currencyId) throws EASBizException, BOSException {
        IRow row = null;
        TransAmtInfo amtInfo = null;
        AccountBankInfo unitAcctBankInfo = null;
        String unitAcctBankId = null;
        int size = table.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            unitAcctBankInfo = (AccountBankInfo)row.getCell(COL_UNITACCTBANK).getValue();
            if (unitAcctBankInfo == null || (amtInfo = this.helper.getTransAmtInfo(unitAcctBankId = unitAcctBankInfo.getId().toString(), currencyId)) == null) continue;
            row.getCell(COL_AMOUNT).setValue((Object)amtInfo.getAmount());
        }
    }

    public static void checkEntryValid(IUIObject ui, KDTable table) throws EASBizException {
        IRow row = null;
        AccountBankInfo info = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String key = null;
        BigDecimal amount = Constants.ZERO;
        boolean allIsZero = true;
        int count = table.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            row = table.getRow(rowIndex);
            if (!(row.getCell(COL_UNITACCTBANK).getValue() instanceof AccountBankInfo)) continue;
            info = (AccountBankInfo)row.getCell(COL_UNITACCTBANK).getValue();
            key = info.getId().toString();
            if (map.containsKey(key)) {
                Object[] params = new Object[]{(Integer)map.get(key), new Integer(rowIndex + 1), info.getName()};
                throw new TransBillException(TransBillException.UNITACCTBANKDUP, params);
            }
            map.put(key, new Integer(rowIndex + 1));
            amount = row.getCell(COL_AMOUNT) == null ? Constants.ZERO : (BigDecimal)row.getCell(COL_AMOUNT).getValue();
            if (amount.signum() == 0) continue;
            allIsZero = false;
        }
        if (allIsZero) {
            throw new TransBillException(TransBillException.ENTRYAMTISALLZERO);
        }
    }
}

