/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BatchPayRuleCollection;
import com.kingdee.eas.fm.be.BatchPayRuleFactory;
import com.kingdee.eas.fm.be.BatchPayRuleInfo;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.IBatchPayRule;
import com.kingdee.eas.fm.be.client.AbstractBatchPayRuleEditUI;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BatchPayRuleEditUI
extends AbstractBatchPayRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchPayRuleEditUI.class);
    private IBatchPayRule iBatchPayRule;
    private List interfacelist = new ArrayList();

    protected IObjectValue createNewData() {
        BatchPayRuleInfo info = new BatchPayRuleInfo();
        info.setMaxBarchNo(100);
        info.setMaxAmount(new BigDecimal(0));
        if (this.comboBankInterface.getItemCount() > 0) {
            BankInterface item = (BankInterface)this.comboBankInterface.getSelectedItem();
            info.setBankInterFaceId(item.getNumber());
            info.setBankInterFace(item.getName());
        }
        return info;
    }

    private IBatchPayRule getBatchPayRuleInterface() throws BOSException {
        if (this.iBatchPayRule == null) {
            this.iBatchPayRule = BatchPayRuleFactory.getRemoteInstance();
        }
        return this.iBatchPayRule;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return this.getBatchPayRuleInterface();
    }

    protected void loadData() throws Exception {
        this.initComponent();
        this.initBankInterfaceList();
        super.loadData();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadBankInterface();
        this.initOldData((IObjectValue)this.editData);
    }

    private void loadBankInterface() {
        if (OprtState.ADDNEW.equals(this.oprtState) && this.comboBankInterface.getItemCount() > 0) {
            this.comboBankInterface.setSelectedIndex(0);
        } else if (OprtState.EDIT.equals(this.oprtState) || OprtState.VIEW.equals(this.oprtState)) {
            for (int i = 0; i < this.comboBankInterface.getItemCount(); ++i) {
                BankInterface item = (BankInterface)this.comboBankInterface.getItemAt(i);
                if (!item.getNumber().equals(this.editData.getBankInterFaceId())) continue;
                this.comboBankInterface.setSelectedItem((Object)item);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        Object selectedItem = this.comboBankInterface.getSelectedItem();
        if (selectedItem != null) {
            BankInterface item = (BankInterface)selectedItem;
            this.editData.setBankInterFaceId(item.getNumber());
            this.editData.setBankInterFace(item.getName());
        }
    }

    public boolean isModify() {
        return false;
    }

    private void initBankInterfaceList() throws ParserException, BOSException {
        Object[] bankCert = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("bankInterFaceId");
        selectors.add("bankInterFace");
        view.setSelector(selectors);
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        view.setFilter(filter);
        AccountBankCollection accountBankColls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int size = accountBankColls.size();
        if (size == 0) {
            logger.error((Object)"\u94f6\u884c\u8d26\u6237\u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a\u90fd\u6ca1\u6709\u8bbe\u7f6e\u94f6\u884c\u63a5\u53e3\u4fe1\u606f");
            return;
        }
        IBankFacade iBankFacade = BankFacadeFactory.getRemoteInstance();
        try {
            bankCert = iBankFacade.getBankCert("", "");
        }
        catch (Exception e) {
            if (e instanceof EBGException) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                if (this.oprtState.equalsIgnoreCase(OprtState.VIEW) || this.oprtState.equalsIgnoreCase(OprtState.EDIT)) {
                    this.loadFields();
                    BankInterface item = new BankInterface();
                    item.setName(this.editData.getBankInterFace());
                    item.setNumber(this.editData.getBankInterFaceId());
                    this.comboBankInterface.addItem((Object)item);
                }
                return;
            }
            e.printStackTrace();
        }
        if (!EmptyUtil.isEmpty((Object[])bankCert)) {
            for (int i = 0; i < bankCert.length; ++i) {
                BankInterface bankInterface;
                if (EmptyUtil.isEmpty((Object)bankCert[i]) || EmptyUtil.isEmpty((Object)(bankInterface = (BankInterface)bankCert[i])) || EmptyUtil.isEmpty((String)bankInterface.getNumber())) continue;
                if (this.interfacelist.size() == accountBankColls.size()) break;
                for (int j = 0; j < accountBankColls.size(); ++j) {
                    AccountBankInfo accountBank = accountBankColls.get(j);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)accountBank) || EmptyUtil.isEmpty((String)accountBank.getBankInterFaceID()) || !bankInterface.getNumber().equals(accountBank.getBankInterFaceID()) || this.interfacelist.contains(accountBank.getBankInterFaceID())) continue;
                    this.interfacelist.add(accountBank.getBankInterFaceID());
                    this.comboBankInterface.addItem((Object)bankInterface);
                }
            }
        }
    }

    private void initComponent() throws ParserException, BOSException {
        SpinnerNumberModel model = new SpinnerNumberModel(100, 1, 1000000, 1);
        this.txtMaxBarchNo.setModel((SpinnerModel)model);
        this.txtMaxAmount.setMinimumValue((Comparable)new BigDecimal(0.0));
        this.txtMaxAmount.setMaximumValue((Comparable)new BigDecimal(1.0E8));
        if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            this.comboBankInterface.setEnabled(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboBankInterface);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtMaxAmount, (BigDecimal)new BigDecimal(0));
        this.checkExistBankInterfaceType();
    }

    private void checkExistBankInterfaceType() throws BOSException, EASBizException, Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankInterfaceId", (Object)this.editData.getBankInterFaceId()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BatchPayRuleCollection collection = this.getBatchPayRuleInterface().getBatchPayRuleCollection(view);
        boolean isExist = false;
        if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            isExist = collection.size() >= 2;
        } else {
            boolean bl = isExist = collection.size() >= 1;
        }
        if (isExist) {
            String warning = EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"checkExistBankInterfaceType");
            MsgBox.showWarning((Component)((Object)this), (String)warning);
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("bankInterFaceId");
        selectors.add("bankInterFace");
        return selectors;
    }
}

